/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.mqtt;

import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.meter.mqtt.MQTTPackBuilder;
import com.jhscale.meter.mqtt.MQTTUnpackBuilder;
import com.jhscale.meter.utils.ByteUtils;
import org.apache.commons.codec.digest.DigestUtils;

public abstract class MQTTBuilder
extends JSONModel {
    private String subContent;
    private String innerContent;

    public abstract String cacheKey();

    public abstract String command();

    public static MQTTPackBuilder packBuilder() {
        return new MQTTPackBuilder();
    }

    public static MQTTUnpackBuilder unpackBuilder() {
        return new MQTTUnpackBuilder();
    }

    public static String buildKey(String uid, String user, String password, String random) {
        byte[] randomBytes = ByteUtils.fromHexString(random);
        byte[] baseBytes = "MQTT".getBytes();
        byte[] top = new byte[baseBytes.length];
        for (int i = 0; i < baseBytes.length; ++i) {
            top[i] = (byte)(baseBytes[i] + randomBytes[i]);
        }
        byte[] content = ByteUtils.byteMerger(randomBytes, ("JH" + uid + user + password).getBytes());
        content = DigestUtils.sha1((byte[])content);
        byte[] bytes = ByteUtils.byteMerger(top, content);
        return ByteUtils.toHexString(bytes);
    }

    protected String getSubContent() {
        return this.subContent;
    }

    protected void setSubContent(String subContent) {
        this.subContent = subContent;
    }

    public String getInnerContent() {
        return this.innerContent;
    }

    public void setInnerContent(String innerContent) {
        this.innerContent = innerContent;
    }
}

