/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.mqtt;

import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.meter.mqtt.entity.Mark;
import com.jhscale.meter.utils.MQTTUtils;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class MQTTContentBuffer
extends JSONModel {
    private StringBuffer content;
    private StringBuffer surplus;

    public MQTTContentBuffer() {
    }

    public MQTTContentBuffer(String buffer) {
        int topIndex;
        if (StringUtils.isNotBlank((CharSequence)buffer) && (topIndex = buffer.indexOf("02")) != -1) {
            if ((buffer = buffer.substring(topIndex)).length() < 12) {
                this.surplus = new StringBuffer(buffer);
            } else {
                Mark mark = new Mark(buffer.substring(2, 4));
                String lenContent = buffer.substring(8, 8 + mark.getLen());
                int length = MQTTUtils.hex2Int(lenContent) * 2;
                int invalidLength = 12 + mark.getLen() + length;
                if (buffer.length() < invalidLength) {
                    this.surplus = new StringBuffer(buffer);
                } else {
                    this.content = new StringBuffer(buffer.substring(0, invalidLength));
                    this.surplus = new StringBuffer(invalidLength);
                }
            }
        }
    }

    public MQTTContentBuffer validContent(String buffer) {
        int topIndex;
        if (StringUtils.isNotBlank((CharSequence)buffer) && (topIndex = buffer.indexOf("02")) != -1) {
            if ((buffer = buffer.substring(topIndex)).length() < 12) {
                this.surplus = new StringBuffer(buffer);
            } else {
                Mark mark = new Mark(buffer.substring(2, 4));
                int len = mark.getLen() * 2;
                String lenContent = buffer.substring(8, 8 + len);
                int length = MQTTUtils.hex2Int(lenContent) * 2;
                int invalidLength = 12 + len + length;
                if (buffer.length() < invalidLength) {
                    this.surplus = new StringBuffer(buffer);
                } else {
                    this.content = new StringBuffer(buffer.substring(0, invalidLength));
                    this.surplus = new StringBuffer(invalidLength);
                }
            }
        }
        return this;
    }

    public StringBuffer contentBuffer() {
        return Objects.isNull(this.content) ? new StringBuffer() : this.content;
    }

    public String content() {
        return this.contentBuffer().toString();
    }

    public StringBuffer surplusBuffer() {
        return Objects.isNull(this.surplus) ? new StringBuffer() : this.surplus;
    }

    public String surplus() {
        return this.surplusBuffer().toString();
    }

    public StringBuffer getContent() {
        return this.content;
    }

    public void setContent(StringBuffer content) {
        this.content = content;
    }

    public StringBuffer getSurplus() {
        return this.surplus;
    }

    public void setSurplus(StringBuffer surplus) {
        this.surplus = surplus;
    }
}

