/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.mqtt;

import com.jhscale.common.utils.Base64Utils;
import com.jhscale.common.utils.JSONUtils;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.mqtt.ICMD;
import com.jhscale.meter.mqtt.IDATA;
import com.jhscale.meter.mqtt.IMQTT;
import com.jhscale.meter.mqtt.LocalMQTTLoader;
import com.jhscale.meter.mqtt.MQTTBuilder;
import com.jhscale.meter.mqtt.MQTTLoader;
import com.jhscale.meter.mqtt.ServerMQTTLoader;
import com.jhscale.meter.mqtt.em.ACK;
import com.jhscale.meter.mqtt.em.CD;
import com.jhscale.meter.mqtt.em.Confirm;
import com.jhscale.meter.mqtt.em.Encoding;
import com.jhscale.meter.mqtt.em.Encrypt;
import com.jhscale.meter.mqtt.entity.MQTTClient;
import com.jhscale.meter.mqtt.entity.Mark;
import com.jhscale.meter.mqtt.entity.ModuleInfo;
import com.jhscale.meter.utils.AesHexUtils;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.CrcUtils;
import com.jhscale.meter.utils.MQTTUtils;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class MQTTPackBuilder
extends MQTTBuilder {
    private Encrypt encrypt;
    private ACK ack;
    private Confirm confirm;
    private CD cd;
    private String cacheKey;
    private MQTTClient mqttClient;
    private MQTTLoader loader;
    private StringBuffer buffer = new StringBuffer();
    private List<IMQTT> imqtts;

    public MQTTPackBuilder mark(Encrypt encrypt, ACK ack, Confirm confirm, CD cd) {
        this.encrypt = encrypt;
        this.ack = ack;
        this.confirm = confirm;
        this.cd = cd;
        return this;
    }

    public MQTTPackBuilder mark(Mark mark) {
        this.encrypt = mark.getEncrypt();
        this.ack = mark.getAck();
        this.confirm = mark.getConfirm();
        this.cd = mark.getCd();
        return this;
    }

    public MQTTPackBuilder request(Encrypt encrypt, boolean answer, CD cd) {
        return this.mark(encrypt, ACK.Request, answer ? Confirm.WAIT : Confirm.NWAIT, cd);
    }

    public MQTTPackBuilder response(Encrypt encrypt, boolean result, CD cd) {
        return this.mark(encrypt, ACK.Response, result ? Confirm.SUCCESS : Confirm.FAIL, cd);
    }

    public MQTTPackBuilder response(Mark mark, boolean result) {
        return this.mark(mark.getEncrypt(), ACK.Response, result ? Confirm.SUCCESS : Confirm.FAIL, mark.getCd());
    }

    public MQTTPackBuilder mqttClient(MQTTClient mqttClient) {
        this.mqttClient = mqttClient;
        return this;
    }

    public MQTTPackBuilder loader(MQTTLoader loader) {
        this.loader = loader;
        return this;
    }

    public MQTTPackBuilder add(IMQTT ... imqtts) {
        if (this.imqtts == null) {
            this.imqtts = new ArrayList<IMQTT>();
        }
        this.imqtts.addAll(Arrays.asList(imqtts));
        return this;
    }

    public MQTTPackBuilder add(String cacheKey, String sunContent) {
        this.cacheKey = cacheKey;
        super.setSubContent(sunContent);
        return this;
    }

    public MQTTPackBuilder spack() throws MeterException {
        if (Objects.isNull((Object)this.mqttClient)) {
            throw new MeterException(MeterStateEnum.MQTT\u5ba2\u6237\u7aef\u4fe1\u606f\u4e0d\u5b58\u5728);
        }
        Mark mark = new Mark(this.encrypt, this.ack, this.confirm, this.cd);
        String nidContent = ByteUtils.convert(MQTTUtils.int2Hex2(this.mqttClient.getNid()));
        JLog.debug("Command build NidContent:{}--{}", this.mqttClient.getNid(), nidContent);
        if ((StringUtils.isBlank((CharSequence)this.mqttClient.getKey()) || Objects.isNull(this.mqttClient.getCharset())) && Objects.nonNull(this.loader)) {
            ModuleInfo moduleInfo = null;
            if (StringUtils.isNotBlank((CharSequence)this.mqttClient.getUid())) {
                moduleInfo = ((ServerMQTTLoader)this.loader).keyAndEncoding(this.mqttClient.getUid());
            }
            if (Objects.isNull(moduleInfo)) {
                throw new MeterException(MeterStateEnum.\u6a21\u5757\u4fe1\u606f\u52a0\u8f7d\u5931\u8d25);
            }
            if (StringUtils.isBlank((CharSequence)this.mqttClient.getKey())) {
                this.mqttClient.appendKey(moduleInfo.getKey());
            }
            if (Objects.isNull(this.mqttClient.getCharset())) {
                this.mqttClient.appendEncoding(moduleInfo.getCoding());
            }
        }
        this.addInner();
        this.encrypt(mark);
        int length = this.buffer.length();
        String lenContent = ByteUtils.convert(MQTTUtils.int2Hex(length / 2));
        JLog.debug("Command assemble LenContent:{}--{}", length, lenContent);
        mark.setLen(lenContent.length());
        String markContent = mark.assembleMark();
        JLog.debug("Command build Mark:{}--{}", mark.toJSON(), markContent);
        this.buffer.insert(0, lenContent).insert(0, nidContent).insert(0, markContent);
        String crcContent = CrcUtils.crc(this.buffer.toString());
        JLog.debug("Command build CRCContent:{}--{}", this.buffer.toString(), crcContent);
        this.buffer.insert(0, "02").append(crcContent).append("03");
        return this;
    }

    public MQTTPackBuilder lpack() throws MeterException {
        if (Objects.isNull((Object)this.mqttClient)) {
            throw new MeterException(MeterStateEnum.MQTT\u5ba2\u6237\u7aef\u4fe1\u606f\u4e0d\u5b58\u5728);
        }
        Mark mark = new Mark(this.encrypt, this.ack, this.confirm, this.cd);
        String nidContent = ByteUtils.convert(MQTTUtils.int2Hex2(this.mqttClient.getNid()));
        JLog.debug("Command build NidContent:{}--{}", this.mqttClient.getNid(), nidContent);
        String uidContent = "";
        if (!CD.MODULE.equals((Object)mark.getCd()) && StringUtils.isNotBlank((CharSequence)this.mqttClient.getUid())) {
            uidContent = ByteUtils.toHexString(this.mqttClient.getUid().getBytes()) + "00";
            JLog.debug("Command build UidContent:{}--{}", this.mqttClient.getUid(), uidContent);
        }
        if ((StringUtils.isBlank((CharSequence)this.mqttClient.getKey()) || Objects.isNull(this.mqttClient.getCharset())) && Objects.nonNull(this.loader)) {
            ModuleInfo moduleInfo = null;
            if (StringUtils.isNotBlank((CharSequence)this.mqttClient.getUid())) {
                moduleInfo = ((LocalMQTTLoader)this.loader).keyAndEncoding();
            }
            if (Objects.isNull(moduleInfo) && !CD.MODULE.equals((Object)mark.getCd())) {
                throw new MeterException(MeterStateEnum.\u6a21\u5757\u4fe1\u606f\u52a0\u8f7d\u5931\u8d25);
            }
            if (Objects.nonNull((Object)moduleInfo)) {
                if (StringUtils.isBlank((CharSequence)this.mqttClient.getKey())) {
                    this.mqttClient.appendKey(moduleInfo.getKey());
                }
                if (Objects.isNull(this.mqttClient.getCharset())) {
                    this.mqttClient.appendEncoding(moduleInfo.getCoding());
                }
            }
        }
        this.addInner();
        this.encrypt(mark);
        int length = uidContent.length() + this.buffer.length();
        String lenContent = ByteUtils.convert(MQTTUtils.int2Hex(length / 2));
        JLog.debug("Command assemble LenContent:{}--{}", length, lenContent);
        mark.setLen(lenContent.length());
        String markContent = mark.assembleMark();
        JLog.debug("Command build Mark:{}--{}", mark.toJSON(), markContent);
        this.buffer.insert(0, uidContent).insert(0, lenContent).insert(0, nidContent).insert(0, markContent);
        String crcContent = CrcUtils.crc(this.buffer.toString());
        JLog.debug("Command build CRCContent:{}--{}", this.buffer.toString(), crcContent);
        this.buffer.insert(0, "02").append(crcContent).append("03");
        return this;
    }

    private void addInner() throws MeterException {
        if (StringUtils.isNotBlank((CharSequence)this.getSubContent())) {
            super.setInnerContent(super.getSubContent());
            this.buffer = new StringBuffer(super.getSubContent());
            if (StringUtils.isBlank((CharSequence)this.cacheKey)) {
                this.cacheKey = this.cd.getBit();
            }
        } else {
            this.buildSubIMQTT();
        }
    }

    private void encrypt(Mark mark) throws MeterException {
        if (Encrypt.AES_Encrypt.equals((Object)mark.getEncrypt())) {
            if (StringUtils.isBlank((CharSequence)this.mqttClient.getKey())) {
                throw new MeterException(MeterStateEnum.MQTT_AES\u5bc6\u94a5\u4e0d\u5b58\u5728);
            }
            int innerLength = this.buffer.length() / 2;
            int fillingLength = 16 - innerLength % 16;
            for (int i = 1; i <= fillingLength; ++i) {
                this.buffer.append(MQTTUtils.int2Hex(i));
            }
            JLog.debug("Command build AES_Encrypt:{}", this.buffer.toString());
            JLog.debug("Command unpack encrypt before:{}", this.buffer.toString());
            this.buffer = new StringBuffer(AesHexUtils.encrypt(this.buffer.toString(), this.mqttClient.getKey()));
            JLog.debug("Command unpack encrypt after:{}", this.buffer.toString());
        }
    }

    public static String packSubContent(List<IMQTT> imqtts, Charset charset, boolean base64) {
        if (charset == null) {
            charset = Encoding.GBK.getCharset();
        }
        if (imqtts == null || imqtts.isEmpty()) {
            return null;
        }
        StringBuffer subContent = new StringBuffer();
        for (IMQTT imqtt : imqtts) {
            if (Objects.isNull(imqtt.getCharset())) {
                imqtt.setCharset(charset);
            }
            if (imqtt instanceof IDATA) {
                subContent.append(((IDATA)imqtt).packStream().over());
                continue;
            }
            subContent.append(imqtt.packSubContent().over());
        }
        return base64 ? Base64Utils.gzipString((String)subContent.toString()) : subContent.toString();
    }

    private void buildSubIMQTT() throws MeterException {
        if (Objects.isNull((Object)this.cd)) {
            throw new MeterException(MeterStateEnum.MQTT\u6307\u4ee4\u7c7b\u578b\u672a\u6dfb\u52a0);
        }
        if (this.imqtts == null || this.imqtts.size() == 0) {
            throw new MeterException(MeterStateEnum.MQTT\u6570\u636e\u5305\u4e0d\u5b58\u5728);
        }
        StringBuffer subContent = new StringBuffer();
        if (CD.MODULE.equals((Object)this.cd) || CD.CMD.equals((Object)this.cd)) {
            if (this.imqtts.size() != 1) {
                throw new MeterException(MeterStateEnum.MQTT\u6570\u636e\u5305\u9519\u8bef);
            }
            if (!(this.imqtts.get(0) instanceof ICMD)) {
                throw new MeterException(MeterStateEnum.MQTT\u5185\u5bb9\u6307\u4ee4\u4e0e\u7c7b\u578b\u4e0d\u914d);
            }
            IMQTT imqtt = this.imqtts.get(0);
            if (Objects.isNull(imqtt.getCharset())) {
                imqtt.setCharset(this.mqttClient.getCharset());
            }
            subContent.append(this.imqtts.get(0).packSubContent().over());
            this.cacheKey = ((ICMD)this.imqtts.get(0)).getCmd().getCmd();
        } else {
            for (IMQTT imqtt : this.imqtts) {
                if (Objects.isNull(imqtt.getCharset())) {
                    imqtt.setCharset(this.mqttClient.getCharset());
                }
                if (imqtt instanceof IDATA) {
                    subContent.append(((IDATA)imqtt).packStream().over());
                    this.cacheKey = ((IDATA)imqtt).getDsort().getSort();
                    continue;
                }
                subContent.append(imqtt.packSubContent().over());
            }
        }
        this.buffer.append(subContent);
        super.setInnerContent(subContent.toString());
        JLog.debug("Command assemble SubContent:{}--{}", JSONUtils.objectToJSON(this.imqtts), subContent.toString());
    }

    public String over() {
        return this.buffer.toString();
    }

    public byte[] stream() {
        return ByteUtils.fromHexString(this.over());
    }

    @Override
    public String cacheKey() {
        return this.cd.getVal() + (StringUtils.isBlank((CharSequence)this.cacheKey) ? "" : ":" + this.cacheKey);
    }

    @Override
    public String command() {
        return StringUtils.isNotBlank((CharSequence)this.cacheKey) ? this.cacheKey : this.cd.getVal().toString();
    }
}

