/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.mqtt;

import com.jhscale.common.utils.Base64Utils;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.mqtt.ICMD;
import com.jhscale.meter.mqtt.IDATA;
import com.jhscale.meter.mqtt.IMQTT;
import com.jhscale.meter.mqtt.LocalMQTTLoader;
import com.jhscale.meter.mqtt.MQTTBuilder;
import com.jhscale.meter.mqtt.MQTTLoader;
import com.jhscale.meter.mqtt.ServerMQTTLoader;
import com.jhscale.meter.mqtt.data.DataResponse;
import com.jhscale.meter.mqtt.em.ACK;
import com.jhscale.meter.mqtt.em.CD;
import com.jhscale.meter.mqtt.em.Encoding;
import com.jhscale.meter.mqtt.em.Encrypt;
import com.jhscale.meter.mqtt.entity.MQTTClient;
import com.jhscale.meter.mqtt.entity.Mark;
import com.jhscale.meter.utils.AesHexUtils;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.CrcUtils;
import com.jhscale.meter.utils.MQTTUtils;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class MQTTUnpackBuilder
extends MQTTBuilder {
    private StringBuffer buffer;
    private MQTTLoader loader;
    private Mark mark;
    private MQTTClient mqttClient;
    private List<IMQTT> imqtts;
    private String cacheKey;

    public MQTTUnpackBuilder content(String content) throws MeterException {
        if (StringUtils.isBlank((CharSequence)content) || !content.startsWith("02") || !content.endsWith("03")) {
            throw new MeterException(MeterStateEnum.MQTT\u6570\u636e\u5305\u683c\u5f0f\u4e0d\u6b63\u786e);
        }
        this.buffer = new StringBuffer(content);
        return this;
    }

    public MQTTUnpackBuilder loader(MQTTLoader loader) {
        this.loader = loader;
        return this;
    }

    public MQTTUnpackBuilder sunpackWithoutSub() throws MeterException {
        this.unpackMark();
        this.mqttClient = new MQTTClient();
        this.mqttClient.appendNid(this.unpackNid());
        String lenContent = this.buffer.substring(8, 8 + this.mark.getLen());
        int length = MQTTUtils.hex2Int(ByteUtils.convertHex(lenContent)) * 2;
        JLog.debug("Command unpack Len:{}--{}", lenContent, length);
        String innerContent = this.buffer.substring(8 + this.mark.getLen(), 8 + this.mark.getLen() + length);
        JLog.debug("Command unpack Uid + Content:{}", innerContent);
        innerContent = this.unpackSUid(innerContent);
        if (this.loader != null && StringUtils.isNotBlank((CharSequence)this.mqttClient.getUid())) {
            this.mqttClient.appendModule(((ServerMQTTLoader)this.loader).keyAndEncoding(this.mqttClient.getUid()));
        }
        JLog.debug("Command unpack MQTTClient:{}", this.mqttClient.toJSON());
        innerContent = this.encrypt(innerContent);
        super.setInnerContent(innerContent);
        String crc = this.buffer.substring(8 + this.mark.getLen() + length, 10 + this.mark.getLen() + length);
        String crcContent = CrcUtils.crc(this.buffer.substring(2, this.buffer.length() - 4));
        JLog.debug("Command unpack crc:{}, crcContent:{}", crc, crcContent);
        if (!crc.equalsIgnoreCase(crcContent)) {
            throw new MeterException(MeterStateEnum.MQTT_CRC\u68c0\u67e5\u9519\u8bef);
        }
        super.setSubContent(innerContent);
        return this;
    }

    public MQTTUnpackBuilder sunpack() throws MeterException {
        return this.sunpackWithoutSub().unpackSubContent();
    }

    public MQTTUnpackBuilder lunpack() throws MeterException {
        this.unpackMark();
        this.mqttClient = new MQTTClient();
        this.mqttClient.appendNid(this.unpackNid());
        String lenContent = this.buffer.substring(8, 8 + this.mark.getLen());
        int length = MQTTUtils.hex2Int(ByteUtils.convertHex(lenContent)) * 2;
        JLog.debug("Command unpack Len:{}--{}", lenContent, length);
        String innerContent = this.buffer.substring(8 + this.mark.getLen(), 8 + this.mark.getLen() + length);
        JLog.debug("Command unpack Uid + Content:{}", innerContent);
        if (this.loader != null) {
            this.mqttClient.appendModule(((LocalMQTTLoader)this.loader).keyAndEncoding());
        }
        JLog.debug("Command unpack MQTTClient:{}", this.mqttClient.toJSON());
        innerContent = this.encrypt(innerContent);
        super.setInnerContent(innerContent);
        String crc = this.buffer.substring(8 + this.mark.getLen() + length, 10 + this.mark.getLen() + length);
        String crcContent = CrcUtils.crc(this.buffer.substring(2, this.buffer.length() - 4));
        JLog.debug("Command unpack crc:{}, crcContent:{}", crc, crcContent);
        if (!crc.equalsIgnoreCase(crcContent)) {
            throw new MeterException(MeterStateEnum.MQTT_CRC\u68c0\u67e5\u9519\u8bef);
        }
        super.setSubContent(innerContent);
        return this.unpackSubContent();
    }

    public MQTTUnpackBuilder unpackMark() throws MeterException {
        if (Objects.isNull(this.buffer) || this.buffer.length() == 0) {
            throw new MeterException(MeterStateEnum.MQTT\u89e3\u6790\u6570\u636e\u5305\u4e0d\u5b58\u5728);
        }
        String markContent = this.buffer.substring(2, 4);
        this.mark = new Mark(markContent);
        JLog.debug("Command unpack Mark:{}--{}", markContent, this.mark.toJSON());
        if (Objects.isNull((Object)this.mark)) {
            throw new MeterException(MeterStateEnum.Mark\u89e3\u6790\u5931\u8d25);
        }
        return this;
    }

    public Integer unpackNid() {
        String nidContent = ByteUtils.convert(this.buffer.substring(4, 8));
        Integer nid = Integer.parseInt(nidContent, 16);
        JLog.debug("Command unpack NID:{}--{}", nidContent, nid);
        return nid;
    }

    private String unpackSUid(String innerContent) {
        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            String hexText = innerContent.substring(0, index);
            innerContent = innerContent.substring(index + 2);
            String uid = new String(ByteUtils.fromHexAscii(hexText)).trim();
            this.mqttClient.appendUid(uid);
            JLog.debug("Command unpack Uid:{}--{}", hexText, uid);
        }
        return innerContent;
    }

    public static List<IMQTT> unpackSubContent(String subContent, Charset charset, boolean base64) {
        if (base64) {
            subContent = Base64Utils.ungzipString((String)subContent);
        }
        if (charset == null) {
            charset = Encoding.GBK.getCharset();
        }
        IDATA idata = new IDATA(charset, subContent);
        ArrayList<IMQTT> imqtts = new ArrayList<IMQTT>();
        Mark mark = new Mark();
        mark.setAck(ACK.Request);
        while (idata.hasNext()) {
            IMQTT mqtt = idata.unpackSubContent(mark);
            if (!Objects.nonNull((Object)mqtt)) continue;
            imqtts.add(mqtt);
        }
        return imqtts;
    }

    private MQTTUnpackBuilder unpackSubContent() throws MeterException {
        IMQTT imqtt = null;
        switch (this.mark.getCd()) {
            case CMD: {
                imqtt = new ICMD(this.mqttClient.getCharset(), super.getSubContent());
                break;
            }
            case MODULE: {
                imqtt = new ICMD(this.mqttClient.getCharset(), super.getSubContent());
                break;
            }
            case API: {
                imqtt = new IDATA(this.mqttClient.getCharset(), super.getSubContent());
                break;
            }
            case DATA: {
                imqtt = new IDATA(this.mqttClient.getCharset(), super.getSubContent());
            }
        }
        if (imqtt == null) {
            throw new MeterException(MeterStateEnum.MQTT\u6307\u4ee4\u7c7b\u578b\u4e0d\u5b58\u5728);
        }
        this.imqtts = new ArrayList<IMQTT>();
        while (imqtt.hasNext()) {
            IMQTT mqtt = imqtt.unpackSubContent(this.mark);
            if (!Objects.nonNull((Object)mqtt)) continue;
            this.imqtts.add(mqtt);
        }
        if ((this.mark.getCd().equals((Object)CD.MODULE) || this.mark.getCd().equals((Object)CD.CMD)) && this.imqtts.size() > 0 && this.imqtts.get(0) != null) {
            this.cacheKey = ((ICMD)this.imqtts.get(0)).getCmd().getCmd();
            super.setSubContent(null);
        } else if (this.imqtts.size() > 0 && this.imqtts.get(0) != null && !(this.imqtts.get(0) instanceof DataResponse)) {
            this.cacheKey = ((IDATA)this.imqtts.get(0)).getDsort().getSort();
            super.setSubContent(null);
        }
        return this;
    }

    private String encrypt(String innerContent) throws MeterException {
        if (Encrypt.AES_Encrypt.equals((Object)this.mark.getEncrypt())) {
            if (StringUtils.isBlank((CharSequence)this.mqttClient.getKey())) {
                throw new MeterException(MeterStateEnum.MQTT_AES\u5bc6\u94a5\u4e0d\u5b58\u5728);
            }
            JLog.debug("Command unpack decrypt before:{}", innerContent);
            try {
                innerContent = AesHexUtils.decrypt(innerContent, this.mqttClient.getKey());
            }
            catch (MeterException e) {
                throw new MeterException(MeterStateEnum.AES\u89e3\u5bc6\u5931\u8d25);
            }
            JLog.debug("Command unpack decrypt after:{}", innerContent);
            int innerLength = innerContent.length();
            int fillingVal = Integer.parseInt(innerContent.substring(innerLength - 2), 16);
            for (int i = 0; i < fillingVal; ++i) {
                int fillingPartVal = Integer.parseInt(innerContent.substring(innerLength - i * 2 - 2, innerLength - i * 2), 16);
                if (fillingPartVal == fillingVal - i) continue;
                throw new MeterException(MeterStateEnum.\u586b\u5145\u5b57\u6bb5\u9519\u8bef);
            }
            innerContent = innerContent.substring(0, innerLength - fillingVal * 2);
            JLog.debug("Command unpack AES_Decrypt:{}", innerContent);
        }
        return innerContent;
    }

    public Mark getMark() {
        return this.mark;
    }

    public MQTTClient getMqttClient() {
        return this.mqttClient;
    }

    public List<IMQTT> getImqtts() {
        return this.imqtts;
    }

    @Override
    public String cacheKey() {
        return this.mark.getCd().getVal() + (StringUtils.isBlank((CharSequence)this.cacheKey) ? "" : ":" + this.cacheKey);
    }

    @Override
    public String command() {
        return StringUtils.isNotBlank((CharSequence)this.cacheKey) ? this.cacheKey : this.mark.getCd().getVal().toString();
    }
}

