/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.mqtt.em;

import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;

public enum Encoding {
    GBK("C", "GBK"),
    UTF_8("U", "UTF-8"),
    GB2312("G", "GB2312");

    private String coding;
    private String encoding;

    private Encoding(String coding, String encoding) {
        this.coding = coding;
        this.encoding = encoding;
    }

    public static Encoding coding(String coding) {
        if (StringUtils.isNotBlank((CharSequence)coding)) {
            for (Encoding encoding : Encoding.values()) {
                if (!coding.equals(encoding.getCoding())) continue;
                return encoding;
            }
        }
        return GBK;
    }

    public String getCoding() {
        return this.coding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Charset getCharset() {
        return Charset.forName(this.getEncoding());
    }
}

