/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.mqtt.em;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public enum RxStatus {
    SUCCESS(0, "00", "\u6570\u636e\u6b63\u786e"),
    CRC_ERROR(1, "01", "\u6570\u636e\u6b63\u786e"),
    DATA_STREAM_ILLEGAL(2, "02", "\u5b58\u5728\u4e0d\u5408\u6cd5\u6d41\u683c\u5f0f"),
    DSORT_ILLEGAL(3, "03", "\u5b58\u5728DSort\u4e0d\u88ab\u63a5\u53d7"),
    DID_ILLEGAL(4, "04", "\u5b58\u5728D-ID\u4e0d\u88ab\u63a5\u53d7"),
    DDATA_ILLEGAL(5, "05", "\u5b58\u5728D-Data\u4e0d\u88ab\u63a5\u53d7"),
    BUSY(6, "06", "\u79e4\u5fd9\u788c\u4e2d\uff0c\u4e0d\u63a5\u53d7\u65b0\u6307\u4ee4");

    private Integer status;
    private String hex;
    private String description;

    private RxStatus(Integer status, String hex, String description) {
        this.status = status;
        this.hex = hex;
        this.description = description;
    }

    public static RxStatus status(Integer status) {
        if (Objects.nonNull(status)) {
            for (RxStatus rxStatus : RxStatus.values()) {
                if (!rxStatus.getStatus().equals(status)) continue;
                return rxStatus;
            }
        }
        return null;
    }

    public static RxStatus status(String status) {
        if (StringUtils.isNotBlank((CharSequence)status)) {
            for (RxStatus rxStatus : RxStatus.values()) {
                if (!status.equals(rxStatus.getHex())) continue;
                return rxStatus;
            }
        }
        return null;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getHex() {
        return this.hex;
    }

    public String getDescription() {
        return this.description;
    }
}

