/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.mqtt.entity;

import com.jhscale.meter.mqtt.em.DCmd;
import com.jhscale.meter.utils.MQTTUtils;

public class DMark {
    private String bin;
    private DCmd cmd;
    private Integer sortl;
    private Integer didl;
    private Integer lenl;

    public DMark(String hex) {
        this.bin = MQTTUtils.hex2Bit(hex);
        this.cmd = DCmd.cmd(this.bin.substring(0, 2));
        this.sortl = (this.bin.charAt(2) == '0' ? 1 : 2) * 2;
        this.didl = MQTTUtils.bit2Int(this.bin.substring(3, 6)) * 2;
        this.lenl = MQTTUtils.bit2Int(this.bin.substring(6, 8)) * 2;
    }

    public DMark(DCmd cmd, Integer sortl, Integer didl) {
        this.cmd = cmd;
        this.sortl = sortl / 2;
        this.didl = didl / 2;
    }

    public String assembleDMark() {
        String bin;
        this.bin = bin = new StringBuffer().append(this.cmd.getCmd()).append(this.sortl == 1 ? "0" : "1").append(MQTTUtils.int2Bit(this.didl, 3)).append(MQTTUtils.int2Bit(this.lenl / 2)).toString();
        return MQTTUtils.bit2Hex(bin);
    }

    public int datal(int dlen) {
        return dlen - this.sortl - this.didl;
    }

    public String getBin() {
        return this.bin;
    }

    public void setBin(String bin) {
        this.bin = bin;
    }

    public DCmd getCmd() {
        return this.cmd;
    }

    public void setCmd(DCmd cmd) {
        this.cmd = cmd;
    }

    public Integer getSortl() {
        return this.sortl;
    }

    public void setSortl(Integer sortl) {
        this.sortl = sortl;
    }

    public Integer getDidl() {
        return this.didl;
    }

    public void setDidl(Integer didl) {
        this.didl = didl;
    }

    public Integer getLenl() {
        return this.lenl;
    }

    public void setLenl(Integer lenl) {
        this.lenl = lenl;
    }
}

