/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.mqtt.entity;

import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.meter.mqtt.em.Encoding;
import com.jhscale.meter.mqtt.entity.ModuleInfo;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class MQTTClient
extends JSONModel {
    private Integer nid = 0;
    private String uid;
    private String key;
    private Charset charset = Encoding.GBK.getCharset();

    public MQTTClient appendNid(Integer nid) {
        this.nid = nid;
        return this;
    }

    public MQTTClient appendUid(String uid) {
        this.uid = uid;
        return this;
    }

    public MQTTClient appendKey(String key) {
        this.key = key;
        return this;
    }

    public MQTTClient appendEncoding(Encoding encoding) {
        this.charset = encoding.getCharset();
        return this;
    }

    public MQTTClient appendEncoding(String coding) {
        this.charset = StringUtils.isBlank((CharSequence)coding) ? Encoding.GBK.getCharset() : Encoding.coding(coding).getCharset();
        return this;
    }

    public MQTTClient appendModule(ModuleInfo moduleInfo) {
        return this.appendEncoding(moduleInfo.getCoding()).appendKey(moduleInfo.getKey());
    }

    public MQTTClient appendEncoding(Charset charset) {
        this.charset = Objects.nonNull(charset) ? charset : Encoding.GBK.getCharset();
        return this;
    }

    public Integer getNid() {
        return this.nid;
    }

    public void setNid(Integer nid) {
        this.nid = nid;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }
}

