/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.mqtt.entity;

import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.meter.mqtt.em.ACK;
import com.jhscale.meter.mqtt.em.CD;
import com.jhscale.meter.mqtt.em.Confirm;
import com.jhscale.meter.mqtt.em.Encrypt;
import com.jhscale.meter.utils.MQTTUtils;

public class Mark
extends JSONModel {
    private String bin;
    private Encrypt encrypt;
    private ACK ack;
    private Confirm confirm;
    private CD cd;
    private int len;

    public Mark() {
    }

    public Mark(ACK ack, Confirm confirm, CD cd) {
        this(Encrypt.Not_Encrypt, ack, confirm, cd);
    }

    public Mark(Encrypt encrypt, ACK ack, Confirm confirm, CD cd) {
        this.encrypt = encrypt;
        this.ack = ack;
        this.confirm = confirm;
        this.cd = cd;
    }

    public Mark(String markContent) {
        this.bin = MQTTUtils.hex2Bit(markContent);
        this.encrypt = Encrypt.bit(this.bin.substring(0, 1));
        this.ack = ACK.bit(this.bin.substring(1, 2));
        this.confirm = Confirm.bit(this.bin.substring(2, 4));
        this.cd = CD.bit(this.bin.substring(4, 6));
        this.len = MQTTUtils.bit2Int(this.bin.substring(6, 8)) * 2;
    }

    public String assembleMark() {
        String bin;
        this.bin = bin = new StringBuffer().append(this.encrypt.getBit()).append(this.ack.getBit()).append(this.confirm.getBit()).append(this.cd.getBit()).append(MQTTUtils.int2Bit(this.len / 2)).toString();
        return MQTTUtils.bit2Hex(bin);
    }

    public String getBin() {
        return this.bin;
    }

    public void setBin(String bin) {
        this.bin = bin;
    }

    public Encrypt getEncrypt() {
        return this.encrypt;
    }

    public void setEncrypt(Encrypt encrypt) {
        this.encrypt = encrypt;
    }

    public ACK getAck() {
        return this.ack;
    }

    public void setAck(ACK ack) {
        this.ack = ack;
    }

    public Confirm getConfirm() {
        return this.confirm;
    }

    public void setConfirm(Confirm confirm) {
        this.confirm = confirm;
    }

    public CD getCd() {
        return this.cd;
    }

    public void setCd(CD cd) {
        this.cd = cd;
    }

    public int getLen() {
        return this.len;
    }

    public void setLen(int len) {
        this.len = len;
    }
}

