/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.io.control.DeviceControl;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.log.PortLogBack;
import com.jhscale.meter.model.device.Device;
import com.jhscale.meter.protocol.IBProtocolResponse;
import com.jhscale.meter.protocol.IProtocolManager;
import com.jhscale.meter.protocol.IProtocolResponse;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyRequest;
import com.jhscale.meter.protocol.entity.IPackRequest;
import com.jhscale.meter.protocol.entity.IPackResponse;
import com.jhscale.meter.protocol.entity.PackAssemblyRequest;
import com.jhscale.meter.protocol.entity.ProtocolEntity;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.utils.ByteUtils;
import java.util.Objects;

public abstract class AbstractProtoManager<U extends PackAssemblyRequest>
implements IProtocolManager<U> {
    protected PortManager portManager;
    protected boolean dopen = false;

    @Override
    public IProtocolManager initPortmanager(PortManager portManager) {
        this.portManager = portManager;
        return this;
    }

    @Override
    public IProtocolManager initPortmanager(DeviceControl deviceControl, Device device) throws MeterException {
        return this.initPortmanager(new PortManager<Device>(deviceControl, device));
    }

    @Override
    public IProtocolManager initPortmanager(PortManager portManager, DeviceClientEventListener listener) {
        if (Objects.nonNull(listener) && Objects.nonNull(portManager)) {
            portManager.setClientEventListener(listener);
        }
        return this.initPortmanager(portManager);
    }

    @Override
    public <T extends IPackResponse> T execute(IPackRequest<T> request) throws MeterException {
        return request.execute();
    }

    @Override
    public void execute(U request, IProtocolResponse protocolResponse) throws MeterException {
        this.checkManager();
        this.checkPort();
        Object execute = this.execute((IPackRequest)request);
        JLog.debug("Execute: {}", execute.toJSON());
        DeviceClientEventListener clientEventListener = this.portManager.getClientEventListener();
        if (clientEventListener != null) {
            clientEventListener.addProtocolResponse(execute.KEY(), new ProtocolEntity((IPackRequest)request, protocolResponse));
        }
        if (GlobalPara.getInstance().isRunLog()) {
            try {
                System.out.printf("%s \u53d1\u9001 %s%n", ((ADPackAssemblyRequest)request).getAdcmd().getContent(), ByteUtils.toHexString(execute.HEX()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.portManager.writeDataImmediately(execute.HEX());
    }

    @Override
    public boolean executeSendOnly(U request) throws MeterException {
        Object execute = request.execute();
        JLog.debug("Execute: {}", execute.toJSON());
        return this.execute(execute.HEX());
    }

    @Override
    public boolean execute(byte[] bytes) throws MeterException {
        this.checkManager();
        this.checkPort();
        if (this.portManager.getClientEventListener() == null) {
            throw new MeterException(MeterStateEnum.AD_\u672a\u521d\u59cb\u5316\u56de\u8c03\u76d1\u542c);
        }
        this.portManager.writeDataImmediately(bytes);
        return true;
    }

    @Override
    public void openPort() throws MeterException {
        this.checkManager();
        this.dopen = this.portManager.openPort();
    }

    @Override
    public void closePort() throws MeterException {
        if (this.portManager != null) {
            this.dopen = !this.portManager.closePort();
        }
    }

    @Override
    public boolean restart() throws MeterException {
        if (this.dopen) {
            IBProtocolResponse ibProtocolResponse = this.portManager.getClientEventListener().defaultResponse();
            if (ibProtocolResponse == null) {
                return false;
            }
            this.initPortmanager(this.portManager, ibProtocolResponse);
            this.dopen = this.portManager.openPort();
            return this.dopen;
        }
        return false;
    }

    @Override
    public void log(boolean log) throws MeterException {
        this.checkManager();
        this.portManager.log(log);
    }

    @Override
    public void logBack(boolean logBack, PortLogBack portLogBack) throws MeterException {
        this.checkManager();
        this.portManager.logBack(logBack, portLogBack);
    }

    protected boolean checkManager() throws MeterException {
        if (this.portManager == null) {
            throw new MeterException(MeterStateEnum.\u901a\u8baf\u5668\u672a\u521d\u59cb\u5316);
        }
        return true;
    }

    protected boolean checkPort() throws MeterException {
        if (!this.dopen) {
            throw new MeterException(MeterStateEnum.\u7aef\u53e3\u672a\u6253\u5f00);
        }
        return true;
    }
}

