/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.ad;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.io.control.DeviceControl;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.model.device.Device;
import com.jhscale.meter.protocol.AbstractProtoManager;
import com.jhscale.meter.protocol.IBProtocolResponse;
import com.jhscale.meter.protocol.IProtocolManager;
import com.jhscale.meter.protocol.IProtocolResponse;
import com.jhscale.meter.protocol.ad.em.CommunicationState;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyRequest;
import com.jhscale.meter.protocol.ad.entity.assembly.UpgradeFirmwareADPARequest;
import com.jhscale.meter.protocol.ad.entity.disassembly.UpgradeFirmwareADPDResponse;
import com.jhscale.meter.protocol.ad.listener.ADScaleClientEventListener;
import com.jhscale.meter.protocol.ad.listener.ADUpgradeEventListener;
import com.jhscale.meter.protocol.entity.ProtocolEntity;
import com.jhscale.meter.protocol.model.WeightCal;
import com.jhscale.meter.utils.FileUtils;

public class ADScaleProtocolManager
extends AbstractProtoManager<ADPackAssemblyRequest> {
    @Override
    public IProtocolManager initPortmanager(PortManager portManager, IBProtocolResponse protocolResponse) {
        return this.initPortmanager(portManager, new ADScaleClientEventListener(protocolResponse, this));
    }

    @Override
    public IProtocolManager initPortmanager(DeviceControl deviceControl, Device device, IBProtocolResponse protocolResponse) throws MeterException {
        return this.initPortmanager(new PortManager<Device>(deviceControl, device, new ADScaleClientEventListener(protocolResponse, this)));
    }

    @Override
    public void shake(final IProtocolResponse protocolResponse) throws MeterException {
        WeightCal.getInstance().setUpgrade(true);
        this.checkManager();
        if (this.dopen) {
            this.portManager.closePort();
        }
        final ADUpgradeEventListener adUpgradeEventListener = new ADUpgradeEventListener(protocolResponse, (IProtocolManager)this);
        this.portManager.setClientEventListener(adUpgradeEventListener);
        adUpgradeEventListener.clear();
        this.dopen = this.portManager.openPort();
        this.execute(new UpgradeFirmwareADPARequest(), new IProtocolResponse<UpgradeFirmwareADPDResponse>(){

            @Override
            public void target(UpgradeFirmwareADPDResponse target) {
                JLog.debug("UpgradeFirmwareADPDResponse:{}", target.toJSON());
                if (target.getResult().isResult()) {
                    adUpgradeEventListener.setCommunication(CommunicationState.SHAKE);
                }
            }

            @Override
            public void exp(MeterException e) {
                if (protocolResponse != null) {
                    protocolResponse.exp(e);
                }
            }
        });
    }

    @Override
    public void shakeWithoutUpgradeFirmware(IProtocolResponse protocolResponse) throws MeterException {
        WeightCal.getInstance().setUpgrade(true);
        this.checkManager();
        if (this.dopen) {
            this.portManager.closePort();
        }
        ADUpgradeEventListener adUpgradeEventListener = new ADUpgradeEventListener(protocolResponse, (IProtocolManager)this);
        this.portManager.setClientEventListener(adUpgradeEventListener);
        adUpgradeEventListener.clear();
        this.dopen = this.portManager.openPort();
        adUpgradeEventListener.setCommunication(CommunicationState.SHAKE);
    }

    @Override
    public void upgrade(byte[] bytes, IProtocolResponse protocolResponse) throws MeterException {
        WeightCal.getInstance().setUpgrade(true);
        this.checkManager();
        this.checkPort();
        ADUpgradeEventListener clientEventListener = (ADUpgradeEventListener)this.portManager.getClientEventListener();
        if (clientEventListener.getCommunication() != CommunicationState.SHAKE) {
            throw new MeterException(MeterStateEnum.AD_\u56fa\u4ef6\u5347\u7ea7\u672a\u63e1\u624b);
        }
        clientEventListener.setShake_state(false);
        clientEventListener.setCommunication(CommunicationState.UPGRATE);
        clientEventListener.addProtocolResponse(CommunicationState.UPGRATE.getKey(), new ProtocolEntity(protocolResponse));
        clientEventListener.upgradeWithCtrl(FileUtils.upgradeBytes(bytes), this.portManager);
    }
}

