/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.ad.em;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public enum BackLight {
    CLOSE(0, "00", "\u5173\u95ed\u80cc\u5149\u706f"),
    OPEN(1, "01", "\u6253\u5f00\u80cc\u5149\u706f");

    private int state;
    private String hex;
    private String description;

    private BackLight(int state, String hex, String description) {
        this.state = state;
        this.hex = hex;
        this.description = description;
    }

    public static BackLight getState(Integer state) {
        if (Objects.isNull(state)) {
            return null;
        }
        for (BackLight templatureState : BackLight.values()) {
            if (state.intValue() != templatureState.getState()) continue;
            return templatureState;
        }
        return null;
    }

    public static BackLight getState(String state) {
        if (StringUtils.isBlank((CharSequence)state)) {
            return null;
        }
        for (BackLight templatureState : BackLight.values()) {
            if (!state.equals(templatureState.getHex())) continue;
            return templatureState;
        }
        return null;
    }

    public int getState() {
        return this.state;
    }

    public String getHex() {
        return this.hex;
    }

    public String getDescription() {
        return this.description;
    }
}

