/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.ad.em;

import com.jhscale.meter.utils.ByteUtils;
import org.apache.commons.lang3.StringUtils;

public enum DigitalTube2 {
    NON("00000000", 0, "00", ""),
    ZERO("01011111", 95, "5F", "0"),
    ONE("01010000", 80, "50", "1"),
    TWO("00111101", 61, "3D", "2"),
    THREE("01111001", 121, "79", "3"),
    FOUR("01110010", 114, "72", "4"),
    FIVE("01101011", 107, "6B", "5"),
    SIX("01101111", 111, "6F", "6"),
    SEVEN("01010001", 81, "51", "7"),
    EIGHT("01111111", 127, "7F", "8"),
    NINE("01111011", 123, "7B", "9"),
    ZERO_("11011111", 223, "DF", "0."),
    ONE_("11010000", 208, "D0", "1."),
    TWO_("10111101", 189, "BD", "2."),
    THREE_("11111001", 249, "F9", "3."),
    FOUR_("11110010", 242, "F2", "4."),
    FIVE_("11101011", 235, "EB", "5."),
    SIX_("11101111", 239, "EF", "6."),
    SEVEN_("11010001", 209, "D1", "7."),
    EIGHT_("11111111", 255, "FF", "8."),
    NINE_("11111011", 251, "FB", "9."),
    A("01110111", 119, "77", "A"),
    B("01101110", 110, "6E", "B"),
    C("00001111", 15, "0F", "C"),
    D("01111100", 124, "7C", "D"),
    E("00101111", 47, "2F", "E"),
    F("00100111", 39, "27", "F"),
    G("01001111", 79, "4F", "G"),
    H("01110110", 118, "76", "H"),
    I("01000000", 64, "40", "I"),
    J("01001111", 79, "5C", "J"),
    K("00110110", 54, "36", "K"),
    L("00001110", 14, "0E", "L"),
    M("01100101", 101, "65", "M"),
    N("01100100", 100, "64", "N"),
    O("01101100", 108, "6C", "O"),
    P("00110111", 55, "37", "P"),
    Q("01110011", 115, "73", "Q"),
    R("00100100", 36, "24", "R"),
    S("01001011", 75, "4B", "S"),
    T("00101110", 46, "2E", "T"),
    U("01011110", 94, "5E", "U"),
    V("01001100", 76, "4C", "V"),
    W("00111010", 58, "3A", "W"),
    X("01010110", 86, "56", "X"),
    Y("01111010", 122, "7A", "Y"),
    Z("01010110", 29, "1D", "Z"),
    A_("11110111", 247, "F7", "A."),
    B_("11101110", 238, "EE", "B."),
    C_("10001111", 143, "8F", "C."),
    D_("11111100", 252, "FC", "D."),
    E_("10101111", 175, "AF", "E."),
    F_("10100111", 167, "A7", "F."),
    G_("11001111", 207, "CF", "G."),
    H_("11110110", 246, "F6", "H."),
    I_("11000000", 192, "C0", "I."),
    J_("11001111", 207, "DC", "J."),
    K_("10110110", 182, "B6", "K."),
    L_("10001110", 142, "8E", "L."),
    M_("11100101", 229, "E5", "M."),
    N_("11100100", 228, "E4", "N."),
    O_("11101100", 236, "EC", "O."),
    P_("10110111", 183, "B7", "P."),
    Q_("11110011", 243, "F3", "Q."),
    R_("10100100", 164, "A4", "R."),
    S_("11001011", 203, "CB", "S."),
    T_("10101110", 174, "AE", "T."),
    U_("11011110", 222, "DE", "U."),
    V_("11001100", 204, "CC", "V."),
    W_("10111010", 186, "BA", "W."),
    X_("11010110", 214, "D6", "X."),
    Y_("11111010", 250, "FA", "Y."),
    Z_("11010110", 157, "9D", "Z.");

    private String bit;
    private int val;
    private String hex;
    private String ascii;

    private DigitalTube2(String bit, int val, String hex, String ascii) {
        this.bit = bit;
        this.val = val;
        this.hex = hex;
        this.ascii = ascii;
    }

    public static DigitalTube2 digitalTube(String ascii) {
        if (StringUtils.isBlank((CharSequence)ascii)) {
            return NON;
        }
        for (DigitalTube2 digitalTube : DigitalTube2.values()) {
            if (!ascii.toUpperCase().equals(digitalTube.getAscii())) continue;
            return digitalTube;
        }
        return NON;
    }

    public static String digital(String part) {
        if (StringUtils.isNotBlank((CharSequence)part)) {
            StringBuffer buffer = new StringBuffer();
            for (int i = part.length() - 1; i > -1; --i) {
                DigitalTube2 digitalTube = null;
                digitalTube = part.charAt(i) == '.' ? DigitalTube2.digitalTube(part.charAt(--i) + ".") : DigitalTube2.digitalTube(String.valueOf(part.charAt(i)));
                buffer.append(digitalTube.getHex());
            }
            return buffer.toString();
        }
        return "";
    }

    public static String digitalTube(int digitalLength, String part) {
        String digital = ByteUtils.convert(DigitalTube2.digital(part));
        StringBuffer buffer = new StringBuffer();
        int append = digitalLength - digital.length();
        if (append < 0) {
            System.err.printf("%s(%s) over %s......%n", part, digital, digitalLength);
            buffer.append(digital, 0, digitalLength);
        } else {
            for (int i = 0; i < append; ++i) {
                buffer.append("0");
            }
            buffer.append(digital);
        }
        return buffer.toString();
    }

    public String getBit() {
        return this.bit;
    }

    public int getVal() {
        return this.val;
    }

    public String getHex() {
        return this.hex;
    }

    public String getAscii() {
        return this.ascii;
    }
}

