/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.ad.em;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public enum Division {
    ZERO(0, "00", "\u5355\u5206\u5ea6", "1"),
    ONE(1, "01", "\u53cc\u5206\u5ea6", "1,2"),
    TWO(2, "02", "\u5355\u5206\u5ea6", "2"),
    THREE(3, "03", "\u53cc\u5206\u5ea6", "2,5"),
    FOUR(4, "04", "\u5355\u5206\u5ea6", "5"),
    FIVE(5, "05", "\u53cc\u5206\u5ea6", "5,10"),
    SIX(6, "06", "\u5355\u5206\u5ea6", "10"),
    SEVEN(7, "07", "\u53cc\u5206\u5ea6", "10,20"),
    EIGHT(8, "08", "\u5355\u5206\u5ea6", "20"),
    NINE(9, "09", "\u53cc\u5206\u5ea6", "20,50"),
    TEN(10, "0A", "\u5355\u5206\u5ea6", "50");

    private int division;
    private String hex;
    private String type;
    private String vals;

    private Division(int division, String hex, String type, String vals) {
        this.division = division;
        this.hex = hex;
        this.type = type;
        this.vals = vals;
    }

    public static Division division(Integer val) {
        if (Objects.isNull(val)) {
            return null;
        }
        for (Division division : Division.values()) {
            if (division.getDivision() != val.intValue()) continue;
            return division;
        }
        return null;
    }

    public static Division division(String val) {
        if (StringUtils.isBlank((CharSequence)val)) {
            return null;
        }
        for (Division division : Division.values()) {
            if (!val.equals(division.hex)) continue;
            return division;
        }
        return null;
    }

    public List<Integer> divisionVals() {
        String[] vals = this.vals.split(",");
        if (vals != null && vals.length > 0) {
            ArrayList<Integer> divisionVals = new ArrayList<Integer>();
            for (String val : vals) {
                try {
                    divisionVals.add(Integer.parseInt(val));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return Collections.emptyList();
    }

    public int getDivision() {
        return this.division;
    }

    public String getHex() {
        return this.hex;
    }

    public String getType() {
        return this.type;
    }

    public String getVals() {
        return this.vals;
    }
}

