/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.ad.em;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public enum TemplatureInExistState {
    CLOSE(0, "00", "\u9000\u51fa\u6e29\u5ea6\u8865\u507f\u72b6\u6001"),
    OPEN(1, "01", "\u8fdb\u5165\u6e29\u5ea6\u8865\u507f\u72b6\u6001");

    private int state;
    private String hex;
    private String description;

    private TemplatureInExistState(int state, String hex, String description) {
        this.state = state;
        this.hex = hex;
        this.description = description;
    }

    public static TemplatureInExistState switchState(Integer state) {
        if (Objects.nonNull(state)) {
            return null;
        }
        for (TemplatureInExistState templatureState : TemplatureInExistState.values()) {
            if (state.intValue() != templatureState.getState()) continue;
            return templatureState;
        }
        return null;
    }

    public static TemplatureInExistState switchState(String state) {
        if (StringUtils.isBlank((CharSequence)state)) {
            return null;
        }
        for (TemplatureInExistState templatureState : TemplatureInExistState.values()) {
            if (!state.equals(templatureState.getHex())) continue;
            return templatureState;
        }
        return null;
    }

    public String getHex() {
        return this.hex;
    }

    public int getState() {
        return this.state;
    }

    public String getDescription() {
        return this.description;
    }
}

