/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.ad.em;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public enum ZeroTrackRange {
    ZERO(0, "00", "\u4e0d\u8ddf\u8e2a"),
    ONE(1, "01", "0.6e"),
    TWO(2, "02", "0.8e"),
    THREE(3, "03", "1.5e"),
    FOUR(4, "04", "2.5e"),
    FIVE(5, "05", "3.5e");

    private int val;
    private String hex;
    private String type;

    private ZeroTrackRange(int val, String hex, String type) {
        this.val = val;
        this.hex = hex;
        this.type = type;
    }

    public static ZeroTrackRange trackrange(Integer val) {
        if (Objects.isNull(val)) {
            return null;
        }
        for (ZeroTrackRange trackRange : ZeroTrackRange.values()) {
            if (val.intValue() != trackRange.getVal()) continue;
            return trackRange;
        }
        return null;
    }

    public static ZeroTrackRange trackrange(String val) {
        if (StringUtils.isBlank((CharSequence)val)) {
            return null;
        }
        for (ZeroTrackRange trackRange : ZeroTrackRange.values()) {
            if (!val.equals(trackRange.getHex())) continue;
            return trackRange;
        }
        return null;
    }

    public int getVal() {
        return this.val;
    }

    public String getHex() {
        return this.hex;
    }

    public String getType() {
        return this.type;
    }
}

