/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.ad.entity;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.ad.em.ADCMD;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyResponse;
import com.jhscale.meter.protocol.entity.PackAssemblyRequest;
import com.jhscale.meter.utils.CodeUtils;
import java.util.Objects;

public class ADPackAssemblyRequest<T extends ADPackAssemblyResponse>
implements PackAssemblyRequest<ADPackAssemblyResponse> {
    private ADCMD adcmd;
    protected StringBuffer inner = new StringBuffer();

    public ADPackAssemblyRequest() {
    }

    public ADPackAssemblyRequest(ADCMD adcmd) {
        this();
        this.adcmd = adcmd;
    }

    public ADCMD getAdcmd() {
        return this.adcmd;
    }

    public void setAdcmd(ADCMD adcmd) {
        this.adcmd = adcmd;
    }

    @Override
    public T execute() throws MeterException {
        String length;
        String cmd;
        int cmdNum;
        int temp;
        if (Objects.isNull((Object)this.adcmd)) {
            throw new MeterException(MeterStateEnum.AD\u6307\u4ee4\u4e0d\u5b58\u5728);
        }
        int frameNum = (int)(Math.random() * 255.0);
        String frame = Integer.toHexString(frameNum);
        if (frame.length() % 2 != 0) {
            frame = "0" + frame;
        }
        if ((temp = (cmdNum = Integer.parseInt(cmd = this.adcmd.getRequest_hex(), 16)) + CodeUtils.codeArr[(frameNum + 1) % 256]) > 255) {
            temp -= 256;
        }
        if ((cmd = Integer.toHexString(temp)).length() % 2 != 0) {
            cmd = "0" + cmd;
        }
        int dataNum = 0;
        int assembleDataLength = 0;
        this.assembly();
        StringBuilder builder = null;
        if (this.inner.length() > 0) {
            builder = new StringBuilder();
            if (this.inner.length() % 2 != 0) {
                throw new MeterException(MeterStateEnum.AD_\u6570\u636e\u683c\u5f0f\u9519\u8bef);
            }
            assembleDataLength = this.inner.length();
            for (int i = 0; i < this.inner.length() / 2; ++i) {
                String bitData;
                String bit = this.inner.substring(i * 2, i * 2 + 2);
                int bitVal = Integer.parseInt(bit, 16);
                dataNum += bitVal;
                if ((bitVal += CodeUtils.codeArr[(frameNum + 2 + i) % 256]) > 255) {
                    bitVal -= 256;
                }
                builder.append((bitData = Integer.toHexString(bitVal)).length() % 2 != 0 ? "0" + bitData : bitData);
            }
        }
        if ((length = Integer.toHexString((cmd.length() + assembleDataLength) / 2)).length() % 2 != 0) {
            length = "0" + length;
        }
        String verify = Integer.toHexString(frameNum + cmdNum + dataNum);
        verify = verify.substring(verify.length() - 2);
        String cmdData = "02" + length + frame + cmd + (builder != null ? builder.toString() : "") + verify + "03";
        cmdData = CodeUtils.encode(cmdData);
        return (T)new ADPackAssemblyResponse(this.adcmd, frameNum, cmdData);
    }

    @Override
    public boolean code() {
        return false;
    }

    @Override
    public void code(boolean code) {
    }

    @Override
    public void assembly() throws MeterException {
    }
}

