/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.ad.entity;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.ad.em.ADCMD;
import com.jhscale.meter.protocol.ad.entity.ADPackDisassemblyResponse;
import com.jhscale.meter.protocol.entity.IPackResponse;
import com.jhscale.meter.protocol.entity.PackDisassemblyRequest;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.CodeUtils;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public class ADPackDisassemblyRequest<T extends ADPackDisassemblyResponse>
implements PackDisassemblyRequest<ADPackDisassemblyResponse> {
    private byte[] bytes;
    private String cmd;
    private String hex;

    public ADPackDisassemblyRequest() {
    }

    public ADPackDisassemblyRequest(String cmd) {
        this.cmd = cmd;
    }

    public ADPackDisassemblyRequest(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public T execute() throws MeterException {
        String verifyStr;
        String dataStr;
        String cmdStr;
        String frameStr;
        String lengthStr;
        if ((this.bytes == null || this.bytes.length == 0) && StringUtils.isBlank((CharSequence)this.cmd)) {
            throw new MeterException(MeterStateEnum.AD\u54cd\u5e94\u6307\u4ee4\u65e0\u6548);
        }
        if (StringUtils.isNotBlank((CharSequence)this.cmd)) {
            this.cmd = this.cmd.trim().replace(" ", "");
            String source_cmd = CodeUtils.decode(this.cmd);
            String cmdData = CodeUtils.checkData(source_cmd);
            lengthStr = cmdData.substring(0, 2);
            frameStr = cmdData.substring(2, 4);
            cmdStr = cmdData.substring(4, 6);
            dataStr = cmdData.substring(6, cmdData.length() - 2);
            verifyStr = cmdData.substring(cmdData.length() - 2, cmdData.length());
            if (Integer.parseInt(lengthStr, 16) != (cmdStr.length() + dataStr.length()) / 2) {
                throw new MeterException(MeterStateEnum.AD\u6570\u636e\u5305\u957f\u5ea6\u68c0\u67e5\u9519\u8bef);
            }
        } else {
            lengthStr = ByteUtils.toHexString(Arrays.copyOfRange(this.bytes, 1, 2));
            frameStr = ByteUtils.toHexString(Arrays.copyOfRange(this.bytes, 2, 3));
            byte[] cmdb = Arrays.copyOfRange(this.bytes, 3, 4);
            cmdStr = ByteUtils.toHexString(cmdb);
            byte[] data = Arrays.copyOfRange(this.bytes, 4, this.bytes.length - 2);
            dataStr = ByteUtils.toHexString(data);
            verifyStr = ByteUtils.toHexString(Arrays.copyOfRange(this.bytes, this.bytes.length - 2, this.bytes.length - 1));
            if (Integer.parseInt(lengthStr, 16) != data.length + cmdb.length) {
                throw new MeterException(MeterStateEnum.AD\u6570\u636e\u5305\u957f\u5ea6\u68c0\u67e5\u9519\u8bef);
            }
        }
        int frame = Integer.parseInt(frameStr, 16);
        int cmdVal = Integer.parseInt(cmdStr, 16) - CodeUtils.codeArr[(frame + 1) % 256];
        if (cmdVal < 0) {
            cmdVal += 256;
        }
        this.hex = Integer.toHexString(cmdVal);
        String cmd = ByteUtils.hex2Ascii(this.hex);
        int dataVal = 0;
        StringBuffer content = new StringBuffer();
        if (StringUtils.isNotBlank((CharSequence)dataStr)) {
            for (int i = 0; i < dataStr.length() / 2; ++i) {
                String bit = dataStr.substring(i * 2, i * 2 + 2);
                int bitVal = Integer.parseInt(bit, 16) - CodeUtils.codeArr[(frame + 2 + i) % 256];
                if (bitVal < 0) {
                    bitVal += 256;
                }
                dataVal += bitVal;
                String bitData = Integer.toHexString(bitVal);
                content.append(bitData.length() % 2 != 0 ? 0 + bitData : bitData);
            }
        }
        String cVerify = Integer.toHexString(frame + cmdVal + dataVal);
        if (!(cVerify = cVerify.substring(cVerify.length() - 2, cVerify.length())).equalsIgnoreCase(verifyStr)) {
            throw new MeterException(MeterStateEnum.AD\u6821\u9a8c\u7801\u65e0\u6548);
        }
        ADCMD adcmd = ADCMD.get_adcmd(this.hex);
        ADPackDisassemblyResponse response = (ADPackDisassemblyResponse)this.response();
        response.setNid(frame);
        response.length = Integer.parseInt(lengthStr, 16);
        response.cmd = cmd;
        response.adcmd = adcmd;
        response.setCommand(adcmd.getNo());
        response.content = content.toString().trim();
        response = response.disassembly();
        if (response == null) {
            throw new MeterException(MeterStateEnum.\u5b50\u5305\u62c6\u89e3\u5931\u8d25);
        }
        return (T)response;
    }

    @Override
    public <T extends IPackResponse> Class<T> getClazz() {
        return ADCMD.get_adcmd(this.hex).getClazz();
    }

    @Override
    public boolean code() {
        return false;
    }

    @Override
    public void code(boolean code) {
    }
}

