/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.ad.entity.assembly;

import com.jhscale.common.model.inter.JSONModel;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.ad.em.ADCMD;
import com.jhscale.meter.protocol.ad.em.DigitalTube2;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyRequest;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyResponse;
import com.jhscale.meter.utils.ByteUtils;
import java.util.List;

public class SetBackDisplay2ADPARequest
extends ADPackAssemblyRequest<ADPackAssemblyResponse> {
    private DisplayVal displayVal;
    private DisplaySignLeft left;
    private DisplaySignRight right;
    private DisplaySignTail tail;
    private List<String> parts;
    private List<String> signs;

    public SetBackDisplay2ADPARequest() {
        super(ADCMD.Set_Back_Display);
    }

    public SetBackDisplay2ADPARequest(DisplayVal displayVal, DisplaySignLeft left, DisplaySignRight right, DisplaySignTail tail) {
        this();
        this.displayVal = displayVal;
        this.left = left;
        this.right = right;
        this.tail = tail;
    }

    public SetBackDisplay2ADPARequest(List<String> parts, List<String> signs) {
        this();
        this.parts = parts;
        this.signs = signs;
    }

    @Override
    public void assembly() throws MeterException {
        if (this.parts != null && this.parts.size() == 3) {
            this.inner.append(DigitalTube2.digitalTube(12, this.parts.get(0))).append(DigitalTube2.digitalTube(14, this.parts.get(1))).append(DigitalTube2.digitalTube(16, this.parts.get(2)));
        } else if (this.displayVal != null) {
            this.inner.append(DigitalTube2.digitalTube(12, this.displayVal.weight)).append(DigitalTube2.digitalTube(14, this.displayVal.price)).append(DigitalTube2.digitalTube(16, this.displayVal.item));
        }
        if (this.signs != null && this.signs.size() == 3) {
            this.signs.stream().forEach(sign -> this.inner.append((String)sign));
        } else {
            if (this.left == null) {
                this.left = new DisplaySignLeft();
            }
            this.inner.append(this.left.hex());
            if (this.right == null) {
                this.right = new DisplaySignRight();
            }
            this.inner.append(this.right.hex());
            if (this.tail == null) {
                this.tail = new DisplaySignTail();
            }
            this.inner.append(this.tail.hex());
        }
    }

    public DisplayVal getDisplayVal() {
        return this.displayVal;
    }

    public void setDisplayVal(DisplayVal displayVal) {
        this.displayVal = displayVal;
    }

    public List<String> getParts() {
        return this.parts;
    }

    public void setParts(List<String> parts) {
        this.parts = parts;
    }

    public List<String> getSigns() {
        return this.signs;
    }

    public void setSigns(List<String> signs) {
        this.signs = signs;
    }

    public static class DisplaySignTail
    implements DisplaySign {
        private boolean sign1;
        private boolean sign2;
        private boolean sign3;
        private boolean sign4;

        public DisplaySignTail() {
        }

        public DisplaySignTail(boolean sign1, boolean sign2, boolean sign3, boolean sign4) {
            this.sign1 = sign1;
            this.sign2 = sign2;
            this.sign3 = sign3;
            this.sign4 = sign4;
        }

        public boolean isSign1() {
            return this.sign1;
        }

        public DisplaySignTail setSign1(boolean sign1) {
            this.sign1 = sign1;
            return this;
        }

        public boolean isSign2() {
            return this.sign2;
        }

        public DisplaySignTail setSign2(boolean sign2) {
            this.sign2 = sign2;
            return this;
        }

        public boolean isSign3() {
            return this.sign3;
        }

        public DisplaySignTail setSign3(boolean sign3) {
            this.sign3 = sign3;
            return this;
        }

        public boolean isSign4() {
            return this.sign4;
        }

        public DisplaySignTail setSign4(boolean sign4) {
            this.sign4 = sign4;
            return this;
        }

        @Override
        public String hex() {
            return ByteUtils.int2Hex((this.sign1 ? 8 : 0) + (this.sign2 ? 4 : 0) + (this.sign3 ? 2 : 0) + (this.sign4 ? 1 : 0));
        }
    }

    public static class DisplaySignRight
    implements DisplaySign {
        private boolean lb;
        private boolean lb1_4;
        private boolean g;
        private boolean kg;
        private boolean g100;
        private boolean g500;
        private boolean qz;

        public DisplaySignRight() {
        }

        public DisplaySignRight(boolean lb, boolean lb1_4, boolean g, boolean kg, boolean g100, boolean g500, boolean qz) {
            this.lb = lb;
            this.lb1_4 = lb1_4;
            this.g = g;
            this.kg = kg;
            this.g100 = g100;
            this.g500 = g500;
            this.qz = qz;
        }

        public boolean isLb() {
            return this.lb;
        }

        public DisplaySignRight setLb(boolean lb) {
            this.lb = lb;
            return this;
        }

        public boolean isLb1_4() {
            return this.lb1_4;
        }

        public DisplaySignRight setLb1_4(boolean lb1_4) {
            this.lb1_4 = lb1_4;
            return this;
        }

        public boolean isG() {
            return this.g;
        }

        public DisplaySignRight setG(boolean g) {
            this.g = g;
            return this;
        }

        public boolean isKg() {
            return this.kg;
        }

        public DisplaySignRight setKg(boolean kg) {
            this.kg = kg;
            return this;
        }

        public boolean isG100() {
            return this.g100;
        }

        public DisplaySignRight setG100(boolean g100) {
            this.g100 = g100;
            return this;
        }

        public boolean isG500() {
            return this.g500;
        }

        public DisplaySignRight setG500(boolean g500) {
            this.g500 = g500;
            return this;
        }

        public boolean isQz() {
            return this.qz;
        }

        public DisplaySignRight setQz(boolean qz) {
            this.qz = qz;
            return this;
        }

        @Override
        public String hex() {
            return ByteUtils.int2Hex((this.lb ? 1 : 0) + (this.lb1_4 ? 2 : 0) + (this.g ? 4 : 0) + (this.kg ? 8 : 0) + (this.g100 ? 64 : 0) + (this.g500 ? 32 : 0) + (this.qz ? 16 : 0));
        }
    }

    public static class DisplaySignLeft
    implements DisplaySign {
        private boolean net;
        private boolean stablize;
        private boolean zero;
        private boolean pcs;
        private boolean g;
        private boolean lb;
        private boolean kg;
        private boolean oz;

        public DisplaySignLeft() {
        }

        public DisplaySignLeft(boolean net, boolean stablize, boolean zero, boolean pcs, boolean g, boolean lb, boolean kg, boolean oz) {
            this.net = net;
            this.stablize = stablize;
            this.zero = zero;
            this.pcs = pcs;
            this.g = g;
            this.lb = lb;
            this.kg = kg;
            this.oz = oz;
        }

        public boolean isNet() {
            return this.net;
        }

        public DisplaySignLeft setNet(boolean net) {
            this.net = net;
            return this;
        }

        public boolean isStablize() {
            return this.stablize;
        }

        public DisplaySignLeft setStablize(boolean stablize) {
            this.stablize = stablize;
            return this;
        }

        public boolean isZero() {
            return this.zero;
        }

        public DisplaySignLeft setZero(boolean zero) {
            this.zero = zero;
            return this;
        }

        public boolean isPcs() {
            return this.pcs;
        }

        public DisplaySignLeft setPcs(boolean pcs) {
            this.pcs = pcs;
            return this;
        }

        public boolean isG() {
            return this.g;
        }

        public DisplaySignLeft setG(boolean g) {
            this.g = g;
            return this;
        }

        public boolean isLb() {
            return this.lb;
        }

        public DisplaySignLeft setLb(boolean lb) {
            this.lb = lb;
            return this;
        }

        public boolean isKg() {
            return this.kg;
        }

        public DisplaySignLeft setKg(boolean kg) {
            this.kg = kg;
            return this;
        }

        public boolean isOz() {
            return this.oz;
        }

        public DisplaySignLeft setOz(boolean oz) {
            this.oz = oz;
            return this;
        }

        @Override
        public String hex() {
            return ByteUtils.int2Hex((this.net ? 16 : 0) + (this.stablize ? 32 : 0) + (this.zero ? 64 : 0) + (this.pcs ? 128 : 0) + (this.lb ? 1 : 0) + (this.kg ? 6 : 0) + (this.g ? 4 : 0) + (this.oz ? 8 : 0));
        }
    }

    public static interface DisplaySign
    extends JSONModel {
        public String hex();
    }

    public static class DisplayVal
    implements JSONModel {
        private String weight;
        private String price;
        private String item;

        public DisplayVal() {
        }

        public DisplayVal(String weight, String price, String item) {
            this.weight = weight;
            this.price = price;
            this.item = item;
        }

        public String getWeight() {
            return this.weight;
        }

        public DisplayVal setWeight(String weight) {
            this.weight = weight;
            return this;
        }

        public String getPrice() {
            return this.price;
        }

        public DisplayVal setPrice(String price) {
            this.price = price;
            return this;
        }

        public String getItem() {
            return this.item;
        }

        public DisplayVal setItem(String item) {
            this.item = item;
            return this;
        }
    }
}

