/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.ad.entity.assembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.ad.em.ADCMD;
import com.jhscale.meter.protocol.ad.em.Division;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyRequest;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyResponse;
import com.jhscale.meter.utils.ByteUtils;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class SetFullScaleADPARequest
extends ADPackAssemblyRequest<ADPackAssemblyResponse> {
    private int fullScale;
    private int doubleDivision;
    private int floa;
    private Division division;
    private String divisionHex;

    public SetFullScaleADPARequest() {
        super(ADCMD.Set_Full_Scale);
    }

    public SetFullScaleADPARequest(int fullScale, int doubleDivision, int floa, Division division) {
        this();
        this.fullScale = fullScale;
        this.doubleDivision = doubleDivision;
        this.floa = floa;
        this.division = division;
    }

    public SetFullScaleADPARequest(int fullScale, int doubleDivision, int floa, String divisionHex) {
        this();
        this.fullScale = fullScale;
        this.doubleDivision = doubleDivision;
        this.floa = floa;
        this.divisionHex = divisionHex;
    }

    @Override
    public void assembly() throws MeterException {
        if (Objects.isNull(this.fullScale)) {
            throw new MeterException(MeterStateEnum.AD_\u6ee1\u91cf\u7a0b\u65e0\u6548);
        }
        String fullScaleHex = ByteUtils.appendFill(Integer.toHexString(this.fullScale), 6);
        this.inner.append(fullScaleHex);
        String doubleDivisionHex = ByteUtils.appendFill(Integer.toHexString(this.doubleDivision), 6);
        this.inner.append(doubleDivisionHex);
        String floaHex = ByteUtils.appendFill(Integer.toHexString(this.floa), 2);
        this.inner.append(floaHex);
        if (this.division == null && StringUtils.isBlank((CharSequence)this.divisionHex)) {
            throw new MeterException(MeterStateEnum.AD_\u5206\u5ea6\u503c\u65e0\u6548);
        }
        this.inner.append(this.divisionHex != null ? this.divisionHex : this.division.getHex());
    }

    public int getFullScale() {
        return this.fullScale;
    }

    public void setFullScale(int fullScale) {
        this.fullScale = fullScale;
    }

    public int getDoubleDivision() {
        return this.doubleDivision;
    }

    public void setDoubleDivision(int doubleDivision) {
        this.doubleDivision = doubleDivision;
    }

    public int getFloa() {
        return this.floa;
    }

    public void setFloa(int floa) {
        this.floa = floa;
    }

    public Division getDivision() {
        return this.division;
    }

    public void setDivision(Division division) {
        this.division = division;
    }

    public String getDivisionHex() {
        return this.divisionHex;
    }

    public void setDivisionHex(String divisionHex) {
        this.divisionHex = divisionHex;
    }
}

