/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.ad.entity.assembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.ad.em.ADCMD;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyRequest;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyResponse;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.MeterUtils;
import java.math.BigDecimal;
import java.util.Objects;

public class SetPeeledADPARequest
extends ADPackAssemblyRequest<ADPackAssemblyResponse> {
    private BigDecimal weight;

    public SetPeeledADPARequest() {
        super(ADCMD.Set_Peeled);
    }

    public SetPeeledADPARequest(BigDecimal weight) {
        this();
        this.weight = weight;
    }

    @Override
    public void assembly() throws MeterException {
        if (Objects.isNull(this.weight) && this.weight.compareTo(new BigDecimal(0)) == -1 && this.weight.compareTo(new BigDecimal(0xFFFFFF)) == 1) {
            throw new MeterException(MeterStateEnum.AD_\u76ae\u91cd\u65e0\u6548);
        }
        int floa = MeterUtils.checkIsDoublePointTwo(this.weight);
        int floatVal = MeterUtils.floatVal(floa);
        int val = this.weight.multiply(new BigDecimal(floatVal)).intValue();
        String valHex = ByteUtils.appendFill(Integer.toHexString(val), 6);
        String floaHex = ByteUtils.appendFill(Integer.toHexString(floa), 2);
        this.inner.append(valHex).append(floaHex);
    }

    public BigDecimal getWeight() {
        return this.weight;
    }

    public void setWeight(BigDecimal weight) {
        this.weight = weight;
    }
}

