/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.ad.entity.assembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.ad.em.ADCMD;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyRequest;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyResponse;
import com.jhscale.meter.utils.ByteUtils;
import java.math.BigDecimal;

public class SetWeightScaleADPARequest
extends ADPackAssemblyRequest<ADPackAssemblyResponse> {
    private BigDecimal scale;
    private BigDecimal fullScale;

    public SetWeightScaleADPARequest() {
        super(ADCMD.Set_Weight_Scale);
    }

    public SetWeightScaleADPARequest(BigDecimal scale) {
        this();
        this.scale = scale;
    }

    @Override
    public void assembly() throws MeterException {
        if (this.scale == null) {
            throw new MeterException(MeterStateEnum.AD_\u6807\u5b9a\u91cd\u91cf\u65e0\u6548);
        }
        if (this.scale.compareTo(new BigDecimal(0)) == -1) {
            this.scale = new BigDecimal(0);
        }
        if (this.fullScale != null && this.scale.compareTo(this.fullScale) == 1) {
            this.scale = this.fullScale;
        }
        this.inner.append(ByteUtils.appendFill(Integer.toHexString(this.scale.intValue()), 6));
    }

    public BigDecimal getScale() {
        return this.scale;
    }

    public void setScale(BigDecimal scale) {
        this.scale = scale;
    }

    public BigDecimal getFullScale() {
        return this.fullScale;
    }

    public void setFullScale(BigDecimal fullScale) {
        this.fullScale = fullScale;
    }
}

