/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.ad.entity.disassembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.protocol.ad.entity.ADPackDisassemblyResponse;
import com.jhscale.meter.utils.ByteUtils;
import org.apache.commons.lang3.StringUtils;

public class ObtainInternalCodeADPDResponse
extends ADPackDisassemblyResponse {
    private Integer internalCode;
    private String sign;
    private boolean s_stb = false;
    private boolean s_negative = false;

    @Override
    public ObtainInternalCodeADPDResponse disassembly() throws MeterException {
        try {
            this.internalCode = Integer.parseInt(this.content.substring(0, 6), 16);
            String sginStr = ByteUtils.formatMark(this.content.substring(6));
            if (StringUtils.isNotBlank((CharSequence)sginStr)) {
                StringBuffer buffer = new StringBuffer();
                if (sginStr.charAt(2) == '1') {
                    this.s_stb = true;
                    buffer.append("STB,");
                }
                if (sginStr.charAt(5) == '1') {
                    this.s_negative = true;
                    buffer.append("NEGATIVE,");
                }
                if (buffer.length() > 1) {
                    this.sign = buffer.substring(0, buffer.length() - 1);
                }
            }
        }
        catch (Exception e) {
            JLog.error("ObtainInternalCodeADPDResponse EXP:{}", e.getMessage(), e);
            throw new MeterException(MeterStateEnum.AD_\u5185\u7801\u8bfb\u53d6\u89e3\u6790\u5931\u8d25);
        }
        return this;
    }

    public Integer getInternalCode() {
        return this.internalCode;
    }

    public Integer getActualInternalCode() {
        return this.s_negative ? 0 - this.internalCode : this.internalCode;
    }

    public String getSign() {
        return this.sign;
    }

    public boolean isS_stb() {
        return this.s_stb;
    }

    public boolean isS_negative() {
        return this.s_negative;
    }
}

