/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.ad.entity.disassembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.protocol.ad.entity.ADPackDisassemblyResponse;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.MeterUtils;
import java.math.BigDecimal;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ObtainWeightADPDResponse
extends ADPackDisassemblyResponse {
    private String flag;
    private String sign;
    private boolean s_adc = false;
    private boolean s_ovf = false;
    private boolean s_stb = false;
    private boolean s_zero = false;
    private boolean s_tare = false;
    private boolean s_negative = false;
    private boolean s_privilege = false;
    private boolean s_on = false;
    private Integer floa;
    private BigDecimal weight;
    private BigDecimal tare;
    private BigDecimal gross;
    private BigDecimal power;
    private int waveCode;
    private int zeroCode;
    private int instantCode;

    @Override
    public ObtainWeightADPDResponse disassembly() throws MeterException {
        if (this.getLength() == 10) {
            this.weight_10();
        } else if (this.getLength() == 8) {
            this.weight_8();
        } else {
            this.weight_5();
        }
        return this;
    }

    private void weight_5() {
        this.flag();
        this.instantCode = Integer.parseInt(this.content.substring(2, 8), 16);
    }

    private void weight_8() {
        this.flag();
        int waveValue = Integer.parseInt(this.content.substring(2, 8), 16);
        if (waveValue >= 0x800000) {
            waveValue -= 0x1000000;
        }
        this.waveCode = waveValue;
        int zeroValue = Integer.parseInt(this.content.substring(8, 14), 16);
        if (zeroValue >= 0x800000) {
            zeroValue -= 0x1000000;
        }
        this.zeroCode = zeroValue;
    }

    private void weight_10() throws MeterException {
        try {
            int floa;
            this.flag();
            int val = 0;
            Integer val2 = null;
            String val2Symbol = null;
            int length = this.content.length();
            if (length == 12) {
                val = Integer.parseInt(this.content.substring(2, this.content.length() - 4), 16);
                floa = Integer.parseInt(this.content.substring(this.content.length() - 4, this.content.length() - 2), 16);
                this.power = new BigDecimal(Integer.parseInt(this.content.substring(this.content.length() - 2, this.content.length()), 16)).divide(new BigDecimal(10));
            } else if (length == 18) {
                val = Integer.parseInt(this.content.substring(2, 8), 16);
                floa = Integer.parseInt(this.content.substring(8, 10), 16);
                val2 = Integer.parseInt(this.content.substring(10, 16), 16);
                val2Symbol = ByteUtils.hex2Ascii(this.content.substring(16, 18));
            } else {
                val = Integer.parseInt(this.content.substring(2, this.content.length() - 2), 16);
                floa = Integer.parseInt(this.content.substring(this.content.length() - 2), 16);
            }
            this.floa = floa;
            int floatVal = MeterUtils.floatVal(floa);
            this.weight = new BigDecimal(val).divide(new BigDecimal(floatVal));
            if (Objects.nonNull(val2)) {
                if ("T".equalsIgnoreCase(val2Symbol)) {
                    this.tare = new BigDecimal(val2).divide(new BigDecimal(floatVal));
                    this.gross = this.weight.add(this.tare);
                } else {
                    this.gross = new BigDecimal(val2).divide(new BigDecimal(floatVal));
                    this.tare = this.gross.subtract(this.weight);
                }
            }
        }
        catch (Exception e) {
            JLog.error("ObtainWeigthADPDResponse EXP:{}", e.getMessage(), e);
            throw new MeterException(MeterStateEnum.AD_\u8bfb\u53d6\u91cd\u91cf\u89e3\u6790\u5931\u8d25);
        }
    }

    private void flag() {
        this.flag = ByteUtils.formatMark(this.content.substring(0, 2));
        if (StringUtils.isNotBlank((CharSequence)this.flag)) {
            StringBuffer buffer = new StringBuffer();
            if (this.flag.charAt(0) == '1') {
                this.s_adc = true;
                buffer.append("ADC,");
            }
            if (this.flag.charAt(1) == '1') {
                this.s_ovf = true;
                buffer.append("OVF,");
            }
            if (this.flag.charAt(2) == '1') {
                this.s_stb = true;
                buffer.append("STB,");
            }
            if (this.flag.charAt(3) == '1') {
                this.s_zero = true;
                buffer.append("ZERO,");
            }
            if (this.flag.charAt(4) == '1') {
                this.s_tare = true;
                buffer.append("TARE,");
            }
            if (this.flag.charAt(5) == '1') {
                this.s_negative = true;
                buffer.append("NEGATIVE,");
            }
            if (this.flag.charAt(6) == '1') {
                this.s_privilege = true;
                buffer.append("PRIVILEGE,");
            }
            if (this.flag.charAt(7) == '1') {
                this.s_on = true;
                buffer.append("ON,");
            }
            if (buffer.length() > 1) {
                this.sign = buffer.substring(0, buffer.length() - 1);
            }
        }
    }

    public String getFlag() {
        return this.flag;
    }

    public String getSign() {
        return this.sign;
    }

    public boolean isS_adc() {
        return this.s_adc;
    }

    public boolean isS_ovf() {
        return this.s_ovf;
    }

    public boolean isS_stb() {
        return this.s_stb;
    }

    public boolean isS_zero() {
        return this.s_zero;
    }

    public boolean isS_tare() {
        return this.s_tare;
    }

    public boolean isS_negative() {
        return this.s_negative;
    }

    public boolean isS_privilege() {
        return this.s_privilege;
    }

    public boolean isS_on() {
        return this.s_on;
    }

    public Integer getFloa() {
        return this.floa;
    }

    public BigDecimal getWeight() {
        return this.weight;
    }

    public BigDecimal getActualWeight() {
        return this.s_negative && Objects.nonNull(this.weight) ? new BigDecimal(0).subtract(this.weight) : this.weight;
    }

    public BigDecimal getTare() {
        return this.tare;
    }

    public BigDecimal getGross() {
        return this.gross;
    }

    public BigDecimal getPower() {
        return this.power;
    }

    public int getWaveCode() {
        return this.waveCode;
    }

    public int getZeroCode() {
        return this.zeroCode;
    }

    public int getInstantCode() {
        return this.instantCode;
    }
}

