/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.ad.listener;

import com.jhscale.common.utils.SystemtUtils;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.protocol.IProtocolManager;
import com.jhscale.meter.protocol.IProtocolResponse;
import com.jhscale.meter.protocol.ad.em.CommunicationState;
import com.jhscale.meter.protocol.ad.entity.disassembly.UpgradeFirmwareADPDResponse;
import com.jhscale.meter.protocol.ad.listener.ADScaleClientEventListener;
import com.jhscale.meter.protocol.entity.ProtocolEntity;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.utils.ByteUtils;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public class ADUpgradeEventListener
extends ADScaleClientEventListener {
    private Integer size = 4;
    private Integer sleep = 12;
    private boolean shake_state = true;
    public static final byte[] shake = ByteUtils.fromHexString("55555555555555555555555555555555");
    private boolean upgrade = true;

    public ADUpgradeEventListener(IProtocolResponse protocolResponse, IProtocolManager protocolManager) {
        super(protocolResponse, protocolManager);
    }

    @Override
    public void onClientEvent(byte[] bytes) throws MeterException {
        if (GlobalPara.getInstance().isRunLog()) {
            System.out.println(String.format("Model: %s ; Content: %s", new Object[]{this.communication, ByteUtils.toHexString(bytes)}));
        }
        switch (this.communication) {
            case NORMAL: {
                super.onClientEvent(bytes);
                if (!this.shake_state) break;
                this.manager.execute(shake);
                break;
            }
            case SHAKE: {
                super.addBuffer(bytes);
                if (!this.shake_state) break;
                this.manager.execute(shake);
                break;
            }
            case UPGRATE: {
                String content = ByteUtils.toHexString(bytes);
                this.upgrade = StringUtils.isBlank((CharSequence)content) || !content.endsWith("13");
                super.clear();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] execute(byte[] buffer) {
        switch (this.communication) {
            case NORMAL: {
                return super.execute(buffer);
            }
            case SHAKE: {
                int index = -1;
                for (int i = 0; i < buffer.length; ++i) {
                    if (buffer[i] != 85) continue;
                    index = i;
                    break;
                }
                if (index == -1) {
                    return buffer;
                }
                buffer = Arrays.copyOfRange(buffer, index, buffer.length);
                ArrayList<byte[]> bytes = new ArrayList<byte[]>();
                index = 0;
                for (int i = 0; i < buffer.length; ++i) {
                    if (buffer[i] != 13 || i + 1 == buffer.length || buffer[i + 1] != 10) continue;
                    bytes.add(Arrays.copyOfRange(buffer, index, i + 1));
                    index = i + 1;
                }
                try {
                    if (bytes.isEmpty()) return Arrays.copyOfRange(buffer, index, buffer.length);
                    for (byte[] aByte : bytes) {
                        String version = new String(aByte).trim();
                        if (!version.startsWith("U")) continue;
                        UpgradeFirmwareADPDResponse response = new UpgradeFirmwareADPDResponse();
                        response.setVersion(version);
                        if (this.defaultResponse == null || !(this.defaultResponse instanceof IProtocolResponse)) continue;
                        ((IProtocolResponse)this.defaultResponse).target(response);
                    }
                    return Arrays.copyOfRange(buffer, index, buffer.length);
                }
                catch (Exception e) {
                    if (this.defaultResponse == null) return Arrays.copyOfRange(buffer, index, buffer.length);
                    this.defaultResponse.exp(new MeterException(e, MeterStateEnum.\u5176\u4ed6\u672a\u77e5\u5f02\u5e38));
                }
                return Arrays.copyOfRange(buffer, index, buffer.length);
            }
        }
        return new byte[0];
    }

    public void setShake_state(boolean shake_state) {
        this.shake_state = shake_state;
    }

    public void upgradeWithCtrl(byte[] bytes, PortManager portmanager) {
        block14: {
            ProtocolEntity protocolEntity = (ProtocolEntity)this.responseMap.get(CommunicationState.UPGRATE.getKey());
            if (protocolEntity != null && protocolEntity.getResponse() != null) {
                IProtocolResponse iProtocolResponse = (IProtocolResponse)protocolEntity.getResponse();
                try {
                    int i = 0;
                    while (i < bytes.length) {
                        if (this.upgrade) {
                            portmanager.writeDataImmediately(Arrays.copyOfRange(bytes, i, i + 1));
                            if (iProtocolResponse != null && (i % 512 == 0 || i + 1 == bytes.length)) {
                                UpgradeFirmwareADPDResponse response = new UpgradeFirmwareADPDResponse();
                                response.setSchedule(i + 1 + "/" + bytes.length);
                                iProtocolResponse.target(response);
                                if (i + 1 == bytes.length) {
                                    int finalI = i;
                                    GlobalPara.getInstance().executor().execute(() -> {
                                        SystemtUtils.sleep((int)20);
                                        UpgradeFirmwareADPDResponse upgradeFirmwareADPDFinishResponse = new UpgradeFirmwareADPDResponse();
                                        upgradeFirmwareADPDFinishResponse.setSchedule(finalI + 1 + "/" + bytes.length);
                                        iProtocolResponse.upgrade_finish(upgradeFirmwareADPDFinishResponse);
                                    });
                                }
                            }
                            ++i;
                            try {
                                Thread.sleep(2L);
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        if (GlobalPara.getInstance().isRunLog()) {
                            System.out.println("\u6d41\u63a7\u4e2d");
                        }
                        try {
                            Thread.sleep(1L);
                        }
                        catch (Exception exception) {}
                    }
                    this.setCommunication(CommunicationState.NORMAL);
                }
                catch (MeterException e) {
                    if (iProtocolResponse != null) {
                        iProtocolResponse.exp(e);
                    }
                }
                catch (Exception e) {
                    if (iProtocolResponse == null) break block14;
                    iProtocolResponse.exp(new MeterException(e, MeterStateEnum.\u5176\u4ed6\u672a\u77e5\u5f02\u5e38));
                }
            }
        }
    }

    public void upgrade(byte[] bytes, PortManager portmanager) {
        block10: {
            int length = bytes.length % this.size == 0 ? bytes.length / this.size : bytes.length / this.size + 1;
            ProtocolEntity protocolEntity = (ProtocolEntity)this.responseMap.get(CommunicationState.UPGRATE.getKey());
            if (protocolEntity != null && protocolEntity.getResponse() != null) {
                IProtocolResponse iProtocolResponse = (IProtocolResponse)protocolEntity.getResponse();
                try {
                    for (int i = 0; i < length; ++i) {
                        int start = i * this.size;
                        int end = (i + 1) * this.size;
                        end = end > bytes.length ? bytes.length : end;
                        portmanager.writeDataImmediately(Arrays.copyOfRange(bytes, start, end));
                        if (iProtocolResponse != null && i % 256 == 0) {
                            UpgradeFirmwareADPDResponse response = new UpgradeFirmwareADPDResponse();
                            response.setSchedule(i + 1 + "/" + length);
                            iProtocolResponse.target(response);
                        }
                        try {
                            Thread.sleep(this.sleep.intValue());
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    UpgradeFirmwareADPDResponse response = new UpgradeFirmwareADPDResponse();
                    response.setSchedule(length + "/" + length);
                    if (iProtocolResponse != null) {
                        iProtocolResponse.target(response);
                    }
                    this.setCommunication(CommunicationState.NORMAL);
                }
                catch (MeterException e) {
                    if (iProtocolResponse != null) {
                        iProtocolResponse.exp(e);
                    }
                }
                catch (Exception e) {
                    if (iProtocolResponse == null) break block10;
                    iProtocolResponse.exp(new MeterException(e, MeterStateEnum.\u5176\u4ed6\u672a\u77e5\u5f02\u5e38));
                }
            }
        }
    }
}

