/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.ble_print.entity;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.ble_print.em.BPCMD;
import com.jhscale.meter.protocol.ble_print.entity.BPPackAssemblyResponse;
import com.jhscale.meter.protocol.entity.PackAssemblyRequest;
import com.jhscale.meter.utils.CodeUtils;
import java.util.Objects;

public class BPPackAssemblyRequest<T extends BPPackAssemblyResponse>
implements PackAssemblyRequest<BPPackAssemblyResponse> {
    private BPCMD bpcmd;
    protected StringBuffer inner = new StringBuffer();
    private boolean code = true;

    public BPPackAssemblyRequest() {
    }

    public BPPackAssemblyRequest(BPCMD bpcmd) {
        this();
        this.bpcmd = bpcmd;
    }

    public BPCMD getBpcmd() {
        return this.bpcmd;
    }

    public void setBpcmd(BPCMD bpcmd) {
        this.bpcmd = bpcmd;
    }

    @Override
    public T execute() throws MeterException {
        String length;
        if (Objects.isNull((Object)this.bpcmd)) {
            throw new MeterException(MeterStateEnum.BP\u6307\u4ee4\u4e0d\u5b58\u5728);
        }
        int frameNum = (int)(Math.random() * 255.0);
        String frame = Integer.toHexString(frameNum);
        if (frame.length() % 2 != 0) {
            frame = "0" + frame;
        }
        String cmd = this.bpcmd.getRequest_hex();
        int cmdNum = Integer.parseInt(cmd, 16);
        if (this.code && (cmdNum += CodeUtils.codeArr[(frameNum + 1) % 256]) > 255) {
            cmdNum -= 256;
        }
        if ((cmd = Integer.toHexString(cmdNum)).length() % 2 != 0) {
            cmd = "0" + cmd;
        }
        int dataNum = 0;
        int assembleDataLength = 0;
        this.assembly();
        StringBuffer buffer = null;
        if (this.inner.length() > 0) {
            buffer = new StringBuffer();
            if (this.inner.length() % 2 != 0) {
                throw new MeterException(MeterStateEnum.BP\u6570\u636e\u683c\u5f0f\u9519\u8bef);
            }
            assembleDataLength = this.inner.length();
            for (int i = 0; i < this.inner.length() / 2; ++i) {
                String bitData;
                String bit = this.inner.substring(i * 2, i * 2 + 2);
                int bitVal = Integer.parseInt(bit, 16);
                dataNum += bitVal;
                if (this.code && (bitVal += CodeUtils.codeArr[(frameNum + 2 + i) % 256]) > 255) {
                    bitVal -= 256;
                }
                buffer.append((bitData = Integer.toHexString(bitVal)).length() % 2 != 0 ? "0" + bitData : bitData);
            }
        }
        if ((length = Integer.toHexString((cmd.length() + assembleDataLength) / 2)).length() % 2 != 0) {
            length = "0" + length;
        }
        String verify = Integer.toHexString(frameNum + cmdNum + dataNum);
        verify = verify.substring(verify.length() - 2, verify.length());
        String cmdData = "02" + length + frame + cmd + (buffer != null ? buffer.toString() : "") + verify + "03";
        if (this.code) {
            cmdData = CodeUtils.encode(cmdData);
        }
        return (T)new BPPackAssemblyResponse(this.bpcmd, frameNum, cmdData);
    }

    @Override
    public boolean code() {
        return this.code;
    }

    @Override
    public void code(boolean code) {
        this.code = code;
    }

    @Override
    public void assembly() throws MeterException {
    }
}

