/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.ble_print.entity;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.ble_print.em.BPCMD;
import com.jhscale.meter.protocol.ble_print.entity.BPPackAssemblyRequest;
import com.jhscale.meter.protocol.ble_print.entity.BPPackDisassemblyResponse;
import com.jhscale.meter.protocol.entity.IPackResponse;
import com.jhscale.meter.protocol.entity.PackDisassemblyRequest;
import com.jhscale.meter.protocol.entity.ProtocolEntity;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.CodeUtils;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BPPackDisassemblyRequest<T extends BPPackDisassemblyResponse>
implements PackDisassemblyRequest<BPPackDisassemblyResponse> {
    private boolean code;
    private byte[] bytes;
    private String cmd;
    private String hex;
    private Map<String, ProtocolEntity> responseMap;

    public BPPackDisassemblyRequest() {
    }

    public BPPackDisassemblyRequest(String cmd) {
        this.cmd = cmd;
    }

    public BPPackDisassemblyRequest(Map<String, ProtocolEntity> responseMap, byte[] bytes) {
        this.responseMap = responseMap;
        this.bytes = bytes;
    }

    @Override
    public T execute() throws MeterException {
        String verifyStr;
        String dataStr;
        String cmdStr;
        String frameStr;
        String lengthStr;
        if ((this.bytes == null || this.bytes.length == 0) && StringUtils.isBlank((CharSequence)this.cmd)) {
            throw new MeterException(MeterStateEnum.BP\u54cd\u5e94\u6307\u4ee4\u65e0\u6548);
        }
        if (StringUtils.isNotBlank((CharSequence)this.cmd)) {
            String source_cmd = this.cmd.trim().replace(" ", "");
            String cmdData = CodeUtils.checkData(source_cmd);
            lengthStr = cmdData.substring(0, 2);
            frameStr = cmdData.substring(2, 4);
            cmdStr = cmdData.substring(4, 6);
            dataStr = cmdData.substring(6, cmdData.length() - 2);
            verifyStr = cmdData.substring(cmdData.length() - 2, cmdData.length());
            if (Integer.parseInt(lengthStr, 16) != (cmdStr.length() + dataStr.length()) / 2) {
                throw new MeterException(MeterStateEnum.BP\u6570\u636e\u5305\u957f\u5ea6\u68c0\u67e5\u9519\u8bef);
            }
        } else {
            byte[] source_bytes = this.bytes;
            lengthStr = ByteUtils.toHexString(Arrays.copyOfRange(source_bytes, 1, 2));
            frameStr = ByteUtils.toHexString(Arrays.copyOfRange(source_bytes, 2, 3));
            byte[] cmdb = Arrays.copyOfRange(source_bytes, 3, 4);
            cmdStr = ByteUtils.toHexString(cmdb);
            byte[] data = Arrays.copyOfRange(source_bytes, 4, source_bytes.length - 2);
            dataStr = ByteUtils.toHexString(data);
            verifyStr = ByteUtils.toHexString(Arrays.copyOfRange(source_bytes, source_bytes.length - 2, source_bytes.length - 1));
            if (Integer.parseInt(lengthStr, 16) != data.length + cmdb.length) {
                throw new MeterException(MeterStateEnum.BP\u6570\u636e\u5305\u957f\u5ea6\u68c0\u67e5\u9519\u8bef);
            }
        }
        int frame = Integer.parseInt(frameStr, 16);
        int cmdVal = Integer.parseInt(cmdStr, 16);
        if (this.code && (cmdVal -= CodeUtils.codeArr[(frame + 1) % 256]) < 0) {
            cmdVal += 256;
        }
        this.hex = Integer.toHexString(cmdVal);
        String cmd = ByteUtils.hex2Ascii(this.hex);
        int dataVal = 0;
        StringBuffer content = new StringBuffer();
        if (StringUtils.isNotBlank((CharSequence)dataStr)) {
            for (int i = 0; i < dataStr.length() / 2; ++i) {
                String bit = dataStr.substring(i * 2, i * 2 + 2);
                int bitVal = Integer.parseInt(bit, 16);
                if (this.code && (bitVal -= CodeUtils.codeArr[(frame + 2 + i) % 256]) < 0) {
                    bitVal += 256;
                }
                dataVal += bitVal;
                String bitData = Integer.toHexString(bitVal);
                content.append(bitData.length() % 2 != 0 ? "0" + bitData : bitData);
            }
        }
        String cVerify = Integer.toHexString(frame + cmdVal + dataVal);
        if (!(cVerify = cVerify.substring(cVerify.length() - 2, cVerify.length())).equalsIgnoreCase(verifyStr)) {
            throw new MeterException(MeterStateEnum.BP\u6821\u9a8c\u7801\u65e0\u6548);
        }
        BPCMD bpcmd = BPCMD.get_bpcmd(this.hex);
        BPPackDisassemblyResponse response = (BPPackDisassemblyResponse)this.response();
        response.setNid(frame);
        response.setLength(Integer.parseInt(lengthStr, 16));
        response.setCmd(cmd);
        response.setBpcmd(bpcmd);
        response.setCommand(bpcmd.getNo());
        response.content = content.toString().trim();
        response.setRequest(this.request(response.KEY()));
        response.disassembly();
        return (T)response;
    }

    public BPPackAssemblyRequest request(String frame) {
        ProtocolEntity protocolEntity;
        if (this.responseMap != null && (protocolEntity = this.responseMap.get(frame)) != null) {
            return (BPPackAssemblyRequest)protocolEntity.getRequest();
        }
        return null;
    }

    @Override
    public <T extends IPackResponse> Class<T> getClazz() {
        return BPCMD.get_bpcmd(this.hex).getClazz();
    }

    @Override
    public boolean code() {
        return this.code;
    }

    @Override
    public void code(boolean code) {
        this.code = code;
    }
}

