/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.ble_print.entity;

import com.jhscale.common.utils.ByteUtils;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.protocol.ad.em.ADResult;
import com.jhscale.meter.protocol.ble_print.em.BPCMD;
import com.jhscale.meter.protocol.ble_print.entity.BPPackAssemblyRequest;
import com.jhscale.meter.protocol.entity.PackDisassemblyResponse;
import java.math.BigDecimal;
import java.util.Date;

public class BPPackDisassemblyResponse<T extends BPPackAssemblyRequest>
extends PackDisassemblyResponse {
    private ADResult result = ADResult.P;
    private String resultHex = ADResult.P.getSign();
    private int length;
    private String cmd;
    private BPCMD bpcmd;
    protected String content;
    protected boolean end = true;
    private T request;

    @Override
    public BPPackDisassemblyResponse disassembly() throws MeterException {
        try {
            this.resultHex = new String(ByteUtils.fromHexString((String)this.split(2)));
            this.result = ADResult.result(this.resultHex);
        }
        catch (Exception e) {
            JLog.error("{} EXP:{}", this.getClass().getSimpleName(), e.getMessage(), e);
            throw new MeterException(MeterStateEnum.BP_\u64cd\u4f5c\u7ed3\u679c\u89e3\u6790\u5931\u8d25);
        }
        return this;
    }

    public ADResult getResult() {
        return this.result;
    }

    public String getResultHex() {
        return this.resultHex;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public String getCmd() {
        return this.cmd;
    }

    public void setBpcmd(BPCMD bpcmd) {
        this.bpcmd = bpcmd;
    }

    public BPCMD getBpcmd() {
        return this.bpcmd;
    }

    protected void setRequest(T request) {
        this.request = request;
    }

    protected T getRequest() {
        return this.request;
    }

    @Override
    public boolean end() {
        return this.end;
    }

    protected String split(int length) {
        String part = this.content.substring(0, length);
        this.content = this.content.substring(length);
        return part;
    }

    protected int split_int(int length) {
        return Integer.parseInt(this.split(length), 16);
    }

    protected Date split_date() {
        return ByteUtils.convertTime_nr((String)this.split(8));
    }

    protected BigDecimal split_bigDecimal() {
        return ByteUtils.convertBigDecimal((String)this.split(8));
    }

    protected String split_bin() {
        return ByteUtils.formatMark((String)this.split(2));
    }
}

