/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.ble_print.entity.assembly;

import com.jhscale.common.model.device.barcode_format.DBarcodeFormatV2;
import com.jhscale.common.model.device.barcode_format.module.DBarV2;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.ble_print.em.BPCMD;
import com.jhscale.meter.protocol.ble_print.entity.BPPackAssemblyRequest;
import com.jhscale.meter.protocol.ble_print.entity.BPPackAssemblyResponse;
import com.jhscale.meter.utils.MeterUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class WriteBarFormatBPPARequest
extends BPPackAssemblyRequest<BPPackAssemblyResponse> {
    private List<DBarcodeFormatV2> formats;

    public WriteBarFormatBPPARequest() {
        super(BPCMD.Write_Bar_Format);
    }

    public void add(DBarcodeFormatV2 ... formats) {
        if (formats != null && formats.length > 0) {
            this.add(Arrays.asList(formats));
        }
    }

    public void add(List<DBarcodeFormatV2> formats) {
        if (formats != null && !formats.isEmpty()) {
            if (this.formats == null) {
                this.formats = new ArrayList<DBarcodeFormatV2>();
            }
            this.formats.addAll(formats);
        }
    }

    @Override
    public void assembly() throws MeterException {
        if (Objects.isNull(this.formats)) {
            throw new MeterException(MeterStateEnum.BP\u6761\u7801\u683c\u5f0f\u4e0d\u5b58\u5728);
        }
        int count = 0;
        for (DBarcodeFormatV2 format : this.formats) {
            if (format.getBars() == null || format.getBars().isEmpty()) continue;
            ++count;
        }
        if (count != 0) {
            this.inner.append(MeterUtils.append(count));
            for (DBarcodeFormatV2 format : this.formats) {
                byte[] byArray;
                if (format.getBars() == null || format.getBars().isEmpty()) continue;
                StringBuffer stringBuffer = this.inner.append(MeterUtils.append(format.no()));
                if (Objects.nonNull(format.getSplit())) {
                    byArray = format.getSplit().substring(0, 1).getBytes();
                } else {
                    byte[] byArray2 = new byte[1];
                    byArray = byArray2;
                    byArray2[0] = 0;
                }
                stringBuffer.append(MeterUtils.append(byArray)).append(MeterUtils.append(format.getBars().size()));
                for (Object o : format.getBars()) {
                    DBarV2 bar = (DBarV2)o;
                    this.inner.append(MeterUtils.append(bar.sno())).append(MeterUtils.append(bar.scontent()));
                }
            }
        }
    }

    public List<DBarcodeFormatV2> getFormats() {
        return this.formats;
    }

    public void setFormats(List<DBarcodeFormatV2> formats) {
        this.formats = formats;
    }
}

