/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.ble_print.entity.disassembly;

import com.jhscale.common.em.DeviceType;
import com.jhscale.common.model.device.log.DLOGV1;
import com.jhscale.common.model.device.log.module.DGoods;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.ble_print.entity.BPPackDisassemblyResponse;
import com.jhscale.meter.protocol.ble_print.entity.assembly.ReadLOGBPPARequest;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class ReadLOGBPPDResponse
extends BPPackDisassemblyResponse<ReadLOGBPPARequest> {
    private String action;
    private String flag;
    private List<DLOGV1> logs;

    @Override
    public ReadLOGBPPDResponse disassembly() throws MeterException {
        ReadLOGBPPARequest request = (ReadLOGBPPARequest)this.getRequest();
        this.action = request.getAction();
        if ("27".equals(request.getAction())) {
            super.disassembly();
        } else {
            this.flag = this.split_bin();
            this.end = this.flag.charAt(0) == '1';
            int count = this.split_int(2);
            for (int i = 0; i < count; ++i) {
                int fid = this.split_int(4);
                int goods_no = this.split_int(4);
                Date date = this.split_date();
                BigDecimal gross = this.split_bigDecimal();
                BigDecimal tare = this.split_bigDecimal();
                BigDecimal weight = gross.subtract(tare);
                this.add(new DLOGV1().setFid(Integer.valueOf(fid)).setKind(DeviceType.BT_Print_Scales.getItype()).setTradeTime(date).addGoods(new DGoods[]{new DGoods().setNo(Integer.valueOf(goods_no)).setAmount(weight).setText1(gross.toString()).setText2(tare.toString())}));
            }
        }
        return this;
    }

    public void add(DLOGV1 ... logs) {
        if (logs != null && logs.length > 0) {
            this.add(Arrays.asList(logs));
        }
    }

    public void add(List<DLOGV1> logs) {
        if (logs != null && !logs.isEmpty()) {
            if (this.logs == null) {
                this.logs = new ArrayList<DLOGV1>();
            }
            this.logs.addAll(logs);
        }
    }

    public Integer length() {
        return Objects.nonNull(this.logs) ? this.logs.size() : 0;
    }

    public Integer lastFid() {
        return Objects.isNull(this.logs) || this.logs.isEmpty() ? 0 : this.logs.get(this.logs.size() - 1).getFid();
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getFlag() {
        return this.flag;
    }

    public void setFlag(String flag) {
        this.flag = flag;
    }

    public List<DLOGV1> getLogs() {
        return this.logs;
    }

    public void setLogs(List<DLOGV1> logs) {
        this.logs = logs;
    }
}

