/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.ble_print.listener;

import com.jhscale.common.utils.ByteUtils;
import com.jhscale.meter.entity.ProtocolAnalyse;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.protocol.IBProtocolResponse;
import com.jhscale.meter.protocol.IDebugProtocolResponse;
import com.jhscale.meter.protocol.IOProtocolResponse;
import com.jhscale.meter.protocol.IProtocolManager;
import com.jhscale.meter.protocol.IProtocolResponse;
import com.jhscale.meter.protocol.ProtocolBufferEvent;
import com.jhscale.meter.protocol.ProtocolBufferThread;
import com.jhscale.meter.protocol.ad.em.CommunicationState;
import com.jhscale.meter.protocol.ble_print.entity.BPPackDisassemblyRequest;
import com.jhscale.meter.protocol.ble_print.entity.BPPackDisassemblyResponse;
import com.jhscale.meter.protocol.entity.ProtocolEntity;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.utils.CodeUtils;
import com.jhscale.meter.utils.MeterUtils;
import java.util.HashMap;
import java.util.Map;

public class BlePrintClientEventListener
implements DeviceClientEventListener,
ProtocolBufferEvent {
    private CommunicationState communication = CommunicationState.NORMAL;
    private boolean code = true;
    private IBProtocolResponse defaultResponse;
    private IProtocolManager manager;
    private Map<String, ProtocolEntity> responseMap;
    public ProtocolBufferThread thread;

    public BlePrintClientEventListener(IBProtocolResponse defaultResponse, IProtocolManager manager, boolean code) {
        this.defaultResponse = defaultResponse;
        this.manager = manager;
        this.responseMap = new HashMap<String, ProtocolEntity>();
        this.code = code;
        this.thread = new ProtocolBufferThread(this);
        this.thread.switchOn();
        this.thread.start();
    }

    @Override
    public void onClientEvent(byte[] bytes) throws MeterException {
        boolean other;
        boolean bl = other = this.defaultResponse != null && this.defaultResponse instanceof IOProtocolResponse;
        if (other) {
            ((IOProtocolResponse)this.defaultResponse).target(bytes);
        } else {
            boolean debug;
            boolean bl2 = debug = this.defaultResponse != null && this.defaultResponse instanceof IDebugProtocolResponse;
            if (bytes != null && bytes.length > 0) {
                if (GlobalPara.getInstance().isRunLog()) {
                    System.out.println("\u6e90\u7801\uff1a " + ByteUtils.toHexString((byte[])bytes));
                }
                if (debug) {
                    ((IDebugProtocolResponse)this.defaultResponse).source(bytes);
                }
                if (this.code) {
                    bytes = CodeUtils.decode(bytes);
                }
                if (GlobalPara.getInstance().isRunLog()) {
                    System.out.println("\u89e3\u7801\uff1a " + ByteUtils.toHexString((byte[])bytes));
                }
                if (debug) {
                    ((IDebugProtocolResponse)this.defaultResponse).target(bytes);
                }
                this.addBuffer(bytes);
            }
        }
    }

    @Override
    public byte[] execute(byte[] buffer) {
        ProtocolAnalyse analyse = MeterUtils.analyse(buffer);
        if (!analyse.getBytes().isEmpty()) {
            analyse.getBytes().forEach(bytes -> {
                block7: {
                    if (GlobalPara.getInstance().isRunLog()) {
                        System.out.printf("\u89e3\u6790\u5185\u5bb9[%s]\uff1a%s%n", ((byte[])bytes).length, ByteUtils.toHexString((byte[])bytes));
                    }
                    try {
                        ProtocolEntity protocolEntity;
                        BPPackDisassemblyResponse response = (BPPackDisassemblyResponse)this.manager.execute(new BPPackDisassemblyRequest(this.responseMap, (byte[])bytes));
                        ProtocolEntity protocolEntity2 = protocolEntity = response.end() ? this.responseMap.remove(response.KEY()) : this.responseMap.get(response.KEY());
                        if (protocolEntity != null && protocolEntity.getResponse() instanceof IProtocolResponse) {
                            ((IProtocolResponse)protocolEntity.getResponse()).target(response);
                            break block7;
                        }
                        if (this.defaultResponse != null && this.defaultResponse instanceof IProtocolResponse) {
                            ((IProtocolResponse)this.defaultResponse).target(response);
                            break block7;
                        }
                        throw new MeterException(MeterStateEnum.BP_\u54cd\u5e94\u901a\u9053\u5bf9\u8c61\u5f02\u5e38);
                    }
                    catch (MeterException e) {
                        e.printStackTrace();
                        if (this.defaultResponse != null) {
                            this.defaultResponse.exp(e);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (this.defaultResponse == null) break block7;
                        this.defaultResponse.exp(new MeterException(e, MeterStateEnum.\u5176\u4ed6\u672a\u77e5\u5f02\u5e38));
                    }
                }
            });
        }
        return analyse.getSurplus();
    }

    @Override
    public void addProtocolResponse(String key, ProtocolEntity response) {
        this.responseMap.put(key, response);
    }

    @Override
    public void stop() {
        this.thread.giveOver();
    }

    @Override
    public synchronized void setCommunication(CommunicationState communication) {
        this.communication = communication;
        this.thread.switchOn();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread.switchOn();
    }

    @Override
    public void onClientEventExp(MeterException e) {
        if (this.defaultResponse != null) {
            this.defaultResponse.exp(e);
        }
    }

    @Override
    public void addBuffer(byte[] bytes) {
        this.thread.addBuffer(bytes);
    }

    @Override
    public void clear() {
        this.thread.clear();
    }
}

