/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.model;

import com.jhscale.common.model.device.barcode_format.DBarcodeFormat;
import com.jhscale.meter.protocol.model.BarCodeItemResult;
import com.jhscale.meter.protocol.model.GlobalPara;

public class BarCodeItemSearch {
    private BarCodeItemSearch() {
    }

    public static byte BarcodeF_CheckSum_EAN_UPC(byte[] Local_Data, int FixLength) {
        int EUC_Reversed = GlobalPara.getInstance().getTMS(139);
        if (EUC_Reversed >= 2) {
            return 48;
        }
        --FixLength;
        int Check = 0;
        for (int Loop = 0; Loop < FixLength; ++Loop) {
            int Temp3 = Local_Data[Loop] - 48;
            Check = (Check + Temp3 * (1 + 2 * (FixLength - Loop + EUC_Reversed & 1))) % 10;
        }
        return (byte)((10 - Check) % 10 + 48);
    }

    public static BarCodeItemResult Calulate(String input) {
        for (int SpecSort = 0; SpecSort < 4; ++SpecSort) {
            BarCodeItemResult result;
            int barNo = GlobalPara.getInstance().getTMS(122 + 2 * SpecSort);
            int barFlag = GlobalPara.getInstance().getTMS(123 + 2 * SpecSort);
            if (barNo == 0 && SpecSort == 0) {
                barNo = GlobalPara.getInstance().getTMS(1);
                barFlag = GlobalPara.getInstance().getTMS(2);
            }
            if ((result = BarCodeItemSearch.Calulate(input, barNo, barFlag)) == null) continue;
            return result;
        }
        return null;
    }

    public static BarCodeItemResult Calulate(String input, int barNo, int barFlag) {
        int loop;
        if (input == null) {
            return null;
        }
        if (barNo == 0) {
            return null;
        }
        DBarcodeFormat barFormat = GlobalPara.getInstance().GetBarcode(barNo);
        if (barFormat == null) {
            return null;
        }
        int index_Pos = 0;
        int index_Lng = input.length();
        byte[] index = input.getBytes();
        byte[] barBytes = barFormat.getDis().getBytes();
        Integer number = null;
        Integer itemcode = null;
        Integer amount = null;
        Integer price = null;
        if (barBytes.length == 24) {
            int GetLngMax;
            for (loop = 0; loop < 6 && barBytes[loop * 4 + 1] >= index_Lng && (GetLngMax = barBytes[loop * 4 + 1] - 48) <= 9; ++loop) {
                int GetNumber = 0;
                for (int GetLng = 0; GetLng < GetLngMax; ++GetLng) {
                    GetNumber = GetNumber * 10 + (index[index_Pos] - 48);
                    ++index_Pos;
                    --index_Lng;
                }
                int dl = barBytes[loop * 4 + 2] - 48;
                if (dl > 0 && dl <= 9) {
                    while (dl > 0) {
                        --dl;
                        GetNumber *= 10;
                    }
                }
                if (barBytes[loop * 4 + 0] == 66) {
                    if (GetNumber == barFlag) continue;
                    break;
                }
                if (barBytes[loop * 4 + 0] == 67) {
                    if (GetNumber == barFormat.getnConst1()) continue;
                    break;
                }
                if (barBytes[loop * 4 + 0] == 68) {
                    if (GetNumber == barFormat.getnConst2()) continue;
                    break;
                }
                if (barBytes[loop * 4 + 0] == 69) {
                    number = GetNumber;
                    continue;
                }
                if (barBytes[loop * 4 + 0] == 70) {
                    itemcode = GetNumber;
                    continue;
                }
                if (barBytes[loop * 4 + 0] == 74) {
                    amount = GetNumber;
                    continue;
                }
                if (barBytes[loop * 4 + 0] == 75 || barBytes[loop * 4 + 0] == 76) {
                    price = GetNumber;
                    continue;
                }
                if (barBytes[loop * 4 + 0] != 65) break;
            }
        }
        if (loop >= 6) {
            int Check = GlobalPara.getInstance().getTMS(119);
            if (Check >= 1) {
                if (index_Lng == 0) {
                    return new BarCodeItemResult();
                }
                byte a = BarCodeItemSearch.BarcodeF_CheckSum_EAN_UPC(index, index_Pos + 1);
                if (a != index[index_Pos]) {
                    return new BarCodeItemResult();
                }
            }
            if (Check >= 2 && index_Lng != 1) {
                return new BarCodeItemResult();
            }
            if (!(number == null && itemcode == null || amount == null && price == null)) {
                return new BarCodeItemResult(number, itemcode, amount, price);
            }
            return null;
        }
        return null;
    }
}

