/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.model;

import javax.xml.bind.DatatypeConverter;

public class ESealCal {
    static int[] CRC16_QuickTable = new int[]{0, 4129, 8258, 12387, 16516, 20645, 24774, 28903, 33032, 37161, 41290, 45419, 49548, 53677, 57806, 61935, 4657, 528, 12915, 8786, 21173, 17044, 29431, 25302, 37689, 33560, 45947, 41818, 54205, 50076, 62463, 58334, 9314, 13379, 1056, 5121, 25830, 29895, 17572, 21637, 42346, 46411, 34088, 38153, 58862, 62927, 50604, 54669, 13907, 9842, 5649, 1584, 30423, 26358, 22165, 18100, 46939, 42874, 38681, 34616, 63455, 59390, 55197, 51132, 18628, 22757, 26758, 30887, 2112, 6241, 10242, 14371, 51660, 55789, 59790, 63919, 35144, 39273, 43274, 47403, 23285, 19156, 31415, 27286, 6769, 2640, 14899, 10770, 56317, 52188, 64447, 60318, 39801, 35672, 47931, 43802, 27814, 31879, 19684, 23749, 11298, 15363, 3168, 7233, 60846, 64911, 52716, 56781, 44330, 48395, 36200, 40265, 32407, 28342, 24277, 20212, 15891, 11826, 7761, 3696, 65439, 61374, 57309, 53244, 48923, 44858, 40793, 36728, 37256, 33193, 45514, 41451, 53516, 49453, 61774, 57711, 4224, 161, 12482, 8419, 20484, 16421, 28742, 24679, 33721, 37784, 41979, 46042, 49981, 54044, 58239, 62302, 689, 4752, 8947, 13010, 16949, 21012, 25207, 29270, 46570, 42443, 38312, 34185, 62830, 58703, 54572, 50445, 13538, 9411, 5280, 1153, 29798, 25671, 21540, 17413, 42971, 47098, 34713, 38840, 59231, 63358, 50973, 55100, 9939, 14066, 1681, 5808, 26199, 30326, 17941, 22068, 55628, 51565, 63758, 59695, 39368, 35305, 47498, 43435, 22596, 18533, 30726, 26663, 6336, 2273, 14466, 10403, 52093, 56156, 60223, 64286, 35833, 39896, 43963, 48026, 19061, 23124, 27191, 31254, 2801, 6864, 10931, 14994, 64814, 60687, 56684, 52557, 48554, 44427, 40424, 36297, 31782, 27655, 23652, 19525, 15522, 11395, 7392, 3265, 61215, 65342, 53085, 57212, 44955, 49082, 36825, 40952, 28183, 32310, 20053, 24180, 11923, 16050, 3793, 7920};

    public static String GetMacComplex(int n1, int n2) {
        return String.format("%06x", n1) + String.format("%06x", n2);
    }

    public static String GetMacSim(int number) {
        return "0023F0" + String.format("%06x", number);
    }

    static int positive(byte input) {
        if (input >= 0) {
            return input;
        }
        return input + 256;
    }

    static int crc1(int[] target, int result) {
        for (int pos = 0; pos < target.length; ++pos) {
            result = (CRC16_QuickTable[result >> 8 ^ target[pos]] ^ result << 8) & 0xFFFF;
        }
        return result;
    }

    static int crc2(int[] target, int result) {
        for (int pos = 0; pos < target.length; ++pos) {
            result ^= target[pos];
            for (int i = 0; i < 8; ++i) {
                if ((result & 1) != 0) {
                    result = result >> 1 ^ 0xA001;
                    continue;
                }
                result >>= 1;
            }
        }
        return result;
    }

    public static int GetCode(String MAC, String MCUID, int TCount) {
        byte[] bmac = DatatypeConverter.parseHexBinary((String)MAC);
        if (bmac.length != 6) {
            return -1;
        }
        byte[] bmcuid = DatatypeConverter.parseHexBinary((String)MCUID);
        if (bmcuid.length != 8) {
            return -1;
        }
        if (TCount <= 0) {
            return -1;
        }
        int[] source = new int[24];
        source[4] = ESealCal.positive(bmac[0]);
        source[5] = ESealCal.positive(bmac[1]);
        source[6] = ESealCal.positive(bmac[2]);
        source[7] = ESealCal.positive(bmac[3]);
        int temp = (TCount >> 16) + ESealCal.positive(bmac[4]) + ESealCal.positive(bmac[5]) * 256;
        source[8] = temp & 0xFF;
        source[9] = temp >> 8 & 0xFF;
        source[10] = TCount & 0xFF;
        source[11] = TCount >> 8 & 0xFF;
        source[12] = ESealCal.positive(bmcuid[0]);
        source[13] = ESealCal.positive(bmcuid[1]);
        source[14] = ESealCal.positive(bmcuid[2]);
        source[15] = ESealCal.positive(bmcuid[3]);
        source[16] = ESealCal.positive(bmcuid[4]);
        source[17] = ESealCal.positive(bmcuid[5]);
        source[18] = ESealCal.positive(bmcuid[6]);
        source[19] = ESealCal.positive(bmcuid[7]);
        source[0] = 121;
        source[1] = 96;
        source[2] = 72;
        source[3] = 37;
        source[20] = 116;
        source[21] = 95;
        source[22] = 113;
        source[23] = 172;
        int c1 = ESealCal.crc1(source, 0) % 10000;
        source[0] = 69;
        source[1] = 236;
        source[2] = 2;
        source[3] = 175;
        source[20] = 121;
        source[21] = 89;
        source[22] = 65;
        source[23] = 129;
        int c2 = ESealCal.crc2(source, 65535) % 10000;
        return c1 * 10000 + c2;
    }
}

