/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.model;

import com.jhscale.common.model.device.log.module.DGoods;
import com.jhscale.common.model.device.plu.DPLUV5;
import com.jhscale.common.model.device.plu.inner.DAutoDiscountV2;
import com.jhscale.common.model.device.plu.inner.DManualDiscount;
import com.jhscale.common.model.device.plu.module.DPriceV2;
import com.jhscale.common.model.inter.GJSONModel;
import com.jhscale.common.utils.BigDecimalUtils;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.exp.RuntimeMeterException;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.protocol.model.TradeContent;
import com.jhscale.meter.protocol.model.WeightCal;
import com.jhscale.meter.protocol.model.WeightResult;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@ApiModel(value="\u660e\u7ec6\u53c2\u6570")
public class ItemContent
implements GJSONModel {
    @ApiModelProperty(value="PLU", name="plu")
    private DPLUV5 plu;
    @ApiModelProperty(value="\u8d1f\u4ea4\u6613\u6807\u5fd7", name="negativeFlag")
    private boolean negativeFlag = false;
    @ApiModelProperty(value="\u5355\u8ba1\u6765\u6e90\u4e0d\u8be6\uff0c\u4e0d\u53c2\u4e0e\u4efb\u4f55\u72ec\u7acb\u6298\u6263", name="fixedSingle")
    private boolean fixedSingle = false;
    @ApiModelProperty(value="\u76ae\u91cd", name="tare")
    private BigDecimal tare = BigDecimal.ZERO;
    @ApiModelProperty(value="\u5305\u88c5\u90e8\u5206\u76ae\u91cd", name="packageTare")
    private BigDecimal packageTare = BigDecimal.ZERO;
    @ApiModelProperty(value="\u767e\u5206\u6bd4\u90e8\u5206\u76ae\u91cd", name="percentTare")
    private BigDecimal percentedTare = BigDecimal.ZERO;
    @ApiModelProperty(value="\u539f\u59cb\u76ae\u91cd", name="preTare")
    private BigDecimal preTare = BigDecimal.ZERO;
    @ApiModelProperty(value="\u5355\u4ef7", name="price")
    private BigDecimal price = BigDecimal.ZERO;
    @ApiModelProperty(value="\u5355\u4ef7\u4e3a\u624b\u52a8\u8f93\u5165", name="priceIsManual")
    private boolean priceIsManual = false;
    @ApiModelProperty(value="\u8f93\u5165\u6570\u91cd\u91cf", name="amountInput")
    private BigDecimal amountInput = BigDecimal.ZERO;
    @ApiModelProperty(value="\u6570\u91cd\u91cf", name="amount")
    private BigDecimal amount = BigDecimal.ZERO;
    @ApiModelProperty(value="\u91cd\u91cf\u5355\u4f4d", name="unit")
    private int unit_weight = 2;
    @ApiModelProperty(value="\u5355\u4f4d\u540d\u79f0", name="unitName")
    private String unitName = "";
    @ApiModelProperty(value="\u672a\u786e\u8ba4\u6570\u91cd\u91cf", name="amount_Unconfirmed")
    private BigDecimal amount_Unconfirmed = BigDecimal.ZERO;
    @ApiModelProperty(value="\u672a\u786e\u8ba4\u5355\u4ef7", name="price_Unconfirmed")
    private BigDecimal price_Unconfirmed = BigDecimal.ZERO;
    @ApiModelProperty(value="\u6709\u6548\u6027_\u5df2\u4f7f\u7528\u7684\u91cd\u91cf", name="valid_UsedGross")
    private BigDecimal valid_UsedGross = BigDecimal.ZERO;
    @ApiModelProperty(value="\u6709\u6548\u6027_\u6570\u91cd\u91cf", name="valid_Amount")
    private boolean valid_Amount = false;
    @ApiModelProperty(value="\u6709\u6548\u6027_\u5355\u8ba1\u7b97", name="valid_Single")
    private boolean valid_Single = false;
    @ApiModelProperty(value="\u7a0e\u79cd", name="taxType")
    private int taxType = 0;
    @ApiModelProperty(value="\u7a0e\u7387", name="taxRate")
    private BigDecimal taxRate = BigDecimal.ZERO;
    @ApiModelProperty(value="\u5355\u4ef7\u5355\u4f4d", name="unit")
    private Integer unit_price = 2;
    @ApiModelProperty(value="\u539f\u59cb\u5355\u4ef7", name="price_FromPLU")
    private BigDecimal price_Original = BigDecimal.ZERO;
    @ApiModelProperty(value="\u539f\u59cb\u5c0f\u8ba1\u542b\u7a0e", name="singleWtax_Original")
    private BigDecimal singleWtax_Original = BigDecimal.ZERO;
    @ApiModelProperty(value="\u539f\u59cb\u5355\u4ef7\u4e0a\u9650", name="price_UpperLimit")
    private BigDecimal price_UpperLimit = BigDecimal.ZERO;
    @ApiModelProperty(value="\u539f\u59cb\u5355\u4ef7\u4e0b\u9650", name="price_LowerLimit")
    private BigDecimal price_LowerLimit = BigDecimal.ZERO;
    @ApiModelProperty(value="\u5e93\u5b58\u6570\u91cd\u91cf", name="amount_Stock")
    private BigDecimal amount_Stock = BigDecimal.ZERO;
    @ApiModelProperty(value="\u5e93\u5b58\u5355\u4f4d", name="unit_Stock")
    private int unit_Stock = 0;
    @ApiModelProperty(value="\u7a0e\u989d", name="tax")
    private BigDecimal tax = BigDecimal.ZERO;
    @ApiModelProperty(value="\u5c0f\u8ba1\u65e0\u7a0e", name="singleNtax")
    private BigDecimal singleNtax = BigDecimal.ZERO;
    @ApiModelProperty(value="\u5c0f\u8ba1\u542b\u7a0e", name="singleWtax")
    private BigDecimal singleWtax = BigDecimal.ZERO;
    @ApiModelProperty(value="\u670d\u52a1\u8d39", name="serviceFee")
    private BigDecimal serviceFee = BigDecimal.ZERO;
    @ApiModelProperty(value="\u5546\u54c1\u56fe\u7247", name="pics")
    private List<String> pics;
    @ApiModelProperty(value="\u9000\u8d27\u6807\u5fd7", name="reject")
    private int reject = 0;
    @ApiModelProperty(value="\u5546\u54c1\u6dfb\u52a0\u6765\u6e90 132-\u952e\u76d8\u8c03\u7528 133-\u5916\u90e8\u6761\u7801\u8c03\u7528 134-\u5185\u90e8\u6761\u7801\u8c03\u7528", name="spec")
    private Integer spec;
    @ApiModelProperty(value="POS\u6253\u5370\u5185\u5bb9", name="posOnlyString")
    private Map<Integer, String> posOnlyString = new HashMap<Integer, String>();

    public ItemContent() {
    }

    public boolean AddValid() throws RuntimeMeterException {
        if (!this.valid_Amount) {
            throw new RuntimeMeterException(MeterStateEnum.\u6570\u91cd\u91cf\u65e0\u6548\u4e0d\u5141\u8bb8\u6dfb\u52a0);
        }
        if (!this.valid_Single) {
            throw new RuntimeMeterException(MeterStateEnum.\u5355\u8ba1\u8ba1\u7b97\u9519\u8bef\u4e0d\u5141\u8bb8\u6dfb\u52a0);
        }
        return true;
    }

    public static BigDecimal GetDisplay_Price(DPLUV5 inputPLU, TradeContent tradeContent) {
        if (tradeContent == null) {
            return GlobalPara.getInstance().CalPLU_Price_wUnit(inputPLU.price(Integer.valueOf(GlobalPara.getInstance().getDeviceLevel())).getPrice(), inputPLU.unit());
        }
        if (tradeContent.VIP_LOGIN()) {
            return GlobalPara.getInstance().CalPLU_Price_wUnit(tradeContent.CalPLU_UPrice_VIPed(inputPLU), inputPLU.unit());
        }
        DPriceV2 price = inputPLU.price(Integer.valueOf(GlobalPara.getInstance().getDeviceLevel()));
        int mpd = GlobalPara.getInstance().getTMS(1076);
        DAutoDiscountV2 discount = null;
        switch (mpd) {
            case 4: {
                discount = Optional.ofNullable(price.getAutoDiscounts()).orElse(Collections.emptyList()).stream().filter(value -> 4 == value.getType()).findFirst().orElse(null);
                break;
            }
            case 5: {
                discount = Optional.ofNullable(price.getAutoDiscounts()).orElse(Collections.emptyList()).stream().filter(value -> 5 == value.getType()).findFirst().orElse(null);
                break;
            }
            case 6: {
                discount = Optional.ofNullable(price.getAutoDiscounts()).orElse(Collections.emptyList()).stream().filter(value -> 6 == value.getType()).findFirst().orElse(null);
                break;
            }
            case 7: {
                discount = Optional.ofNullable(price.getAutoDiscounts()).orElse(Collections.emptyList()).stream().filter(value -> 7 == value.getType()).findFirst().orElse(null);
                break;
            }
        }
        if (discount != null) {
            return GlobalPara.getInstance().CalPLU_Price_wUnit(discount.getDiscount(), inputPLU.unit());
        }
        return null;
    }

    public static int GetDisplay_MoneyUnit(DPLUV5 inputPLU) {
        if (inputPLU.unit() == 2) {
            return 2;
        }
        return GlobalPara.getInstance().CalPLU_PriceUnit_wUnit(inputPLU.unit());
    }

    public static int GetDisplay_MoneyUnit(int price_unit) {
        if (price_unit == 2) {
            return 2;
        }
        return GlobalPara.getInstance().CalPLU_PriceUnit_wUnit(price_unit);
    }

    public ItemContent(DPLUV5 plu, TradeContent tradeContent) {
        this.plu = plu;
        int tradeType = tradeContent.getTradeType();
        this.negativeFlag = tradeType == 1 || tradeType == 10;
        BigDecimal price = this.plu.price(Integer.valueOf(GlobalPara.getInstance().getDeviceLevel())).getPrice();
        this.setPrice_Original(GlobalPara.getInstance().CalPLU_Price_wUnit(price, plu.unit()));
        BigDecimal priceZero = GlobalPara.getInstance().CalPLU_Price_wUnit(BigDecimal.ZERO, plu.unit());
        if (this.getPrice_Original().compareTo(BigDecimal.ZERO) == 0) {
            this.setPrice_LowerLimit(priceZero);
            this.setPrice_UpperLimit(priceZero);
        } else if ((GlobalPara.getInstance().getTMS(110) & 1) != 0) {
            this.setPrice_LowerLimit(this.getPrice_Original());
            this.setPrice_UpperLimit(this.getPrice_Original());
        } else {
            DManualDiscount dm = this.plu.price(Integer.valueOf(GlobalPara.getInstance().getDeviceLevel())).manualDiscount(1);
            int type = dm.type();
            if (type == 0) {
                this.setPrice_LowerLimit(GlobalPara.getInstance().CalPLU_Price_wUnit(new BigDecimal(Math.min(100, GlobalPara.getInstance().getTMS(111))).movePointLeft(2).multiply(price), plu.unit()));
            } else if (type == 2) {
                this.setPrice_LowerLimit(this.getPrice_Original());
            } else if (type == 3) {
                this.setPrice_LowerLimit(GlobalPara.getInstance().CalPLU_Price_wUnit(dm.getDiscount(), plu.unit()));
            } else {
                this.setPrice_LowerLimit(priceZero);
            }
            dm = this.plu.price(Integer.valueOf(GlobalPara.getInstance().getDeviceLevel())).manualDiscount(0);
            type = dm.type();
            if (type == 0) {
                int hl = GlobalPara.getInstance().getTMS(112);
                if (hl != 0) {
                    hl = Math.max(100, hl);
                }
                this.setPrice_UpperLimit(GlobalPara.getInstance().CalPLU_Price_wUnit(new BigDecimal(hl).movePointLeft(2).multiply(price), plu.unit()));
            } else if (type == 2) {
                this.setPrice_UpperLimit(this.getPrice_Original());
            } else if (type == 3) {
                this.setPrice_UpperLimit(GlobalPara.getInstance().CalPLU_Price_wUnit(dm.getDiscount(), plu.unit()));
            } else {
                this.setPrice_UpperLimit(priceZero);
            }
        }
        this.setPrice(GlobalPara.getInstance().CalPLU_Price_wUnit(tradeContent.CalPLU_UPrice_VIPed(plu), plu.unit()));
        if (plu.unit() == 2) {
            this.setUnit_weight(2);
            this.setUnit_price(2);
            this.setPreTare(BigDecimal.ZERO);
        } else {
            this.setUnit_weight(GlobalPara.getInstance().getWeightUNIT());
            this.setUnit_price(GlobalPara.getInstance().CalPLU_PriceUnit_wUnit(GlobalPara.getInstance().getPriceUNIT()));
            this.setPreTare(GlobalPara.getInstance().EcsCal_Unit_WeightConvertSystem(plu.tare(), plu.unit()));
        }
        this.setTaxType(plu.taxType());
        this.setTaxRate(BigDecimal.valueOf(plu.taxRate().intValue()));
        if (this.getTaxType() == 0) {
            this.setTaxType(GlobalPara.getInstance().getTMS(116));
            this.setTaxRate(new BigDecimal(GlobalPara.getInstance().getTMS(117)).divide(new BigDecimal(10000)));
        }
    }

    public ItemContent Item_Set_Good(DGoods good) {
        if (Objects.nonNull(good.getAmountStock())) {
            this.amount_Stock = good.getAmountStock();
        }
        if (Objects.nonNull(good.getUnitStock())) {
            this.unit_Stock = good.getUnitStock();
        }
        if (Objects.nonNull(good.getAmount())) {
            this.amount = good.getAmount();
        }
        if (Objects.nonNull(good.getUnit())) {
            this.unit_weight = good.getUnit();
        }
        if (this.unit_weight != GlobalPara.getInstance().getWeightUNIT()) {
            this.unit_price = this.unit_weight;
            this.price = good.getPrice();
        } else {
            this.unit_price = GlobalPara.getInstance().getPriceUNIT();
            this.price = GlobalPara.getInstance().EcsCal_Unit_PriceConvertTo(good.getPrice(), this.unit_weight, this.unit_price);
        }
        this.singleWtax = good.getItemTotal();
        if (Objects.nonNull(good.getTax())) {
            this.tax = good.getTax();
        }
        this.singleNtax = this.singleWtax.subtract(this.tax);
        this.valid_Amount = true;
        this.valid_Single = true;
        return this;
    }

    public ItemContent Item_Set_Weight(BigDecimal net, boolean valid) {
        this.setAmount(net);
        this.setValid_Amount(valid);
        return this;
    }

    public ItemContent Item_Set_Weight(WeightResult result) {
        BigDecimal net;
        boolean valid = false;
        this.amountInput = net = result.getNetWeight();
        if (result.getValidType() >= 2) {
            net = WeightCal.getInstance().weightZero;
        } else if (net.compareTo(BigDecimal.ZERO) <= 0) {
            net = WeightCal.getInstance().weightZero;
        } else if (result.getValidType() == 0 && result.isStable()) {
            valid = true;
        }
        this.packageTare = result.getTare();
        if (!GlobalPara.getInstance().EcsCal_Unit_isWeight(this.getUnit_weight())) {
            return this;
        }
        this.percentedTare = this.getPlu().percentTare().compareTo(BigDecimal.ZERO) > 0 ? net.multiply(this.getPlu().getPercentTare()).setScale(GlobalPara.getInstance().getPointOfWeight(), 5) : BigDecimal.ZERO.setScale(GlobalPara.getInstance().getPointOfWeight());
        net = net.subtract(this.percentedTare);
        if (this.negativeFlag) {
            net = net.negate();
        }
        this.setAmount(net);
        this.setTare(result.getTare());
        this.setValid_Amount(valid, result.getGross());
        return this;
    }

    public ItemContent Item_Set_Count(BigDecimal pcs) {
        boolean valid;
        if (GlobalPara.getInstance().EcsCal_Unit_isWeight(this.getUnit_weight())) {
            return this;
        }
        this.amountInput = pcs;
        boolean bl = valid = pcs.compareTo(BigDecimal.ZERO) > 0;
        if (!valid) {
            pcs = BigDecimal.ZERO;
        }
        if (this.negativeFlag) {
            pcs = pcs.negate();
        }
        this.setAmount(pcs);
        this.setValid_Amount(valid);
        return this;
    }

    public ItemContent Item_Set_Count_Negate(BigDecimal pcs) {
        boolean valid;
        if (GlobalPara.getInstance().EcsCal_Unit_isWeight(this.getUnit_weight())) {
            return this;
        }
        this.amountInput = pcs;
        boolean bl = valid = pcs.compareTo(BigDecimal.ZERO) < 0;
        if (!valid) {
            pcs = BigDecimal.ZERO;
        }
        if (this.negativeFlag) {
            pcs = pcs.negate();
        }
        this.setAmount(pcs);
        this.setValid_Amount(valid);
        return this;
    }

    public ItemContent Item_Set_Amount_Stock(WeightResult result) {
        if (GlobalPara.getInstance().EcsCal_Unit_isWeight(this.getUnit_weight())) {
            return this;
        }
        this.setAmount_Stock(result.getNetWeight());
        this.setUnit_Stock(GlobalPara.getInstance().getWeightUNIT());
        return this;
    }

    public ItemContent Item_Set_Amount_Stock(BigDecimal net) {
        if (GlobalPara.getInstance().EcsCal_Unit_isWeight(this.getUnit_weight())) {
            return this;
        }
        this.setAmount_Stock(net);
        this.setUnit_Stock(GlobalPara.getInstance().getWeightUNIT());
        return this;
    }

    public ItemContent Item_Set_UPrice(BigDecimal price) {
        this.setPrice(GlobalPara.getInstance().EcsCal_Rounding(price, GlobalPara.getInstance().getPointOfPrice(), 0));
        this.setPriceIsManual(true);
        return this;
    }

    public ItemContent Item_Set_UPrice_WithUnit(BigDecimal price, int unitPrice) {
        return this.Item_Set_UPrice(GlobalPara.getInstance().EcsCal_Unit_PriceConvertTo(price, unitPrice, this.unit_price));
    }

    public boolean Item_Check_UPrice() {
        if (this.getPrice_Original().compareTo(BigDecimal.ZERO) == 0) {
            return true;
        }
        return (GlobalPara.getInstance().getTMS(110) & 1) == 0;
    }

    public boolean Item_Check_UPrice(BigDecimal price) {
        if (!this.Item_Check_UPrice()) {
            return false;
        }
        BigDecimal toBe = GlobalPara.getInstance().EcsCal_Rounding(price, GlobalPara.getInstance().getPointOfPrice(), 0);
        if (this.price_UpperLimit.compareTo(BigDecimal.ZERO) != 0 && toBe.compareTo(this.price_UpperLimit) > 0) {
            return false;
        }
        return this.price_LowerLimit.compareTo(BigDecimal.ZERO) == 0 || toBe.compareTo(this.price_LowerLimit) >= 0;
    }

    public ItemContent Item_ReCal(TradeContent tradeContent) {
        int spu;
        BigDecimal tax;
        this.Item_GetUPrice_Track(tradeContent);
        BigDecimal purTax = GlobalPara.getInstance().EcsCal_Unit_ValueConvert(this.getPrice().multiply(this.getAmount()), this.getUnit_weight(), this.getUnit_price());
        BigDecimal purTax_Orignal = GlobalPara.getInstance().EcsCal_Unit_ValueConvert(this.getPrice_Original().multiply(this.getAmount()), this.getUnit_weight(), this.getUnit_price());
        if (this.getTaxType() == 1) {
            tax = purTax.multiply(this.getTaxRate());
            purTax = purTax.add(tax);
            purTax_Orignal = purTax_Orignal.add(purTax_Orignal.multiply(this.getTaxRate()));
        } else {
            tax = this.getTaxType() == 2 ? purTax.multiply(this.getTaxRate()).divide(this.getTaxRate().add(BigDecimal.ONE), 7, 4) : (this.getTaxType() == 3 ? purTax.multiply(this.getTaxRate()) : BigDecimal.ZERO);
        }
        this.setTax(GlobalPara.getInstance().EcsCal_Rounding_Single(tax));
        this.setSingleWtax(GlobalPara.getInstance().EcsCal_Rounding_Single(purTax));
        this.setSingleNtax(this.getSingleWtax().subtract(this.getTax()));
        this.setSingleWtax_Original(GlobalPara.getInstance().EcsCal_Rounding_Single(purTax_Orignal));
        this.setValid_Single(this.getSingleWtax().compareTo(BigDecimal.ZERO) != 0 || GlobalPara.getInstance().getTMS(70) == 1);
        if (GlobalPara.getInstance().EcsCal_Unit_isWeight(this.getUnit_weight())) {
            int spu2;
            if (WeightCal.getInstance().getUsedGross().compareTo(BigDecimal.ZERO) > 0) {
                this.amount_Unconfirmed = this.price_Unconfirmed = BigDecimal.ZERO;
            } else if (this.isValid_Amount() && ((spu2 = GlobalPara.getInstance().getTMS(283)) == 2 || spu2 >= 1 && this.getSingleWtax().compareTo(BigDecimal.ZERO) > 0)) {
                this.amount_Unconfirmed = this.amount;
                this.price_Unconfirmed = this.price;
            }
        } else if (this.isValid_Amount() && ((spu = GlobalPara.getInstance().getTMS(283)) == 2 || spu >= 1 && this.getSingleWtax().compareTo(BigDecimal.ZERO) > 0)) {
            this.amount_Unconfirmed = this.amount;
            this.price_Unconfirmed = this.price;
        }
        return this;
    }

    public boolean ItemHasUnconfirmed(WeightResult wr) {
        if (wr.getGross().compareTo(BigDecimal.ZERO) <= 0) {
            return this.amount_Unconfirmed.compareTo(BigDecimal.ZERO) > 0;
        }
        return false;
    }

    public BigDecimal getAmount_Unconfirmed() {
        return this.amount_Unconfirmed;
    }

    public void setAmount_Unconfirmed(BigDecimal amount_Unconfirmed) {
        this.amount_Unconfirmed = amount_Unconfirmed;
    }

    public BigDecimal getPrice_Unconfirmed() {
        return this.price_Unconfirmed;
    }

    public void setPrice_Unconfirmed(BigDecimal price_Unconfirmed) {
        this.price_Unconfirmed = price_Unconfirmed;
    }

    private boolean Item_GetUPrice_Track(TradeContent tradeContent) {
        DPriceV2 dPrice;
        if (GlobalPara.getInstance().getTMS(115) <= 0 || GlobalPara.getInstance().getTMS(115) > 3) {
            return false;
        }
        if (this.isPriceIsManual()) {
            return false;
        }
        BigDecimal price = tradeContent.CalPLU_UPrice_VIPed(this.getPlu());
        boolean update = GlobalPara.getInstance().getTMS(115) == 3;
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int day_week = calendar.get(7);
        if (calendar.getFirstDayOfWeek() == 1) {
            --day_week;
        } else if (day_week == 7) {
            day_week = 0;
        }
        day_week = 1 << day_week;
        if (GlobalPara.getInstance().isDiscountAuto_InTime() && (dPrice = this.plu.price(Integer.valueOf(GlobalPara.getInstance().getDeviceLevel()))).getAutoDiscounts() != null && !dPrice.getAutoDiscounts().isEmpty()) {
            for (DAutoDiscountV2 autoDiscount : dPrice.getAutoDiscounts()) {
                if ((autoDiscount.date() & day_week) == 0) continue;
                switch (autoDiscount.type()) {
                    case 1: {
                        if (this.getAmount().compareTo(GlobalPara.getInstance().EcsCal_Unit_WeightConvertSystem(autoDiscount.lower(), this.getPlu().getUnit())) >= 0 && this.getAmount().compareTo(GlobalPara.getInstance().EcsCal_Unit_WeightConvertSystem(autoDiscount.upper(), this.getPlu().getUnit())) <= 0) {
                            price = autoDiscount.getDiscount().compareTo(BigDecimal.ZERO) >= 0 ? autoDiscount.discount() : price.add(autoDiscount.discount());
                        }
                        update = true;
                        break;
                    }
                    case 2: {
                        int hhmm = calendar.get(11) * 100 + calendar.get(12);
                        if (hhmm >= autoDiscount.lower().intValue() && hhmm <= autoDiscount.upper().intValue()) {
                            price = BigDecimalUtils.compareMoreZeroValue((BigDecimal)autoDiscount.discount()) ? autoDiscount.discount() : price.add(autoDiscount.discount());
                            update = true;
                            break;
                        }
                        if (GlobalPara.getInstance().getTMS(115) != 2) break;
                        update = true;
                        break;
                    }
                    case 11: {
                        if (!BigDecimalUtils.compareMoreZeroValue((BigDecimal)autoDiscount.discount())) break;
                        this.setServiceFee(autoDiscount.discount());
                        break;
                    }
                }
            }
        }
        if (update) {
            this.setPrice(GlobalPara.getInstance().CalPLU_Price_wUnit(price, this.getPlu().getUnit()));
            this.setUnit_price(GlobalPara.getInstance().CalPLU_PriceUnit_wUnit(this.getPlu().getUnit()));
        }
        return update;
    }

    public ItemContent addPics(String ... pics) {
        if (pics == null || pics.length == 0) {
            return this;
        }
        if (this.pics == null) {
            this.pics = new ArrayList<String>();
        }
        this.pics.addAll(Arrays.asList(pics));
        return this;
    }

    public List<String> pics() {
        if (this.pics != null && !this.pics.isEmpty()) {
            return this.pics;
        }
        return this.plu.getPictures();
    }

    public boolean SwitchUnit() {
        if (this.unit_weight == 2) {
            this.setUnit_weight(GlobalPara.getInstance().getWeightUNIT());
            this.setUnit_price(GlobalPara.getInstance().getPriceUNIT());
            if (this.plu.unit() != 2) {
                this.setPreTare(GlobalPara.getInstance().EcsCal_Unit_WeightConvertSystem(this.plu.tare(), this.plu.unit()));
            }
            return true;
        }
        this.setUnit_weight(2);
        this.setUnit_price(2);
        this.setPreTare(BigDecimal.ZERO);
        return false;
    }

    public DPLUV5 getPlu() {
        return this.plu;
    }

    public void setPlu(DPLUV5 plu) {
        this.plu = plu;
    }

    public BigDecimal getTare() {
        return this.tare;
    }

    public void setTare(BigDecimal tare) {
        this.tare = tare;
    }

    public BigDecimal getPackageTare() {
        return this.packageTare;
    }

    public BigDecimal getPercentedTare() {
        return this.percentedTare;
    }

    public boolean isFixedSingle() {
        return this.fixedSingle;
    }

    public void setFixedSingle(boolean fixedSingle) {
        this.fixedSingle = fixedSingle;
    }

    public BigDecimal getPreTare() {
        return this.preTare;
    }

    public void setPreTare(BigDecimal preTare) {
        this.preTare = preTare;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public boolean isPriceIsManual() {
        return this.priceIsManual;
    }

    public void setPriceIsManual(boolean priceIsManual) {
        this.priceIsManual = priceIsManual;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public int getUnit_weight() {
        return this.unit_weight;
    }

    public void setUnit_weight(int unit_weight) {
        this.unit_weight = unit_weight;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public boolean isValid_Amount() {
        return this.valid_Amount;
    }

    public void setValid_Amount(boolean valid_Amount) {
        this.valid_Amount = valid_Amount;
        this.valid_UsedGross = BigDecimal.ZERO;
    }

    public void setValid_Amount(boolean valid_Amount, BigDecimal usedGross) {
        this.valid_Amount = valid_Amount;
        this.valid_UsedGross = usedGross;
    }

    public BigDecimal getValid_UsedGross() {
        return this.valid_UsedGross;
    }

    public boolean isValid_Single() {
        return this.valid_Single;
    }

    public void setValid_Single(boolean valid_Single) {
        this.valid_Single = valid_Single;
    }

    public int getTaxType() {
        return this.taxType;
    }

    public void setTaxType(int taxType) {
        this.taxType = taxType;
    }

    public BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public Integer getUnit_price() {
        return this.unit_price;
    }

    public void setUnit_price(Integer unit_price) {
        this.unit_price = unit_price;
    }

    public BigDecimal getPrice_Original() {
        return this.price_Original;
    }

    public ItemContent setPrice_Original(BigDecimal price_Original) {
        this.price_Original = price_Original;
        return this;
    }

    public BigDecimal getPrice_UpperLimit() {
        return this.price_UpperLimit;
    }

    public void setPrice_UpperLimit(BigDecimal price_UpperLimit) {
        this.price_UpperLimit = price_UpperLimit;
    }

    public BigDecimal getPrice_LowerLimit() {
        return this.price_LowerLimit;
    }

    public void setPrice_LowerLimit(BigDecimal price_LowerLimit) {
        this.price_LowerLimit = price_LowerLimit;
    }

    public BigDecimal getSingleWtax_Original() {
        return this.singleWtax_Original;
    }

    public void setSingleWtax_Original(BigDecimal singleWtax_Original) {
        this.singleWtax_Original = singleWtax_Original;
    }

    public BigDecimal getAmount_Stock() {
        return this.amount_Stock;
    }

    public void setAmount_Stock(BigDecimal amount_Stock) {
        this.amount_Stock = amount_Stock;
    }

    public int getUnit_Stock() {
        return this.unit_Stock;
    }

    public void setUnit_Stock(int unit_Stock) {
        this.unit_Stock = unit_Stock;
    }

    public BigDecimal getTax() {
        return this.tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public BigDecimal getSingleNtax() {
        return this.singleNtax;
    }

    public void setSingleNtax(BigDecimal singleNtax) {
        this.singleNtax = singleNtax;
    }

    public BigDecimal getSingleWtax() {
        return this.singleWtax;
    }

    public void setSingleWtax(BigDecimal singleWtax) {
        this.singleWtax = singleWtax;
    }

    public BigDecimal getServiceFee() {
        return this.serviceFee;
    }

    public void setServiceFee(BigDecimal serviceFee) {
        this.serviceFee = serviceFee;
    }

    public boolean isNegativeFlag() {
        return this.negativeFlag;
    }

    public void setNegativeFlag(boolean negativeFlag) {
        this.negativeFlag = negativeFlag;
    }

    public List<String> getPics() {
        return this.pics;
    }

    public void setPics(List<String> pics) {
        this.pics = pics;
    }

    public int getReject() {
        return this.reject;
    }

    public void setReject(int reject) {
        this.reject = reject;
    }

    public boolean reject() {
        return this.reject == 1;
    }

    public Integer getSpec() {
        return this.spec;
    }

    public void setSpec(Integer spec) {
        this.spec = spec;
    }

    public int spec() {
        return Objects.nonNull(this.spec) ? this.spec : 132;
    }

    public void putPosOnlyString(Integer number, String value) {
        this.posOnlyString.put(number, value);
    }

    public String getPosOnlyString(Integer number) {
        return this.posOnlyString.get(number);
    }

    public Map<Integer, String> getPosOnlyString() {
        return this.posOnlyString;
    }
}

