/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.model;

import com.jhscale.common.model.device._inner.PublicExecute;
import com.jhscale.common.model.device._inner.PublicExecuteModify;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.protocol.model.JHTCPAccept;
import com.jhscale.meter.utils.MeterUtils;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class JHTCPAnswer
extends JHTCPAccept {
    private int limit = 50;
    private boolean async = false;
    private List<PublicExecute> answers;
    private String answerStr;

    public JHTCPAnswer() {
    }

    public JHTCPAnswer(PortManager portManager, PublicExecute accept) {
        super(portManager, accept);
    }

    public JHTCPAnswer(ChannelHandlerContext ctx, PublicExecute accept) {
        super(ctx, accept);
    }

    public JHTCPAnswer addAnswer(PublicExecute ... answers) {
        if (answers != null && answers.length > 0) {
            this.addAnswerList(Arrays.asList(answers));
        }
        return this;
    }

    public JHTCPAnswer addAnswerOnce(PublicExecute execute) {
        if (execute != null) {
            this.addAnswer(execute);
        }
        return this;
    }

    public JHTCPAnswer addAnswerList(List<PublicExecute> executes) {
        if (executes != null && !executes.isEmpty()) {
            if (this.answers == null) {
                this.answers = new ArrayList<PublicExecute>();
            }
            this.answers.addAll(executes);
        }
        return this;
    }

    public boolean resultExecute() {
        if (StringUtils.isNotBlank((CharSequence)this.answerStr)) {
            return this.writeData(this.answerStr);
        }
        if (this.answers != null && !this.answers.isEmpty()) {
            boolean result = true;
            for (PublicExecute answer : this.answers) {
                if (answer instanceof PublicExecuteModify) {
                    int page = ((PublicExecuteModify)answer).getModels().size() / this.limit;
                    page = ((PublicExecuteModify)answer).getModels().size() % this.limit == 0 ? page : page + 1;
                    for (int i = 0; i < page; ++i) {
                        if (i == page) {
                            System.out.println(1);
                        }
                        int end = Math.min(((PublicExecuteModify)answer).getModels().size(), (i + 1) * this.limit);
                        int start = i * this.limit;
                        String part = answer.Package_No_Reflex(start, end);
                        result = this.writeData(part);
                    }
                } else {
                    String response = MeterUtils.public_response_package(this.getAccept(), Arrays.asList(answer));
                    result = this.writeData(response);
                }
                if (result) continue;
                break;
            }
            return result;
        }
        String response = MeterUtils.public_response_package(this.getAccept(), null);
        return this.writeData(response);
    }

    public boolean onceResultExecute(int status) {
        if (StringUtils.isNotBlank((CharSequence)this.answerStr)) {
            return this.writeData(this.answerStr);
        }
        if (this.answers == null || this.answers.isEmpty()) {
            String response = MeterUtils.public_response_package(this.getAccept(), null);
            return this.writeData(response);
        }
        boolean result = true;
        for (PublicExecute answer : this.answers) {
            long t1 = System.currentTimeMillis();
            StringBuilder builder = new StringBuilder();
            if (status == 0 || status == 3) {
                builder.append(answer.Package_No_Reflex_Top());
            }
            builder.append(answer.Package_No_Reflex_Body());
            if (status == 2 || status == 3) {
                builder.append(answer.Package_No_Reflex_Tail());
            }
            long t2 = System.currentTimeMillis();
            result = this.writeData(builder.toString());
            long t3 = System.currentTimeMillis();
            answer.clear();
            if (!result) break;
            System.out.printf("Length:[%s], Total:[%s], Package:[%s], Write_Send:[%s]%n", builder.length(), t3 - t1, t2 - t1, t3 - t2);
        }
        if (this.answers != null && !this.answers.isEmpty()) {
            this.answers.clear();
        }
        return result;
    }

    public int getLimit() {
        return this.limit;
    }

    public JHTCPAnswer setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public boolean isAsync() {
        return this.async;
    }

    public JHTCPAnswer setAsync(boolean async) {
        this.async = async;
        return this;
    }

    public List<PublicExecute> getAnswers() {
        return this.answers;
    }

    public JHTCPAnswer setAnswers(List<PublicExecute> answers) {
        this.answers = answers;
        return this;
    }

    public String getAnswerStr() {
        return this.answerStr;
    }

    public JHTCPAnswer setAnswerStr(String answerStr) {
        this.answerStr = answerStr;
        return this;
    }
}

