/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.model;

import com.jhscale.common.model.device.plu.FDPLU;
import com.jhscale.common.utils.SystemtUtils;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.io.control.DeviceControl;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.model.device.Device;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.protocol.model.ItemContent;
import com.jhscale.meter.protocol.model.WeightResult;
import java.math.BigDecimal;
import java.util.Objects;

public class SerialDisplay {
    static final int itemContentValidDelay = 2;
    private FDPLU plu = null;
    private int inputUnit = 3;
    private BigDecimal inputAmount = BigDecimal.ZERO;
    private BigDecimal inputPrice = BigDecimal.ZERO;
    private BigDecimal inputItem = BigDecimal.ZERO;
    private WeightResult wr = new WeightResult();
    private int itemContentValid = 0;
    private PortManager portManager = null;
    private boolean serialDisplayPause = false;
    private boolean serialDisplayAction = true;
    private boolean hasPLU = false;
    private static final byte[] HexValue = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    public void serialDisplayStop() {
        try {
            this.serialDisplayAction = false;
            SystemtUtils.sleep((int)1);
            this.portManager.closePort();
            this.portManager = null;
        }
        catch (MeterException e) {
            throw new RuntimeException(e);
        }
    }

    public void serialDisplayPause(boolean pause) {
        this.serialDisplayPause = pause;
    }

    public void quitItemContent() {
        this.hasPLU = false;
    }

    public void setItemContentWR(ItemContent itemContent, WeightResult inputWR) {
        this.hasPLU = true;
        if (inputWR != null) {
            this.wr = inputWR;
        }
        this.inputAmount = itemContent.getAmount();
        this.inputUnit = itemContent.getUnit_weight();
        this.plu = itemContent.getPlu();
        this.inputPrice = itemContent.getPrice();
        this.inputItem = itemContent.getSingleWtax();
        this.itemContentValid = 2;
    }

    public void setItemContentWR(ItemContent itemContent) {
        this.setItemContentWR(itemContent, null);
    }

    public void setWeightResult(WeightResult inputWR) {
        if (this.hasPLU) {
            return;
        }
        if (this.itemContentValid >= 0) {
            --this.itemContentValid;
        } else {
            this.wr = inputWR;
            this.inputAmount = inputWR.getNetWeight();
            this.inputUnit = inputWR.getUnit();
            this.plu = null;
            this.inputPrice = BigDecimal.ZERO;
            this.inputItem = BigDecimal.ZERO;
        }
    }

    public void Init_Port(DeviceControl control, Device device) throws MeterException {
        if (Objects.isNull(control)) {
            throw new MeterException(MeterStateEnum.\u63a7\u5236\u5668\u4e0d\u5b58\u5728);
        }
        if (Objects.isNull(device)) {
            throw new MeterException(MeterStateEnum.\u901a\u8baf\u8bbe\u5907\u4e0d\u5b58\u5728);
        }
        int spec = GlobalPara.getInstance().getTMS(57);
        if (spec == 0) {
            throw new MeterException(MeterStateEnum.AD_\u663e\u793a\u901a\u8baf\u534f\u8bae\u672a\u914d\u7f6e);
        }
        this.portManager = new PortManager<Device>(control, device, new DeviceClientEventListener(){

            @Override
            public void onClientEvent(byte[] bytes) throws MeterException {
                byte[] output;
                if (!SerialDisplay.this.serialDisplayPause && (output = SerialDisplay.this.toSerialPortContent_ACK(bytes)) != null) {
                    SerialDisplay.this.portManager.writeDataImmediately(output);
                }
            }

            @Override
            public void onClientEventExp(MeterException e) {
            }
        });
        this.portManager.openPort();
        new Thread("SerialDisplay"){

            @Override
            public void run() {
                while (SerialDisplay.this.serialDisplayAction) {
                    try {
                        byte[] output;
                        if (!SerialDisplay.this.serialDisplayPause && (output = SerialDisplay.this.toSerialPortContent_100ms()) != null) {
                            SerialDisplay.this.portManager.writeDataImmediately(output);
                        }
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }.start();
    }

    public static SerialDisplay getInstance() {
        return SingleSerialDisplay.SINGLETON;
    }

    private String nums32_New_Fill(BigDecimal net, int digit, char fill) {
        String rv = net.toString();
        if (rv.length() >= digit) {
            return rv.substring(0, digit - 1);
        }
        while (rv.length() < digit) {
            rv = fill + rv;
        }
        return rv;
    }

    private String unit_B4() {
        int unit = this.wr.getUnit() - 3;
        if (unit == 1) {
            return "   g";
        }
        if (unit == 2) {
            return " ton";
        }
        if (unit == 3) {
            return "  lb";
        }
        if (unit == 4) {
            return "500g";
        }
        if (unit == 5) {
            return "100g";
        }
        if (unit == 6) {
            return "lb/4";
        }
        return "  kg";
    }

    byte Formula_HexToBCD(int Hex) {
        return (byte)(Hex / 10 % 10 << 4 | Hex % 10);
    }

    private byte[] Protocol_A() {
        int itemUS;
        byte[] temp = new byte[14];
        temp[0] = -1;
        BigDecimal weight = this.inputAmount;
        temp[1] = (byte)(weight.scale() + 1 & 7);
        int weightUS = weight.unscaledValue().intValue();
        if (weightUS < 0) {
            weightUS = -weightUS;
            temp[1] = (byte)(temp[1] | 8);
        }
        if (this.wr.isStable()) {
            temp[1] = (byte)(temp[1] | 0x10);
        }
        if (this.wr.getValidType() >= 4) {
            temp[1] = (byte)(temp[1] | 0x20);
        }
        if (this.plu == null) {
            temp[1] = (byte)(temp[1] | 0x40);
        }
        if (this.plu == null || !GlobalPara.getInstance().EcsCal_Unit_isWeight(this.inputUnit) || this.inputUnit != 3) {
            temp[1] = (byte)(temp[1] | 0x80);
        }
        temp[2] = this.Formula_HexToBCD(weightUS);
        temp[3] = this.Formula_HexToBCD(weightUS / 100);
        temp[4] = this.Formula_HexToBCD(weightUS / 10000);
        temp[5] = (byte)(this.inputPrice.scale() + 1 & 7);
        if (this.plu == null) {
            temp[5] = (byte)(temp[5] | 8);
        }
        int priceUS = this.inputPrice.unscaledValue().intValue();
        temp[6] = this.Formula_HexToBCD(priceUS);
        temp[7] = this.Formula_HexToBCD(priceUS / 100);
        temp[8] = this.Formula_HexToBCD(priceUS / 10000);
        temp[9] = (byte)(this.inputItem.scale() + 1 & 7);
        if (this.plu == null) {
            temp[9] = (byte)(temp[9] | 8);
        }
        if ((itemUS = this.inputItem.unscaledValue().intValue()) > 999999) {
            temp[9] = (byte)(temp[9] | 0x10);
        }
        if (itemUS < 999999) {
            temp[9] = (byte)(temp[9] | 0x20);
        }
        temp[10] = this.Formula_HexToBCD(itemUS);
        temp[11] = this.Formula_HexToBCD(itemUS / 100);
        temp[12] = this.Formula_HexToBCD(itemUS / 10000);
        temp[13] = (byte)GlobalPara.getInstance().getTMS(40);
        return temp;
    }

    private byte[] Protocol_B() {
        byte[] temp = new byte[6];
        temp[0] = -1;
        BigDecimal weight = this.wr.getNetWeight();
        temp[1] = (byte)(weight.scale() + 1 & 7);
        int weightUS = weight.unscaledValue().intValue();
        if (weightUS < 0) {
            weightUS = -weightUS;
            temp[1] = (byte)(temp[1] | 0x20);
        }
        if (this.wr.isStable()) {
            temp[1] = (byte)(temp[1] | 0x40);
        }
        if (this.wr.getValidType() >= 4) {
            temp[1] = (byte)(temp[1] | 0x80);
        }
        temp[2] = this.Formula_HexToBCD(weightUS);
        temp[3] = this.Formula_HexToBCD(weightUS / 100);
        temp[4] = this.Formula_HexToBCD(weightUS / 10000);
        temp[5] = (byte)(this.wr.getUnit() != 3 ? 1 : 0);
        return temp;
    }

    private byte[] Protocol_C() {
        String rv = "WT";
        rv = this.wr.getValidType() >= 4 ? rv + "OL" : (this.wr.isStable() ? rv + "ST" : rv + "US");
        BigDecimal weight = this.wr.getNetWeight();
        if (weight.compareTo(BigDecimal.ZERO) < 0) {
            rv = rv + '-';
            weight = weight.negate();
        } else {
            rv = rv + '+';
        }
        rv = rv + this.nums32_New_Fill(weight, 7, ' ') + this.unit_B4() + "\r\n";
        return rv.getBytes();
    }

    private byte[] Protocol_D() {
        byte[] temp = new byte[8];
        temp[0] = 61;
        byte[] weightChar = this.wr.getNetWeight().toString().getBytes();
        int pos = weightChar.length;
        for (int out = 1; out < 8; ++out) {
            temp[out] = pos > 0 ? weightChar[--pos] : 32;
        }
        return temp;
    }

    private byte[] Protocol_E() {
        byte[] temp = new byte[12];
        temp[0] = 2;
        temp[11] = 3;
        BigDecimal weight = this.wr.getNetWeight();
        Integer weightUS = weight.unscaledValue().intValue();
        if (weightUS < 0) {
            weightUS = -weightUS.intValue();
            temp[1] = 45;
        } else {
            temp[1] = 43;
        }
        byte[] weightChar = weightUS.toString().getBytes();
        int pos = weightChar.length;
        for (int out = 7; out > 1; --out) {
            temp[out] = pos > 0 ? weightChar[--pos] : 48;
        }
        temp[8] = (byte)(weight.scale() + 48);
        int crc = temp[1] ^ temp[2] ^ temp[3] ^ temp[4] ^ temp[5] ^ temp[6] ^ temp[7] ^ temp[8];
        temp[9] = HexValue[crc >> 4 & 0xF];
        temp[10] = HexValue[crc & 0xF];
        return temp;
    }

    private byte[] Protocol_F() {
        byte[] temp = new byte[]{10, 13, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
        if (this.inputAmount.compareTo(BigDecimal.ZERO) >= 0) {
            int out;
            Integer ctAmount = this.inputAmount.movePointRight(3).intValue();
            Integer ctPrice = this.inputPrice.movePointRight(2).intValue();
            Integer ctItem = this.inputItem.movePointRight(2).intValue();
            byte[] weightChar = ctAmount.toString().getBytes();
            int pos = weightChar.length;
            for (out = 6; out >= 2 && pos > 0; --out) {
                temp[out] = weightChar[--pos];
            }
            weightChar = ctPrice.toString().getBytes();
            pos = weightChar.length;
            for (out = 13; out >= 9 && pos > 0; --out) {
                temp[out] = weightChar[--pos];
            }
            weightChar = ctItem.toString().getBytes();
            pos = weightChar.length;
            for (out = 21; out >= 16 && pos > 0; --out) {
                temp[out] = weightChar[--pos];
            }
        }
        return temp;
    }

    private byte[] Protocol_G() {
        byte[] temp = new byte[]{10, 13, 32, 32, 32, 32, 32};
        Integer ctWeight = this.wr.getNetWeight().movePointRight(3).intValue();
        int endpos = 2;
        if (ctWeight < 0) {
            temp[endpos] = 45;
            ++endpos;
            ctWeight = -ctWeight.intValue();
        }
        byte[] weightChar = ctWeight.toString().getBytes();
        int pos = weightChar.length;
        for (int out = 6; out >= endpos; --out) {
            if (pos > 0) {
                temp[out] = weightChar[--pos];
                continue;
            }
            if (endpos <= 2) continue;
            temp[out] = 48;
        }
        return temp;
    }

    private byte[] Protocol_H() {
        BigDecimal weight = this.wr.getNetWeight();
        if (!this.wr.isStable() || weight.compareTo(BigDecimal.ZERO) < 0) {
            byte[] temp = new byte[]{63, 63, 63, 63, 63};
            return temp;
        }
        byte[] temp = new byte[]{2, 32, 32, 32, 32, 32, 32, 32, 32, 75, 71};
        byte[] weightChar = weight.toString().getBytes();
        int pos = weightChar.length;
        for (int out = 7; out >= 1 && pos > 0; --out) {
            temp[out] = weightChar[--pos];
        }
        int unit = this.wr.getUnit();
        if (unit == 4) {
            temp[9] = 32;
            temp[10] = 71;
        } else if (unit == 5) {
            temp[9] = 32;
            temp[10] = 84;
        } else if (unit == 6) {
            temp[9] = 76;
            temp[10] = 66;
        } else {
            temp[9] = 75;
            temp[10] = 71;
        }
        return temp;
    }

    public byte[] toSerialPortContent_100ms() {
        int spec = GlobalPara.getInstance().getTMS(57);
        if (spec == 1) {
            return this.Protocol_A();
        }
        if (spec == 2) {
            return this.Protocol_B();
        }
        if (spec == 3) {
            return this.Protocol_C();
        }
        if (spec == 4) {
            return this.Protocol_D();
        }
        if (spec == 5) {
            if (this.wr.isStable()) {
                return this.Protocol_D();
            }
        } else {
            if (spec == 6) {
                return this.Protocol_E();
            }
            if (spec == 7) {
                if (this.wr.isStable()) {
                    return this.Protocol_E();
                }
            } else {
                if (spec == 8) {
                    return this.Protocol_F();
                }
                if (spec == 9) {
                    if (this.wr.isStable()) {
                        return this.Protocol_F();
                    }
                } else {
                    if (spec == 10) {
                        return this.Protocol_G();
                    }
                    if (spec == 11) {
                        if (this.wr.isStable()) {
                            return this.Protocol_G();
                        }
                    } else if (spec == 12) {
                        // empty if block
                    }
                }
            }
        }
        return null;
    }

    public byte[] toSerialPortContent_ACK(byte[] input) {
        if (input == null) {
            return null;
        }
        int spec = GlobalPara.getInstance().getTMS(57);
        if (spec == 12) {
            for (int loop = 0; loop < input.length; ++loop) {
                if (input[loop] != 80) continue;
                return this.Protocol_H();
            }
        }
        return null;
    }

    public void setPlu(FDPLU plu) {
        this.plu = plu;
    }

    public void setAmount(BigDecimal amount) {
        this.inputAmount = amount;
    }

    public void setPrice(BigDecimal price) {
        this.inputPrice = price;
    }

    public void setItem(BigDecimal item) {
        this.inputItem = item;
    }

    public void setSerialDisplayPause(boolean pause) {
        this.serialDisplayPause = pause;
    }

    private static class SingleSerialDisplay {
        private static final SerialDisplay SINGLETON = new SerialDisplay();

        private SingleSerialDisplay() {
        }
    }
}

