/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.model;

import com.jhscale.common.model.device._inner.PublicExecute;
import com.jhscale.common.model.device._inner.PublicExecuteAsk;
import com.jhscale.common.model.device._inner.PublicExecuteDelete;
import com.jhscale.common.model.device._inner.PublicExecuteEnd;
import com.jhscale.common.model.device._inner.PublicExecuteModify;
import com.jhscale.common.model.device._inner.PublicExecuteModifyCache;
import com.jhscale.common.model.device._inner.PublicExecuteRecovery;
import com.jhscale.common.model.device._inner.UnPackageResponse;
import com.jhscale.common.model.device.info.DTIM;
import com.jhscale.common.model.inter.DataJSONModel;
import com.jhscale.common.utils.DDataUtils;
import com.jhscale.common.utils.SystemtUtils;
import com.jhscale.meter.entity.TCPCacheChannel;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.io.TCPClient;
import com.jhscale.meter.io.TCPServer;
import com.jhscale.meter.io.UDPLink;
import com.jhscale.meter.io.control.SocketControl;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.io.listener.SocketClientEventListener;
import com.jhscale.meter.model.device.TCPClientDevice;
import com.jhscale.meter.model.device.TCPServerDevice;
import com.jhscale.meter.model.device.UDPDevice;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.protocol.model.JHTCPAccept;
import com.jhscale.meter.protocol.model.JHTCPAnswer;
import com.jhscale.meter.protocol.model.SocketNotify;
import com.jhscale.meter.protocol.model.TCPClientResponse;
import com.jhscale.meter.protocol.model.TCPServerCache;
import com.jhscale.meter.protocol.other.CMPT;
import com.jhscale.meter.protocol.other.cmpt.CMPTAction;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class SocketCommunication
implements GlobalPara.GlobalParaRefresh {
    private SocketNotify notify;
    private static final int version = 251;
    private int tcp_server_port = 33581;
    private boolean tcp_link_status = false;
    private TCPServer TCPServer;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private TCPServerCache serverCache;
    private Map<String, TCPCacheChannel> cacheChannelMap;
    @Deprecated
    private String tcp_server_msg_cache;
    private TCPClient TCPClient;
    private UDPLink UDP_Link;
    private UDP_Thread UDP_Thread;
    private int UDP_Type;
    private static final String Send_33583 = "UDP\t\r\n";
    private static final String Send_33584 = "UDP\t%s\t%s\r\n";
    private Long executeTime = null;
    private CMPTAction cmptAction;
    private SocketControl tcp_server_control;
    private SocketControl udp_control;

    private SocketCommunication() {
        GlobalPara.getInstance().addRefresh(this);
    }

    public static SocketCommunication getInstance() {
        return SingleSocketCommunication.SINGLETON;
    }

    public SocketCommunication Init_Notify(SocketNotify notify) {
        this.notify = notify;
        return this;
    }

    protected synchronized String tcp_server_msg_merge(ChannelHandlerContext ctx, String acceptMsg) {
        TCPCacheChannel cacheChannel;
        String cache = "";
        if (this.cacheChannelMap != null && (cacheChannel = this.cacheChannelMap.get(ctx.channel().remoteAddress().toString())) != null) {
            cache = cacheChannel.getTcp_server_msg_cache();
        }
        return cache + acceptMsg;
    }

    protected synchronized void tcp_server_msg_cache(ChannelHandlerContext ctx, String surplus) {
        String address_key;
        TCPCacheChannel channel;
        if (this.cacheChannelMap == null) {
            this.cacheChannelMap = new HashMap<String, TCPCacheChannel>();
        }
        if ((channel = this.cacheChannelMap.get(address_key = ctx.channel().remoteAddress().toString())) == null) {
            channel = new TCPCacheChannel(ctx);
            this.cacheChannelMap.put(ctx.channel().toString(), channel);
        }
        channel.setTcp_server_msg_cache(surplus);
    }

    public boolean tcp_server_ask(PublicExecuteAsk ask) {
        boolean result = false;
        if (this.cacheChannelMap != null && !this.cacheChannelMap.isEmpty()) {
            result = true;
            String ask_str = ask.Package_No_Reflex_Body();
            for (TCPCacheChannel value : this.cacheChannelMap.values()) {
                try {
                    value.getCtx().writeAndFlush((Object)ask_str);
                }
                catch (Exception e) {
                    result = false;
                }
            }
        }
        return result;
    }

    public boolean Init_TCP_Server(final TCPServerDevice device) {
        int tms = GlobalPara.getInstance().getTMS(43);
        if (tms == 1) {
            this.cacheChannelMap = new HashMap<String, TCPCacheChannel>();
            new Thread(){

                @Override
                public void run() {
                    SocketCommunication.this.bossGroup = (EventLoopGroup)new NioEventLoopGroup();
                    SocketCommunication.this.workerGroup = (EventLoopGroup)new NioEventLoopGroup();
                    try {
                        ServerBootstrap serverBootstrap = new ServerBootstrap();
                        ((ServerBootstrap)serverBootstrap.group(SocketCommunication.this.bossGroup, SocketCommunication.this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                            public void initChannel(SocketChannel ch) throws Exception {
                                ChannelPipeline pipeline = ch.pipeline();
                                pipeline.addLast(new ChannelHandler[]{new StringDecoder(GlobalPara.getInstance().getProgram_encoding())});
                                pipeline.addLast(new ChannelHandler[]{new StringEncoder(GlobalPara.getInstance().getProgram_encoding())});
                                pipeline.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                                    public void channelActive(ChannelHandlerContext ctx) throws Exception {
                                        SocketCommunication.this.cacheChannelMap.put(ctx.channel().remoteAddress().toString(), new TCPCacheChannel(ctx));
                                    }

                                    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                                        SocketCommunication.this.cacheChannelMap.remove(ctx.channel().remoteAddress().toString());
                                    }

                                    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                                        String content = msg.toString();
                                        String acceptStr = SocketCommunication.this.tcp_server_msg_merge(ctx, content);
                                        if (GlobalPara.getInstance().isRunLog()) {
                                            System.out.printf("Accept Content: %s%n", acceptStr);
                                        }
                                        long un_package_start = System.currentTimeMillis();
                                        UnPackageResponse un_package_response = DDataUtils.Public_UnPackage_Lines_Distribute((String)acceptStr, (boolean)GlobalPara.getInstance().isRunLog());
                                        long un_package_end = System.currentTimeMillis();
                                        if (GlobalPara.getInstance().isRunLog()) {
                                            System.out.printf("Accept UnPackage Str_Length:[%s] Size:[%s] Time:[%s] Un_Package_Response: %s%n", acceptStr.length(), un_package_response.size(), un_package_end - un_package_start, un_package_response.toJSON());
                                        }
                                        SocketCommunication.this.tcp_server_msg_cache(ctx, un_package_response.getSurplus());
                                        if (un_package_response.size() > 0) {
                                            for (PublicExecute acceptExecute : un_package_response.getExecutes()) {
                                                JHTCPAnswer answer = null;
                                                if (acceptExecute instanceof PublicExecuteRecovery) {
                                                    JHTCPAccept accept = new JHTCPAccept(ctx, acceptExecute);
                                                    switch (acceptExecute.getType()) {
                                                        case "INF": {
                                                            answer = accept.callBack().addAnswer(new PublicExecute[]{new PublicExecuteModify("INF").add(new DataJSONModel[]{GlobalPara.getInstance().deviceInfo()})});
                                                            break;
                                                        }
                                                        case "MAC": {
                                                            answer = accept.callBack().addAnswer(new PublicExecute[]{new PublicExecuteModify("MAC").add(new DataJSONModel[]{GlobalPara.getInstance().deviceMac()})});
                                                            break;
                                                        }
                                                        case "TIM": {
                                                            answer = accept.callBack().addAnswer(new PublicExecute[]{new PublicExecuteModify("TIM").add(new DataJSONModel[]{new DTIM().setTime(new Date())})});
                                                            break;
                                                        }
                                                        default: {
                                                            new TCPServerThread(ctx, new TCPServerCache(acceptExecute)).start();
                                                            break;
                                                        }
                                                    }
                                                } else if (acceptExecute instanceof PublicExecuteModify) {
                                                    if (SocketCommunication.this.serverCache != null && SocketCommunication.this.serverCache.getExecute() instanceof PublicExecuteModify) {
                                                        ((PublicExecuteModify)SocketCommunication.this.serverCache.getExecute()).add(((PublicExecuteModify)acceptExecute).getModels());
                                                    } else {
                                                        SocketCommunication.this.serverCache = new TCPServerCache(acceptExecute);
                                                    }
                                                } else if (acceptExecute instanceof PublicExecuteModifyCache) {
                                                    if (SocketCommunication.this.serverCache != null && SocketCommunication.this.serverCache.getExecute() instanceof PublicExecuteModifyCache) {
                                                        ((PublicExecuteModifyCache)SocketCommunication.this.serverCache.getExecute()).add(((PublicExecuteModifyCache)acceptExecute).getLines());
                                                    } else {
                                                        SocketCommunication.this.serverCache = new TCPServerCache(acceptExecute);
                                                    }
                                                } else if (acceptExecute instanceof PublicExecuteDelete) {
                                                    if (SocketCommunication.this.serverCache != null && SocketCommunication.this.serverCache.getExecute() instanceof PublicExecuteDelete) {
                                                        ((PublicExecuteDelete)SocketCommunication.this.serverCache.getExecute()).add(((PublicExecuteDelete)acceptExecute).getIds());
                                                    } else {
                                                        SocketCommunication.this.serverCache = new TCPServerCache(acceptExecute);
                                                    }
                                                } else if (acceptExecute instanceof PublicExecuteEnd) {
                                                    if (SocketCommunication.this.serverCache != null) {
                                                        new TCPServerThread(ctx, SocketCommunication.this.serverCache.clone()).start();
                                                        SocketCommunication.this.serverCache = null;
                                                    }
                                                } else if (acceptExecute instanceof PublicExecuteAsk) {
                                                    System.err.printf("Accept Ask: %s%n", acceptExecute.toJSON());
                                                    new TCPServerThread(ctx, new TCPServerCache(acceptExecute)).start();
                                                }
                                                if (answer == null || answer.isAsync()) continue;
                                                answer.resultExecute();
                                            }
                                        }
                                    }

                                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                                        cause.printStackTrace();
                                        ctx.close();
                                    }
                                }});
                            }
                        });
                        ChannelFuture future = serverBootstrap.bind(Objects.isNull(device) || device.getPort() <= 0 ? SocketCommunication.this.tcp_server_port : device.getPort()).sync();
                        System.out.println("TCP Server Start Success");
                        future.channel().closeFuture().sync();
                        System.out.println("TCP Server Close Success");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            if (SocketCommunication.this.bossGroup != null) {
                                SocketCommunication.this.bossGroup.shutdownGracefully();
                            }
                            if (SocketCommunication.this.workerGroup != null) {
                                SocketCommunication.this.workerGroup.shutdownGracefully();
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
            }.start();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    @Deprecated
    protected synchronized String tcp_server_msg_cache(String acceptMsg) {
        return (StringUtils.isNotBlank((CharSequence)this.tcp_server_msg_cache) ? this.tcp_server_msg_cache : "") + acceptMsg;
    }

    @Deprecated
    public boolean Init_TCP_Server(SocketControl control, TCPServerDevice device) {
        int tms = GlobalPara.getInstance().getTMS(43);
        if (tms == 1) {
            try {
                device = device == null ? new TCPServerDevice() : device;
                this.tcp_server_port = device.getPort();
                this.TCPServer = new TCPServer(control, device, (DeviceClientEventListener)new SocketClientEventListener(){

                    @Override
                    public void onClientLink(InetAddress address, int port) {
                        SocketCommunication.this.UDP_Terminal_Pause_Resume();
                        SocketCommunication.this.tcp_link_status = true;
                        SocketCommunication.this.tcp_server_msg_cache = "";
                    }

                    @Override
                    public void onClientBreak(InetAddress address, int port) {
                        SocketCommunication.this.UDP_Terminal_Pause_Resume();
                        SocketCommunication.this.tcp_link_status = false;
                        SocketCommunication.this.tcp_server_msg_cache = "";
                    }

                    @Override
                    public byte[] onClientEventResponse(PortManager portManager, byte[] bytes) throws MeterException {
                        if (bytes != null && bytes.length > 0) {
                            String acceptStr = SocketCommunication.this.tcp_server_msg_cache(new String(bytes, GlobalPara.getInstance().getProgram_encoding()));
                            if (GlobalPara.getInstance().isRunLog()) {
                                System.out.printf("Accept Content: %s%n", acceptStr);
                            }
                            long un_package_start = System.currentTimeMillis();
                            UnPackageResponse un_package_response = DDataUtils.Public_UnPackage_Lines_Distribute((String)acceptStr, (boolean)GlobalPara.getInstance().isRunLog());
                            long un_package_end = System.currentTimeMillis();
                            if (GlobalPara.getInstance().isRunLog()) {
                                System.out.printf("Accept UnPackage Str_Length:[%s] Size:[%s] Time:[%s] Un_Package_Response: %s%n", acceptStr.length(), un_package_response.size(), un_package_end - un_package_start, un_package_response.toJSON());
                            }
                            SocketCommunication.this.tcp_server_msg_cache = un_package_response.getSurplus();
                            if (un_package_response.size() > 0) {
                                for (PublicExecute acceptExecute : un_package_response.getExecutes()) {
                                    JHTCPAnswer answer = null;
                                    if (acceptExecute instanceof PublicExecuteRecovery) {
                                        JHTCPAccept accept = new JHTCPAccept(portManager, acceptExecute);
                                        switch (acceptExecute.getType()) {
                                            case "INF": {
                                                answer = accept.callBack().addAnswer(new PublicExecute[]{new PublicExecuteModify("INF").add(new DataJSONModel[]{GlobalPara.getInstance().deviceInfo()})});
                                                break;
                                            }
                                            case "MAC": {
                                                answer = accept.callBack().addAnswer(new PublicExecute[]{new PublicExecuteModify("MAC").add(new DataJSONModel[]{GlobalPara.getInstance().deviceMac()})});
                                                break;
                                            }
                                            case "TIM": {
                                                answer = accept.callBack().addAnswer(new PublicExecute[]{new PublicExecuteModify("TIM").add(new DataJSONModel[]{new DTIM().setTime(new Date())})});
                                                break;
                                            }
                                            default: {
                                                new TCPServerThread(portManager, new TCPServerCache(acceptExecute)).start();
                                                break;
                                            }
                                        }
                                    } else if (acceptExecute instanceof PublicExecuteModify) {
                                        if (SocketCommunication.this.serverCache != null && SocketCommunication.this.serverCache.getExecute() instanceof PublicExecuteModify) {
                                            ((PublicExecuteModify)SocketCommunication.this.serverCache.getExecute()).add(((PublicExecuteModify)acceptExecute).getModels());
                                        } else {
                                            SocketCommunication.this.serverCache = new TCPServerCache(acceptExecute);
                                        }
                                    } else if (acceptExecute instanceof PublicExecuteModifyCache) {
                                        if (SocketCommunication.this.serverCache != null && SocketCommunication.this.serverCache.getExecute() instanceof PublicExecuteModifyCache) {
                                            ((PublicExecuteModifyCache)SocketCommunication.this.serverCache.getExecute()).add(((PublicExecuteModifyCache)acceptExecute).getLines());
                                        } else {
                                            SocketCommunication.this.serverCache = new TCPServerCache(acceptExecute);
                                        }
                                    } else if (acceptExecute instanceof PublicExecuteDelete) {
                                        if (SocketCommunication.this.serverCache != null && SocketCommunication.this.serverCache.getExecute() instanceof PublicExecuteDelete) {
                                            ((PublicExecuteDelete)SocketCommunication.this.serverCache.getExecute()).add(((PublicExecuteDelete)acceptExecute).getIds());
                                        } else {
                                            SocketCommunication.this.serverCache = new TCPServerCache(acceptExecute);
                                        }
                                    } else if (acceptExecute instanceof PublicExecuteEnd) {
                                        if (SocketCommunication.this.serverCache != null) {
                                            new TCPServerThread(portManager, SocketCommunication.this.serverCache.clone()).start();
                                            SocketCommunication.this.serverCache = null;
                                        }
                                    } else if (acceptExecute instanceof PublicExecuteAsk) {
                                        System.err.printf("Accept Ask: %s%n", acceptExecute.toJSON());
                                        new TCPServerThread(portManager, new TCPServerCache(acceptExecute)).start();
                                    }
                                    if (answer == null || answer.isAsync()) continue;
                                    answer.resultExecute();
                                }
                            }
                        }
                        return new byte[0];
                    }

                    @Override
                    public void onClientEventExp(MeterException e) {
                        if (SocketCommunication.this.notify != null) {
                            SocketCommunication.this.notify.onClientEventExp(e);
                        }
                    }
                });
                return this.TCPServer.openPort();
            }
            catch (MeterException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean Stop_TCP_Server() {
        try {
            if (this.TCPServer == null && this.workerGroup == null && this.bossGroup == null) {
                return true;
            }
            boolean result = false;
            if (this.TCPServer != null) {
                result = this.TCPServer.closePort();
            } else {
                if (this.workerGroup != null) {
                    this.workerGroup.shutdownGracefully();
                }
                if (this.bossGroup != null) {
                    this.bossGroup.shutdownGracefully();
                }
                result = true;
            }
            this.TCPServer = null;
            this.workerGroup = null;
            this.bossGroup = null;
            this.tcp_server_port = 33581;
            return result;
        }
        catch (MeterException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean Init_TCP_Client(SocketControl control) {
        int tms = GlobalPara.getInstance().getTMS(43);
        if (tms == 2) {
            try {
                this.TCPClient = new TCPClient(control, new TCPClientDevice(String.format("%s.%s.%s.%s", GlobalPara.getInstance().getTMS(154), GlobalPara.getInstance().getTMS(155), GlobalPara.getInstance().getTMS(156), GlobalPara.getInstance().getTMS(157))));
                return this.TCPClient.openPort();
            }
            catch (MeterException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean Stop_TCP_Client() {
        try {
            if (this.TCPClient == null) {
                return true;
            }
            boolean result = this.TCPClient.closePort();
            this.TCPClient = null;
            return result;
        }
        catch (MeterException e) {
            e.printStackTrace();
            return false;
        }
    }

    public TCPClientResponse network(byte[] request) {
        if (request == null || request.length == 0) {
            return TCPClientResponse.fail(MeterStateEnum.TCP_Client\u53d1\u9001\u6570\u636e\u5305\u4e0d\u5b58\u5728);
        }
        if (this.TCPClient == null) {
            return TCPClientResponse.fail(MeterStateEnum.TCP_Client\u672a\u6253\u5f00);
        }
        try {
            return TCPClientResponse.success(this.TCPClient.sendWithAccept(request));
        }
        catch (MeterException e) {
            e.printStackTrace();
            return TCPClientResponse.fail(e.getMeterState());
        }
        catch (Exception e) {
            e.printStackTrace();
            return TCPClientResponse.fail();
        }
    }

    public TCPClientResponse network(String request) {
        if (StringUtils.isBlank((CharSequence)request)) {
            return TCPClientResponse.fail(MeterStateEnum.TCP_Client\u53d1\u9001\u6570\u636e\u5305\u4e0d\u5b58\u5728);
        }
        return this.network(request.getBytes());
    }

    public boolean Init_UDP_Link(SocketControl control, int type) {
        if (type == 1 || type == 2) {
            this.UDP_Type = type;
            try {
                this.UDP_Link = new UDPLink(control, type == 1 ? UDPDevice.UDP_PC() : UDPDevice.UDP_Terminal(), (DeviceClientEventListener)new SocketClientEventListener(){

                    @Override
                    public byte[] onClientEvent(PortManager portManager, InetAddress address, int port, byte[] bytes) throws MeterException {
                        String accept = new String(bytes);
                        if (GlobalPara.getInstance().isRunLog()) {
                            System.out.printf("\u6536\u5230\u6765\u81ea:%s,\u5bf9\u65b9\u7aef\u53e3\u53f7\u4e3a:%s,\u6d88\u606f\u5185\u5bb9\uff1a%s%n", address, port, accept);
                        }
                        if (StringUtils.isNotBlank((CharSequence)accept)) {
                            if (SocketCommunication.this.UDP_Type == 2 && SocketCommunication.Send_33583.equals(accept)) {
                                SocketCommunication.this.UDP_Terminal();
                            }
                        } else if (SocketCommunication.this.notify != null) {
                            SocketCommunication.this.notify.udpFoundEvent(address, port, accept);
                        }
                        return new byte[0];
                    }

                    @Override
                    public void onClientEventExp(MeterException e) {
                        if (SocketCommunication.this.notify != null) {
                            SocketCommunication.this.notify.onClientEventExp(e);
                        }
                    }
                });
                boolean result = this.UDP_Link.openPort();
                if (this.UDP_Type == 1) {
                    this.UDP_PC(4);
                } else if (this.UDP_Type == 2) {
                    this.UDP_Thread = new UDP_Thread(new UDP_Execute(){

                        @Override
                        public void execute() {
                            SocketCommunication.this.UDP_Terminal();
                        }
                    }, 30);
                    this.UDP_Thread.start();
                }
                return result;
            }
            catch (MeterException e) {
                e.printStackTrace();
                this.UDP_Link = null;
            }
        }
        return false;
    }

    public boolean Stop_UDP_Link() {
        try {
            if (this.UDP_Thread != null) {
                this.UDP_Thread.close();
                this.UDP_Thread = null;
            }
            if (this.UDP_Link == null) {
                return true;
            }
            boolean result = this.UDP_Link.closePort();
            this.UDP_Link = null;
            return result;
        }
        catch (MeterException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean UDP_PC() {
        return this.UDP_PC(1);
    }

    public boolean UDP_PC(int count) {
        if (this.UDP_Link != null && this.UDP_Type == 1) {
            count = count <= 0 ? 1 : count;
            for (int i = 0; i < count; ++i) {
                try {
                    this.UDP_Link.writeDataImmediately(Send_33583.getBytes());
                    continue;
                }
                catch (MeterException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean UDP_Terminal_Pause_Resume() {
        if (this.UDP_Thread != null) {
            this.UDP_Thread.pause = !this.UDP_Thread.pause;
            return true;
        }
        return false;
    }

    public boolean UDP_Terminal() {
        return this.UDP_Terminal(1);
    }

    public boolean UDP_Terminal(int count) {
        if (this.UDP_Link != null && this.UDP_Terminal_Broadcast_Check() && this.UDP_Type == 2) {
            count = count <= 0 ? 1 : count;
            for (int i = 0; i < count; ++i) {
                if (this.executeTime != null && System.currentTimeMillis() - this.executeTime < 5000L) {
                    return true;
                }
                try {
                    this.UDP_Link.writeDataImmediately(String.format(Send_33584, this.tcp_server_port, 251).getBytes());
                    this.executeTime = System.currentTimeMillis();
                    continue;
                }
                catch (MeterException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean UDP_Terminal_Broadcast_Check() {
        return (this.TCPServer != null || this.workerGroup != null && this.bossGroup != null) && !this.tcp_link_status && (this.cacheChannelMap == null || this.cacheChannelMap.isEmpty());
    }

    public SocketCommunication Init_CMPT_Control(SocketControl tcp_server_control, SocketControl udp_control) {
        this.tcp_server_control = tcp_server_control;
        this.udp_control = udp_control;
        return this;
    }

    public CMPTAction cmptAction() {
        return this.cmptAction;
    }

    @Override
    public int[] refreshIds() {
        return new int[]{179};
    }

    @Override
    public void refreshAction(int no, int value) {
        switch (no) {
            case 179: {
                this.Init_CMPT();
            }
        }
    }

    public boolean Init_CMPT() {
        if (this.tcp_server_control != null && this.udp_control != null) {
            int custom_protocol = GlobalPara.getInstance().getTMS(179);
            CMPT cmpt = CMPT.serial(custom_protocol);
            if (cmpt == null) {
                return false;
            }
            try {
                if (this.cmptAction != null) {
                    if (this.cmptAction.CMPT().equals((Object)cmpt)) {
                        return true;
                    }
                    this.cmptAction.Stop_Action();
                    this.cmptAction = null;
                }
                this.cmptAction = (CMPTAction)cmpt.getClazz().newInstance();
                this.cmptAction.Init_CMPT_Action(cmpt, this.tcp_server_control, this.udp_control, this.notify);
                return this.cmptAction.Init_Action();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private class TCPServerThread
    extends Thread {
        private PortManager portManager;
        private ChannelHandlerContext ctx;
        private final TCPServerCache cache;

        TCPServerThread(PortManager portManager, TCPServerCache cache) {
            this.portManager = portManager;
            this.cache = cache;
        }

        public TCPServerThread(ChannelHandlerContext ctx, TCPServerCache cache) {
            this.ctx = ctx;
            this.cache = cache;
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            PublicExecute execute = this.cache.getExecute();
            if (execute instanceof PublicExecuteModifyCache) {
                execute = DDataUtils.Public_UnPackage_ModifyCache_To_Modify_No_Reflex((PublicExecuteModifyCache)((PublicExecuteModifyCache)this.cache.getExecute()), (boolean)GlobalPara.getInstance().isRunLog());
            }
            long end = System.currentTimeMillis();
            if (GlobalPara.getInstance().isRunLog()) {
                System.out.printf("Accept End Execute [%s] Type: [%s] Size: [%s] Total_Time: [%s] Cache_Time: [%s]%n", execute.getExecute(), execute.getType(), execute.size(), System.currentTimeMillis() - this.cache.getStart(), end - start);
            }
            long t1 = System.currentTimeMillis();
            JHTCPAnswer answer_thread = SocketCommunication.this.notify.acceptEvent(execute, this.portManager != null ? new JHTCPAccept(this.portManager, execute) : new JHTCPAccept(this.ctx, execute));
            if (answer_thread != null && !answer_thread.isAsync()) {
                answer_thread.resultExecute();
            }
            long t2 = System.currentTimeMillis();
            if (GlobalPara.getInstance().isRunLog()) {
                System.out.printf("\u8017\u65f6\uff1a[%s]%n", t2 - t1);
            }
        }
    }

    private static interface UDP_Execute {
        public void execute();
    }

    private class UDP_Thread
    extends Thread {
        private final UDP_Execute execute;
        private int time = 30;
        private boolean run = true;
        private boolean pause = false;

        UDP_Thread(UDP_Execute execute, int time) {
            this.execute = execute;
            this.time = time;
        }

        @Override
        public void run() {
            while (!this.isInterrupted() && this.run) {
                if (!this.pause) {
                    this.execute.execute();
                }
                SystemtUtils.sleep((int)this.time);
            }
        }

        void close() {
            this.interrupt();
            this.run = false;
        }
    }

    private static class SingleSocketCommunication {
        private static final SocketCommunication SINGLETON = new SocketCommunication();

        private SingleSocketCommunication() {
        }
    }
}

