/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.model;

import com.jhscale.common.em.PayType;
import com.jhscale.common.em.PayWay;
import com.jhscale.common.em.TradeType;
import com.jhscale.common.em.Version;
import com.jhscale.common.model.device._inner.DLOGContent;
import com.jhscale.common.model.device._inner.PublicExecuteAsk;
import com.jhscale.common.model.device.barcode_format.DBarcodeFormat;
import com.jhscale.common.model.device.category.DCategory;
import com.jhscale.common.model.device.log.DLOGV1;
import com.jhscale.common.model.device.log.module.DGoods;
import com.jhscale.common.model.device.log.module.DSource;
import com.jhscale.common.model.device.plu.DPLUV5;
import com.jhscale.common.model.device.plu.inner.DAutoDiscountV2;
import com.jhscale.common.model.device.plu.module.DPriceV2;
import com.jhscale.common.model.device.plu.module.DTimeV2;
import com.jhscale.common.model.inter.GJSONModel;
import com.jhscale.common.utils.BigDecimalUtils;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.RuntimeMeterException;
import com.jhscale.meter.protocol.model.BarCodeItemResult;
import com.jhscale.meter.protocol.model.CalPLU_ShelfDate;
import com.jhscale.meter.protocol.model.FID_SID;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.protocol.model.ItemContent;
import com.jhscale.meter.protocol.model.PrintCalculate_BarcodeCal;
import com.jhscale.meter.protocol.model.PrintContent;
import com.jhscale.meter.protocol.model.SocketCommunication;
import com.jhscale.meter.protocol.model.WeightCal;
import com.jhscale.meter.protocol.model.sp.TradeSpOut;
import com.jhscale.meter.protocol.model.sp.TradeSpecial;
import com.jhscale.meter.protocol.print.PrintGeneralFactory;
import com.jhscale.meter.protocol.print.link.IPrintBack;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@ApiModel(value="\u4ea4\u6613\u5185\u5bb9")
public class TradeContent
implements GJSONModel {
    @ApiModelProperty(value="\u5546\u54c1\u660e\u7ec6", name="item")
    private List<ItemContent> item;
    @ApiModelProperty(value="\u662f\u5426\u9884\u6253\u5370", name="isPrePrint")
    private boolean isPrePrint = false;
    @ApiModelProperty(value="\u662f\u5426\u91cd\u590d\u6253\u5370", name="isRePrint")
    private boolean isRePrint = false;
    @ApiModelProperty(value="\u4ea4\u6613\u65f6\u95f4", name="tradeTime")
    private Date tradeTime;
    @ApiModelProperty(value="\u6c38\u4e45\u65e5\u5fd7\u7f16\u53f7", name="fid")
    private int fid;
    @ApiModelProperty(value="\u4e34\u65f6\u65e5\u5fd7\u7f16\u53f7", name="sid")
    private int sid = 0;
    @ApiModelProperty(value="\u684c\u53f7", name="vid")
    private int vid = 1;
    @ApiModelProperty(value="\u8425\u4e1a\u5458\u7f16\u53f7", name="salesman_Number")
    private int salesman_Number = 0;
    @ApiModelProperty(value="\u8425\u4e1a\u5458\u540d\u79f0", name="salesman_Name")
    private String salesman_Name = "";
    @ApiModelProperty(value="\u670d\u52a1\u5458\u7f16\u53f7", name="serviceman_Number")
    private int serviceman_Number = 0;
    @ApiModelProperty(value="\u670d\u52a1\u5458\u7f16\u53f7", name="serviceman_Name")
    private String serviceman_Name = "";
    @ApiModelProperty(value="\u65e5\u5fd7\u7c7b\u578b", name="tradeType")
    private int tradeType = 0;
    @ApiModelProperty(value="\u65e5\u5fd7\u7c7b\u578b\u540d\u79f0", name="tradeTypeName")
    private String tradeTypeName = "\u9500\u552e";
    @ApiModelProperty(value="\u603b\u6570\u91cf", name="tCount")
    private BigDecimal tCount = BigDecimal.ZERO;
    @ApiModelProperty(value="\u603b\u91cd\u91cf", name="tWeight")
    private BigDecimal tWeight = BigDecimal.ZERO;
    @ApiModelProperty(value="\u603b\u91cd\u91cf\u5355\u4f4d", name="tUnitWeight")
    private int tUnitWeight = 0;
    @ApiModelProperty(value="\u91cd\u91cf\u5355\u4f4d", name="unit_Weight")
    private int unit_Weight = 0;
    @ApiModelProperty(value="\u539f\u59cb\u4ef7\u7a0e\u5408\u8ba1", name="purTax_FromPLU")
    private BigDecimal purTax_FromPLU = BigDecimal.ZERO;
    @ApiModelProperty(value="\u5546\u54c1\u4ef7\u7a0e\u5408\u8ba1", name="purTax_Addup")
    private BigDecimal purTax_Addup = BigDecimal.ZERO;
    @ApiModelProperty(value="\u5546\u54c1\u7a0e\u989d\u5408\u8ba1", name="tax_Addup")
    private BigDecimal tax_Addup = BigDecimal.ZERO;
    @ApiModelProperty(value="\u670d\u52a1\u8d39\u4ef7\u7a0e\u5408\u8ba1", name="purTax_ServiceFee")
    private BigDecimal purTax_ServiceFee = BigDecimal.ZERO;
    @ApiModelProperty(value="\u670d\u52a1\u8d39\u7a0e\u989d\u5408\u8ba1", name="tax_ServiceFee")
    private BigDecimal tax_ServiceFee = BigDecimal.ZERO;
    @ApiModelProperty(value="\u603b\u670d\u52a1\u8d39\u7c7b\u578b", name="total_ServiceFee_Type")
    private int total_ServiceFee_Type = 0;
    @ApiModelProperty(value="\u603b\u670d\u52a1\u8d39\u989d\u5ea6", name="total_ServiceFee_Rate")
    private BigDecimal total_ServiceFee_Rate = BigDecimal.ZERO;
    @ApiModelProperty(value="\u6298\u6263\u540e\u4ef7\u7a0e\u5408\u8ba1", name="purTax_Discounted")
    private BigDecimal purTax_Discounted = BigDecimal.ZERO;
    @ApiModelProperty(value="\u6298\u6263\u540e\u7a0e\u989d\u5408\u8ba1", name="tax_Discounted")
    private BigDecimal tax_Discounted = BigDecimal.ZERO;
    @ApiModelProperty(value="\u603b\u4ef7\u7a0e\u5408\u8ba1", name="purTax_Final")
    private BigDecimal purTax_Final = BigDecimal.ZERO;
    @ApiModelProperty(value="\u603b\u4ef7\u7a0e\u5408\u8ba1 == \u5269\u4f59\u9000\u6b3e\u91d1\u989d", name="surplus_Reject")
    private BigDecimal surplus_Reject;
    @ApiModelProperty(value="\u820d\u5165\u91d1\u989d", name="rounding")
    private BigDecimal rounding = BigDecimal.ZERO;
    @ApiModelProperty(value="\u627e\u96f6", name="change")
    private BigDecimal change = BigDecimal.ZERO;
    @ApiModelProperty(value="\u73b0\u91d1\u652f\u4ed8\u989d", name="pay_Cash")
    private BigDecimal pay_Cash = BigDecimal.ZERO;
    @ApiModelProperty(value="\u5176\u4ed61\u652f\u4ed8\u989d", name="pay_Other1")
    private BigDecimal pay_Other1 = BigDecimal.ZERO;
    @ApiModelProperty(value="\u5176\u4ed62\u652f\u4ed8\u989d", name="pay_Other2")
    private BigDecimal pay_Other2 = BigDecimal.ZERO;
    @ApiModelProperty(value="\u5176\u4ed62\u652f\u4ed8\u989d", name="pay_Other3")
    private BigDecimal pay_Other3 = BigDecimal.ZERO;
    @ApiModelProperty(value="\u5409\u5361\u4e91\u652f\u4ed8\u989d\u603b\u503c", name="pay_JKY_All")
    private BigDecimal pay_JKY_All = BigDecimal.ZERO;
    @ApiModelProperty(value="\u5409\u5361\u4e91\u652f\u4ed8\u989d\u8d60\u9001\u90e8\u5206", name="pay_JKY_Gift")
    private BigDecimal pay_JKY_Gift = BigDecimal.ZERO;
    @ApiModelProperty(value="\u5361\u652f\u4ed8\u989d", name="pay_Card")
    private BigDecimal pay_Card = BigDecimal.ZERO;
    @ApiModelProperty(value="\u4f1a\u5458\u5361\u539f\u4f59\u989d", name="pay_VIP_Balance_Old")
    private BigDecimal pay_VIP_Balance_Old = BigDecimal.ZERO;
    @ApiModelProperty(value="\u4f1a\u5458\u5361\u73b0\u4f59\u989d", name="pay_VIP_Balance_New")
    private BigDecimal pay_VIP_Balance_New = BigDecimal.ZERO;
    @ApiModelProperty(value="\u4f1a\u5458\u5361\u53f7", name="pay_VIP_Number")
    private String pay_VIP_ID = "";
    @ApiModelProperty(value="\u4f1a\u5458\u4e3b\u8bc6\u522b\u7801", name="pay_VIP_ID1")
    private String pay_VIP_ID_Plus1 = "";
    @ApiModelProperty(value="\u4f1a\u5458\u526f\u8bc6\u522b\u7801", name="pay_VIP_ID2")
    private String pay_VIP_ID_Plus2 = "";
    @ApiModelProperty(value="\u4f1a\u5458\u4f18\u60e0\u7b49\u7ea7", name="pay_VIP_Level")
    private char pay_VIP_Level = '\u0000';
    @ApiModelProperty(value="\u4f1a\u5458\u4f18\u60e0\u7387", name="pay_VIP_DiscountP1W")
    private int pay_VIP_DiscountP1W = 10000;
    @ApiModelProperty(value="\u4f1a\u5458\u5361\u79ef\u5206", name="pay_VIP_Point")
    private BigDecimal pay_VIP_Point = BigDecimal.ZERO;
    @ApiModelProperty(value="\u539f\u4ea4\u6613\u4fe1\u606f", name="source")
    private DSource source;
    @ApiModelProperty(value="\u4e91\u652f\u4ed8\u989d", name="pay_Cloud")
    private BigDecimal pay_Cloud = BigDecimal.ZERO;
    @ApiModelProperty(value="\u4e91\u652f\u4ed8\u4ea4\u6613\u6e20\u9053", name="pay_Cloud_TypeName")
    private Integer pay_Cloud_Way = 0;
    @ApiModelProperty(value="\u4e91\u652f\u4ed8\u652f\u4ed8\u65b9\u5f0f", name="pay_Cloud_TypeName")
    private Integer pay_Cloud_Type = 0;
    @ApiModelProperty(value="\u4e91\u652f\u4ed8\u7c7b\u578b\u540d", name="pay_Cloud_TypeName")
    private String pay_Cloud_TypeName = "";
    @ApiModelProperty(value="\u4e91\u652f\u4ed8\u5355\u53f7", name="pay_Cloud_Bill")
    private String pay_Cloud_Bill = "";
    @ApiModelProperty(value="\u9519\u8bef\u7801", name="error_code")
    private String error_code = "";
    @ApiModelProperty(value="\u9519\u8bef\u5185\u5bb9", name="error_text1")
    private String error_text1 = "";
    @ApiModelProperty(value="\u5ba2\u5236\u4fe1\u606f", name="customInfo")
    private Map<String, String> customInfo;
    @ApiModelProperty(value="\u6253\u5370\u5185\u5bb9", name="printContents")
    private List<PrintContent> printContents;
    @ApiModelProperty(value="\u65e5\u5fd7\u5185\u5bb9", name="logContent")
    private DLOGContent logContent;
    @ApiModelProperty(value="\u7279\u6b8a\u4fe1\u606f", name="spInfo")
    private Map<String, Object> spInfo = new HashMap<String, Object>();
    @ApiModelProperty(value="POS\u6253\u5370\u5185\u5bb9", name="posOnlyString")
    private Map<Integer, String> posOnlyString = new HashMap<Integer, String>();
    private static final String ZUUL = "http://jhscale.com/H5/index.html?type=tbs&mac=%s&fid=%s&date=%s";
    private static final byte[] HexValue = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final char[] HexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public TradeContent() {
        this.item = new ArrayList<ItemContent>();
        this.customInfo = new HashMap<String, String>();
    }

    public TradeContent(int type) {
        this();
        this.Total_TradeType_Set(type);
    }

    public TradeContent Total_Salesman_Set(int number, String name) {
        this.salesman_Number = number;
        this.salesman_Name = name;
        return this;
    }

    public TradeContent Total_Serviceman_Set(int number, String name) {
        this.serviceman_Number = number;
        this.serviceman_Name = name;
        return this;
    }

    public TradeContent Total_VID_Set(int number) {
        this.vid = number;
        return this;
    }

    public TradeContent Total_TradeType_Set(int type) {
        this.tradeType = type;
        this.tradeTypeName = GlobalPara.getInstance().getTradeTypeName(type);
        return this;
    }

    public BigDecimal CalPLU_UPrice_VIPed(DPLUV5 plu) {
        int p1w;
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int day_week = calendar.get(7);
        if (calendar.getFirstDayOfWeek() == 1) {
            --day_week;
        } else if (day_week == 7) {
            day_week = 0;
        }
        day_week = 1 << day_week;
        DPriceV2 price = plu.price(Integer.valueOf(GlobalPara.getInstance().getDeviceLevel()));
        if (this.pay_VIP_Level != '\u0000') {
            if (GlobalPara.getInstance().isDiscountAuto_InTime()) {
                for (int level = this.pay_VIP_Level - 65; level >= 0 && level < 4; --level) {
                    if (price.getAutoDiscounts() == null || price.getAutoDiscounts().isEmpty()) continue;
                    for (DAutoDiscountV2 autoDiscount : price.getAutoDiscounts()) {
                        int ctSort;
                        if ((autoDiscount.date() & day_week) == 0 || (ctSort = autoDiscount.type() - 4) < 0 || ctSort >= 4 || level != ctSort) continue;
                        if (BigDecimalUtils.compareMoreZeroValue((BigDecimal)autoDiscount.discount())) {
                            return autoDiscount.discount();
                        }
                        return price.getPrice().add(autoDiscount.discount());
                    }
                }
            }
            p1w = this.pay_VIP_DiscountP1W;
        } else {
            p1w = 10000 - GlobalPara.getInstance().getTMS(287) * 100;
        }
        if (p1w == 0 || p1w >= 10000) {
            return price.getPrice();
        }
        return price.getPrice().multiply(new BigDecimal(p1w)).divide(new BigDecimal(10000));
    }

    public ItemContent Item_Set_Note(ItemContent itemC, BigDecimal amount, BigDecimal price) {
        if (price == null) {
            if (amount == null) {
                return null;
            }
            itemC.setAmount(amount);
            if (amount.compareTo(BigDecimal.ZERO) > 0) {
                itemC.setValid_Amount(true);
            }
        } else {
            BigDecimal tax;
            if (amount == null) {
                BigDecimal mayAmount = null;
                BigDecimal mayUprice = null;
                try {
                    mayUprice = GlobalPara.getInstance().EcsCal_Unit_ValueConvert(itemC.getPlu().price(Integer.valueOf(GlobalPara.getInstance().getDeviceLevel())).getPrice(), itemC.getUnit_weight(), itemC.getUnit_price());
                    mayAmount = price.divide(mayUprice, GlobalPara.getInstance().getPointOfWeight(), RoundingMode.HALF_UP);
                }
                catch (Exception e) {
                    mayAmount = BigDecimal.ONE;
                    mayUprice = price;
                }
                itemC.setFixedSingle(true);
                if (GlobalPara.getInstance().EcsCal_Unit_isWeight(itemC.getUnit_weight())) {
                    itemC.setUnit_weight(2);
                    itemC.setUnit_price(2);
                    itemC.setAmount(BigDecimal.ONE);
                    itemC.setPrice(price);
                    itemC.setAmount_Stock(mayAmount);
                    itemC.setUnit_Stock(GlobalPara.getInstance().getWeightUNIT());
                } else {
                    itemC.setAmount(mayAmount.stripTrailingZeros());
                    itemC.setPrice(mayUprice);
                }
            } else {
                itemC.setAmount(amount);
            }
            if (itemC.getTaxType() == 1) {
                tax = price.multiply(itemC.getTaxRate());
                price = price.add(tax);
            } else {
                tax = itemC.getTaxType() == 2 ? price.multiply(itemC.getTaxRate()).divide(itemC.getTaxRate().add(BigDecimal.ONE), 7, 4) : (itemC.getTaxType() == 3 ? price.multiply(itemC.getTaxRate()) : BigDecimal.ZERO);
            }
            itemC.setTax(GlobalPara.getInstance().EcsCal_Rounding_Single(tax));
            itemC.setSingleWtax(GlobalPara.getInstance().EcsCal_Rounding_Single(price));
            itemC.setSingleNtax(itemC.getSingleWtax().subtract(itemC.getTax()));
            boolean valid = itemC.getSingleWtax().compareTo(BigDecimal.ZERO) != 0 || GlobalPara.getInstance().getTMS(70) == 1;
            itemC.setValid_Amount(valid);
            itemC.setValid_Single(valid);
            return itemC;
        }
        itemC.Item_ReCal(this);
        return itemC;
    }

    public ItemContent Item_Set_Note(ItemContent itemC, BarCodeItemResult barCIR) {
        BigDecimal amount = null;
        BigDecimal price = null;
        if (barCIR.getPrice() != null) {
            price = new BigDecimal(barCIR.getPrice()).movePointLeft(GlobalPara.getInstance().getTMS(209));
        }
        if (barCIR.getAmount() != null) {
            amount = new BigDecimal(barCIR.getAmount()).movePointLeft(GlobalPara.getInstance().getTMS(GlobalPara.getInstance().EcsCal_Unit_isWeight(itemC.getPlu().unit()) ? 208 : 196));
        }
        return this.Item_Set_Note(itemC, amount, price);
    }

    @Deprecated
    public void Total_RemoveItem(ItemContent itemC) {
        this.item.remove(itemC);
        this.Total_NoExtraDiscount();
    }

    public List<ItemContent> Total_RemoveItem(Integer ... indexes) {
        return indexes != null && indexes.length > 0 ? this.Total_RemoveItem(Arrays.asList(indexes)) : new ArrayList<ItemContent>();
    }

    public List<ItemContent> Total_RemoveItem(List<Integer> indexes) {
        ArrayList<ItemContent> item = new ArrayList<ItemContent>();
        if (indexes != null && !indexes.isEmpty()) {
            for (int index : indexes) {
                if (index >= this.item.size()) continue;
                item.add(this.item.get(index));
                this.item.set(index, null);
            }
            Iterator<ItemContent> iterator = this.item.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                iterator.remove();
            }
        }
        this.Total_NoExtraDiscount();
        return item;
    }

    public boolean Total_AddItem(ItemContent itemC) throws RuntimeMeterException {
        if (!itemC.AddValid()) {
            return false;
        }
        WeightCal.getInstance().update_UsedGross(itemC.getValid_UsedGross(), itemC.getPlu().no());
        this.item.add(itemC);
        this.Total_NoExtraDiscount();
        return true;
    }

    public TradeContent Total_AddItem(List<ItemContent> itemCs) {
        if (itemCs != null && !itemCs.isEmpty()) {
            for (ItemContent itemC : itemCs) {
                if (!itemC.AddValid()) continue;
                this.item.add(itemC);
            }
            this.Total_NoExtraDiscount();
        }
        return this;
    }

    public boolean VIP_LOGIN() {
        return this.pay_VIP_Level != '\u0000';
    }

    public void Total_VIP_Set(char level, int p1w) {
        this.pay_VIP_Level = level;
        this.pay_VIP_DiscountP1W = level == '\u0000' ? 10000 : p1w;
        this.Total_VIP_Calculate();
    }

    public TradeContent Total_VIP_Clear() {
        this.pay_VIP_Level = '\u0000';
        this.pay_VIP_DiscountP1W = 10000;
        this.Total_VIP_Calculate();
        return this;
    }

    private void Total_VIP_Calculate() {
        if (this.item.isEmpty()) {
            return;
        }
        for (ItemContent itemContent : this.item) {
            if (itemContent.isPriceIsManual() || itemContent.isFixedSingle()) continue;
            itemContent.setPrice(GlobalPara.getInstance().CalPLU_Price_wUnit(this.CalPLU_UPrice_VIPed(itemContent.getPlu()), itemContent.getPlu().getUnit()));
            itemContent.setUnit_price(GlobalPara.getInstance().CalPLU_PriceUnit_wUnit(itemContent.getPlu().getUnit()));
            itemContent.Item_ReCal(this);
        }
        this.Total_NoExtraDiscount();
    }

    private void Total_NoExtraDiscount() {
        this.Total_InfoCheck_O();
        this.Total_Set_Discount(this.purTax_Addup.add(this.purTax_ServiceFee));
        this.Total_InfoCheck_E();
    }

    public TradeContent Total_Close(int inputFID, int inputSID) {
        this.tradeTime = new Date();
        BigDecimal needcash = this.Total_Cal_LeftPay();
        if (this.pay_Cash.compareTo(needcash) >= 0) {
            this.change = this.pay_Cash.subtract(needcash);
        } else {
            this.pay_Cash = needcash;
            this.change = GlobalPara.getInstance().EcsCal_Rounding_Total(BigDecimal.ZERO);
        }
        this.isPrePrint = false;
        this.fid = inputFID;
        this.sid = inputSID;
        return this;
    }

    public TradeContent Total_Close(FID_SID fid_sid) {
        return this.Total_Close(fid_sid.getFid(), fid_sid.getSid());
    }

    public TradeContent Total_Close(int inputFID, int inputSID, String error) {
        this.tradeTime = new Date();
        this.isPrePrint = false;
        this.fid = inputFID;
        this.sid = inputSID;
        this.error_code = error;
        return this;
    }

    public TradeContent Total_Close(int inputFID, int inputSID, String error_code, String error_msg) {
        if (StringUtils.isNotBlank((CharSequence)error_msg)) {
            this.error_text1 = error_msg.length() > 1024 ? error_msg.substring(0, 1024) : error_msg;
        }
        return this.Total_Close(inputFID, inputSID, error_code);
    }

    public TradeContent Total_Close(FID_SID fid_sid, String error) {
        this.tradeTime = new Date();
        this.isPrePrint = false;
        this.fid = fid_sid.getFid();
        this.sid = fid_sid.getSid();
        this.error_code = error;
        return this;
    }

    private String Total_Log_Text(int spec, DPLUV5 plu) {
        if (spec <= 0) {
            return null;
        }
        if (spec == 1) {
            return plu.getName();
        }
        if (spec <= 8) {
            return plu.getText().text(Integer.valueOf(spec - 1));
        }
        if (spec == 9) {
            return plu.getItemCode().toString();
        }
        if (spec == 10) {
            return plu.getIndexBar();
        }
        if (spec <= 14) {
            return null;
        }
        if (spec == 15) {
            return this.pay_VIP_ID;
        }
        if (spec == 16) {
            return this.pay_VIP_ID_Plus1;
        }
        return null;
    }

    public TradeContent Total_Log(DLOGContent content) {
        if (content != null) {
            this.logContent = content;
            DLOGV1 dlogv1 = (DLOGV1)new DLOGV1().Server_UnPackage(this.logContent.getLog()).getObj();
            this.Total_TradeType_Set(dlogv1.getType());
            this.Total_Salesman_Set(dlogv1.getSaleMan(), "");
            if (dlogv1.getGoodsList() != null && !dlogv1.getGoodsList().isEmpty()) {
                for (Object o : dlogv1.getGoodsList()) {
                    DGoods goods = (DGoods)o;
                    DPLUV5 plu = new DPLUV5();
                    plu.setNo(goods.getNo());
                    plu.setName(goods.getName());
                    plu.setUnit(goods.getUnit());
                    plu.setUnitText(goods.getUnitText());
                    plu.setCategory(goods.getCategory());
                    plu.setPrice(new DPriceV2().setPrice(goods.getPrice()));
                    ItemContent itemContent = new ItemContent(plu, this);
                    itemContent.Item_Set_Good(goods);
                    this.Total_AddItem(itemContent);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)dlogv1.getErrMsg4())) {
                String[] split;
                for (String str : split = dlogv1.getErrMsg4().split("\t")) {
                    try {
                        if (!StringUtils.isNotBlank((CharSequence)str)) continue;
                        String[] ss = str.split(":");
                        this.putPosOnlyString(Integer.parseInt(ss[0]), ss[1]);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            if (Objects.nonNull(dlogv1.getJkyPay()) || Objects.nonNull(dlogv1.getJkyGiftPay())) {
                this.Total_Pay_JKY((Objects.nonNull(dlogv1.getJkyPay()) ? dlogv1.getJkyPay() : BigDecimal.ZERO).add(Objects.nonNull(dlogv1.getJkyGiftPay()) ? dlogv1.getJkyGiftPay() : BigDecimal.ZERO), Objects.nonNull(dlogv1.getJkyGiftPay()) ? dlogv1.getJkyGiftPay() : BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, "");
            }
            if (Objects.nonNull(dlogv1.getCardPay())) {
                this.Total_Pay_Card(dlogv1.getCardPay(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, "", "", "");
            }
            if (Objects.nonNull(dlogv1.getOtherPay1())) {
                this.Total_Pay_Other1(dlogv1.getOtherPay1());
            }
            if (Objects.nonNull(dlogv1.getOtherPay2())) {
                this.Total_Pay_Other2(dlogv1.getOtherPay2());
            }
            if (Objects.nonNull(dlogv1.getOtherPay3())) {
                this.Total_Pay_Other3(dlogv1.getOtherPay2());
            }
            if (Objects.nonNull(dlogv1.getCloudPay())) {
                this.Total_Pay_Cloud(dlogv1.getCloudPay(), dlogv1.getPayWay(), dlogv1.getPayType(), PayType.type((Integer)dlogv1.getType()).getDescription(), "");
            }
            if (Objects.nonNull(dlogv1.getCash())) {
                this.Total_Pay_Cash(dlogv1.getCash());
            }
            if (Objects.nonNull(dlogv1.getTradeVal())) {
                this.Total_Set_Discount(dlogv1.getTradeVal());
            }
            this.Total_Close(dlogv1.getFid(), dlogv1.getSid(), StringUtils.isNotBlank((CharSequence)dlogv1.getErrCode()) ? dlogv1.getErrCode() : "", StringUtils.isNotBlank((CharSequence)dlogv1.getErrMsg4()) ? dlogv1.getErrMsg4() : "");
            this.tradeTime = new Date(content.getTradeDate());
        }
        return this;
    }

    public TradeContent Total_Log() {
        if (this.logContent == null) {
            this.surplus_Reject = this.purTax_Final;
            Integer cloudPay = this.defaultNull(this.pay_Cloud_Way);
            BigDecimal jkp = this.defaultNull(this.pay_JKY_All);
            PayWay payway = Objects.nonNull(cloudPay) ? PayWay.Aggregate_PAY : (Objects.nonNull(jkp) ? PayWay.JK_PAY : PayWay.CASH_PAY);
            DLOGV1 dlogv1 = new DLOGV1().setFid(Integer.valueOf(this.fid)).setKind(Integer.valueOf(GlobalPara.getInstance().getDeviceType())).setTradeTime(this.tradeTime).setSid(Integer.valueOf(this.sid)).setTradeVal(this.purTax_Final).setType(Integer.valueOf(this.tradeType)).setSaleMan(Integer.valueOf(this.salesman_Number)).setRoundingDiscount(this.defaultNull(this.rounding)).setTax(this.defaultNull(this.tax_Discounted)).setCash(this.purTax_Final.subtract(this.pay_Card).subtract(this.pay_Other1).subtract(this.pay_Other2).subtract(this.pay_Other3).subtract(this.pay_JKY_All).subtract(this.pay_Cloud)).setCardPay(this.defaultNull(this.pay_Card)).setOtherPay1(this.defaultNull(this.pay_Other1)).setOtherPay2(this.defaultNull(this.pay_Other2)).setOtherPay3(this.defaultNull(this.pay_Other3)).setServiceCharge(this.defaultNull(this.purTax_ServiceFee)).setPayWay(payway.getType()).setPayType(this.defaultNull(this.pay_Cloud_Type)).setCloudPay(this.defaultNull(this.pay_Cloud)).setSource(this.source).setErrCode(this.error_code).setErrMsg1(this.error_text1).setJkyPay(this.defaultNullBigDecimalSubtract(this.pay_JKY_All, this.pay_JKY_Gift)).setJkyGiftPay(this.defaultNull(this.pay_JKY_Gift));
            if (this.posOnlyString != null && !this.posOnlyString.isEmpty()) {
                StringBuilder builder = new StringBuilder();
                for (Map.Entry<Integer, String> entry : this.posOnlyString.entrySet()) {
                    builder.append(entry.getKey()).append(":").append(entry.getValue()).append("\t");
                }
                dlogv1.setErrMsg4(builder.toString());
            }
            if (this.item != null && !this.item.isEmpty()) {
                for (int i = 0; i < this.item.size(); ++i) {
                    ItemContent itemContent = this.item.get(i);
                    DCategory category = GlobalPara.getInstance().GetCategory(itemContent.getPlu().getCategory());
                    Integer dept = Objects.nonNull(category) ? category.getDept() : null;
                    DGoods goods = new DGoods().setNo(itemContent.getPlu().getNo()).setUnit(Integer.valueOf(itemContent.getUnit_weight())).setName(itemContent.getPlu().getName()).setAmount(this.defaultNull(itemContent.getAmount())).setPrice(this.defaultNull(GlobalPara.getInstance().EcsCal_Unit_PriceConvertTo(itemContent.getPrice(), itemContent.getUnit_price(), itemContent.getUnit_weight()))).setItemTotal(this.defaultNull(itemContent.getSingleWtax())).setUnitText(itemContent.getPlu().getUnitText()).setAmountStock(this.defaultNull(itemContent.getAmount_Stock())).setUnitStock(this.defaultNull(itemContent.getUnit_Stock())).setTax(this.defaultNull(itemContent.getTax())).setCategory(itemContent.getPlu().getCategory()).setDept(dept).setText1(this.defaultNull(this.Total_Log_Text(GlobalPara.getInstance().getTMS(290), itemContent.getPlu()))).setText2(this.defaultNull(this.Total_Log_Text(GlobalPara.getInstance().getTMS(291), itemContent.getPlu()))).setText3(this.defaultNull(this.Total_Log_Text(GlobalPara.getInstance().getTMS(292), itemContent.getPlu()))).setText4(this.defaultNull(this.Total_Log_Text(GlobalPara.getInstance().getTMS(293), itemContent.getPlu()))).setPics(itemContent.pics());
                    if (itemContent.getPosOnlyString() != null && !itemContent.getPosOnlyString().isEmpty()) {
                        StringBuilder builder = new StringBuilder();
                        for (String value : itemContent.getPosOnlyString().values()) {
                            builder.append(value).append("\t");
                        }
                        goods.setText4(builder.toString());
                    }
                    dlogv1.addGoods(new DGoods[]{goods});
                }
            }
            this.logContent = new DLOGContent().setEdition(Version.VERSION03.getVersion()).setFid(dlogv1.getFid()).setSid(dlogv1.getSid()).setLog(dlogv1.Server_Package()).setLogType(dlogv1.getType()).setTradeDate(Long.valueOf(dlogv1.getTradeTime().getTime()));
        }
        return this;
    }

    public boolean network_ask() {
        int tms = GlobalPara.getInstance().getTMS(58);
        if (tms == 1 || tms == 3) {
            PublicExecuteAsk ask = new PublicExecuteAsk("REP");
            ask.add(new String[]{String.valueOf(this.fid)});
            return SocketCommunication.getInstance().tcp_server_ask(ask);
        }
        return false;
    }

    private BigDecimal defaultNullBigDecimalSubtract(BigDecimal b1, BigDecimal b2) {
        if (b1 == null) {
            return null;
        }
        if (b2 == null) {
            b2 = BigDecimal.ZERO;
        }
        return b1.subtract(b2);
    }

    private String defaultNull(String inStr) {
        return StringUtils.isNotBlank((CharSequence)inStr) ? inStr : null;
    }

    private BigDecimal defaultNull(BigDecimal bigDecimal) {
        return Objects.nonNull(bigDecimal) && !BigDecimalUtils.compareZeroValue((BigDecimal)bigDecimal) ? bigDecimal : null;
    }

    private Integer defaultNull(Integer integer) {
        return Objects.nonNull(integer) && integer != 0 ? integer : null;
    }

    public TradeContent Total_Pay_Cash(BigDecimal cash) {
        BigDecimal needcash = this.Total_Cal_LeftPay();
        if (cash.compareTo(needcash) >= 0) {
            this.pay_Cash = cash;
            this.change = this.pay_Cash.subtract(needcash);
        } else {
            this.pay_Cash = needcash;
            this.change = GlobalPara.getInstance().EcsCal_Rounding_Total(BigDecimal.ZERO);
        }
        return this;
    }

    public TradeContent Total_Pay_JKY(BigDecimal jky_all, BigDecimal jky_Gift, BigDecimal point, BigDecimal balance_Old, BigDecimal balance_new, String id) {
        this.pay_JKY_All = jky_all;
        this.pay_JKY_Gift = jky_Gift;
        this.pay_VIP_Point = point;
        this.pay_VIP_Balance_Old = balance_Old;
        this.pay_VIP_Balance_New = balance_new;
        this.pay_VIP_ID = id;
        this.pay_VIP_ID_Plus1 = "";
        this.pay_VIP_ID_Plus2 = "";
        return this;
    }

    public TradeContent Total_Pay_Card(BigDecimal pay, BigDecimal point, BigDecimal balance_Old, BigDecimal balance_new, String id, String id_p1, String id_p2) {
        this.pay_Card = pay;
        this.pay_VIP_Point = point;
        this.pay_VIP_Balance_Old = balance_Old;
        this.pay_VIP_Balance_New = balance_new;
        this.pay_VIP_ID = id;
        this.pay_VIP_ID_Plus1 = id_p1;
        this.pay_VIP_ID_Plus2 = id_p2;
        return this;
    }

    public TradeContent Total_Pay_Other1(BigDecimal pay) {
        this.pay_Other1 = pay;
        return this;
    }

    public TradeContent Total_Pay_Other2(BigDecimal pay) {
        this.pay_Other2 = pay;
        return this;
    }

    public TradeContent Total_Pay_Other3(BigDecimal pay) {
        this.pay_Other3 = pay;
        return this;
    }

    public TradeContent Total_Pay_Cloud(BigDecimal pay, Integer payWay, Integer payType, String typeName, String billID) {
        this.pay_Cloud = pay;
        this.pay_Cloud_Way = payWay;
        this.pay_Cloud_Type = payType;
        this.pay_Cloud_TypeName = typeName;
        this.pay_Cloud_Bill = billID;
        return this;
    }

    private void Total_InfoCheck_O() {
        if (this.total_ServiceFee_Type == 0 && GlobalPara.getInstance().getTMS(302) >= 4) {
            this.total_ServiceFee_Type = GlobalPara.getInstance().getTMS(302) - 3;
            this.total_ServiceFee_Rate = new BigDecimal(GlobalPara.getInstance().getTMS(303)).divide(new BigDecimal(10000));
        }
        this.tCount = BigDecimal.ZERO;
        this.tWeight = BigDecimal.ZERO.setScale(GlobalPara.getInstance().getPointOfWeight());
        this.tax_Addup = this.purTax_FromPLU = BigDecimal.ZERO;
        this.purTax_Addup = this.purTax_FromPLU;
        this.tUnitWeight = 0;
        this.purTax_ServiceFee = this.total_ServiceFee_Type == 1 ? this.total_ServiceFee_Rate : BigDecimal.ZERO;
        for (ItemContent itemContent : this.item) {
            if (GlobalPara.getInstance().EcsCal_Unit_isWeight(itemContent.getUnit_weight())) {
                if (this.tUnitWeight == 0) {
                    this.tWeight = itemContent.getAmount();
                    this.tUnitWeight = itemContent.getUnit_weight();
                    if (this.tUnitWeight < 2 || this.tUnitWeight > 9) {
                        this.tUnitWeight = GlobalPara.getInstance().getWeightUNIT();
                    }
                } else {
                    this.tWeight = GlobalPara.getInstance().EcsCal_Unit_WeightConvertTo(itemContent.getAmount(), itemContent.getUnit_weight(), this.tUnitWeight).add(this.tWeight);
                }
                this.tCount = this.tCount.add(BigDecimal.ONE);
            } else {
                this.tCount = this.tCount.add(itemContent.getAmount());
            }
            this.purTax_ServiceFee = this.purTax_ServiceFee.add(itemContent.getServiceFee());
            this.tax_Addup = this.tax_Addup.add(itemContent.getTax());
            this.purTax_Addup = this.purTax_Addup.add(itemContent.getSingleWtax());
            this.purTax_FromPLU = itemContent.getSingleWtax_Original().compareTo(BigDecimal.ZERO) == 0 ? this.purTax_FromPLU.add(itemContent.getSingleWtax()) : this.purTax_FromPLU.add(itemContent.getSingleWtax_Original());
            if (this.total_ServiceFee_Type != 2 || itemContent.getServiceFee().compareTo(BigDecimal.ZERO) != 0 && GlobalPara.getInstance().getTMS(301) != 2) continue;
            BigDecimal perbase = GlobalPara.getInstance().getTMS(304) == 0 ? itemContent.getSingleNtax() : itemContent.getSingleWtax();
            this.purTax_ServiceFee = this.purTax_ServiceFee.add(GlobalPara.getInstance().EcsCal_Rounding_Single(perbase.multiply(this.total_ServiceFee_Rate)));
        }
        if (this.unit_Weight == 0) {
            this.unit_Weight = this.tUnitWeight;
        }
        BigDecimal serviceFeeRate_TaxRate = new BigDecimal(GlobalPara.getInstance().getTMS(306)).divide(new BigDecimal(10000));
        if (GlobalPara.getInstance().getTMS(305) == 1) {
            this.tax_ServiceFee = this.purTax_ServiceFee.multiply(serviceFeeRate_TaxRate);
            this.purTax_ServiceFee = this.purTax_ServiceFee.add(this.tax_ServiceFee);
        } else {
            this.tax_ServiceFee = GlobalPara.getInstance().getTMS(305) == 2 ? this.purTax_ServiceFee.multiply(serviceFeeRate_TaxRate).divide(serviceFeeRate_TaxRate.add(BigDecimal.ONE), 7, 4) : (GlobalPara.getInstance().getTMS(305) == 3 ? this.purTax_ServiceFee.multiply(serviceFeeRate_TaxRate) : BigDecimal.ZERO);
        }
    }

    public TradeContent Total_Set_Discount(BigDecimal total) {
        this.purTax_Discounted = total;
        this.Total_InfoCheck_E();
        return this;
    }

    public BigDecimal Total_Set_Discount(int discount) {
        return GlobalPara.getInstance().EcsCal_Rounding_Total(this.purTax_Final.multiply(BigDecimal.valueOf(discount)).divide(BigDecimal.valueOf(10000L)));
    }

    public BigDecimal Total_Get_Discount_U0L1(int U0L1) {
        BigDecimal ct = BigDecimal.ZERO;
        for (ItemContent itemContent : this.item) {
            BigDecimal itemLimit;
            BigDecimal bigDecimal = itemLimit = U0L1 == 0 ? itemContent.getPrice_UpperLimit() : itemContent.getPrice_LowerLimit();
            if (itemLimit.compareTo(BigDecimal.ZERO) == 0) {
                return BigDecimal.ZERO;
            }
            BigDecimal purTax = GlobalPara.getInstance().EcsCal_Unit_ValueConvert(itemLimit.multiply(itemContent.getAmount()), itemContent.getUnit_weight(), itemContent.getUnit_price());
            if (itemContent.getTaxType() == 1) {
                BigDecimal tax = purTax.multiply(itemContent.getTaxRate());
                purTax = purTax.add(tax);
            }
            ct = ct.add(purTax);
        }
        return ct;
    }

    public boolean Total_Check_Discount() {
        if (this.item.size() == 0) {
            return false;
        }
        return (GlobalPara.getInstance().getTMS(110) & 2) == 0;
    }

    public boolean Total_Check_Discount(BigDecimal total) {
        if (!this.Total_Check_Discount()) {
            return false;
        }
        BigDecimal limit = this.Total_Get_Discount_U0L1(0);
        if (limit.compareTo(BigDecimal.ZERO) != 0 && total.compareTo(limit) > 0) {
            return false;
        }
        limit = this.Total_Get_Discount_U0L1(1);
        return limit.compareTo(BigDecimal.ZERO) == 0 || total.compareTo(limit) >= 0;
    }

    private void Total_InfoCheck_E() {
        this.purTax_Final = GlobalPara.getInstance().EcsCal_Rounding_Total(this.purTax_Discounted);
        this.rounding = this.purTax_Final.subtract(this.purTax_Discounted);
    }

    public BigDecimal Total_Cal_LeftPay(BigDecimal pay_Available) {
        return this.purTax_Final.subtract(this.pay_Card).subtract(this.pay_Other1).subtract(this.pay_Other2).subtract(this.pay_Other3).subtract(this.pay_JKY_All).subtract(this.pay_Cloud).subtract(pay_Available);
    }

    public BigDecimal Total_Cal_LeftPay() {
        return this.Total_Cal_LeftPay(BigDecimal.ZERO);
    }

    public boolean printCalculate_HasItem(int[][] items, int start) {
        while (start < items.length && items[start][1] != 5) {
            if (items[start][1] == 1 && items[start][2] == 0) {
                return true;
            }
            ++start;
        }
        return false;
    }

    public TradeContent printCalculate(int tms, Integer val) {
        PrintContent printContent2;
        if (this.printContents == null) {
            this.printContents = new ArrayList<PrintContent>();
        }
        this.printContents.clear();
        PrintContent printContent1 = this.printCalculate_BillType(1, tms, val);
        if (printContent1.exist()) {
            this.printContents.add(printContent1);
        }
        if ((printContent2 = this.printCalculate_BillType(2, tms, val)).exist()) {
            this.printContents.add(printContent2);
        }
        return this;
    }

    public TradeContent printCalculate() {
        return this.printCalculate(56, null);
    }

    public TradeContent print(IPrintBack printBack) throws MeterException {
        TradeContent tradeContent = this.printCalculate();
        PrintGeneralFactory.getInstance().print_answer(tradeContent.getPrintContents(), printBack);
        return tradeContent;
    }

    public TradeContent rePrintCalculate() {
        return this.printCalculate(65, null);
    }

    public TradeContent rePrintCalculate(IPrintBack printBack) throws MeterException {
        TradeContent tradeContent = this.rePrintCalculate();
        PrintGeneralFactory.getInstance().print_answer(tradeContent.getPrintContents(), printBack);
        return tradeContent;
    }

    private int printCalculate_getOffset_X(int width, int height, int dir) {
        if (dir == 0) {
            return width;
        }
        if (dir == 1) {
            return -height;
        }
        if (dir == 2) {
            return -width;
        }
        if (dir == 3) {
            return height;
        }
        return 0;
    }

    private int printCalculate_getOffset_Y(int width, int height, int dir) {
        if (dir == 0) {
            return height;
        }
        if (dir == 1) {
            return width;
        }
        if (dir == 2) {
            return -height;
        }
        if (dir == 3) {
            return -width;
        }
        return 0;
    }

    public static String printCalculate_MapInfo(int angle, int addition, int grid, int font, int sx, int sy, int lx, int ly) {
        return TradeContent.printCalculate_getX2(angle) + TradeContent.printCalculate_getX2(addition) + TradeContent.printCalculate_getX2(grid) + TradeContent.printCalculate_getX2(font) + TradeContent.printCalculate_getX4(sx) + TradeContent.printCalculate_getX4(sy) + TradeContent.printCalculate_getX4(lx) + TradeContent.printCalculate_getX4(ly);
    }

    private PrintContent printCalculate_BillType(int billType, int tms, Integer val) {
        int reverse;
        int barcode_Flag;
        int barcode;
        int label;
        int fucPrint;
        boolean isSingle;
        int pcs = 0;
        int width = 48;
        String result = "";
        int version = 0;
        if (GlobalPara.getInstance().getTMS(269) == 1) {
            return new PrintContent("", 48, 0);
        }
        int puse = GlobalPara.getInstance().getTMS(54) % 10;
        boolean bl = isSingle = this.item.size() == 1;
        if (billType != 2) {
            billType = 1;
        }
        if (Objects.nonNull(val)) {
            fucPrint = val;
            if (fucPrint == 1) {
                pcs = billType == 1 ? 1 : 0;
            } else if (fucPrint == 2) {
                pcs = billType == 2 ? 1 : 0;
            } else if (fucPrint == 4) {
                pcs = 0;
            } else if (fucPrint == 5) {
                pcs = GlobalPara.getInstance().getTMS(21) != 0 ? (billType == 1 ? 1 : 0) : (billType == 2 ? 1 : 0);
            } else if (fucPrint == 6) {
                pcs = GlobalPara.getInstance().getTMS(21) != 0 ? (billType == 2 ? 1 : 0) : (billType == 1 ? 1 : 0);
            } else {
                if (fucPrint == 7 || fucPrint == 8) {
                    isSingle = false;
                }
                pcs = isSingle ? (billType == 1 ? GlobalPara.getInstance().getTMS(3) : GlobalPara.getInstance().getTMS(13)) : (billType == 1 ? GlobalPara.getInstance().getTMS(8) : GlobalPara.getInstance().getTMS(18));
            }
        } else if (tms == 56) {
            fucPrint = GlobalPara.getInstance().getTMS(tms);
            if (fucPrint == 1) {
                pcs = billType == 1 ? 1 : 0;
            } else if (fucPrint == 2) {
                pcs = billType == 2 ? 1 : 0;
            } else if (fucPrint == 4) {
                pcs = 0;
            } else if (fucPrint == 5) {
                pcs = GlobalPara.getInstance().getTMS(21) != 0 ? (billType == 1 ? 1 : 0) : (billType == 2 ? 1 : 0);
            } else if (fucPrint == 6) {
                pcs = GlobalPara.getInstance().getTMS(21) != 0 ? (billType == 2 ? 1 : 0) : (billType == 1 ? 1 : 0);
            } else {
                if (fucPrint == 7 || fucPrint == 8) {
                    isSingle = false;
                }
                pcs = isSingle ? (billType == 1 ? GlobalPara.getInstance().getTMS(3) : GlobalPara.getInstance().getTMS(13)) : (billType == 1 ? GlobalPara.getInstance().getTMS(8) : GlobalPara.getInstance().getTMS(18));
            }
        } else if (tms == 65) {
            fucPrint = GlobalPara.getInstance().getTMS(tms);
            if (fucPrint == 0) {
                pcs = 0;
            } else if (fucPrint == 1) {
                pcs = billType == 1 ? 1 : 0;
            } else if (fucPrint == 2) {
                pcs = billType == 2 ? 1 : 0;
            } else if (fucPrint == 5) {
                pcs = GlobalPara.getInstance().getTMS(21) != 0 ? (billType == 1 ? 1 : 0) : (billType == 2 ? 1 : 0);
            } else if (fucPrint == 6) {
                pcs = GlobalPara.getInstance().getTMS(21) != 0 ? (billType == 2 ? 1 : 0) : (billType == 1 ? 1 : 0);
            } else {
                if (fucPrint == 7) {
                    isSingle = false;
                }
                pcs = isSingle ? (billType == 1 ? GlobalPara.getInstance().getTMS(3) : GlobalPara.getInstance().getTMS(13)) : (billType == 1 ? GlobalPara.getInstance().getTMS(8) : GlobalPara.getInstance().getTMS(18));
            }
        }
        if (pcs == 0) {
            return new PrintContent("", 48, 0);
        }
        if (isSingle) {
            if (billType == 1) {
                label = GlobalPara.getInstance().getTMS(0);
                barcode = GlobalPara.getInstance().getTMS(1);
                barcode_Flag = GlobalPara.getInstance().getTMS(2);
                reverse = GlobalPara.getInstance().getTMS(4);
            } else {
                label = GlobalPara.getInstance().getTMS(10);
                barcode = GlobalPara.getInstance().getTMS(11);
                barcode_Flag = GlobalPara.getInstance().getTMS(12);
                reverse = GlobalPara.getInstance().getTMS(14);
            }
            try {
                int tv;
                DCategory dCategory;
                if (puse == 0) {
                    int tv2 = billType == 1 ? this.item.get(0).getPlu().getPrint().getType1().intValue() : this.item.get(0).getPlu().getPrint().getType2().intValue();
                    if (tv2 != 0) {
                        label = tv2;
                    }
                } else if (puse == 2 && (dCategory = GlobalPara.getInstance().GetCategory(this.item.get(0).getPlu().getCategory())) != null && (tv = billType == 1 ? dCategory.getPrint().getType1().intValue() : dCategory.getPrint().getType2().intValue()) != 0) {
                    label = tv;
                }
            }
            catch (Exception dCategory) {}
        } else if (billType == 1) {
            label = GlobalPara.getInstance().getTMS(5);
            barcode = GlobalPara.getInstance().getTMS(6);
            barcode_Flag = GlobalPara.getInstance().getTMS(7);
            reverse = GlobalPara.getInstance().getTMS(9);
        } else {
            label = GlobalPara.getInstance().getTMS(15);
            barcode = GlobalPara.getInstance().getTMS(16);
            barcode_Flag = GlobalPara.getInstance().getTMS(17);
            reverse = GlobalPara.getInstance().getTMS(19);
        }
        if (label == 0) {
            return new PrintContent("", 48, 0);
        }
        try {
            int labelwidthMM;
            String format = GlobalPara.getInstance().GetLabelFormat(label).getPf();
            String[] subs = format.split("\\|");
            String textInBase64 = new String(GlobalPara.getInstance().getEncryptDecrypt().decode(subs[1]));
            String[] texts = textInBase64.split("\t");
            String[] infos = subs[0].split(",");
            int sort = TradeContent.tryParseInt(infos[0]);
            version = TradeContent.tryParseInt(infos[1]);
            int labelwidth = TradeContent.tryParseInt(infos[2]);
            width = labelwidthMM = labelwidth / 8;
            int labelheigth = TradeContent.tryParseInt(infos[3]);
            boolean can04 = false;
            int subY = 0;
            int itemsize = subs.length - 1;
            int[][] items = new int[itemsize][12];
            for (int loop = 0; loop < itemsize - 1; ++loop) {
                String[] itemParts = subs[loop + 2].split(",");
                if (itemParts.length >= 12) {
                    int pos = reverse != 0 ? itemsize - 2 - loop : loop;
                    items[pos][0] = TradeContent.tryParseInt(itemParts[0]);
                    items[pos][1] = TradeContent.tryParseInt(itemParts[1]);
                    items[pos][2] = TradeContent.tryParseInt(itemParts[2]);
                    items[pos][3] = TradeContent.tryParseInt(itemParts[3]);
                    items[pos][4] = TradeContent.tryParseInt(itemParts[4]);
                    items[pos][5] = TradeContent.tryParseInt(itemParts[5]);
                    items[pos][6] = TradeContent.tryParseInt(itemParts[6]);
                    items[pos][7] = TradeContent.tryParseInt(itemParts[7]);
                    items[pos][8] = TradeContent.tryParseInt(itemParts[8]);
                    items[pos][9] = TradeContent.tryParseInt(itemParts[9]);
                    items[pos][10] = TradeContent.tryParseInt(itemParts[10]);
                    items[pos][11] = TradeContent.tryParseInt(itemParts[11]);
                    if (reverse == 0) continue;
                    items[pos][8] = labelwidth - 1 - items[pos][8];
                    items[pos][9] = labelheigth - 1 - items[pos][9];
                    int[] nArray = items[pos];
                    nArray[5] = nArray[5] ^ 2;
                    int gridPrint = items[pos][6];
                    if (gridPrint == 64) {
                        gridPrint = 128;
                    } else if (gridPrint == 128) {
                        gridPrint = 64;
                    }
                    items[pos][6] = items[pos][6] & 0x3F | gridPrint;
                    continue;
                }
                new PrintContent("", 48, 0);
            }
            items[itemsize - 1][0] = 100;
            items[itemsize - 1][1] = 5;
            items[itemsize - 1][2] = 1;
            items[itemsize - 1][3] = 0;
            items[itemsize - 1][4] = 1;
            items[itemsize - 1][5] = 0;
            items[itemsize - 1][6] = 0;
            items[itemsize - 1][7] = 0;
            items[itemsize - 1][8] = 0;
            items[itemsize - 1][9] = labelheigth;
            items[itemsize - 1][10] = 0;
            items[itemsize - 1][11] = 0;
            result = "03" + TradeContent.printCalculate_getX2(labelwidthMM);
            int ctPos = 0;
            int cyclePos = -1;
            int x_Init = this.printCalculate_HasItem(items, 0) ? 1 : 0;
            boolean[] condition = this.printCalculate_GetCondition(0);
            while (true) {
                if (ctPos >= itemsize) {
                    result = result + "08";
                    break;
                }
                int[] itemValue = items[ctPos];
                if (itemValue[1] == 5) {
                    if (can04) {
                        result = result + "04";
                        can04 = false;
                    }
                    if (itemValue[2] == 1) {
                        result = result + "06";
                    }
                    if (itemValue[3] > 0) {
                        result = result + "05" + TradeContent.printCalculate_getX4(itemValue[3]);
                    }
                    subY = itemValue[9];
                    if (itemValue[2] == 0 || ctPos == itemsize - 1) {
                        if (x_Init > 0 && ++x_Init <= this.item.size()) {
                            condition = this.printCalculate_GetCondition(x_Init - 1);
                            ctPos = cyclePos;
                            subY = ctPos < 0 ? 0 : items[ctPos][9];
                        } else {
                            x_Init = this.printCalculate_HasItem(items, ctPos + 1) ? 1 : 0;
                            cyclePos = ctPos;
                            condition = this.printCalculate_GetCondition(0);
                        }
                    }
                } else {
                    int pos1 = itemValue[9];
                    int pos2 = itemValue[9] + this.printCalculate_getOffset_Y(itemValue[10], itemValue[11], itemValue[5]);
                    if ((itemValue[6] & 0x80) != 0) {
                        if (can04) {
                            result = result + "04";
                            can04 = false;
                        }
                        subY = Math.min(pos1, pos2);
                    }
                    if (itemValue[4] < condition.length && condition[itemValue[4]]) {
                        String cttext;
                        int Addition = 0;
                        if (GlobalPara.getInstance().getTMS(35) > 0) {
                            Addition = 32;
                        } else if ((itemValue[6] & 0x20) != 0) {
                            Addition = 32;
                        }
                        String mapInfo = TradeContent.printCalculate_MapInfo(itemValue[5], Addition, itemValue[6] & 0xF, itemValue[7], itemValue[8], itemValue[9] - subY, itemValue[10], itemValue[11]);
                        String out = "";
                        if (itemValue[1] == 2) {
                            out = this.printCalculate_Sale(mapInfo, itemValue[2], itemValue[3]);
                        } else if (itemValue[1] == 1) {
                            out = this.printCalculate_Item(mapInfo, itemValue[2], itemValue[3], x_Init > 0 ? x_Init - 1 : 0);
                        } else if (itemValue[1] == 0) {
                            int ctbar = itemValue[3];
                            if (ctbar == 0) {
                                if (x_Init > 0) {
                                    int buse = GlobalPara.getInstance().getTMS(54) / 10 % 10;
                                    if (buse == 1) {
                                        ctbar = barcode;
                                    } else if (buse == 2) {
                                        DCategory dCategory = GlobalPara.getInstance().GetCategory(this.item.get(x_Init - 1).getPlu().getCategory());
                                        ctbar = dCategory != null ? (billType == 1 ? dCategory.getPrint().getBarcode1().intValue() : dCategory.getPrint().getBarcode2().intValue()) : barcode;
                                    } else {
                                        try {
                                            ctbar = billType == 1 ? this.item.get(x_Init - 1).getPlu().getPrint().getBarcode1().intValue() : this.item.get(x_Init - 1).getPlu().getPrint().getBarcode2().intValue();
                                        }
                                        catch (Exception exp) {
                                            ctbar = 0;
                                        }
                                    }
                                    if (ctbar == 0) {
                                        ctbar = barcode;
                                    }
                                } else {
                                    ctbar = barcode;
                                }
                            }
                            try {
                                DBarcodeFormat barFormat = GlobalPara.getInstance().GetBarcode(ctbar);
                                PrintCalculate_BarcodeCal bcc = new PrintCalculate_BarcodeCal();
                                int bformat = barFormat.getFormat();
                                int bcheck = barFormat.getCheck();
                                int[] exBytes = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
                                exBytes[0] = bformat;
                                if (bformat == 11) {
                                    if ((bcheck & 0x80) == 0) {
                                        exBytes[1] = 1;
                                    } else {
                                        exBytes[1] = bcheck >> 2 & 0xF;
                                        exBytes[2] = bcheck >> 8 & 0x1F;
                                        exBytes[3] = bcheck >> 13 & 7;
                                    }
                                } else if (bformat == 8) {
                                    if ((bcheck & 0x80) == 0) {
                                        exBytes[1] = 9;
                                    } else {
                                        exBytes[1] = (byte)(bcheck >> 2 & 0xF);
                                        exBytes[2] = (byte)(bcheck >> 8 & 0x1F);
                                        exBytes[3] = (byte)(bcheck >> 16 & 0x7F);
                                        exBytes[4] = (byte)(bcheck >> 24 & 7);
                                        exBytes[5] = (byte)(bcheck >> 27 & 7);
                                    }
                                } else if ((bcheck & 0x80) != 0) {
                                    exBytes[1] = bcheck >> 2 & 0x1F;
                                    if (exBytes[1] == 31) {
                                        exBytes[1] = 255;
                                    }
                                    exBytes[2] = bcheck >> 9 & 7;
                                    exBytes[3] = bcheck >> 12 & 0xF;
                                    exBytes[4] = bcheck & 3;
                                    exBytes[5] = bcheck >> 16 & 3;
                                    exBytes[6] = bcheck >> 18 & 0x1F;
                                    exBytes[7] = bcheck >> 23 & 0x1F;
                                }
                                String barcodeType = TradeContent.printCalculate_getX2(exBytes[0]) + TradeContent.printCalculate_getX2(exBytes[1]) + TradeContent.printCalculate_getX2(exBytes[2]) + TradeContent.printCalculate_getX2(exBytes[3]) + TradeContent.printCalculate_getX2(exBytes[4]) + TradeContent.printCalculate_getX2(exBytes[5]) + TradeContent.printCalculate_getX2(exBytes[6]) + TradeContent.printCalculate_getX2(exBytes[7]);
                                out = TradeContent.printCalculate_DrawBarcode(mapInfo, barcodeType, bcc.GetContent(barFormat.getDis().getBytes(), barcode_Flag, x_Init, billType, this));
                            }
                            catch (Exception exp) {
                                out = "";
                            }
                        } else if (itemValue[1] == 3) {
                            String cttext2 = "";
                            if (itemValue[2] >= 0 && itemValue[2] < texts.length) {
                                cttext2 = texts[itemValue[2]];
                            }
                            out = TradeContent.printCalculate_CommandText(mapInfo, cttext2);
                        } else if (itemValue[1] == 4) {
                            out = "0A" + mapInfo.substring(0, 2) + "00" + TradeContent.printCalculate_getX2(itemValue[2]) + mapInfo.substring(8);
                        } else if (itemValue[1] == 6) {
                            out = TradeContent.printCalculate_Bitmap(mapInfo, itemValue[2]);
                        } else if (itemValue[1] == 7) {
                            Object ob = TradeSpecial.printCalculte_Special(this, itemValue, mapInfo, x_Init, subY, labelwidth);
                            if (ob != null) {
                                if (ob instanceof String) {
                                    out = (String)ob;
                                } else if (ob instanceof TradeSpOut) {
                                    out = ((TradeSpOut)ob).getOut();
                                    subY = ((TradeSpOut)ob).getSubY();
                                }
                            }
                        } else if (itemValue[1] == 8) {
                            ItemContent itemC = this.item.get(itemValue[2] == 0 ? (x_Init > 0 ? x_Init - 1 : 0) : itemValue[2] - 1);
                            cttext = itemC.getPosOnlyString(itemValue[3]);
                            if (cttext != null && cttext.length() > 0) {
                                out = TradeContent.printCalculate_CommandText(mapInfo, cttext);
                            }
                        } else if (itemValue[1] == 9) {
                            Integer value = itemValue[2];
                            cttext = this.getPosOnlyString(value);
                            if (cttext != null && cttext.length() > 0) {
                                out = TradeContent.printCalculate_CommandText(mapInfo, cttext);
                            }
                        } else {
                            out = "";
                        }
                        if (out.length() > 0) {
                            result = result + out;
                            can04 = true;
                        }
                    }
                    if ((itemValue[6] & 0x40) != 0) {
                        if (can04) {
                            result = result + "04";
                            can04 = false;
                        }
                        subY = Math.max(pos1, pos2);
                    }
                }
                ++ctPos;
            }
        }
        catch (Exception exp) {
            width = 48;
            result = "";
            pcs = 0;
        }
        return new PrintContent(result, width, pcs);
    }

    private boolean[] printCalculate_GetCondition(int itemPos) {
        Integer sdt;
        ItemContent itemC = this.item.get(itemPos);
        boolean[] condition = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        condition[1] = true;
        if (this.tradeType <= 1) {
            if (this.pay_Card.compareTo(BigDecimal.ZERO) != 0) {
                condition[15] = true;
            }
            if (this.pay_Cash.compareTo(BigDecimal.ZERO) != 0) {
                condition[14] = true;
            }
            if (this.pay_Other1.compareTo(BigDecimal.ZERO) != 0) {
                condition[17] = true;
            }
            if (this.pay_Other2.compareTo(BigDecimal.ZERO) != 0) {
                condition[18] = true;
            }
            if (this.pay_Other3.compareTo(BigDecimal.ZERO) != 0) {
                condition[19] = true;
            }
            if (this.pay_Cloud.compareTo(BigDecimal.ZERO) != 0) {
                condition[32] = true;
            }
            if (this.pay_JKY_All.compareTo(BigDecimal.ZERO) != 0) {
                condition[35] = true;
            }
            if (this.pay_VIP_ID != null && !this.pay_VIP_ID.isEmpty()) {
                condition[31] = true;
            }
            if (this.pay_VIP_Point.compareTo(BigDecimal.ZERO) != 0) {
                condition[20] = true;
            } else {
                condition[29] = true;
            }
            if (this.pay_JKY_All.compareTo(BigDecimal.ZERO) != 0 || this.pay_Card.compareTo(BigDecimal.ZERO) != 0) {
                condition[36] = true;
            }
            if (this.purTax_Final.compareTo(this.purTax_Addup.add(this.purTax_ServiceFee)) != 0) {
                condition[16] = true;
            }
            if (this.purTax_Addup.compareTo(this.purTax_FromPLU) != 0) {
                condition[34] = true;
            }
        }
        condition[21] = !this.isRePrint && !this.isPrePrint;
        condition[22] = this.isRePrint;
        condition[23] = this.isPrePrint;
        if (itemC.getTaxRate().compareTo(BigDecimal.ZERO) == 0) {
            condition[28] = true;
        } else {
            condition[13] = true;
        }
        if (GlobalPara.getInstance().EcsCal_Unit_isWeight(itemC.getUnit_weight())) {
            condition[2] = true;
            condition[10] = true;
            if (itemC.getTare().compareTo(BigDecimal.ZERO) > 0) {
                condition[5] = true;
                if (itemC.getTare().compareTo(itemC.getPreTare()) != 0 && itemC.getPreTare().compareTo(itemC.getTare()) == 0) {
                    condition[33] = true;
                } else {
                    condition[30] = true;
                }
            } else {
                condition[26] = true;
            }
        } else {
            condition[3] = true;
            condition[26] = true;
            if (itemC.getAmount().compareTo(BigDecimal.ONE) == 0) {
                condition[24] = true;
            } else {
                condition[10] = true;
            }
        }
        if (itemC.getPrice().compareTo(BigDecimal.ZERO) == 0) {
            condition[6] = true;
        } else {
            condition[27] = true;
        }
        if (itemC.getPlu().getNo() == 9999999 || itemC.getPlu().getNo() == 9999998) {
            condition[4] = true;
        } else {
            condition[25] = true;
        }
        if (itemC.getPlu().time().saleDatePS() != 0) {
            condition[7] = true;
        }
        if (itemC.getPlu().time().packDatePS() != 0) {
            condition[8] = true;
        }
        if (itemC.getPlu().time().useDatePS() != 0) {
            condition[9] = true;
        }
        if ((sdt = Integer.valueOf(GlobalPara.getInstance().getTMS(105) & 3)) == 3) {
            condition[9] = false;
        } else if (sdt != 0) {
            condition[9] = true;
        }
        if (itemC.getServiceFee().compareTo(BigDecimal.ZERO) != 0) {
            condition[11] = true;
        }
        if (this.purTax_ServiceFee.compareTo(BigDecimal.ZERO) != 0) {
            condition[12] = true;
        }
        return condition;
    }

    private String printCalculate_DrawFont_AddDeletedLine(String mapInfo) {
        if (mapInfo.length() != 24) {
            return "";
        }
        try {
            Integer addition = Integer.parseInt(mapInfo.substring(2, 4), 16);
            addition = addition | 0x40;
            String ka = Integer.toHexString(addition);
            return mapInfo.substring(0, 2) + ka + mapInfo.substring(4);
        }
        catch (Exception e) {
            return "";
        }
    }

    private String printCalculate_Item(String mapInfo, int Flag1, int Flag2, int itemPos) {
        try {
            ItemContent itemC = this.item.get(Flag1 == 0 ? itemPos : Flag1 - 1);
            String result = "";
            if (Flag2 == 0) {
                String name = itemC.getPlu().getName();
                if (this.tradeType != TradeType.\u9500\u552e.getType() && this.tradeType != TradeType.\u81ea\u52a8\u6a21\u5f0f.getType()) {
                    name = this.tradeTypeName + ":" + name;
                }
                return TradeContent.printCalculate_CommandText(mapInfo, name);
            }
            if (Flag2 == 1) {
                result = GlobalPara.getInstance().GetStringTMS(itemC.getAmount());
                if (GlobalPara.getInstance().getTMS(185) != 0) {
                    result = result + GlobalPara.getInstance().EcsCal_Unit_LoadName(itemC.getUnit_weight(), itemC.getUnitName());
                }
                return TradeContent.printCalculate_CommandText(mapInfo, result);
            }
            if (Flag2 == 2) {
                if (GlobalPara.getInstance().EcsCal_Unit_isWeight(itemC.getUnit_weight())) {
                    result = GlobalPara.getInstance().GetStringTMS(itemC.getTare());
                    if (GlobalPara.getInstance().getTMS(185) != 0) {
                        result = result + GlobalPara.getInstance().EcsCal_Unit_LoadName(itemC.getUnit_weight(), itemC.getUnitName());
                    }
                    return TradeContent.printCalculate_CommandText(mapInfo, result);
                }
            } else if (Flag2 == 3) {
                if (itemC.getPrice_Original().compareTo(new BigDecimal(0)) > 0 && itemC.getPrice_Original().compareTo(itemC.getPrice()) != 0) {
                    if (GlobalPara.getInstance().getTMS(186) != 0) {
                        result = GlobalPara.getInstance().getMoneyPrefix();
                    }
                    result = result + GlobalPara.getInstance().GetStringTMS(itemC.getPrice_Original());
                    if (GlobalPara.getInstance().getTMS(186) != 0) {
                        result = result + GlobalPara.getInstance().getMoneySuffix() + "/" + GlobalPara.getInstance().EcsCal_Unit_LoadName(itemC.getUnit_price(), itemC.getUnitName());
                    }
                    return TradeContent.printCalculate_CommandText(mapInfo, result);
                }
            } else {
                if (Flag2 == 4) {
                    if (GlobalPara.getInstance().getTMS(186) != 0) {
                        result = GlobalPara.getInstance().getMoneyPrefix();
                    }
                    result = result + GlobalPara.getInstance().GetStringTMS(itemC.getPrice());
                    if (GlobalPara.getInstance().getTMS(186) != 0) {
                        result = result + GlobalPara.getInstance().getMoneySuffix() + "/" + GlobalPara.getInstance().EcsCal_Unit_LoadName(itemC.getUnit_price(), itemC.getUnitName());
                    }
                    return TradeContent.printCalculate_CommandText(mapInfo, result);
                }
                if (Flag2 == 5) {
                    if (GlobalPara.getInstance().getTMS(187) != 0) {
                        result = GlobalPara.getInstance().getMoneyPrefix();
                    }
                    result = result + GlobalPara.getInstance().GetStringTMS(itemC.getSingleWtax());
                    if (GlobalPara.getInstance().getTMS(187) != 0) {
                        result = result + GlobalPara.getInstance().getMoneySuffix();
                    }
                    return TradeContent.printCalculate_CommandText(mapInfo, result);
                }
                if (Flag2 == 6) {
                    return TradeContent.printCalculate_CommandText(mapInfo, Integer.toString(itemC.getPlu().getNo()));
                }
                if (Flag2 == 7) {
                    return TradeContent.printCalculate_CommandText(mapInfo, Integer.toString(itemC.getPlu().getCategory()));
                }
                if (Flag2 == 8) {
                    return TradeContent.printCalculate_CommandText(mapInfo, Integer.toString(itemC.getPlu().getCategory()));
                }
                if (Flag2 == 9) {
                    return TradeContent.printCalculate_CommandText(mapInfo, itemC.getPlu().getIndexBar());
                }
                if (Flag2 == 10) {
                    return TradeContent.printCalculate_CommandText(mapInfo, Integer.toString(itemC.getPlu().getItemCode()));
                }
                if (Flag2 == 11) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(this.tradeTime);
                    DTimeV2 dTime = itemC.getPlu().time();
                    if (dTime.saleDatePS() != 3) {
                        calendar.add(5, dTime.saleDatePS() == 2 ? -dTime.saleDatePC().intValue() : dTime.saleDatePC());
                    } else {
                        Integer minute = dTime.saleDatePC() * 24 * 60 + dTime.saleTimePC() / 100 * 60 + dTime.saleTimePC() % 100;
                        calendar.add(12, dTime.saleDatePS() == 2 ? -minute.intValue() : minute);
                    }
                    return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().EcsCal_PrintDate(calendar));
                }
                if (Flag2 == 12) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(this.tradeTime);
                    DTimeV2 dTime = itemC.getPlu().time();
                    if (dTime.saleTimePS() == 1) {
                        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), dTime.saleTimePC() / 100 % 24, dTime.saleTimePC() % 100 % 60);
                    } else if (dTime.saleTimePS() != 2) {
                        if (dTime.saleTimePS() == 3) {
                            Integer minute = dTime.saleDatePC() * 24 * 60 + dTime.saleTimePC() / 100 * 60 + dTime.saleTimePC() % 100;
                            calendar.add(12, dTime.saleDatePS() == 2 ? -minute.intValue() : minute);
                        } else {
                            return "";
                        }
                    }
                    return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().EcsCal_PrintTime(calendar));
                }
                if (Flag2 == 13) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(this.tradeTime);
                    DTimeV2 dTime = itemC.getPlu().time();
                    if (dTime.packTimePS() != 3) {
                        calendar.add(5, dTime.packDatePS() == 2 ? -dTime.packDatePC().intValue() : dTime.packDatePC());
                    } else {
                        Integer minute = dTime.packDatePC() * 24 * 60 + dTime.packTimePC() / 100 * 60 + dTime.packTimePC() % 100;
                        calendar.add(12, dTime.packDatePS() == 2 ? -minute.intValue() : minute);
                    }
                    return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().EcsCal_PrintDate(calendar));
                }
                if (Flag2 == 14) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(this.tradeTime);
                    DTimeV2 dTime = itemC.getPlu().time();
                    if (dTime.packTimePS() == 1) {
                        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), dTime.packTimePC() / 100 % 24, dTime.packTimePC() % 100 % 60);
                    } else if (dTime.packTimePS() != 2) {
                        if (dTime.packTimePS() == 3) {
                            Integer minute = dTime.packDatePC() * 24 * 60 + dTime.packTimePC() / 100 * 60 + dTime.packTimePC() % 100;
                            calendar.add(12, dTime.packDatePS() == 2 ? -minute.intValue() : minute);
                        } else {
                            return "";
                        }
                    }
                    return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().EcsCal_PrintTime(calendar));
                }
                if (Flag2 == 15) {
                    CalPLU_ShelfDate shelfdate = new CalPLU_ShelfDate(itemC, this.tradeTime);
                    if (!shelfdate.isPrintable()) {
                        return "";
                    }
                    if (shelfdate.isByHour()) {
                        if (shelfdate.getInType() >= 4) {
                            return TradeContent.printCalculate_CommandText(mapInfo, shelfdate.getDirectValue().toString() + GlobalPara.getInstance().getLang("Hours"));
                        }
                        Calendar calendar = shelfdate.getCalendar();
                        return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().EcsCal_PrintDate(calendar) + "\n " + GlobalPara.getInstance().EcsCal_PrintTime(calendar) + " ");
                    }
                    if (shelfdate.getInType() >= 4) {
                        return TradeContent.printCalculate_CommandText(mapInfo, shelfdate.getDirectValue().toString() + GlobalPara.getInstance().getLang("Days"));
                    }
                    return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().EcsCal_PrintDate(shelfdate.getCalendar()));
                }
                if (Flag2 == 16) {
                    return TradeContent.printCalculate_CommandText(mapInfo, itemC.getPlu().getText().text(Integer.valueOf(0)));
                }
                if (Flag2 == 17) {
                    return TradeContent.printCalculate_CommandText(mapInfo, itemC.getPlu().getText().text(Integer.valueOf(1)));
                }
                if (Flag2 == 18) {
                    return TradeContent.printCalculate_CommandText(mapInfo, itemC.getPlu().getText().text(Integer.valueOf(2)));
                }
                if (Flag2 == 19) {
                    return TradeContent.printCalculate_CommandText(mapInfo, itemC.getPlu().getText().text(Integer.valueOf(3)));
                }
                if (Flag2 == 20) {
                    return TradeContent.printCalculate_CommandText(mapInfo, itemC.getPlu().getText().text(Integer.valueOf(4)));
                }
                if (Flag2 == 21) {
                    return TradeContent.printCalculate_CommandText(mapInfo, itemC.getPlu().getText().text(Integer.valueOf(5)));
                }
                if (Flag2 == 22) {
                    return TradeContent.printCalculate_CommandText(mapInfo, itemC.getPlu().getText().text(Integer.valueOf(6)));
                }
                if (Flag2 == 23) {
                    if (GlobalPara.getInstance().EcsCal_Unit_isWeight(itemC.getUnit_weight())) {
                        result = GlobalPara.getInstance().GetStringTMS(itemC.getAmount().add(itemC.getTare()));
                        if (GlobalPara.getInstance().getTMS(185) != 0) {
                            result = result + GlobalPara.getInstance().EcsCal_Unit_LoadName(itemC.getUnit_weight(), itemC.getUnitName());
                        }
                        return TradeContent.printCalculate_CommandText(mapInfo, result);
                    }
                } else {
                    if (Flag2 == 24) {
                        return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().EcsCal_Unit_LoadName(itemC.getUnit_weight(), itemC.getUnitName()));
                    }
                    if (Flag2 == 25) {
                        return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getMoneyPrefix() + GlobalPara.getInstance().getMoneySuffix() + "/" + GlobalPara.getInstance().EcsCal_Unit_LoadName(itemC.getUnit_price(), itemC.getUnitName()));
                    }
                    if (Flag2 == 26) {
                        if (GlobalPara.getInstance().getTMS(187) != 0) {
                            result = GlobalPara.getInstance().getMoneyPrefix();
                        }
                        result = result + GlobalPara.getInstance().GetStringTMS(itemC.getSingleNtax());
                        if (GlobalPara.getInstance().getTMS(187) != 0) {
                            result = result + GlobalPara.getInstance().getMoneySuffix();
                        }
                        return TradeContent.printCalculate_CommandText(mapInfo, result);
                    }
                    if (Flag2 == 27) {
                        if (GlobalPara.getInstance().getTMS(187) != 0) {
                            result = GlobalPara.getInstance().getMoneyPrefix();
                        }
                        result = result + GlobalPara.getInstance().GetStringTMS(itemC.getTax());
                        if (GlobalPara.getInstance().getTMS(187) != 0) {
                            result = result + GlobalPara.getInstance().getMoneySuffix();
                        }
                        return TradeContent.printCalculate_CommandText(mapInfo, result);
                    }
                    if (Flag2 == 28) {
                        if (GlobalPara.getInstance().getTMS(187) != 0) {
                            result = GlobalPara.getInstance().getMoneyPrefix();
                        }
                        result = result + GlobalPara.getInstance().GetStringTMS(itemC.getServiceFee());
                        if (GlobalPara.getInstance().getTMS(187) != 0) {
                            result = result + GlobalPara.getInstance().getMoneySuffix();
                        }
                        return TradeContent.printCalculate_CommandText(mapInfo, result);
                    }
                    if (Flag2 == 29) {
                        return TradeContent.printCalculate_CommandText(mapInfo, itemC.getTaxRate().movePointRight(2).toString() + "%");
                    }
                    if (Flag2 == 30) {
                        return TradeContent.printCalculate_CommandText(mapInfo, Integer.toString(itemC.getPlu().getNo()) + ": " + itemC.getPlu().getName());
                    }
                    if (Flag2 == 31) {
                        if (itemC.getPrice_Original().compareTo(BigDecimal.ZERO) != 0 && itemC.getPrice_Original().compareTo(itemC.getPrice()) != 0) {
                            if (GlobalPara.getInstance().getTMS(186) != 0) {
                                result = GlobalPara.getInstance().getMoneyPrefix();
                            }
                            result = result + GlobalPara.getInstance().GetStringTMS(itemC.getPrice_Original());
                            if (GlobalPara.getInstance().getTMS(186) != 0) {
                                result = result + GlobalPara.getInstance().getMoneySuffix() + "/" + GlobalPara.getInstance().EcsCal_Unit_LoadName(itemC.getUnit_price(), itemC.getUnitName());
                            }
                            mapInfo = this.printCalculate_DrawFont_AddDeletedLine(mapInfo);
                            return TradeContent.printCalculate_CommandText(mapInfo, result);
                        }
                    } else if (Flag2 == 32) {
                        if (GlobalPara.getInstance().EcsCal_Unit_isWeight(itemC.getUnit_Stock())) {
                            result = GlobalPara.getInstance().GetStringTMS(itemC.getAmount_Stock());
                            if (GlobalPara.getInstance().getTMS(185) != 0) {
                                result = result + GlobalPara.getInstance().EcsCal_Unit_LoadName(itemC.getUnit_Stock(), "");
                            }
                            return TradeContent.printCalculate_CommandText(mapInfo, result);
                        }
                    } else {
                        if (Flag2 == 33) {
                            return TradeContent.printCalculate_Bitmap(mapInfo, itemC.getPlu().getPrint().getBitmap());
                        }
                        if (Flag2 == 34) {
                            if (itemC.getPlu().percentTare().compareTo(BigDecimal.ZERO) > 0 && itemC.getPlu().percentTare().compareTo(BigDecimal.ONE) < 0 && itemC.getPercentedTare().compareTo(BigDecimal.ZERO) >= 0) {
                                result = GlobalPara.getInstance().GetStringTMS(itemC.getTare());
                                if (GlobalPara.getInstance().getTMS(185) != 0) {
                                    result = result + GlobalPara.getInstance().EcsCal_Unit_LoadName(itemC.getPlu().getUnit(), "");
                                }
                                return TradeContent.printCalculate_CommandText(mapInfo, result);
                            }
                        } else if (Flag2 == 35) {
                            if (itemC.getPlu().percentTare().compareTo(BigDecimal.ZERO) > 0 && itemC.getPlu().percentTare().compareTo(BigDecimal.ONE) < 0 && itemC.getPercentedTare().compareTo(BigDecimal.ZERO) >= 0) {
                                result = GlobalPara.getInstance().GetStringTMS(itemC.getPercentedTare());
                                if (GlobalPara.getInstance().getTMS(185) != 0) {
                                    result = result + GlobalPara.getInstance().EcsCal_Unit_LoadName(itemC.getPlu().getUnit(), "");
                                }
                                return TradeContent.printCalculate_CommandText(mapInfo, result);
                            }
                        } else if (Flag2 == 36) {
                            if (itemC.getPlu().percentTare().compareTo(BigDecimal.ZERO) > 0 && itemC.getPlu().percentTare().compareTo(BigDecimal.ONE) < 0 && itemC.getPercentedTare().compareTo(BigDecimal.ZERO) >= 0) {
                                return TradeContent.printCalculate_CommandText(mapInfo, itemC.getPlu().percentTare().movePointRight(2).toString() + "%");
                            }
                        } else if (Flag2 == 37 || Flag2 == 38) {
                            if (itemC.getPrice_Original().compareTo(BigDecimal.ZERO) != 0 && itemC.getPrice_Original().compareTo(itemC.getPrice()) != 0) {
                                if (GlobalPara.getInstance().getTMS(187) != 0) {
                                    result = GlobalPara.getInstance().getMoneyPrefix();
                                }
                                result = result + GlobalPara.getInstance().GetStringTMS(itemC.getSingleWtax_Original());
                                if (GlobalPara.getInstance().getTMS(187) != 0) {
                                    result = result + GlobalPara.getInstance().getMoneySuffix();
                                }
                                if (Flag2 == 38) {
                                    mapInfo = this.printCalculate_DrawFont_AddDeletedLine(mapInfo);
                                }
                                return TradeContent.printCalculate_CommandText(mapInfo, result);
                            }
                        } else if (Flag2 == 39) {
                            return TradeContent.printCalculate_CommandText(mapInfo, Integer.toString(itemPos));
                        }
                    }
                }
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    private String printCalculate_Sale_xID(Integer id, Integer lng) {
        if (id == 0) {
            return "";
        }
        if ((lng = Integer.valueOf(lng % 10)) >= 0) {
            return "#" + String.format("%0" + lng + "d", id);
        }
        return id.toString();
    }

    private String printCalculate_Sale(String mapInfo, int Flag1, int Flag2) {
        try {
            block144: {
                String result = "";
                if (Flag1 == 0) {
                    return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getStoreName());
                }
                if (Flag1 == 1) {
                    return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getDeviceName());
                }
                if (Flag1 == 2) {
                    return TradeContent.printCalculate_CommandText(mapInfo, "D" + Integer.toString(GlobalPara.getInstance().getDeviceNumber()));
                }
                if (Flag1 == 3) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(this.tradeTime);
                    return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().EcsCal_PrintDate(calendar));
                }
                if (Flag1 == 4) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(this.tradeTime);
                    return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().EcsCal_PrintTime(calendar));
                }
                if (Flag1 == 5) {
                    Integer LogLng = this.item.size();
                    return TradeContent.printCalculate_CommandText(mapInfo, LogLng.toString());
                }
                if (Flag1 == 6) {
                    return TradeContent.printCalculate_CommandText(mapInfo, this.tCount.toString());
                }
                if (Flag1 == 7) {
                    return TradeContent.printCalculate_CommandText(mapInfo, this.tWeight.toString());
                }
                if (Flag1 == 8) {
                    if (GlobalPara.getInstance().getTMS(187) != 0) {
                        result = GlobalPara.getInstance().getMoneyPrefix();
                    }
                    result = result + GlobalPara.getInstance().GetStringTMS(this.purTax_Discounted);
                    if (GlobalPara.getInstance().getTMS(187) != 0) {
                        result = result + GlobalPara.getInstance().getMoneySuffix();
                    }
                    return TradeContent.printCalculate_CommandText(mapInfo, result);
                }
                if (Flag1 == 9) {
                    if (!this.isPrePrint) {
                        if (GlobalPara.getInstance().getTMS(187) != 0) {
                            result = GlobalPara.getInstance().getMoneyPrefix();
                        }
                        result = result + GlobalPara.getInstance().GetStringTMS(this.pay_Cash);
                        if (GlobalPara.getInstance().getTMS(187) != 0) {
                            result = result + GlobalPara.getInstance().getMoneySuffix();
                        }
                        return TradeContent.printCalculate_CommandText(mapInfo, result);
                    }
                } else if (Flag1 == 10) {
                    if (!this.isPrePrint) {
                        if (GlobalPara.getInstance().getTMS(187) != 0) {
                            result = GlobalPara.getInstance().getMoneyPrefix();
                        }
                        result = result + GlobalPara.getInstance().GetStringTMS(this.change);
                        if (GlobalPara.getInstance().getTMS(187) != 0) {
                            result = result + GlobalPara.getInstance().getMoneySuffix();
                        }
                        return TradeContent.printCalculate_CommandText(mapInfo, result);
                    }
                } else {
                    if (Flag1 == 11) {
                        if (GlobalPara.getInstance().getTMS(187) != 0) {
                            result = GlobalPara.getInstance().getMoneyPrefix();
                        }
                        result = result + GlobalPara.getInstance().GetStringTMS(this.rounding);
                        if (GlobalPara.getInstance().getTMS(187) != 0) {
                            result = result + GlobalPara.getInstance().getMoneySuffix();
                        }
                        return TradeContent.printCalculate_CommandText(mapInfo, result);
                    }
                    if (Flag1 == 12) {
                        return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().EcsCal_Unit_LoadName(this.unit_Weight, ""));
                    }
                    if (Flag1 == 13) {
                        return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getMoneyPrefix() + GlobalPara.getInstance().getMoneySuffix() + "/" + GlobalPara.getInstance().EcsCal_Unit_LoadName(this.unit_Weight, ""));
                    }
                    if (Flag1 == 14) {
                        return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().EcsCal_Unit_LoadName(2, ""));
                    }
                    if (Flag1 == 15) {
                        return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getMoneyPrefix() + GlobalPara.getInstance().getMoneySuffix() + "/" + GlobalPara.getInstance().EcsCal_Unit_LoadName(2, ""));
                    }
                    if (Flag1 == 16) {
                        return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getMoneyPrefix() + GlobalPara.getInstance().getMoneySuffix());
                    }
                    if (Flag1 == 17) {
                        return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getTMT(4));
                    }
                    if (Flag1 == 18) {
                        return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getTMT(5));
                    }
                    if (Flag1 == 19) {
                        return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getTMT(6));
                    }
                    if (Flag1 == 20) {
                        return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getTMT(7));
                    }
                    if (Flag1 == 21) {
                        return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getTMT(8));
                    }
                    if (Flag1 == 22) {
                        return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getTMT(9));
                    }
                    if (Flag1 == 23) {
                        return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getTMT(10));
                    }
                    if (Flag1 == 24) {
                        return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getTMT(11));
                    }
                    if (Flag1 == 25) {
                        if (!this.isPrePrint) {
                            int fsid_LLng = GlobalPara.getInstance().getTMS(143);
                            if (fsid_LLng / 10 == 2) {
                                return TradeContent.printCalculate_CommandText(mapInfo, this.printCalculate_Sale_xID(this.sid, fsid_LLng));
                            }
                            return TradeContent.printCalculate_CommandText(mapInfo, this.printCalculate_Sale_xID(this.fid, fsid_LLng));
                        }
                    } else if (Flag1 == 26) {
                        if (!this.isPrePrint) {
                            int fsid_LLng = GlobalPara.getInstance().getTMS(143);
                            if (fsid_LLng / 10 == 1) {
                                return TradeContent.printCalculate_CommandText(mapInfo, this.printCalculate_Sale_xID(this.fid, fsid_LLng));
                            }
                            return TradeContent.printCalculate_CommandText(mapInfo, this.printCalculate_Sale_xID(this.sid, fsid_LLng));
                        }
                    } else {
                        if (Flag1 == 27) {
                            if (GlobalPara.getInstance().getTMS(187) != 0) {
                                result = GlobalPara.getInstance().getMoneyPrefix();
                            }
                            result = result + GlobalPara.getInstance().GetStringTMS(this.purTax_Final);
                            if (GlobalPara.getInstance().getTMS(187) != 0) {
                                result = result + GlobalPara.getInstance().getMoneySuffix();
                            }
                            return TradeContent.printCalculate_CommandText(mapInfo, result);
                        }
                        if (Flag1 == 28) {
                            if (GlobalPara.getInstance().getTMS(187) != 0) {
                                result = GlobalPara.getInstance().getMoneyPrefix();
                            }
                            result = result + GlobalPara.getInstance().GetStringTMS(this.purTax_Addup.add(this.purTax_ServiceFee));
                            if (GlobalPara.getInstance().getTMS(187) != 0) {
                                result = result + GlobalPara.getInstance().getMoneySuffix();
                            }
                            return TradeContent.printCalculate_CommandText(mapInfo, result);
                        }
                        if (Flag1 == 29) {
                            if (GlobalPara.getInstance().getTMS(187) != 0) {
                                result = GlobalPara.getInstance().getMoneyPrefix();
                            }
                            result = result + GlobalPara.getInstance().GetStringTMS(this.getPur_Diff());
                            if (GlobalPara.getInstance().getTMS(187) != 0) {
                                result = result + GlobalPara.getInstance().getMoneySuffix();
                            }
                            return TradeContent.printCalculate_CommandText(mapInfo, result);
                        }
                        if (Flag1 == 30) {
                            return TradeContent.printCalculate_CommandText(mapInfo, Integer.toString(this.salesman_Number));
                        }
                        if (Flag1 == 31) {
                            return TradeContent.printCalculate_CommandText(mapInfo, this.salesman_Name);
                        }
                        if (Flag1 == 32) {
                            return TradeContent.printCalculate_CommandText(mapInfo, this.purTax_Discounted.subtract(this.tax_Discounted).toString());
                        }
                        if (Flag1 == 33) {
                            return TradeContent.printCalculate_CommandText(mapInfo, this.tax_Discounted.toString());
                        }
                        if (Flag1 == 34) {
                            return TradeContent.printCalculate_CommandText(mapInfo, Integer.toString(this.serviceman_Number));
                        }
                        if (Flag1 == 35) {
                            return TradeContent.printCalculate_CommandText(mapInfo, this.serviceman_Name);
                        }
                        if (Flag1 == 36) {
                            return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getTMT(12));
                        }
                        if (Flag1 == 37) {
                            return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getTMT(13));
                        }
                        if (Flag1 == 38) {
                            return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getTMT(14));
                        }
                        if (Flag1 == 39) {
                            return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getTMT(15));
                        }
                        if (Flag1 == 40) {
                            return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getTMT(16));
                        }
                        if (Flag1 == 41) {
                            return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getTMT(17));
                        }
                        if (Flag1 == 42) {
                            return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getTMT(18));
                        }
                        if (Flag1 == 43) {
                            return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getTMT(19));
                        }
                        if (Flag1 == 44) {
                            return TradeContent.printCalculate_CommandText(mapInfo, this.purTax_ServiceFee.toString());
                        }
                        if (Flag1 == 45) {
                            return TradeContent.printCalculate_CommandText(mapInfo, this.tax_ServiceFee.toString());
                        }
                        if (Flag1 == 46) {
                            return TradeContent.printCalculate_CommandText(mapInfo, this.purTax_ServiceFee.subtract(this.tax_ServiceFee).toString());
                        }
                        if (Flag1 == 47) {
                            return TradeContent.printCalculate_CommandText(mapInfo, "V" + Integer.toString(this.vid));
                        }
                        if (Flag1 == 48) {
                            if (!this.isPrePrint && this.pay_VIP_Balance_Old.compareTo(BigDecimal.ZERO) > 0) {
                                return TradeContent.printCalculate_CommandText(mapInfo, this.pay_VIP_Balance_New.toString());
                            }
                        } else if (Flag1 == 49) {
                            if (!this.isPrePrint && this.pay_VIP_Balance_Old.compareTo(BigDecimal.ZERO) > 0) {
                                return TradeContent.printCalculate_CommandText(mapInfo, this.pay_VIP_Balance_Old.toString());
                            }
                        } else if (Flag1 == 50) {
                            if (!this.isPrePrint) {
                                return TradeContent.printCalculate_CommandText(mapInfo, this.pay_VIP_ID);
                            }
                        } else if (Flag1 == 51) {
                            if (!this.isPrePrint) {
                                return TradeContent.printCalculate_CommandText(mapInfo, this.pay_Card.toString());
                            }
                        } else if (Flag1 == 52) {
                            if (!this.isPrePrint) {
                                return TradeContent.printCalculate_CommandText(mapInfo, this.pay_Other1.toString());
                            }
                        } else if (Flag1 == 53) {
                            if (!this.isPrePrint) {
                                return TradeContent.printCalculate_CommandText(mapInfo, this.pay_Other2.toString());
                            }
                        } else if (Flag1 == 54) {
                            if (!this.isPrePrint) {
                                return TradeContent.printCalculate_CommandText(mapInfo, this.pay_Other3.toString());
                            }
                        } else {
                            if (Flag1 == 55) {
                                return TradeContent.printCalculate_CommandText(mapInfo, this.tradeTypeName);
                            }
                            if (Flag1 == 56) {
                                if (!this.isPrePrint) {
                                    return TradeContent.printCalculate_CommandText(mapInfo, this.pay_VIP_ID_Plus1);
                                }
                            } else if (Flag1 == 57) {
                                if (!this.isPrePrint) {
                                    return TradeContent.printCalculate_CommandText(mapInfo, this.pay_VIP_ID_Plus2);
                                }
                            } else if (Flag1 == 58) {
                                if (!this.isPrePrint) {
                                    return TradeContent.printCalculate_CommandText(mapInfo, "-" + new BigDecimal(10000 - this.pay_VIP_DiscountP1W).movePointLeft(2).toString() + "%");
                                }
                            } else if (Flag1 == 59) {
                                if (!this.isPrePrint) {
                                    return TradeContent.printCalculate_CommandText(mapInfo, this.pay_VIP_Point.toString());
                                }
                            } else {
                                if (Flag1 == 60) {
                                    try {
                                        int exchange = GlobalPara.getInstance().getTMS(297);
                                        BigDecimal rate = GlobalPara.ecsCal_getNumS32(exchange);
                                        if (rate.compareTo(BigDecimal.ZERO) != 0) {
                                            rate = this.purTax_Final.divide(rate, GlobalPara.getInstance().getTMS(298), 4);
                                            return TradeContent.printCalculate_CommandText(mapInfo, rate.toString());
                                        }
                                        break block144;
                                    }
                                    catch (Exception exp) {
                                        return "";
                                    }
                                }
                                if (Flag1 != 61 && Flag1 != 62 && Flag1 != 63 && Flag1 != 64) {
                                    if (Flag1 == 65) {
                                        return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getSystemID());
                                    }
                                    if (Flag1 == 66) {
                                        if (GlobalPara.getInstance().getTMS(187) != 0) {
                                            result = GlobalPara.getInstance().getMoneyPrefix();
                                        }
                                        result = result + GlobalPara.getInstance().GetStringTMS(this.getPurTax_Diff());
                                        if (GlobalPara.getInstance().getTMS(187) != 0) {
                                            result = result + GlobalPara.getInstance().getMoneySuffix();
                                        }
                                        return TradeContent.printCalculate_CommandText(mapInfo, result);
                                    }
                                    if (Flag1 == 67) {
                                        if (!this.isPrePrint) {
                                            return TradeContent.printCalculate_CommandText(mapInfo, this.pay_Cloud_TypeName);
                                        }
                                    } else if (Flag1 == 68) {
                                        if (!this.isPrePrint) {
                                            if (GlobalPara.getInstance().getTMS(187) != 0) {
                                                result = GlobalPara.getInstance().getMoneyPrefix();
                                            }
                                            result = result + GlobalPara.getInstance().GetStringTMS(this.pay_Cloud);
                                            if (GlobalPara.getInstance().getTMS(187) != 0) {
                                                result = result + GlobalPara.getInstance().getMoneySuffix();
                                            }
                                            return TradeContent.printCalculate_CommandText(mapInfo, result);
                                        }
                                    } else if (Flag1 == 69) {
                                        if (!this.isPrePrint) {
                                            return TradeContent.printCalculate_CommandText(mapInfo, this.pay_Cloud_Bill);
                                        }
                                    } else if (Flag1 == 70) {
                                        if (!this.isPrePrint) {
                                            if (GlobalPara.getInstance().getTMS(187) != 0) {
                                                result = GlobalPara.getInstance().getMoneyPrefix();
                                            }
                                            result = result + GlobalPara.getInstance().GetStringTMS(this.pay_JKY_All);
                                            if (GlobalPara.getInstance().getTMS(187) != 0) {
                                                result = result + GlobalPara.getInstance().getMoneySuffix();
                                            }
                                            return TradeContent.printCalculate_CommandText(mapInfo, result);
                                        }
                                    } else if (Flag1 == 71) {
                                        if (this.purTax_FromPLU.compareTo(this.purTax_Addup) != 0) {
                                            if (GlobalPara.getInstance().getTMS(187) != 0) {
                                                result = GlobalPara.getInstance().getMoneyPrefix();
                                            }
                                            result = result + GlobalPara.getInstance().GetStringTMS(this.purTax_FromPLU);
                                            if (GlobalPara.getInstance().getTMS(187) != 0) {
                                                result = result + GlobalPara.getInstance().getMoneySuffix();
                                            }
                                            mapInfo = this.printCalculate_DrawFont_AddDeletedLine(mapInfo);
                                            return TradeContent.printCalculate_CommandText(mapInfo, result);
                                        }
                                    } else if (Flag1 == 72) {
                                        BigDecimal saved = this.purTax_FromPLU.add(this.purTax_ServiceFee).subtract(this.purTax_Discounted);
                                        if (saved.compareTo(BigDecimal.ZERO) > 0) {
                                            if (GlobalPara.getInstance().getTMS(187) != 0) {
                                                result = GlobalPara.getInstance().getMoneyPrefix();
                                            }
                                            result = result + GlobalPara.getInstance().GetStringTMS(saved);
                                            if (GlobalPara.getInstance().getTMS(187) != 0) {
                                                result = result + GlobalPara.getInstance().getMoneySuffix();
                                            }
                                            return TradeContent.printCalculate_CommandText(mapInfo, result);
                                        }
                                    } else if (Flag1 == 73) {
                                        Calendar calendar = Calendar.getInstance();
                                        calendar.setTime(this.tradeTime);
                                        SimpleDateFormat formatter = new SimpleDateFormat("yyMM");
                                        String qrContent = String.format(ZUUL, GlobalPara.getInstance().getSystemID(), this.fid, formatter.format(calendar.getTime()));
                                        return TradeContent.printCalculate_DrawBarcode(mapInfo, "0B01030500000000", qrContent.getBytes());
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static int tryParseInt(String toParse, int defaultValue) {
        try {
            return Integer.parseInt(toParse, 10);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int tryParseInt(String toParse) {
        return TradeContent.tryParseInt(toParse, 0);
    }

    public static String printCalculate_Item_Special(String nohead, int itemPos) {
        return "";
    }

    public static String printCalculate_Sale_Special(String nohead) {
        return "";
    }

    public static Integer[] printCalculate_GetNValue(String nohead, int size) {
        Integer n;
        Integer n2;
        String[] nstring = nohead.split("-");
        Integer[] nvalue = new Integer[size];
        Integer loop = 0;
        while (loop < nstring.length) {
            nvalue[loop.intValue()] = TradeContent.tryParseInt(nstring[loop]);
            n2 = loop;
            n = loop = Integer.valueOf(loop + 1);
        }
        while (loop < size) {
            nvalue[loop.intValue()] = 0;
            n2 = loop;
            n = loop = Integer.valueOf(loop + 1);
        }
        return nvalue;
    }

    public static String printCalculate_getX2(int value) {
        return "" + HexChar[value >> 4 & 0xF] + HexChar[value & 0xF];
    }

    public static String printCalculate_getX4(int value) {
        return "" + HexChar[value >> 4 & 0xF] + HexChar[value & 0xF] + HexChar[value >> 12 & 0xF] + HexChar[value >> 8 & 0xF];
    }

    public static String printCalculate_GetBarcodeHex(byte[] bytes) {
        int len = bytes.length;
        byte[] hex = new byte[len * 2 + 2];
        int count = 0;
        for (int i = 0; i < len; ++i) {
            int value = bytes[i];
            if (value < 0) {
                value += 256;
            }
            hex[count] = HexValue[value / 16 & 0xF];
            hex[count + 1] = HexValue[value & 0xF];
            count += 2;
        }
        hex[count] = 48;
        hex[count + 1] = 48;
        count += 2;
        return new String(hex);
    }

    public static String printCalculate_GetTextHex(String text) {
        byte[] bytes = text.getBytes();
        int len = bytes.length;
        byte[] hex = new byte[len * 2 + 2];
        int count = 0;
        for (int i = 0; i < len; ++i) {
            int value = bytes[i];
            if (value < 0) {
                value += 256;
            }
            if (value == 10 || value == 11) {
                value = 11;
            } else if (value < 32) continue;
            hex[count] = HexValue[value / 16 & 0xF];
            hex[count + 1] = HexValue[value & 0xF];
            count += 2;
        }
        hex[count] = 48;
        hex[count + 1] = 48;
        return new String(Arrays.copyOfRange(hex, 0, count += 2));
    }

    public static String printCalculate_Bitmap(String mapInfo, int bitmap) {
        if (mapInfo == null) {
            return "";
        }
        if (mapInfo.isEmpty()) {
            return "";
        }
        return "16" + mapInfo + TradeContent.printCalculate_getX4(bitmap);
    }

    public static String printCalculate_Bitmap_Inner(String mapInfo, int bitmap) {
        if (mapInfo == null) {
            return "";
        }
        if (mapInfo.isEmpty()) {
            return "";
        }
        return "18" + mapInfo + TradeContent.printCalculate_getX4(bitmap);
    }

    public static String printCalculate_CommandText(String command, String text) {
        if (command == null) {
            return "";
        }
        if (command.isEmpty()) {
            return "";
        }
        if (text == null) {
            return "";
        }
        if (text.isEmpty()) {
            return "";
        }
        return "12" + command + TradeContent.printCalculate_GetTextHex(text);
    }

    public static String printCalculate_DrawBarcode(String mapInfo, String barcodeType, byte[] input) {
        if (mapInfo == null) {
            return "";
        }
        if (mapInfo.isEmpty()) {
            return "";
        }
        if (barcodeType == null) {
            return "";
        }
        if (barcodeType.isEmpty()) {
            return "";
        }
        if (input == null) {
            return "";
        }
        return "14" + mapInfo + barcodeType + TradeContent.printCalculate_GetBarcodeHex(input);
    }

    public void setSpInfo(String key, Object value) {
        this.spInfo.put(key, value);
    }

    public Object getSpInfo(String key) {
        return this.spInfo.get(key);
    }

    public List<ItemContent> getItem() {
        return this.item;
    }

    public void setItem(List<ItemContent> item) {
        this.item = item;
    }

    public boolean isPrePrint() {
        return this.isPrePrint;
    }

    public void setPrePrint(boolean prePrint) {
        this.isPrePrint = prePrint;
    }

    public boolean isRePrint() {
        return this.isRePrint;
    }

    public void setRePrint(boolean rePrint) {
        this.isRePrint = rePrint;
    }

    public Date getTradeTime() {
        return this.tradeTime;
    }

    public void setTradeTime(Date tradeTime) {
        this.tradeTime = tradeTime;
    }

    public int getFid() {
        return this.fid;
    }

    public void setFid(int fid) {
        this.fid = fid;
    }

    public int getSid() {
        return this.sid;
    }

    public void setSid(int sid) {
        this.sid = sid;
    }

    public int getVid() {
        return this.vid;
    }

    public void setVid(int vid) {
        this.vid = vid;
    }

    public int getSalesman_Number() {
        return this.salesman_Number;
    }

    public void setSalesman_Number(int salesman_Number) {
        this.salesman_Number = salesman_Number;
    }

    public String getSalesman_Name() {
        return this.salesman_Name;
    }

    public void setSalesman_Name(String salesman_Name) {
        this.salesman_Name = salesman_Name;
    }

    public int getServiceman_Number() {
        return this.serviceman_Number;
    }

    public void setServiceman_Number(int serviceman_Number) {
        this.serviceman_Number = serviceman_Number;
    }

    public String getServiceman_Name() {
        return this.serviceman_Name;
    }

    public void setServiceman_Name(String serviceman_Name) {
        this.serviceman_Name = serviceman_Name;
    }

    public int getTradeType() {
        return this.tradeType;
    }

    public void setTradeType(int tradeType) {
        this.tradeType = tradeType;
    }

    public TradeContent tradeType(TradeType tradeType) {
        this.tradeType = tradeType.getType();
        return this;
    }

    public String getTradeTypeName() {
        return this.tradeTypeName;
    }

    public void setTradeTypeName(String tradeTypeName) {
        this.tradeTypeName = tradeTypeName;
    }

    public BigDecimal gettCount() {
        return this.tCount;
    }

    public void settCount(BigDecimal tCount) {
        this.tCount = tCount;
    }

    public BigDecimal gettWeight() {
        return this.tWeight;
    }

    public void settWeight(BigDecimal tWeight) {
        this.tWeight = tWeight;
    }

    public int gettUnitWeight() {
        return this.tUnitWeight;
    }

    public void settUnitWeight(int tUnitWeight) {
        this.tUnitWeight = tUnitWeight;
    }

    public int getUnit_Weight() {
        return this.unit_Weight;
    }

    public void setUnit_Weight(int unit_Weight) {
        this.unit_Weight = unit_Weight;
    }

    public BigDecimal getPurTax_FromPLU() {
        return this.purTax_FromPLU;
    }

    public void setPurTax_FromPLU(BigDecimal purTax_FromPLU) {
        this.purTax_FromPLU = purTax_FromPLU;
    }

    public BigDecimal getPurTax_Addup() {
        return this.purTax_Addup;
    }

    public void setPurTax_Addup(BigDecimal purTax_Addup) {
        this.purTax_Addup = purTax_Addup;
    }

    public BigDecimal getTax_Addup() {
        return this.tax_Addup;
    }

    public void setTax_Addup(BigDecimal tax_Addup) {
        this.tax_Addup = tax_Addup;
    }

    public BigDecimal getPurTax_ServiceFee() {
        return this.purTax_ServiceFee;
    }

    public void setPurTax_ServiceFee(BigDecimal purTax_ServiceFee) {
        this.purTax_ServiceFee = purTax_ServiceFee;
    }

    public BigDecimal getTax_ServiceFee() {
        return this.tax_ServiceFee;
    }

    public void setTax_ServiceFee(BigDecimal tax_ServiceFee) {
        this.tax_ServiceFee = tax_ServiceFee;
    }

    public int getTotal_ServiceFee_Type() {
        return this.total_ServiceFee_Type;
    }

    public void setTotal_ServiceFee_Type(int total_ServiceFee_Type) {
        this.total_ServiceFee_Type = total_ServiceFee_Type;
    }

    public BigDecimal getTotal_ServiceFee_Rate() {
        return this.total_ServiceFee_Rate;
    }

    public void setTotal_ServiceFee_Rate(BigDecimal total_ServiceFee_Rate) {
        this.total_ServiceFee_Rate = total_ServiceFee_Rate;
    }

    public BigDecimal getPurTax_Discounted() {
        return this.purTax_Discounted;
    }

    public void setPurTax_Discounted(BigDecimal purTax_Discounted) {
        this.purTax_Discounted = purTax_Discounted;
    }

    public BigDecimal getTax_Discounted() {
        return this.tax_Discounted;
    }

    public void setTax_Discounted(BigDecimal tax_Discounted) {
        this.tax_Discounted = tax_Discounted;
    }

    public BigDecimal getPurTax_Final() {
        return this.purTax_Final;
    }

    public void setPurTax_Final(BigDecimal purTax_Final) {
        this.purTax_Final = purTax_Final;
    }

    public BigDecimal getPurTax_Diff() {
        return this.purTax_Final.subtract(this.purTax_Addup).subtract(this.purTax_ServiceFee);
    }

    public BigDecimal getPur_Diff() {
        return this.purTax_Final.subtract(this.purTax_Addup).subtract(this.purTax_ServiceFee).subtract(this.tax_Discounted.subtract(this.tax_Addup).subtract(this.tax_ServiceFee));
    }

    public BigDecimal getSurplus_Reject() {
        return this.surplus_Reject;
    }

    public void setSurplus_Reject(BigDecimal surplus_Reject) {
        this.surplus_Reject = surplus_Reject;
    }

    public BigDecimal getRounding() {
        return this.rounding;
    }

    public void setRounding(BigDecimal rounding) {
        this.rounding = rounding;
    }

    public BigDecimal getChange() {
        return this.change;
    }

    public void setChange(BigDecimal change) {
        this.change = change;
    }

    public BigDecimal getPay_Cash() {
        return this.pay_Cash;
    }

    public void setPay_Cash(BigDecimal pay_Cash) {
        this.pay_Cash = pay_Cash;
    }

    public BigDecimal getPay_Other1() {
        return this.pay_Other1;
    }

    public void setPay_Other1(BigDecimal pay_Other1) {
        this.pay_Other1 = pay_Other1;
    }

    public BigDecimal getPay_Other2() {
        return this.pay_Other2;
    }

    public void setPay_Other2(BigDecimal pay_Other2) {
        this.pay_Other2 = pay_Other2;
    }

    public BigDecimal getPay_Other3() {
        return this.pay_Other3;
    }

    public void setPay_Other3(BigDecimal pay_Other3) {
        this.pay_Other3 = pay_Other3;
    }

    public BigDecimal getPay_JKY_All() {
        return this.pay_JKY_All;
    }

    public void setPay_JKY_All(BigDecimal pay_JKY_All) {
        this.pay_JKY_All = pay_JKY_All;
    }

    public BigDecimal getPay_JKY_Gift() {
        return this.pay_JKY_Gift;
    }

    public void setPay_JKY_Gift(BigDecimal pay_JKY_Gift) {
        this.pay_JKY_Gift = pay_JKY_Gift;
    }

    public BigDecimal getPay_Card() {
        return this.pay_Card;
    }

    public void setPay_Card(BigDecimal pay_Card) {
        this.pay_Card = pay_Card;
    }

    public BigDecimal getPay_VIP_Balance_Old() {
        return this.pay_VIP_Balance_Old;
    }

    public void setPay_VIP_Balance_Old(BigDecimal pay_VIP_Balance_Old) {
        this.pay_VIP_Balance_Old = pay_VIP_Balance_Old;
    }

    public BigDecimal getPay_VIP_Balance_New() {
        return this.pay_VIP_Balance_New;
    }

    public void setPay_VIP_Balance_New(BigDecimal pay_VIP_Balance_New) {
        this.pay_VIP_Balance_New = pay_VIP_Balance_New;
    }

    public String getPay_VIP_ID() {
        return this.pay_VIP_ID;
    }

    public void setPay_VIP_ID(String pay_VIP_ID) {
        this.pay_VIP_ID = pay_VIP_ID;
    }

    public String getPay_VIP_ID_Plus1() {
        return this.pay_VIP_ID_Plus1;
    }

    public void setPay_VIP_ID_Plus1(String pay_VIP_ID_Plus1) {
        this.pay_VIP_ID_Plus1 = pay_VIP_ID_Plus1;
    }

    public String getPay_VIP_ID_Plus2() {
        return this.pay_VIP_ID_Plus2;
    }

    public void setPay_VIP_ID_Plus2(String pay_VIP_ID_Plus2) {
        this.pay_VIP_ID_Plus2 = pay_VIP_ID_Plus2;
    }

    public char getPay_VIP_Level() {
        return this.pay_VIP_Level;
    }

    public void setPay_VIP_Level(char pay_VIP_Level) {
        this.pay_VIP_Level = pay_VIP_Level;
    }

    public int getPay_VIP_DiscountP1W() {
        return this.pay_VIP_DiscountP1W;
    }

    public void setPay_VIP_DiscountP1W(int pay_VIP_DiscountP1W) {
        this.pay_VIP_DiscountP1W = pay_VIP_DiscountP1W;
    }

    public BigDecimal getPay_VIP_Point() {
        return this.pay_VIP_Point;
    }

    public void setPay_VIP_Point(BigDecimal pay_VIP_Point) {
        this.pay_VIP_Point = pay_VIP_Point;
    }

    public DSource getSource() {
        return this.source;
    }

    public TradeContent setSource(DSource source) {
        this.source = source;
        return this;
    }

    public BigDecimal getPay_Cloud() {
        return this.pay_Cloud;
    }

    public Integer getPay_Cloud_Type() {
        return this.pay_Cloud_Type;
    }

    public Integer getPay_Cloud_Way() {
        return this.pay_Cloud_Way;
    }

    public void setPay_Cloud_Way(Integer pay_Cloud_Way) {
        this.pay_Cloud_Way = pay_Cloud_Way;
    }

    public void setPay_Cloud_Type(Integer pay_Cloud_Type) {
        this.pay_Cloud_Type = pay_Cloud_Type;
    }

    public void setPay_Cloud(BigDecimal pay_Cloud) {
        this.pay_Cloud = pay_Cloud;
    }

    public String getPay_Cloud_TypeName() {
        return this.pay_Cloud_TypeName;
    }

    public void setPay_Cloud_TypeName(String pay_Cloud_TypeName) {
        this.pay_Cloud_TypeName = pay_Cloud_TypeName;
    }

    public String getPay_Cloud_Bill() {
        return this.pay_Cloud_Bill;
    }

    public void setPay_Cloud_Bill(String pay_Cloud_Bill) {
        this.pay_Cloud_Bill = pay_Cloud_Bill;
    }

    public String getError_code() {
        return this.error_code;
    }

    public void setError_code(String error_code) {
        this.error_code = error_code;
    }

    public Map<String, String> getCustomInfo() {
        return this.customInfo;
    }

    public void setCustomInfo(Map<String, String> customInfo) {
        this.customInfo = customInfo;
    }

    public List<PrintContent> getPrintContents() {
        return this.printContents;
    }

    public void setPrintContents(List<PrintContent> printContents) {
        this.printContents = printContents;
    }

    public DLOGContent getLogContent() {
        return this.logContent;
    }

    public void setLogContent(DLOGContent logContent) {
        this.logContent = logContent;
    }

    public void putPosOnlyString(Integer number, String value) {
        this.posOnlyString.put(number, value);
    }

    public String getPosOnlyString(Integer number) {
        return this.posOnlyString.get(number);
    }
}

