/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.model;

import com.jhscale.common.em.PayType;
import com.jhscale.common.em.PayWay;
import com.jhscale.common.em.TradeType;
import com.jhscale.common.model.device.UnitType;
import com.jhscale.common.model.device.log.module.DSource;
import com.jhscale.common.model.device.plu.DPLUV5;
import com.jhscale.common.model.device.saleman.DSaleMan;
import com.jhscale.common.model.device.saleman.DSaleManV1;
import com.jhscale.common.model.inter.GJSONModel;
import com.jhscale.common.utils.BigDecimalUtils;
import com.jhscale.common.ysscale.UnitEnum;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.exp.RuntimeMeterException;
import com.jhscale.meter.protocol.constant.TMS;
import com.jhscale.meter.protocol.model.BarCodeItemResult;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.protocol.model.ItemContent;
import com.jhscale.meter.protocol.model.SerialDisplay;
import com.jhscale.meter.protocol.model.TradeContent;
import com.jhscale.meter.protocol.model.TradeReject;
import com.jhscale.meter.protocol.model.TradeUnconfirmed;
import com.jhscale.meter.protocol.model.WeightCal;
import com.jhscale.meter.protocol.model.WeightResult;
import com.jhscale.meter.protocol.print.PrintGeneralFactory;
import com.jhscale.meter.protocol.print.entity.PrintResponse;
import com.jhscale.meter.protocol.print.link.IPrintBack;
import com.jhscale.meter.protocol.trade.CardSettlement;
import com.jhscale.meter.protocol.trade.CashSettlement;
import com.jhscale.meter.protocol.trade.CloudPaySettlement;
import com.jhscale.meter.protocol.trade.DeviceSettlement;
import com.jhscale.meter.protocol.trade.JKYSettlement;
import com.jhscale.meter.protocol.trade.OtherPaySettlement;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class TradePipeline
implements GJSONModel {
    private TradeContent tradeContent;

    public TradePipeline() {
        this.Create();
    }

    public TradePipeline(TradeType type, DSaleMan salesman) {
        this.Create(type, salesman);
    }

    public TradePipeline(DSaleMan salesman) {
        this.Create(salesman);
    }

    public TradePipeline(TradeType type) {
        this.Create(type);
    }

    public TradePipeline(int type, DSaleMan salesman) {
        this.Create(type, salesman);
    }

    private TradePipeline Create() {
        return this.Create(TradeType.\u9500\u552e, GlobalPara.getInstance().getSaleMan());
    }

    private TradePipeline Create(DSaleMan salesman) {
        return this.Create(TradeType.\u9500\u552e, salesman);
    }

    private TradePipeline Create(TradeType type) {
        return this.Create(type, GlobalPara.getInstance().getSaleMan());
    }

    private TradePipeline Create(TradeType type, DSaleMan salesman) {
        return this.Create(type.getType(), salesman);
    }

    private TradePipeline Create(int type, DSaleMan salesman) {
        if (salesman == null) {
            salesman = ((DSaleManV1)new DSaleManV1().setNo(Integer.valueOf(0))).setName("");
        }
        this.tradeContent = new TradeContent(type).Total_Salesman_Set(salesman.no(), salesman.getName());
        return this;
    }

    public TradeContent Current_TradeContent() throws RuntimeMeterException {
        if (this.tradeContent == null) {
            throw new RuntimeMeterException(MeterStateEnum.\u4ea4\u6613\u672a\u521b\u5efa);
        }
        return this.tradeContent;
    }

    public TradeContent Current_TradeContent_WOE() {
        if (this.tradeContent == null) {
            this.Create();
        }
        return this.tradeContent;
    }

    public TradePipeline Total_VIP_Set(char level, int p1w) {
        this.Current_TradeContent_WOE().Total_VIP_Set(level, p1w);
        return this;
    }

    public TradePipeline Total_VIP_Clear() {
        this.Current_TradeContent_WOE().Total_VIP_Clear();
        return this;
    }

    public boolean Item_New_Check(DPLUV5 content) throws MeterException {
        return GlobalPara.getInstance().EcsCal_MoneyUnitAllowed(content.getUnit());
    }

    public ItemContent Item_New(DPLUV5 content) throws RuntimeMeterException {
        ItemContent itemContent = new ItemContent(content, this.Current_TradeContent_WOE());
        WeightCal.getInstance().SetTare_PLUValue(itemContent.getPreTare());
        return itemContent;
    }

    public ItemContent Item_Set_Weight(ItemContent itemContent, WeightResult wr) throws RuntimeMeterException {
        ItemContent _itemContent = itemContent.Item_Set_Weight(wr).Item_ReCal(this.Current_TradeContent_WOE());
        SerialDisplay.getInstance().setItemContentWR(_itemContent, wr);
        return _itemContent;
    }

    @Deprecated
    public ItemContent Item_Set_Weight(ItemContent itemContent, BigDecimal wt) throws RuntimeMeterException {
        ItemContent _itemContent = itemContent.Item_Set_Weight(wt, true).Item_ReCal(this.Current_TradeContent_WOE());
        SerialDisplay.getInstance().setItemContentWR(_itemContent);
        return _itemContent;
    }

    public ItemContent Item_Set_Weight(ItemContent itemContent) throws RuntimeMeterException {
        return this.Item_Set_Weight(itemContent, WeightCal.getInstance().GetResult());
    }

    public ItemContent Item_Set_Count(ItemContent itemContent, BigDecimal pcs) throws RuntimeMeterException {
        ItemContent _itemContent = itemContent.Item_Set_Count(pcs).Item_ReCal(this.Current_TradeContent_WOE());
        SerialDisplay.getInstance().setItemContentWR(_itemContent);
        return _itemContent;
    }

    public ItemContent Item_Set_Count(ItemContent itemContent) throws RuntimeMeterException {
        return this.Item_Set_Count(itemContent, BigDecimal.ONE);
    }

    public ItemContent Item_Set_Amount_Stock(ItemContent itemContent, BigDecimal pcs, WeightResult wr) throws RuntimeMeterException {
        ItemContent _itemContent = itemContent.Item_Set_Count(pcs).Item_Set_Amount_Stock(wr).Item_ReCal(this.Current_TradeContent_WOE());
        SerialDisplay.getInstance().setItemContentWR(_itemContent, wr);
        return _itemContent;
    }

    public ItemContent Item_Set_Amount_Stock(ItemContent itemContent, BigDecimal pcs) throws RuntimeMeterException {
        return this.Item_Set_Amount_Stock(itemContent, pcs, WeightCal.getInstance().GetResult());
    }

    public ItemContent Item_Set_Amount_Stock(ItemContent itemContent) throws RuntimeMeterException {
        return this.Item_Set_Amount_Stock(itemContent, BigDecimal.ONE, WeightCal.getInstance().GetResult());
    }

    public ItemContent Item_Set_Price(ItemContent itemContent, BigDecimal price) throws RuntimeMeterException {
        ItemContent _itemContent = itemContent.Item_Set_UPrice(price).Item_ReCal(this.Current_TradeContent_WOE());
        SerialDisplay.getInstance().setItemContentWR(_itemContent);
        return _itemContent;
    }

    public ItemContent Item_Set_Price(ItemContent itemContent, BigDecimal price, int unitPrice) throws RuntimeMeterException {
        ItemContent _itemContent = itemContent.Item_Set_UPrice_WithUnit(price, unitPrice).Item_ReCal(this.Current_TradeContent_WOE());
        SerialDisplay.getInstance().setItemContentWR(_itemContent);
        return _itemContent;
    }

    public boolean Item_Check_Price(ItemContent itemContent, BigDecimal price) throws RuntimeMeterException {
        return itemContent.Item_Check_UPrice(price);
    }

    public boolean Item_Check_Price(ItemContent itemContent) throws RuntimeMeterException {
        return itemContent.Item_Check_UPrice();
    }

    public boolean Total_AddItem_check(ItemContent itemContent) throws MeterException {
        return itemContent.AddValid();
    }

    public ItemContent Item_Set_Note(ItemContent itemContent, BigDecimal amount, BigDecimal price) {
        itemContent.setSpec(134);
        ItemContent _itemContent = this.Current_TradeContent().Item_Set_Note(itemContent, amount, price);
        if (_itemContent == null) {
            throw new RuntimeMeterException(MeterStateEnum.\u5185\u90e8\u6761\u7801\u65e0\u6548\u4e0d\u5141\u8bb8\u6dfb\u52a0);
        }
        _itemContent.setSpec(134);
        SerialDisplay.getInstance().setItemContentWR(_itemContent);
        return _itemContent;
    }

    public ItemContent Item_Set_Note(ItemContent itemContent, BarCodeItemResult barCIR) {
        itemContent.setSpec(134);
        ItemContent _itemContent = this.Current_TradeContent().Item_Set_Note(itemContent, barCIR);
        if (_itemContent == null) {
            throw new RuntimeMeterException(MeterStateEnum.\u5185\u90e8\u6761\u7801\u65e0\u6548\u4e0d\u5141\u8bb8\u6dfb\u52a0);
        }
        _itemContent.setSpec(134);
        SerialDisplay.getInstance().setItemContentWR(_itemContent);
        return _itemContent;
    }

    public ItemContent Total_Add_Pics(ItemContent itemContent, String ... pics) {
        itemContent.addPics(pics);
        return itemContent;
    }

    public boolean Total_AddItem(ItemContent itemContent) throws RuntimeMeterException {
        if (Objects.isNull(itemContent.getSpec())) {
            itemContent.setSpec(132);
        }
        return this.Total_Add_Item(itemContent);
    }

    public boolean Total_AddItem_Index(ItemContent itemContent) throws RuntimeMeterException {
        if (Objects.isNull(itemContent.getSpec())) {
            itemContent.setSpec(133);
        }
        return this.Total_Add_Item(itemContent);
    }

    public boolean Total_Add_Item(ItemContent itemContent) throws RuntimeMeterException {
        boolean result;
        int tms = GlobalPara.getInstance().getTMS(itemContent.spec());
        TradeContent tradeContent = this.Current_TradeContent_WOE();
        if (tms == 2 && UnitType.\u8ba1\u4ef6.equals((Object)UnitEnum.unit((Integer)itemContent.getUnit_weight()).getType()) && tradeContent.getItem() != null && !tradeContent.getItem().isEmpty()) {
            Iterator<ItemContent> iterator = tradeContent.getItem().iterator();
            while (iterator.hasNext()) {
                ItemContent next = iterator.next();
                if (next == null || !next.getPlu().getNo().equals(itemContent.getPlu().getNo()) || !Objects.nonNull(next.getPrice()) || !Objects.nonNull(itemContent.getPrice()) || !BigDecimalUtils.compareEqual((BigDecimal)next.getPrice(), (BigDecimal)itemContent.getPrice())) continue;
                itemContent = this.Item_Set_Count(itemContent, next.getAmount().add(itemContent.getAmount()));
                iterator.remove();
            }
        }
        if (result = this.ACL_Total_Add_Item(itemContent)) {
            SerialDisplay.getInstance().quitItemContent();
        }
        return result;
    }

    private boolean ACL_Total_Add_Item(ItemContent itemContent) throws RuntimeMeterException {
        this.Current_TradeContent().Total_AddItem(itemContent);
        this.Item_Print_Check(itemContent);
        this.Total_QuitItem();
        SerialDisplay.getInstance().quitItemContent();
        return true;
    }

    private void Item_Print_Check(ItemContent itemContent) {
        int fucPrint = GlobalPara.getInstance().getTMS(56);
        if (fucPrint == TMS.Fuc_Print7 && itemContent.spec() != 134 || (fucPrint == TMS.Fuc_Print8 || fucPrint == TMS.Fuc_Print9) && itemContent.spec() == 132) {
            if (GlobalPara.getInstance().isRunLog()) {
                System.out.println("Item_Print_Check Double Print Need");
            }
            try {
                TradePipeline pipeline = new TradePipeline();
                TradeContent tradeContent = pipeline.Current_TradeContent_WOE();
                tradeContent.setTradeTime(new Date());
                tradeContent.Total_AddItem(itemContent);
                pipeline.Settlement_Once(new CashSettlement(tradeContent.Total_Cal_LeftPay()));
                tradeContent.printCalculate(-1, 0);
                PrintGeneralFactory.getInstance().print_answer(tradeContent.getPrintContents(), new IPrintBack(){

                    @Override
                    public void responseBack(PrintResponse response) {
                        if (GlobalPara.getInstance().isRunLog()) {
                            System.out.println("Item_Print_Check Double Print Need" + response.toString());
                        }
                    }
                });
            }
            catch (MeterException e) {
                e.printStackTrace();
            }
        }
    }

    public TradeContent Total_Set_Discount(BigDecimal total) {
        return this.Current_TradeContent_WOE().Total_Set_Discount(total);
    }

    public boolean Total_Check_Discount(BigDecimal total) {
        return this.Current_TradeContent_WOE().Total_Check_Discount(total);
    }

    public boolean Total_Check_Discount() {
        return this.Current_TradeContent_WOE().Total_Check_Discount();
    }

    public TradeContent Settlement_All(int fid, int sid, DeviceSettlement ... settlements) throws RuntimeMeterException {
        return this.settlement(this.Current_TradeContent_WOE(), settlements).Current_TradeContent_WOE().Total_Close(fid, sid).printCalculate().Total_Log();
    }

    public TradeContent Settlement_Once(DeviceSettlement ... settlements) throws RuntimeMeterException {
        return this.settlement(this.Current_TradeContent_WOE(), settlements).Current_TradeContent_WOE();
    }

    public BigDecimal Settlement(DeviceSettlement ... settlements) throws RuntimeMeterException {
        BigDecimal pay_Available = BigDecimal.ZERO;
        if (settlements != null) {
            block7: for (DeviceSettlement settlement : settlements) {
                switch (settlement.getType()) {
                    case \u73b0\u91d1: {
                        pay_Available = pay_Available.add(((CashSettlement)settlement).cash());
                        continue block7;
                    }
                    case \u805a\u5408\u652f\u4ed8: {
                        pay_Available = pay_Available.add(((CloudPaySettlement)settlement).cloudPay());
                        continue block7;
                    }
                    case \u5409\u5361\u4e91: {
                        pay_Available = pay_Available.add(((JKYSettlement)settlement).jkyPay()).add(((JKYSettlement)settlement).jkyPay_Gift()).add(((JKYSettlement)settlement).getCash());
                        continue block7;
                    }
                    case \u5361\u4ed8: {
                        pay_Available = pay_Available.add(((CardSettlement)settlement).cardPay());
                        continue block7;
                    }
                    case \u5176\u4ed6\u652f\u4ed8: {
                        pay_Available = pay_Available.add(((OtherPaySettlement)settlement).other1()).add(((OtherPaySettlement)settlement).other2()).add(((OtherPaySettlement)settlement).other3());
                    }
                }
            }
        }
        return this.Current_TradeContent_WOE().Total_Cal_LeftPay(pay_Available);
    }

    public TradeContent Settlement(int fid, int sid) throws RuntimeMeterException {
        return this.Current_TradeContent_WOE().Total_Close(fid, sid).printCalculate().Total_Log();
    }

    public TradeContent CP_Total_UnKnow_Item(int fid, int sid) throws RuntimeMeterException {
        return this.Total_UnKnow_Item(fid, sid, CloudPaySettlement.class, "195", "CP_UN_KNOW_Pay");
    }

    public TradeContent JKY_Total_UnKnow_Item(int fid, int sid) throws RuntimeMeterException {
        return this.Total_UnKnow_Item(fid, sid, JKYSettlement.class, "65546", "JKY_UN_KNOW_Pay");
    }

    public TradeContent Card_Total_UnKnow_Item(int fid, int sid) throws RuntimeMeterException {
        return this.Total_UnKnow_Item(fid, sid, CardSettlement.class, "65537", "Card_UN_KNOW_Pay");
    }

    public TradeContent Other_Total_UnKnow_Item(int fid, int sid) throws RuntimeMeterException {
        return this.Total_UnKnow_Item(fid, sid, OtherPaySettlement.class, "65538", "Other_UN_KNOW_Pay");
    }

    public <T extends DeviceSettlement> TradeContent Total_UnKnow_Item(int fid, int sid, Class<T> settlementClazz, String errorCode, String errorMsg) throws RuntimeMeterException {
        DeviceSettlement settlement = null;
        try {
            settlement = (DeviceSettlement)((Object)settlementClazz.newInstance());
        }
        catch (Exception e) {
            settlement = new CashSettlement();
        }
        BigDecimal leftPay = this.Current_TradeContent_WOE().Total_Cal_LeftPay();
        if (settlement instanceof CloudPaySettlement) {
            ((CloudPaySettlement)settlement).setCloudPay(leftPay);
            ((CloudPaySettlement)settlement).setPayWay(PayWay.Aggregate_PAY);
            ((CloudPaySettlement)settlement).setPayType(PayType.UNKNOWN_PAY);
            ((CloudPaySettlement)settlement).setBillId("");
        } else if (settlement instanceof JKYSettlement) {
            ((JKYSettlement)settlement).setJkyPay(leftPay);
        } else if (settlement instanceof CardSettlement) {
            ((CardSettlement)settlement).setCardPay(leftPay);
        } else if (settlement instanceof OtherPaySettlement) {
            ((OtherPaySettlement)settlement).setOther1(leftPay);
        } else {
            ((CashSettlement)settlement).setCash(leftPay);
        }
        return this.settlement(this.Current_TradeContent_WOE(), settlement).Total_Error(fid, sid, errorCode, errorMsg);
    }

    public TradeContent Total_RemoveItem(int fid, int sid, Integer ... indexes) throws RuntimeMeterException {
        List<ItemContent> itemContents = this.Current_TradeContent_WOE().Total_RemoveItem(indexes);
        return this.Total_RemoveItem(fid, sid, itemContents);
    }

    public List<ItemContent> Total_RemoveItem(Integer ... indexes) throws RuntimeMeterException {
        return this.Current_TradeContent_WOE().Total_RemoveItem(indexes);
    }

    public TradeContent Total_RemoveItem(int fid, int sid, List<ItemContent> itemContents) throws RuntimeMeterException {
        return new TradePipeline(TradeType.\u6e05\u9664).Current_TradeContent().Total_AddItem(itemContents).Total_Close(fid, sid).printCalculate().Total_Log();
    }

    public TradeContent Total_Error(int fid, int sid, String error_code, String error_msg) {
        return ((TradeContent)this.Current_TradeContent_WOE().toObject(TradeContent.class)).tradeType(TradeType.\u9519\u8bef\u65e5\u5fd7).Total_Close(fid, sid, error_code, error_msg).printCalculate().Total_Log();
    }

    public TradeContent Total_New_Error(int fid, int sid, String error_code, String error_msg) {
        return new TradePipeline(TradeType.\u9519\u8bef\u65e5\u5fd7).Current_TradeContent_WOE().Total_Close(fid, sid, error_code, error_msg).printCalculate().Total_Log();
    }

    public TradeUnconfirmed Item_Unconfirmed(ItemContent itemContent, WeightResult wr, boolean cancel) throws MeterException {
        if (itemContent == null) {
            return new TradeUnconfirmed();
        }
        if (UnitType.\u8ba1\u91cd.equals((Object)UnitEnum.unit((Integer)itemContent.getPlu().getUnit()).getType())) {
            if (wr != null && itemContent.ItemHasUnconfirmed(wr) || cancel) {
                TradeContent tradeUnconfirmed = new TradePipeline(TradeType.\u672a\u786e\u8ba4).Current_TradeContent();
                ItemContent itemCodeUnconfirmed = new ItemContent(itemContent.getPlu(), tradeUnconfirmed).Item_Set_UPrice(itemContent.getPrice_Unconfirmed()).Item_Set_Weight(itemContent.getAmount_Unconfirmed(), true).Item_ReCal(tradeUnconfirmed);
                boolean add_status = tradeUnconfirmed.Total_AddItem(itemCodeUnconfirmed);
                itemContent.setAmount_Unconfirmed(BigDecimal.ZERO);
                itemContent.setPrice_Unconfirmed(BigDecimal.ZERO);
                return new TradeUnconfirmed(add_status, tradeUnconfirmed, GlobalPara.getInstance().getTMS(283) == 3);
            }
        } else {
            TradeContent tradeUnconfirmed = new TradePipeline(TradeType.\u672a\u786e\u8ba4).Current_TradeContent();
            ItemContent itemCodeUnconfirmed = new ItemContent(itemContent.getPlu(), tradeUnconfirmed).Item_Set_UPrice(itemContent.getPrice_Unconfirmed()).Item_Set_Count(itemContent.getAmount_Unconfirmed()).Item_ReCal(tradeUnconfirmed);
            boolean add_status = tradeUnconfirmed.Total_AddItem(itemCodeUnconfirmed);
            itemContent.setAmount_Unconfirmed(BigDecimal.ZERO);
            itemContent.setPrice_Unconfirmed(BigDecimal.ZERO);
            return new TradeUnconfirmed(add_status, tradeUnconfirmed, GlobalPara.getInstance().getTMS(283) == 3);
        }
        return new TradeUnconfirmed();
    }

    public TradeUnconfirmed Weight_Notify_Call(ItemContent itemContent, WeightResult wr) throws MeterException {
        return this.Item_Unconfirmed(this.Item_Set_Weight(itemContent, wr), wr, false);
    }

    public TradeContent Item_Quit(ItemContent itemContent) throws MeterException {
        TradeUnconfirmed tradeUnconfirmed = this.Item_Unconfirmed(itemContent, null, true);
        return tradeUnconfirmed != null && tradeUnconfirmed.isStatus() ? tradeUnconfirmed.getUnconfirmed() : null;
    }

    private TradePipeline Total_QuitItem() {
        WeightCal.getInstance().SetTare_PLUReset();
        GlobalPara.getInstance().getPriceUNIT_Hold();
        return this;
    }

    private TradePipeline settlement(TradeContent tradeContent, DeviceSettlement ... settlements) {
        if (settlements != null) {
            block7: for (DeviceSettlement settlement : settlements) {
                switch (settlement.getType()) {
                    case \u73b0\u91d1: {
                        tradeContent.Total_Pay_Cash(((CashSettlement)settlement).getCash());
                        continue block7;
                    }
                    case \u805a\u5408\u652f\u4ed8: {
                        CloudPaySettlement cloudPaySettlement = (CloudPaySettlement)settlement;
                        tradeContent.Total_Pay_Cloud(cloudPaySettlement.getCloudPay(), cloudPaySettlement.payWay(), cloudPaySettlement.payType(), cloudPaySettlement.getPayType().getDescription(), cloudPaySettlement.getBillId());
                        continue block7;
                    }
                    case \u5409\u5361\u4e91: {
                        JKYSettlement jkySettlement = (JKYSettlement)settlement;
                        tradeContent.Total_Pay_JKY(jkySettlement.getJkyPay().add(jkySettlement.getJkyPay_Gift()), jkySettlement.getJkyPay_Gift(), jkySettlement.getPoint(), jkySettlement.getBalanceOld(), jkySettlement.getBalanceNew(), jkySettlement.getAccount());
                        continue block7;
                    }
                    case \u5361\u4ed8: {
                        CardSettlement cardSettlement = (CardSettlement)settlement;
                        tradeContent.Total_Pay_Card(cardSettlement.getCardPay(), cardSettlement.getPoint(), cardSettlement.getBalanceOld(), cardSettlement.getBalanceNew(), cardSettlement.getId(), cardSettlement.getId_p1(), cardSettlement.getId_p2());
                        continue block7;
                    }
                    case \u5176\u4ed6\u652f\u4ed8: {
                        OtherPaySettlement otherPaySettlement = (OtherPaySettlement)settlement;
                        tradeContent.Total_Pay_Other1(otherPaySettlement.getOther1()).Total_Pay_Other2(otherPaySettlement.getOther2()).Total_Pay_Other3(otherPaySettlement.getOther3());
                    }
                }
            }
        }
        return this;
    }

    public TradeReject Item_Reject(TradeContent inputTrade, DSaleMan salesman, int ... items) throws MeterException {
        if (!TradeType.\u9500\u552e.getType().equals(inputTrade.getTradeType())) {
            return new TradeReject();
        }
        ArrayList<Object> itemContents = new ArrayList<Object>();
        if (items != null && items.length > 0) {
            for (Object object : (Object)items) {
                ItemContent itemContent = inputTrade.getItem().remove((int)object);
                if (itemContent == null || itemContent.reject()) continue;
                itemContents.add(itemContent.toObject(ItemContent.class));
                itemContent.setReject(1);
            }
        } else {
            for (ItemContent itemContent : inputTrade.getItem()) {
                if (itemContent.reject()) continue;
                itemContents.add(itemContent.toObject(ItemContent.class));
                itemContent.setReject(1);
            }
        }
        if (!itemContents.isEmpty()) {
            boolean isAll = true;
            for (ItemContent itemContent : inputTrade.getItem()) {
                isAll = isAll && itemContent.reject();
            }
            TradeContent rejectTrade = this.Create(TradeType.\u9000\u8d27, salesman).Current_TradeContent().setSource(new DSource().setFid(Integer.valueOf(inputTrade.getFid())).setTradeTime(inputTrade.getTradeTime()));
            for (ItemContent itemContent : itemContents) {
                ItemContent itemReject = new ItemContent(itemContent.getPlu(), rejectTrade);
                itemReject.Item_Set_UPrice(itemContent.getPrice()).setPrice_Original(itemContent.getPrice());
                if (UnitType.\u8ba1\u91cd.equals((Object)UnitEnum.unit((Integer)itemContent.getPlu().getUnit()))) {
                    itemReject.Item_Set_Weight(itemContent.getAmount().negate(), true);
                } else if (BigDecimalUtils.compareMoreZeroValue((BigDecimal)itemContent.getAmount_Stock())) {
                    itemContent.Item_Set_Count_Negate(itemContent.getAmount().negate()).Item_Set_Amount_Stock(itemContent.getAmount_Stock().negate());
                } else {
                    itemContent.Item_Set_Count(itemContent.getAmount().negate());
                }
                rejectTrade.Total_AddItem(itemReject);
            }
            if (isAll) {
                rejectTrade.Total_Set_Discount(inputTrade.getSurplus_Reject().negate());
                inputTrade.setSurplus_Reject(BigDecimal.ZERO);
            } else {
                BigDecimal reject_PurTax_Final = rejectTrade.getPurTax_Final().negate();
                if (BigDecimalUtils.compareValue((BigDecimal)inputTrade.getSurplus_Reject(), (BigDecimal)reject_PurTax_Final) >= 0) {
                    inputTrade.setSurplus_Reject(inputTrade.getSurplus_Reject().subtract(reject_PurTax_Final));
                } else {
                    rejectTrade.Total_Set_Discount(inputTrade.getSurplus_Reject().negate());
                    inputTrade.setSurplus_Reject(BigDecimal.ZERO);
                }
            }
            return new TradeReject(inputTrade, rejectTrade);
        }
        return new TradeReject();
    }

    public static TradeContent Add_Fid_Sid(TradeContent tradeContent, int fid, int sid) {
        tradeContent.Total_Close(fid, sid).Total_Log();
        return tradeContent;
    }

    public static TradeContent Execute_Print(TradeContent tradeContent) {
        tradeContent.printCalculate();
        return tradeContent;
    }

    public static WeightResult Weight_Info() {
        return WeightCal.getInstance().GetResult();
    }

    public static void SetTare_Button() {
        WeightCal.getInstance().SetTare_Button();
    }

    public static void SetZero_Button() {
        WeightCal.getInstance().SetZero_Button();
    }

    public static void SetZero_Force() {
        WeightCal.getInstance().SetZero_Force();
    }
}

