/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.model;

import com.jhscale.common.model.inter.GJSONModel;
import com.jhscale.common.utils.ProtectKey;
import com.jhscale.common.utils.SystemtUtils;
import com.jhscale.meter.em.WeighingMode;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.control.DeviceControl;
import com.jhscale.meter.model.device.Device;
import com.jhscale.meter.model.device.SealLeadStatus;
import com.jhscale.meter.protocol.IProtocolManager;
import com.jhscale.meter.protocol.IProtocolResponse;
import com.jhscale.meter.protocol.ad.ADScaleProtocolManager;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyRequest;
import com.jhscale.meter.protocol.ad.entity.ADPackDisassemblyResponse;
import com.jhscale.meter.protocol.ad.entity.assembly.CheckStableAndSetZeroCodeADPARequest;
import com.jhscale.meter.protocol.ad.entity.assembly.ObtainFullScaleADPARequest;
import com.jhscale.meter.protocol.ad.entity.assembly.ObtainLeadStatusADPARequest;
import com.jhscale.meter.protocol.ad.entity.assembly.ObtainVersionADPARequest;
import com.jhscale.meter.protocol.ad.entity.assembly.ObtainZeroCodeOpenADPARequest;
import com.jhscale.meter.protocol.ad.entity.assembly.SetInternalCodeZeroADPARequest;
import com.jhscale.meter.protocol.ad.entity.assembly.SetWeighingModelADPARequest;
import com.jhscale.meter.protocol.ad.entity.disassembly.CheckStableAndSetZeroCodeADPAResponse;
import com.jhscale.meter.protocol.ad.entity.disassembly.ObtainFullScaleADPDResponse;
import com.jhscale.meter.protocol.ad.entity.disassembly.ObtainLeadStatusADPDResponse;
import com.jhscale.meter.protocol.ad.entity.disassembly.ObtainVersionADPDResponse;
import com.jhscale.meter.protocol.ad.entity.disassembly.ObtainWeightADPDResponse;
import com.jhscale.meter.protocol.ad.entity.disassembly.ObtainZeroCodeOpenADPAResponse;
import com.jhscale.meter.protocol.ad.entity.disassembly.SetInternalCodeZeroADPAResponse;
import com.jhscale.meter.protocol.ad.entity.disassembly.SetWeighingModelADPDResponse;
import com.jhscale.meter.protocol.entity.IPackResponse;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.protocol.model.LeadInfo;
import com.jhscale.meter.protocol.model.SerialDisplay;
import com.jhscale.meter.protocol.model.WeightChangeNotify;
import com.jhscale.meter.protocol.model.WeightInfoNotify;
import com.jhscale.meter.protocol.model.WeightMN;
import com.jhscale.meter.protocol.model.WeightNotify;
import com.jhscale.meter.protocol.model.WeightResult;
import com.jhscale.meter.protocol.model.WeightUnitNotify;
import com.jhscale.meter.seal.SealManager;
import com.jhscale.meter.seal.cmd.ObtainStatusResponse;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang3.StringUtils;

@ApiModel(value="\u91cd\u91cf\u8ba1\u7b97")
public class WeightCal
implements IProtocolResponse,
GJSONModel {
    @ApiModelProperty(value="\u5f3a\u5236\u53bb\u76ae\u8303\u56f4", name="tareLimit")
    private BigDecimal tareLimit = null;
    @ApiModelProperty(value="lb\u6ee1\u91cf\u7a0b\u5185\u7801", name="lb_codeFull")
    private int lb_codeFull = 300000;
    @ApiModelProperty(value="lb\u91cf\u7a0b\u4fe1\u606f", name="lb_mn")
    private WeightMN lb_mn = new WeightMN(3, 60000, 30000, 0, 20, 10, 0);
    @ApiModelProperty(value="kg\u6ee1\u91cf\u7a0b\u5185\u7801", name="kg_codeFull")
    private int kg_codeFull = 300000;
    @ApiModelProperty(value="kg\u91cf\u7a0b\u4fe1\u606f", name="kg_mn")
    private WeightMN kg_mn = new WeightMN(3, 30000, 15000, 0, 10, 5, 0);
    @ApiModelProperty(value="g\u6ee1\u91cf\u7a0b\u5185\u7801", name="g_codeFull")
    private int g_codeFull = 300000;
    @ApiModelProperty(value="kg\u91cf\u7a0b\u4fe1\u606f", name="g_mn")
    private WeightMN g_mn = new WeightMN(3, 30000, 15000, 0, 10, 5, 0);
    @ApiModelProperty(value="\u6ee1\u91cf\u7a0b\u5185\u7801", name="codeFull")
    private int codeFull = 300000;
    @ApiModelProperty(value="\u5206\u5ea6\u4fe1\u606f", name="mn")
    private WeightMN mn = new WeightMN(3, 30000, 15000, 0, 10, 5, 0);
    @ApiModelProperty(value="\u6807\u5b9a\u5185\u7801", name="codeFromCalibrate")
    private int codeFromCalibrate = 0;
    @ApiModelProperty(value="\u5f00\u673a\u96f6\u70b9\u5185\u7801", name="codeOfZeroStart")
    private int codeOfZeroStart = 0;
    @ApiModelProperty(value="\u5f53\u524d\u96f6\u70b9\u5185\u7801", name="codeOfZeroCurrent")
    private int codeOfZeroCurrent = 0;
    @ApiModelProperty(value="\u5f00\u673a\u5b8c\u6210\u6807\u5fd7", name="finishOfZeroStart")
    private boolean finishOfZeroStart = false;
    @ApiModelProperty(value="\u6bdb\u91cd\u5185\u7801", name="codeOfGross")
    private int codeOfGross = 0;
    @ApiModelProperty(value="\u76ae\u91cd\u5185\u7801", name="codeOfTare")
    private int codeOfTare = 0;
    @ApiModelProperty(value="\u76ae\u91cd\u662f\u5426\u9884\u7f6e", name="tareIsPreset")
    private boolean tareIsPreset = false;
    @ApiModelProperty(value="\u76ae\u91cd\u5185\u7801_\u624b\u52a8", name="codeOfTare_Manual")
    private int codeOfTare_Manual = 0;
    @ApiModelProperty(value="\u76ae\u91cd\u5185\u7801_PLU", name="codeOfTare_PLU")
    private int codeOfTare_PLU = 0;
    @ApiModelProperty(value="\u7a33\u5b9a", name="stable")
    private boolean stable = true;
    @ApiModelProperty(value="ADC\u9519\u8bef", name="adc")
    private boolean adc = false;
    @ApiModelProperty(value="\u5df2\u4f7f\u7528\u7684\u91cd\u91cf", name="usedGross")
    private BigDecimal usedGross = BigDecimal.ZERO;
    @ApiModelProperty(value="\u5df2\u4f7f\u7528\u91cd\u91cf\u5bf9\u5e94\u7684PLU", name="usedGross_PLU")
    private int usedGross_PLU = 0;
    @ApiModelProperty(value="\u5df2\u4f7f\u7528\u540e\u7684\u6700\u5c0f\u91cd\u91cf", name="minAfterUsedGross")
    private BigDecimal minAfterUsedGross = BigDecimal.ZERO;
    @ApiModelProperty(value="\u65b0\u7ed3\u679c", name="newResult")
    private boolean newResult = false;
    @ApiModelProperty(value="\u91cd\u91cf\u96f6\u70b9", name="weightZero")
    public BigDecimal weightZero = new BigDecimal("0.000");
    @ApiModelProperty(value="\u91cd\u91cf\u6ee1\u91cf\u7a0b", name="weightFull_0")
    public BigDecimal weightFull_0 = new BigDecimal("30.000");
    @ApiModelProperty(value="\u91cd\u91cf\u91cf\u7a0b1", name="weightFull_1")
    public BigDecimal weightFull_1 = new BigDecimal("30.000");
    @ApiModelProperty(value="\u91cd\u91cf\u91cf\u7a0b2", name="weightFull_2")
    public BigDecimal weightFull_2 = new BigDecimal("30.000");
    @ApiModelProperty(value="\u91cd\u91cf\u5206\u5ea60", name="weightDegree_0")
    public BigDecimal weightDegree_0 = new BigDecimal("0.010");
    @ApiModelProperty(value="\u91cd\u91cf\u5206\u5ea61", name="weightDegree_1")
    public BigDecimal weightDegree_1 = new BigDecimal("0.010");
    @ApiModelProperty(value="\u91cd\u91cf\u5206\u5ea62", name="weightDegree_2")
    public BigDecimal weightDegree_2 = new BigDecimal("0.010");
    @ApiModelProperty(value="\u7cfb\u7edf\u91cd\u91cf\u5355\u4f4d", name="weightUNIT")
    private int weightUNIT = 3;
    @ApiModelProperty(value="\u7cbe\u5ea6\u6570\u503c", name="maxDegrees")
    private int maxDegrees = 3000;
    @ApiModelProperty(value="\u7a33\u5b9a\u5185\u7801\u6570", name="codeForStable")
    private int codeForStable = 50;
    @ApiModelProperty(value="\u8ddf\u96f6\u5185\u7801\u6570", name="codeForZeroTrack")
    private int codeForZeroTrack = 50;
    @ApiModelProperty(value="\u5224\u96f6\u5185\u7801\u6570", name="codeForZeroJudge")
    private int codeForZeroJudge = 50;
    @ApiModelProperty(value="\u96f6\u70b9\u5224\u5b9a\u5728\u51c0\u91cd\u6267\u884c", name="zeroJudge_InNET")
    private boolean zeroJudge_InNET = false;
    private static final int[] const_division = new int[]{1, 2, 2, 5, 5, 10, 10, 20, 20, 50, 50, 100, 100, 200, 200};
    private static final int[] const_division_mid = new int[]{1, 1, 2, 2, 5, 5, 10, 10, 20, 20, 50, 50, 100, 100, 200};
    private static final int[] const_cap_p1 = new int[]{0, 2, 5, 6, 8, 10, 15, 15, 16, 20, 25, 25, 25, 30, 30, 30, 35, 35, 40, 40, 40, 45, 45, 50, 50, 50, 55, 55, 60, 60, 60, 70, 70, 70, 80, 80, 80, 80, 90, 90, 90, 90, 90, 90, 90, 90, 95, 95, 100, 100, 100, 110, 110, 120, 120, 130, 130, 140, 140, 140, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 160, 170, 180, 190, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200};
    private static final int[] const_cap_p2 = new int[]{0, 5, 10, 15, 20, 25, 30, 30, 35, 40, 50, 50, 50, 60, 60, 60, 80, 80, 80, 90, 90, 90, 90, 100, 100, 100, 110, 120, 130, 140, 150, 150, 150, 160, 160, 160, 160, 170, 180, 190, 200, 200, 200, 200, 200, 200, 210, 220, 230, 240, 250, 250, 250, 250, 250, 260, 260, 270, 280, 290, 300, 300, 300, 300, 300, 300, 300, 300, 300, 300, 300, 300, 300, 300, 300, 300, 320, 320, 330, 340, 350, 350, 350, 350, 350, 350, 350, 350, 400, 400, 400, 400, 400, 400, 400, 400, 400, 400, 400, 400};
    private IProtocolManager protocolManager;
    private List<WeightNotify> weightNotifies;
    private boolean run;
    private Timer leadStatusTimer;
    private ProtectKey.Token token;
    private ProtectKey.Token temp;
    private boolean debug;
    private boolean upgrade;
    private int last_Cap = 30000;
    private int last_Dot = 3;
    private int last_Div = 6;
    private boolean last_Init = false;
    private int cameraStatus = 0;
    private int ai_Status = 0;
    private int ai_Step = 0;
    private BigDecimal ai_LastWeight = BigDecimal.ZERO;

    private WeightCal() {
    }

    public static WeightCal getInstance() {
        return SingleWeightCal.SINGLETON;
    }

    public boolean isRun() {
        return this.run;
    }

    public void setRun(boolean run) {
        this.run = run;
    }

    public BigDecimal getUsedGross() {
        return this.usedGross;
    }

    public BigDecimal getTareLimit() {
        return this.tareLimit;
    }

    public void setTareLimit(BigDecimal tareLimit) {
        this.tareLimit = tareLimit;
    }

    public WeightCal Init_Manager(DeviceControl control, Device device) throws MeterException {
        if (Objects.isNull(control)) {
            throw new MeterException(MeterStateEnum.\u63a7\u5236\u5668\u4e0d\u5b58\u5728);
        }
        if (Objects.isNull(device)) {
            throw new MeterException(MeterStateEnum.\u901a\u8baf\u8bbe\u5907\u4e0d\u5b58\u5728);
        }
        this.protocolManager = new ADScaleProtocolManager().initPortmanager(control, device, this);
        this.protocolManager.openPort();
        this.debug = false;
        this.Init_Command();
        this.schedule();
        return this;
    }

    public WeightCal close() throws MeterException {
        if (this.protocolManager != null) {
            this.protocolManager.closePort();
        }
        if (this.leadStatusTimer != null) {
            this.leadStatusTimer.cancel();
        }
        this.token = null;
        this.temp = null;
        this.debug = false;
        if (this.weightNotifies != null) {
            this.weightNotifies = null;
        }
        return this;
    }

    public boolean isUpgrade() {
        return this.upgrade;
    }

    public void setUpgrade(boolean upgrade) {
        this.upgrade = upgrade;
    }

    private void schedule() {
        if (!GlobalPara.getInstance().Lead_Check()) {
            return;
        }
        try {
            String value = GlobalPara.getInstance().db_find("LEAD");
            if (StringUtils.isNotBlank((CharSequence)value)) {
                if (SealManager.getInstance().validate()) {
                    GlobalPara.getInstance().db_delete("LEAD");
                } else {
                    this.token = new ProtectKey.Token(value);
                }
            }
        }
        catch (Exception e) {
            System.out.printf("Schedule Error: %s%n", e.getMessage());
        }
        this.leadStatusTimer = new Timer();
        this.leadStatusTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!WeightCal.this.upgrade) {
                    WeightCal.this.obtainLeadStatus();
                }
            }
        }, 5000L, 30000L);
    }

    public LeadInfo leadInfo() {
        return this.token != null ? new LeadInfo(this.token.getT2(), GlobalPara.getInstance().getSystemID()) : null;
    }

    public LeadInfo tempLeadInfo() {
        this.temp = ProtectKey.obtainToken((int)3);
        return new LeadInfo(this.temp.getT2(), GlobalPara.getInstance().getSystemID());
    }

    public synchronized boolean firstLog() {
        boolean first;
        boolean bl = first = this.token != null && !this.token.getAndSet();
        if (first) {
            GlobalPara.getInstance().db_insert("LEAD", this.token.content());
        }
        return first;
    }

    public boolean leadCheck(String t1) {
        SealLeadStatus status;
        if (this.token == null) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)t1) && t1.equals(this.token.getT1()) && Objects.nonNull(status = this.obtainLeadStatus()) && status.isStatus()) {
            this.token = null;
            GlobalPara.getInstance().db_delete("LEAD");
            return true;
        }
        return false;
    }

    public boolean leadCheck() {
        if (this.token == null) {
            return true;
        }
        SealLeadStatus status = this.obtainLeadStatus();
        if (Objects.nonNull(status) && status.isStatus()) {
            this.token = null;
            GlobalPara.getInstance().db_delete("LEAD");
            return true;
        }
        return false;
    }

    public boolean tempLeadCheck(String t1) {
        if (this.temp == null || StringUtils.isBlank((CharSequence)t1)) {
            return false;
        }
        if (t1.equals(this.temp.getT1())) {
            this.debug = true;
            return true;
        }
        return false;
    }

    public SealLeadStatus obtainLeadStatus() {
        boolean result = GlobalPara.getInstance().Lead_Check();
        if (!result) {
            return new SealLeadStatus().setStatus(true);
        }
        if (SealManager.getInstance().validate()) {
            ObtainStatusResponse statusResponse = SealManager.getInstance().status();
            if (statusResponse != null && !statusResponse.statusOK() && this.token == null) {
                GlobalPara.getInstance().Write_Log("\u84dd\u7259\u94c5\u5c01", statusResponse.toJSON());
                this.token = ProtectKey.obtainToken((int)3);
                GlobalPara.getInstance().db_insert("LEAD", this.token.content());
            }
            return new SealLeadStatus().setStatus(statusResponse == null || statusResponse.statusOK()).setContent(Objects.nonNull(statusResponse) ? statusResponse.getStatus() : null).setId(Objects.nonNull(statusResponse) ? statusResponse.getUid() : null);
        }
        ObtainLeadStatusADPDResponse execute = this.execute(new ObtainLeadStatusADPARequest(), ObtainLeadStatusADPDResponse.class);
        if (execute != null && execute.getResult().isResult() && this.token == null) {
            GlobalPara.getInstance().Write_Log("\u4eea\u8868\u94c5\u5c01", execute.toJSON());
            this.token = ProtectKey.obtainToken((int)3);
            GlobalPara.getInstance().db_insert("LEAD", this.token.content());
        }
        return new SealLeadStatus().setStatus(execute == null || !execute.getResult().isResult());
    }

    public <T extends ADPackDisassemblyResponse> T execute(ADPackAssemblyRequest request, Class<T> clazz) {
        if (this.protocolManager == null) {
            return null;
        }
        final ADPackDisassemblyResponse[] responses = new ADPackDisassemblyResponse[1];
        try {
            this.protocolManager.execute(request, new IProtocolResponse<T>(){

                @Override
                public void target(T target) throws MeterException {
                    responses[0] = target;
                }

                @Override
                public void exp(MeterException e) {
                }
            });
            for (int count = 1; count < 5 && responses[0] == null; ++count) {
                SystemtUtils.sleep((int)1);
            }
            return (T)responses[0];
        }
        catch (MeterException e) {
            System.err.printf("WeightCal_Err: %s%n", e.getMessage());
            return null;
        }
    }

    public void Init_Command() throws MeterException {
        this.protocolManager.execute(new SetWeighingModelADPARequest(WeighingMode.Wave_Internal_Continuous), new IProtocolResponse<SetWeighingModelADPDResponse>(){

            @Override
            public void target(SetWeighingModelADPDResponse target) throws MeterException {
                if (GlobalPara.getInstance().isRunLog()) {
                    System.out.println("\u8bbe\u7f6e\u79e4\u91cd\u6a21\u5f0f \u54cd\u5e94\uff1a" + target.toJSON());
                }
            }

            @Override
            public void exp(MeterException e) {
            }
        });
        SystemtUtils.sleep((int)1);
        this.protocolManager.execute(new ObtainVersionADPARequest(), new IProtocolResponse<ObtainVersionADPDResponse>(){

            @Override
            public void target(ObtainVersionADPDResponse target) throws MeterException {
                if (GlobalPara.getInstance().isRunLog()) {
                    System.out.println("\u8bfb\u53d6\u7248\u672c \u54cd\u5e94\uff1a" + target.toJSON());
                }
            }

            @Override
            public void exp(MeterException e) {
            }
        });
        SystemtUtils.sleep((int)1);
        final ObtainFullScaleADPDResponse[] responses = new ObtainFullScaleADPDResponse[1];
        for (int count = 0; count < 5 && responses[0] == null; ++count) {
            SystemtUtils.sleep((int)1);
            this.protocolManager.execute(new ObtainFullScaleADPARequest(), new IProtocolResponse<ObtainFullScaleADPDResponse>(){

                @Override
                public void target(ObtainFullScaleADPDResponse target) throws MeterException {
                    if (GlobalPara.getInstance().isRunLog()) {
                        System.out.println("\u6ee1\u91cf\u7a0b\u8bfb\u53d6\u547d\u4ee4 \u54cd\u5e94\uff1a" + target.toJSON());
                    }
                    responses[0] = target;
                }

                @Override
                public void exp(MeterException e) {
                }
            });
        }
        if (responses[0] == null) {
            throw new MeterException(MeterStateEnum.AD_\u79e4\u53f0\u901a\u8baf\u521d\u59cb\u5316\u5f02\u5e38);
        }
        this.Init_Cap(responses[0].getScale(), responses[0].getFloa(), responses[0].getDivision().getDivision());
    }

    public IProtocolManager getProtocolManager() {
        return this.protocolManager;
    }

    public WeightCal Init_Notifies(WeightNotify ... weightNotifies) {
        if (weightNotifies != null && weightNotifies.length > 0) {
            return this.Init_Notifies(Arrays.asList(weightNotifies));
        }
        return this;
    }

    public WeightCal Init_Notifies(List<WeightNotify> weightNotifies) {
        if (weightNotifies != null && !weightNotifies.isEmpty()) {
            if (this.weightNotifies == null) {
                this.weightNotifies = new ArrayList<WeightNotify>();
            }
            Iterator<WeightNotify> iterator = weightNotifies.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                iterator.remove();
            }
            if (!weightNotifies.isEmpty()) {
                this.weightNotifies.addAll(weightNotifies);
            }
        }
        return this;
    }

    public WeightCal Remove_Notify(WeightNotify weightNotify) {
        if (Objects.nonNull(weightNotify) && Objects.nonNull((Object)weightNotify.identify()) && this.weightNotifies != null && !this.weightNotifies.isEmpty()) {
            Iterator<WeightNotify> iterator = this.weightNotifies.iterator();
            while (iterator.hasNext()) {
                if (!((Object)((Object)weightNotify.identify())).equals((Object)iterator.next().identify())) continue;
                iterator.remove();
                break;
            }
        }
        return this;
    }

    private void COM_Get_ZeroInfo(final int codeFromCalibrate) {
        try {
            this.protocolManager.execute(new ObtainZeroCodeOpenADPARequest(), new IProtocolResponse<ObtainZeroCodeOpenADPAResponse>(){

                @Override
                public void target(ObtainZeroCodeOpenADPAResponse target) throws MeterException {
                    int range;
                    WeightCal.this.codeOfZeroStart = target.getZeroCode();
                    int flag = target.getFlag();
                    WeightCal.this.finishOfZeroStart = (flag & 2) != 0;
                    if (!WeightCal.this.finishOfZeroStart && codeFromCalibrate <= (range = WeightCal.this.codeFull * (GlobalPara.getInstance().getTMS(220) % 100) / 100) && codeFromCalibrate >= -range) {
                        WeightCal.this.COM_SetZero(codeFromCalibrate);
                    }
                    if (GlobalPara.getInstance().isRunLog()) {
                        System.out.printf("\u521d\u59cb\u5316\u96f6\u70b9:%s|%s%n", WeightCal.this.codeOfZeroStart, WeightCal.this.finishOfZeroStart);
                    }
                }

                @Override
                public void exp(MeterException e) {
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int ParaCal_e_10(int value) {
        return (value * this.mn.getDivision_2() * this.codeFull + 5 * this.mn.getCapacity_0()) / (10 * this.mn.getCapacity_0());
    }

    private void COM_Set_CodesInfo() {
        CheckStableAndSetZeroCodeADPARequest request = new CheckStableAndSetZeroCodeADPARequest();
        request.setStable(this.codeForStable);
        request.setZero(this.codeForZeroTrack);
        try {
            this.protocolManager.execute(request, new IProtocolResponse<CheckStableAndSetZeroCodeADPAResponse>(){

                @Override
                public void target(CheckStableAndSetZeroCodeADPAResponse target) throws MeterException {
                    if (GlobalPara.getInstance().isRunLog()) {
                        System.out.println("\u521d\u59cb\u5316\u96f6\u70b9\u7a33\u5b9a\u4fe1\u606f\u5b8c\u6210");
                    }
                }

                @Override
                public void exp(MeterException e) {
                    System.err.println("\u521d\u59cb\u5316\u96f6\u70b9\u7a33\u5b9a\u4fe1\u606f\u547d\u4ee4 \u5f02\u5e38:---" + e.getMessage());
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void COM_SetZero(int code) {
        SetInternalCodeZeroADPARequest request = new SetInternalCodeZeroADPARequest();
        request.setZero(code);
        try {
            this.protocolManager.execute(request, new IProtocolResponse<SetInternalCodeZeroADPAResponse>(){

                @Override
                public void target(SetInternalCodeZeroADPAResponse target) throws MeterException {
                    if (GlobalPara.getInstance().isRunLog()) {
                        System.out.printf("\u5185\u7801\u7f6e\u96f6\u5b8c\u6210: %s%n", target.toJSON());
                    }
                }

                @Override
                public void exp(MeterException e) {
                    System.err.println("\u5185\u7801\u7f6e\u96f6\u547d\u4ee4 \u5f02\u5e38:---" + e.getMessage());
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public WeightCal ParaCal() {
        this.weightUNIT = GlobalPara.getInstance().getWeightUNIT();
        if (this.weightUNIT == 6) {
            this.mn = this.lb_mn;
            this.codeFull = this.lb_codeFull;
        } else if (this.weightUNIT == 4) {
            this.mn = this.g_mn;
            this.codeFull = this.g_codeFull;
        } else {
            this.mn = this.kg_mn;
            this.codeFull = this.kg_codeFull;
        }
        this.maxDegrees = this.mn.getCapacity_0() / this.mn.getDivision_2();
        int value = GlobalPara.getInstance().getTMS(223);
        boolean bl = this.zeroJudge_InNET = value >= 100 && value < 200;
        if ((value %= 100) < 2) {
            value = 2;
        }
        this.codeForZeroJudge = this.ParaCal_e_10(value);
        value = GlobalPara.getInstance().getTMS(224);
        if (this.maxDegrees <= 4000) {
            if (value < 4) {
                value = 4;
            }
        } else if (this.maxDegrees < 8000) {
            if (value < 7) {
                value = 7;
            }
        } else if (this.maxDegrees < 16000) {
            if (value < 20) {
                value = 20;
            }
        } else if (value < 35) {
            value = 35;
        }
        this.codeForZeroTrack = this.ParaCal_e_10(value);
        this.codeForStable = this.ParaCal_e_10(GlobalPara.getInstance().getTMS(225));
        this.COM_Set_CodesInfo();
        this.weightZero = BigDecimal.ZERO.movePointLeft(this.mn.getDot());
        this.weightFull_0 = new BigDecimal(this.mn.getCapacity_0()).movePointLeft(this.mn.getDot());
        this.weightFull_1 = new BigDecimal(this.mn.getCapacity_1()).movePointLeft(this.mn.getDot());
        this.weightFull_2 = new BigDecimal(this.mn.getCapacity_2()).movePointLeft(this.mn.getDot());
        this.weightDegree_0 = new BigDecimal(this.mn.getDivision_0()).movePointLeft(this.mn.getDot());
        this.weightDegree_1 = new BigDecimal(this.mn.getDivision_1()).movePointLeft(this.mn.getDot());
        this.weightDegree_2 = new BigDecimal(this.mn.getDivision_2()).movePointLeft(this.mn.getDot());
        return this;
    }

    public void ReInit() {
        if (this.last_Init) {
            this.Init_Cap(this.last_Cap, this.last_Dot, this.last_Div);
        }
        if (this.weightNotifies != null && !this.weightNotifies.isEmpty()) {
            for (WeightNotify weightNotify : this.weightNotifies) {
                if (!(weightNotify instanceof WeightUnitNotify)) continue;
                ((WeightUnitNotify)weightNotify).unit_change();
                break;
            }
        }
    }

    public WeightCal Init_Cap(int cap, int dot, int div) {
        this.last_Cap = cap;
        this.last_Dot = dot;
        this.last_Div = div;
        this.last_Init = true;
        int spec213 = GlobalPara.getInstance().getTMS(213);
        BigDecimal kgCap = new BigDecimal(cap).movePointLeft(dot);
        int zeronumber = 1;
        int headvalue = cap;
        if (headvalue < 0) {
            headvalue = -headvalue;
        }
        while (headvalue > 99) {
            headvalue /= 10;
            zeronumber *= 10;
        }
        if (headvalue == 0) {
            headvalue = 30;
            zeronumber = 1000;
        }
        int headvalue_p1 = const_cap_p1[headvalue];
        int headvalue_p2 = const_cap_p2[headvalue];
        if (zeronumber < 100) {
            zeronumber = 100;
        }
        if (div < 0 || div > 10) {
            div = headvalue * zeronumber < 10000 ? 0 : 6;
        }
        if (spec213 >= 0 && spec213 <= 6) {
            int dvalue = headvalue * zeronumber / 3000;
            dvalue = dvalue < 2 ? 0 : (dvalue < 5 ? 2 : (dvalue < 10 ? 4 : (dvalue < 20 ? 6 : (dvalue < 50 ? 8 : (dvalue < 100 ? 10 : (dvalue < 200 ? 12 : 14))))));
            if (spec213 == 1) {
                --dvalue;
            } else if (spec213 == 2) {
                dvalue -= 3;
            } else if (spec213 == 3) {
                dvalue -= 5;
            } else if (spec213 == 4) {
                dvalue -= 2;
            } else if (spec213 == 5) {
                dvalue -= 4;
            } else if (spec213 == 6) {
                dvalue -= 6;
            }
            if (dvalue < 0) {
                dvalue = 0;
            }
            div = dvalue;
        }
        if (dot < 0 || dot > 7) {
            dot = 0;
        }
        this.kg_mn = GlobalPara.getInstance().get_WeightMN(kgCap, spec213, 3);
        if (this.kg_mn == null) {
            this.kg_mn = new WeightMN(dot, headvalue * zeronumber, headvalue_p2 * zeronumber / 10, 0, const_division[div], const_division_mid[div], 0);
        }
        this.g_mn = GlobalPara.getInstance().get_WeightMN(kgCap, spec213, 4);
        if (this.g_mn == null) {
            this.g_mn = new WeightMN(dot - 3, headvalue * zeronumber, headvalue_p2 * zeronumber / 10, 0, const_division[div], const_division_mid[div], 0);
        }
        this.lb_mn = GlobalPara.getInstance().get_WeightMN(kgCap, spec213, 6);
        if (this.lb_mn == null) {
            this.lb_mn = new WeightMN(dot, headvalue_p1 * zeronumber, headvalue * zeronumber, 0, const_division[div + 2], const_division_mid[div + 2], 0);
        }
        this.kg_codeFull = new BigDecimal(300000).multiply(new BigDecimal(this.kg_mn.getCapacity_0())).divide(new BigDecimal(cap), 0, 4).intValue();
        this.g_codeFull = new BigDecimal(300000).multiply(new BigDecimal(this.g_mn.getCapacity_0())).divide(new BigDecimal(cap), 0, 4).intValue();
        this.lb_codeFull = new BigDecimal("136077.6").multiply(new BigDecimal(this.lb_mn.getCapacity_0())).divide(new BigDecimal(cap), 0, 4).intValue();
        this.ParaCal();
        return this;
    }

    private BigDecimal Cal_Code_To_CurrentDegree(int code) {
        long calbuf = (long)code * (long)this.mn.getCapacity_0();
        long cc_calbuf_1 = (long)this.codeFull * (long)this.mn.getCapacity_1();
        long cc_calbuf_2 = (long)this.codeFull * (long)this.mn.getCapacity_2();
        int ctDivision = calbuf < cc_calbuf_2 ? this.mn.getDivision_2() : (calbuf < cc_calbuf_1 ? this.mn.getDivision_1() : this.mn.getDivision_0());
        return new BigDecimal(ctDivision).movePointLeft(this.mn.getDot());
    }

    private BigDecimal Cal_Code_To_Value(int code, boolean toTrack) {
        long calbuf = (long)code * (long)this.mn.getCapacity_0();
        long cc_calbuf_1 = (long)this.codeFull * (long)this.mn.getCapacity_1();
        long cc_calbuf_2 = (long)this.codeFull * (long)this.mn.getCapacity_2();
        int ctDivision = calbuf < cc_calbuf_2 ? this.mn.getDivision_2() : (calbuf < cc_calbuf_1 ? this.mn.getDivision_1() : this.mn.getDivision_0());
        if (toTrack && code <= this.codeForZeroJudge && code >= -this.codeForZeroJudge) {
            calbuf = 0L;
        } else {
            calbuf = calbuf > 0L ? (calbuf += (long)(this.codeFull * ctDivision / 2)) : (calbuf -= (long)(this.codeFull * ctDivision / 2));
            calbuf /= (long)(this.codeFull * ctDivision);
        }
        return new BigDecimal(calbuf * (long)ctDivision).movePointLeft(this.mn.getDot());
    }

    private BigDecimal Cal_Code_To_Value(int code) {
        return this.Cal_Code_To_Value(code, false);
    }

    private int Cal_Value_To_Code(BigDecimal value) {
        this.mn = this.weightUNIT == 6 ? this.lb_mn : (this.weightUNIT == 4 ? this.g_mn : this.kg_mn);
        return value.multiply(new BigDecimal(this.codeFull)).divide(new BigDecimal(this.mn.getCapacity_0()).movePointLeft(this.mn.getDot()), 0, 4).intValue();
    }

    public WeightCal SetTare_ClearAll() {
        this.codeOfTare = 0;
        this.codeOfTare_PLU = 0;
        this.codeOfTare_Manual = 0;
        return this;
    }

    public int SetTare_Button() {
        return this.SetTare_Code_Current(3);
    }

    private int SetTare_Code_Current(int m1p2) {
        if (!this.stable) {
            return 3;
        }
        if (GlobalPara.getInstance().getTMS(227) == 1 && this.codeOfTare > 0) {
            if (this.codeOfGross > 0) {
                return 4;
            }
            return this.SetTare_Code_M1P2(m1p2, 0);
        }
        if (this.codeOfGross > 0) {
            if (GlobalPara.getInstance().getTMS(227) == 0 && this.codeOfGross < this.codeOfTare) {
                return 5;
            }
            return this.SetTare_Code_M1P2(m1p2, this.codeOfGross);
        }
        this.codeOfTare_Manual = this.codeOfGross;
        this.SetTare_Update();
        return 0;
    }

    private int SetTare_Code_M1P2(int m1p2, int code) {
        BigDecimal dis = this.Cal_Code_To_Value(code);
        if (dis.compareTo(BigDecimal.ZERO) <= 0) {
            code = 0;
        } else {
            int spec = GlobalPara.getInstance().getTMS(226);
            if (this.tareLimit != null && dis.compareTo(this.tareLimit) > 0) {
                return 1;
            }
            if ((spec & 1) == 0 && dis.compareTo(this.weightFull_2) > 0) {
                return 1;
            }
            spec = GlobalPara.getInstance().getTMS(219);
            if (spec > 0 && (spec < 100 ? dis.compareTo(this.Cal_Code_To_Value(this.codeFull * spec / 100)) > 0 : (spec <= 200 ? dis.compareTo(this.Cal_Code_To_Value(this.codeFull * (spec - 100) / 100)) >= 0 : (spec <= 210 ? dis.compareTo(this.Cal_Code_To_Value(this.codeFull / (spec - 200))) > 0 : spec <= 220 && dis.compareTo(this.Cal_Code_To_Value(this.codeFull / (spec - 210))) >= 0)))) {
                return 2;
            }
        }
        if ((m1p2 & 1) != 0) {
            this.codeOfTare_Manual = code;
        }
        if ((m1p2 & 2) != 0) {
            this.codeOfTare_PLU = code;
        }
        this.SetTare_Update();
        return 0;
    }

    private boolean SetZero_PercentTest(int code, int percent) {
        int lowwer;
        int upper;
        code = this.Cal_Value_To_Code(this.Cal_Code_To_Value(this.codeFromCalibrate - code));
        if (percent <= 100) {
            upper = percent * this.codeFull / 100;
            lowwer = -upper;
        } else if (percent <= 199) {
            upper = percent % 10 * this.codeFull / 100;
            lowwer = (percent / 10 - 10) * this.codeFull / 100;
        } else if (percent / 10000 == 1) {
            upper = percent % 100 * this.codeFull / 100;
            lowwer = percent / 100 % 100 * this.codeFull / 100;
        } else {
            return false;
        }
        return code >= lowwer && code <= upper;
    }

    public int SetZero_Button() {
        if (!this.stable) {
            return 1;
        }
        if (!this.finishOfZeroStart) {
            return 2;
        }
        int tms221 = GlobalPara.getInstance().getTMS(221);
        int tms222 = GlobalPara.getInstance().getTMS(222);
        int tms286 = GlobalPara.getInstance().getTMS(286);
        if ((tms221 == 0 || this.SetZero_PercentTest(this.codeOfZeroCurrent, tms221)) && (tms222 == 0 || this.SetZero_PercentTest(this.codeOfZeroStart, tms222)) && (tms286 != 1 || this.codeOfTare_Manual == 0 && this.codeOfTare_PLU == 0)) {
            this.SetZero_Force();
            return 0;
        }
        return 3;
    }

    public void SetZero_Force() {
        this.COM_SetZero(this.codeFromCalibrate);
    }

    public WeightCal SetTare_PLUReset() {
        this.SetTare_Code_M1P2(2, 0);
        return this;
    }

    public int SetTare_PLUValue(BigDecimal tare) {
        return this.SetTare_Code_M1P2(2, this.Cal_Value_To_Code(tare));
    }

    private void SetTare_Update() {
        int ctTare;
        int tms68 = GlobalPara.getInstance().getTMS(68);
        boolean ctPreset = false;
        if (tms68 == 0) {
            ctTare = this.codeOfTare_Manual;
        } else if (tms68 == 2) {
            if (this.codeOfTare_PLU == 0) {
                ctTare = this.codeOfTare_Manual;
            } else {
                ctTare = this.codeOfTare_PLU;
                ctPreset = true;
            }
        } else if (tms68 == 3) {
            ctTare = this.codeOfTare_PLU;
            ctPreset = true;
        } else if (this.codeOfTare_Manual == 0) {
            ctTare = this.codeOfTare_PLU;
            ctPreset = true;
        } else {
            ctTare = this.codeOfTare_Manual;
        }
        BigDecimal tv = this.Cal_Code_To_Value(ctTare);
        if (tv.compareTo(BigDecimal.ZERO) == 0) {
            ctTare = 0;
            ctPreset = false;
        }
        this.codeOfTare = ctTare;
        this.tareIsPreset = ctPreset;
    }

    public WeightResult GetResult() {
        BigDecimal degree;
        int validType;
        int cdNet;
        boolean ctZero;
        int cdGross = this.codeOfGross;
        int cdTare = this.codeOfTare;
        boolean ctIsPreset = this.tareIsPreset;
        if (cdGross < this.codeForZeroJudge && cdGross > -this.codeForZeroJudge) {
            ctZero = true;
            cdGross = 0;
            cdNet = -cdTare;
        } else {
            cdNet = cdGross - cdTare;
            if (cdNet < this.codeForZeroJudge && cdNet > -this.codeForZeroJudge) {
                ctZero = this.zeroJudge_InNET;
                cdNet = 0;
                cdGross = cdTare;
            } else {
                ctZero = false;
            }
        }
        BigDecimal ctTare = this.Cal_Code_To_Value(cdTare);
        BigDecimal ctGross = this.Cal_Code_To_Value(cdGross, true);
        BigDecimal ctNet = this.Cal_Code_To_Value(cdNet, true);
        if (this.token != null && !this.debug) {
            validType = 50;
        } else if (!this.finishOfZeroStart) {
            validType = 5;
        } else {
            int minusDeg = GlobalPara.getInstance().getTMS(216);
            int plusDeg = GlobalPara.getInstance().getTMS(215);
            int saleDeg = GlobalPara.getInstance().getTMS(217);
            validType = minusDeg > 0 && ctGross.add(this.weightDegree_2.multiply(new BigDecimal(minusDeg))).compareTo(BigDecimal.ZERO) < 0 ? 3 : (plusDeg > 0 && ctGross.subtract(this.weightDegree_0.multiply(new BigDecimal(plusDeg))).compareTo(this.weightFull_0) > 0 ? 4 : (ctGross.compareTo(BigDecimal.ZERO) <= 0 || ctGross.compareTo(this.weightFull_0) > 0 ? 2 : (ctNet.compareTo(BigDecimal.ZERO) <= 0 ? 2 : (saleDeg > 0 && ctGross.compareTo(this.weightDegree_2.multiply(new BigDecimal(saleDeg))) < 0 ? 1 : 0))));
        }
        int tms103 = GlobalPara.getInstance().getTMS(103);
        if (tms103 == 1) {
            ctTare = ctGross.subtract(ctNet);
        } else if (tms103 == 2) {
            ctNet = ctGross.subtract(ctTare);
        } else if (tms103 == 3) {
            ctGross = ctNet.add(ctTare);
        }
        if (this.minAfterUsedGross.compareTo(ctGross) < 0) {
            this.minAfterUsedGross = ctGross;
        }
        int zeroBackDegree = GlobalPara.getInstance().getTMS(234);
        if (this.usedGross.compareTo(BigDecimal.ZERO) > 0) {
            int vau = Integer.min(zeroBackDegree, Integer.max(GlobalPara.getInstance().getTMS(217), 1) - 1);
            if (ctGross.compareTo(this.weightDegree_2.multiply(new BigDecimal(vau))) <= 0) {
                this.usedGross = BigDecimal.ZERO;
            } else if (GlobalPara.getInstance().getTMS(68) <= 1 && ctNet.compareTo(BigDecimal.ZERO) <= 0) {
                this.usedGross = BigDecimal.ZERO;
            } else if (zeroBackDegree > 16 && this.usedGross.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal va = this.usedGross.multiply(new BigDecimal(32 - zeroBackDegree)).divide(new BigDecimal(16));
                if (this.usedGross.subtract(this.minAfterUsedGross).compareTo(va) > 0 && ctGross.subtract(this.minAfterUsedGross).compareTo(va) > 0) {
                    this.usedGross = BigDecimal.ZERO;
                }
            }
        }
        int NoZeroBackCheck = GlobalPara.getInstance().getTMS(69);
        boolean needBackZero = this.usedGross.compareTo(BigDecimal.ZERO) == 0 ? false : (NoZeroBackCheck == 2 ? false : (NoZeroBackCheck == 1 ? ctGross.compareTo(this.usedGross.add(degree = this.Cal_Code_To_CurrentDegree(cdNet))) > 0 || ctGross.compareTo(this.usedGross.subtract(degree)) < 0 : true));
        WeightResult result = new WeightResult();
        result.setAdc(this.adc);
        result.setFinishOfZeroStart(this.finishOfZeroStart);
        result.setUnit(this.weightUNIT);
        result.setStable(this.stable);
        result.setZero(ctZero);
        result.setTare(ctTare);
        result.setNetWeight(ctNet);
        result.setGross(ctGross);
        result.setValidType(validType);
        result.setTareIsPreset(ctIsPreset);
        result.setAutoAllowed(this.stable && validType == 0 && this.usedGross.compareTo(BigDecimal.ZERO) == 0);
        result.setNeedBackZero(needBackZero);
        if (this.newResult) {
            this.newResult = false;
            int action = 0;
            int reTimes = GlobalPara.getInstance().getTMS(1034, 1);
            if (reTimes < 0 || reTimes > 9) {
                reTimes = 1;
            }
            if (this.ai_Status == 0) {
                boolean isValid;
                BigDecimal wv = GlobalPara.getInstance().getAiWeightValid();
                if (wv.compareTo(BigDecimal.ZERO) <= 0) {
                    isValid = validType == 0;
                } else {
                    boolean bl = isValid = validType <= 1 && ctNet.compareTo(wv) >= 0;
                }
                this.ai_Step = isValid ? ++this.ai_Step : 0;
                if (this.ai_Step > GlobalPara.getInstance().getTMS(1035, 1, 1)) {
                    action = 1;
                    this.ai_Status = this.stable ? 2 : 1;
                    this.ai_Step = 0;
                    this.ai_LastWeight = ctGross;
                }
                if (isValid) {
                    if (this.cameraStatus == 0 && action == 0) {
                        action = 4;
                    }
                    this.cameraStatus = 1;
                } else if (this.cameraStatus > 0) {
                    ++this.cameraStatus;
                    if (this.cameraStatus > GlobalPara.getInstance().getTMS(1039, 50)) {
                        action = 5;
                        this.cameraStatus = 0;
                    }
                }
            } else {
                int st;
                boolean isQuit;
                BigDecimal wq = GlobalPara.getInstance().getAiWeightQuit();
                if (wq.compareTo(BigDecimal.ZERO) <= 0) {
                    isQuit = validType != 0;
                } else {
                    boolean bl = isQuit = ctNet.compareTo(wq) < 0;
                }
                if (isQuit) {
                    action = 3;
                    this.ai_Status = 0;
                    this.ai_Step = 0;
                } else if (this.ai_Status == 1) {
                    if (this.stable) {
                        ++this.ai_Step;
                        st = GlobalPara.getInstance().getTMS(1031, 1);
                        if (st > 0 && this.ai_Step > st) {
                            action = 2;
                            ++this.ai_Status;
                            this.ai_Step = 0;
                            this.ai_LastWeight = ctGross;
                        }
                    } else {
                        this.ai_Step = 0;
                    }
                } else if (this.ai_Status <= 1 + reTimes) {
                    if (this.stable) {
                        ++this.ai_Step;
                        st = GlobalPara.getInstance().getTMS(1033, 20);
                        if (st >= 0 && this.ai_Step > st) {
                            action = 2;
                            ++this.ai_Status;
                            this.ai_Step = 0;
                            this.ai_LastWeight = ctGross;
                        }
                    } else {
                        this.ai_Step = 0;
                    }
                } else {
                    int va = GlobalPara.getInstance().getTMS(1032, 10);
                    if (va < 10) {
                        va = 10;
                    }
                    BigDecimal range = this.weightDegree_2.multiply(new BigDecimal(va));
                    BigDecimal dif = ctGross.subtract(this.ai_LastWeight);
                    if (dif.compareTo(range) > 0 || dif.add(range).compareTo(BigDecimal.ZERO) < 0) {
                        this.ai_Status = 1;
                        this.ai_Step = 0;
                        this.ai_LastWeight = ctGross;
                    }
                    if (this.cameraStatus > 0) {
                        ++this.cameraStatus;
                        if (this.cameraStatus > GlobalPara.getInstance().getTMS(1039, 50)) {
                            action = 5;
                            this.cameraStatus = 0;
                        }
                    }
                }
            }
            if (!(this.weightNotifies == null || this.weightNotifies.isEmpty() || this.adc || validType != 0 && validType != 1 && validType != 2)) {
                for (WeightNotify weightNotify : this.weightNotifies) {
                    if (!(weightNotify instanceof WeightChangeNotify)) continue;
                    WeightChangeNotify weightChangeNotify = (WeightChangeNotify)weightNotify;
                    if (1 == action) {
                        weightChangeNotify.start();
                        continue;
                    }
                    if (2 == action) {
                        weightChangeNotify.reconfirm();
                        continue;
                    }
                    if (3 == action) {
                        weightChangeNotify.cancel();
                        continue;
                    }
                    if (4 == action) {
                        weightChangeNotify.open();
                        continue;
                    }
                    if (5 != action) continue;
                    weightChangeNotify.close();
                }
            }
        }
        return result.clearWeight();
    }

    public void update_UsedGross(BigDecimal input, int pluN0) {
        if (input.compareTo(BigDecimal.ZERO) > 0) {
            this.usedGross = this.minAfterUsedGross = input;
            this.usedGross_PLU = pluN0;
        }
    }

    public WeightCal SetCode(int codeFromCalibrate, int codeOfZeroCurrent, boolean stable, boolean notFinish, boolean adc) {
        if (!this.finishOfZeroStart && stable) {
            this.COM_Get_ZeroInfo(codeFromCalibrate);
        }
        this.stable = stable;
        this.codeFromCalibrate = codeFromCalibrate;
        this.codeOfZeroCurrent = codeOfZeroCurrent;
        this.codeOfGross = codeFromCalibrate - codeOfZeroCurrent;
        this.newResult = true;
        this.adc = adc;
        return this;
    }

    public void target(IPackResponse target) {
        if (target instanceof ObtainWeightADPDResponse) {
            ObtainWeightADPDResponse response = (ObtainWeightADPDResponse)target;
            if (response.getLength() == 8) {
                this.SetCode(response.getWaveCode(), response.getZeroCode(), response.isS_stb(), response.isS_on(), response.isS_adc());
                GlobalPara.getInstance().setPrivilege(response.isS_privilege());
                WeightResult wr = this.GetResult();
                if (this.weightNotifies != null && !this.weightNotifies.isEmpty()) {
                    for (WeightNotify weightNotify : this.weightNotifies) {
                        if (!(weightNotify instanceof WeightInfoNotify)) continue;
                        WeightInfoNotify weightInfoNotify = (WeightInfoNotify)weightNotify;
                        weightInfoNotify.weight(wr);
                        if (!wr.isNeedBackZero()) continue;
                        weightInfoNotify.exp(wr, new MeterException(MeterStateEnum.\u91cd\u91cf\u9700\u8981\u8fd4\u56de\u96f6\u70b9));
                    }
                }
                SerialDisplay.getInstance().setWeightResult(wr);
            } else {
                System.err.println("\u672a\u77e5\u91cd\u91cf\u4fe1\u606f\uff1a" + target.toJSON());
            }
        } else {
            System.err.println("\u901a\u7528\u672a\u77e5\u6307\u4ee4\u5185\u5bb9 -> " + target.toJSON());
        }
    }

    @Override
    public void exp(MeterException e) {
        System.err.println("\u901a\u7528\u5f02\u5e38\u6307\u4ee4\u5185\u5bb9 -> " + e.getMessage());
    }

    private static class SingleWeightCal {
        private static final WeightCal SINGLETON = new WeightCal();

        private SingleWeightCal() {
        }
    }
}

