/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.model.sp;

import com.jhscale.common.model.device.other.DSpDWL;
import com.jhscale.meter.protocol.model.CalPLU_ShelfDate;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.protocol.model.ItemContent;
import com.jhscale.meter.protocol.model.TradeContent;
import com.jhscale.meter.protocol.model.sp.PtMapAddr;
import com.jhscale.meter.protocol.model.sp.PtMapArea;
import com.jhscale.meter.protocol.model.sp.TradeSpOut;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

public class TradeSpecial {
    private static int tryParseInt(String toParse) {
        return TradeSpecial.tryParseInt(toParse, 0);
    }

    private static int tryParseInt(String toParse, int defaultValue) {
        try {
            return Integer.parseInt(toParse, 10);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private static BigDecimal tryParseBigDecimal(String toParse) {
        try {
            String[] v = toParse.split(",", -1);
            int dot = 0;
            if (v.length >= 2) {
                dot = TradeSpecial.tryParseInt(v[1]);
            }
            return new BigDecimal(TradeSpecial.tryParseInt(v[0])).movePointLeft(dot);
        }
        catch (Exception e) {
            return BigDecimal.ZERO;
        }
    }

    public static String printCalculte_Special_ID2Text(int[] itemValue, String key, Integer id) {
        DSpDWL spDWL = GlobalPara.getInstance().getSpData(key, id);
        if (spDWL == null) {
            return "";
        }
        if (itemValue[3] == 0) {
            return spDWL.no().toString();
        }
        String[] sg = spDWL.getContent().split("\t", -1);
        if (itemValue[3] <= 2 && itemValue[3] <= sg.length) {
            return sg[itemValue[3] - 1];
        }
        return "";
    }

    public static String printCalculte_Special_Nutrition_GetMapInfo_Full(PtMapArea area, int angle, int grid, int font, int leftPercent, int rightPercent, boolean autoNewline) {
        int lx;
        int sy;
        int sx;
        int ly = 64;
        if (angle == 2) {
            sx = area.te.x - (area.te.x - area.ts.x) * leftPercent / 100;
            sy = area.ts.y + 64;
            lx = (area.te.x - area.ts.x) * (rightPercent - leftPercent) / 100 + 1;
        } else {
            grid -= 6;
            sx = area.ts.x + (area.te.x - area.ts.x) * leftPercent / 100;
            sy = area.ts.y + 1;
            lx = (area.te.x - area.ts.x) * (rightPercent - leftPercent) / 100 + 1;
        }
        return TradeContent.printCalculate_MapInfo(angle, autoNewline ? 32 : 0, grid, font, sx, sy, lx, ly);
    }

    public static String printCalculte_Special_Nutrition_GetMapInfo_Simple(PtMapArea area, int angle, int grid, int font) {
        return TradeSpecial.printCalculte_Special_Nutrition_GetMapInfo_Full(area, angle, grid, font, 0, 100, false);
    }

    public static String printCalculte_Special_Nutrition_Border_FBB(PtMapArea area, int leftPercent, int rightPercent, int angle, int fbb) {
        if (angle == 2) {
            leftPercent = 100 - leftPercent;
            rightPercent = 100 - rightPercent;
        }
        leftPercent = area.ts.x + (area.te.x - area.ts.x) * leftPercent / 100;
        rightPercent = area.ts.x + (area.te.x - area.ts.x) * rightPercent / 100;
        return "0B02" + TradeContent.printCalculate_getX2(fbb) + TradeContent.printCalculate_getX4(leftPercent) + TradeContent.printCalculate_getX4(rightPercent);
    }

    public static String printCalculte_Speical_Nutrition_Buttom(PtMapArea area, String chars, int angle, int grid, int font, int fbb, boolean autoNewline) {
        String mapInfo = TradeSpecial.printCalculte_Special_Nutrition_GetMapInfo_Full(area, angle, grid, font, 1, 100, autoNewline);
        String out = TradeContent.printCalculate_CommandText(mapInfo, chars);
        out = out + TradeSpecial.printCalculte_Special_Nutrition_Border_FBB(area, 0, 100, angle, fbb);
        out = out + "04";
        return out;
    }

    public static String printCalculte_Speical_Nutrition_Header(PtMapArea area, String chars, int angle, int grid, int font) {
        return TradeSpecial.printCalculte_Speical_Nutrition_Buttom(area, chars, angle, grid, font, 2, false);
    }

    public static String printCalculte_Speical_Nutrition_Header_UD(PtMapArea area, String unit1, Integer valor, int type, int angle, int font) {
        String mapInfo;
        String out = "";
        int unit = unit1.length() == 0 ? -1 : (unit1.equals("g") ? 0 : (unit1.equals("ml") ? 1 : 2));
        int loop = 0;
        while (true) {
            mapInfo = TradeSpecial.printCalculte_Special_Nutrition_GetMapInfo_Full(area, angle, 8, font, loop > 0 ? 71 : 56, loop > 0 ? 86 : 71, false);
            String text = loop > 0 ? valor.toString() : "100";
            text = unit == -1 ? text + (type == 1 ? " ml" : " g") : (unit == 0 ? text + " g" : (unit == 1 ? text + " ml" : text + unit1));
            out = out + TradeContent.printCalculate_CommandText(mapInfo, text);
            if (loop > 0) break;
            ++loop;
        }
        mapInfo = TradeSpecial.printCalculte_Special_Nutrition_GetMapInfo_Full(area, angle, 8, font, 86, 100, false);
        out = out + TradeContent.printCalculate_CommandText(mapInfo, "%VD*");
        out = out + TradeSpecial.printCalculte_Special_Nutrition_Border_FBB(area, 0, 100, angle, 2);
        out = out + TradeSpecial.printCalculte_Special_Nutrition_Border_FBB(area, 56, 71, angle, 2);
        out = out + TradeSpecial.printCalculte_Special_Nutrition_Border_FBB(area, 56, 86, angle, 2);
        return out + "04";
    }

    public static String printCalculte_Speical_Nutrition_4_Loop(PtMapArea area, String[] ln_des, BigDecimal[] ln_valor, BigDecimal[] ln_valor100, BigDecimal[] ln_percent, int loop, int type, int angle, boolean percentPrint, boolean tryRemoveDot, int font, boolean bitmapAlways) {
        if (ln_des[loop].length() <= 0) {
            return "";
        }
        String mapInfo = TradeSpecial.printCalculte_Special_Nutrition_GetMapInfo_Full(area, angle, 7, font, 1, 56, false);
        String out = TradeContent.printCalculate_CommandText(mapInfo, ln_des[loop]);
        int loopN = 0;
        while (true) {
            BigDecimal value = loopN > 0 ? ln_valor[loop] : ln_valor100[loop];
            if (!bitmapAlways) {
                if (loop == 0) {
                    value = value.compareTo(BigDecimal.valueOf(40L, 1)) <= 0 ? BigDecimal.ZERO : value.setScale(0, 4);
                } else if (loop >= 1 && loop <= 5 || loop == 8) {
                    value = value.compareTo(BigDecimal.valueOf(5L, 1)) <= 0 ? BigDecimal.ZERO : (value.compareTo(BigDecimal.valueOf(100L, 1)) >= 0 ? value.setScale(0, 4) : value.stripTrailingZeros());
                } else if (loop == 6 || loop == 7) {
                    value = value.compareTo(BigDecimal.valueOf(1L, 1)) <= 0 ? BigDecimal.ZERO : (value.compareTo(BigDecimal.valueOf(100L, 1)) >= 0 ? value.setScale(0, 4) : value.stripTrailingZeros());
                } else if (loop == 9) {
                    value = value.compareTo(BigDecimal.valueOf(50L, 1)) <= 0 ? BigDecimal.ZERO : (value.compareTo(BigDecimal.valueOf(100L, 1)) >= 0 ? value.setScale(0, 4) : value.stripTrailingZeros());
                }
            }
            mapInfo = TradeSpecial.printCalculte_Special_Nutrition_GetMapInfo_Full(area, angle, 8, font, loopN > 0 ? 71 : 56, loopN > 0 ? 86 : 71, false);
            if (tryRemoveDot) {
                value = value.stripTrailingZeros();
            }
            out = out + TradeContent.printCalculate_CommandText(mapInfo, value.toPlainString());
            if (loopN > 0) break;
            ++loopN;
        }
        mapInfo = TradeSpecial.printCalculte_Special_Nutrition_GetMapInfo_Full(area, angle, 8, font, 86, 100, false);
        String lpn = ln_percent[loop].toString();
        if (percentPrint) {
            lpn = lpn + "%";
        }
        out = out + TradeContent.printCalculate_CommandText(mapInfo, lpn);
        out = out + TradeSpecial.printCalculte_Special_Nutrition_Border_FBB(area, 0, 100, angle, 2);
        out = out + TradeSpecial.printCalculte_Special_Nutrition_Border_FBB(area, 56, 71, angle, 2);
        out = out + TradeSpecial.printCalculte_Special_Nutrition_Border_FBB(area, 56, 86, angle, 2);
        return out + "04";
    }

    public static Object printCalculte_Special_Nutrition_4(ItemContent itemC, int[] itemValue, int subY, int labelwidth, int nu4_id, boolean bitmapAlways, String title, int type, boolean percentPrint, boolean tryRemoveDot, int font_10PB, int font_8P, int font_8PB, int font_6P) {
        int loop;
        String out = "";
        String[] segs = GlobalPara.getInstance().getSpSeg("NU3", nu4_id);
        if (segs == null || segs.length < 55) {
            return "";
        }
        int unit = itemC.getPlu().getUnit();
        BigDecimal amount = itemC.getAmount();
        String Info1 = " \ufeff* Percentual de valores di\u00e1rios fornecidos pela";
        String Info2 = " por\u00e7\u00e3o.";
        String Info3 = " \ufeff* Percentual de valores di\u00e1rios fornecidos pela por\u00e7\u00e3o.";
        String Info4 = " Por\u00e7\u00f5es por embalagem: ";
        String Info5 = " Por\u00e7\u00e3o: ";
        String name = segs[0];
        String des = segs[1];
        int valor = TradeSpecial.tryParseInt(segs[2]);
        String unit1 = segs[3];
        String unit2 = segs[4];
        String[] ln_des = new String[20];
        BigDecimal[] ln_valor = new BigDecimal[20];
        BigDecimal[] ln_valor100 = new BigDecimal[20];
        BigDecimal[] ln_percent = new BigDecimal[20];
        ln_des[0] = "Valor energ\u00e9tico(kcal)";
        ln_valor[0] = TradeSpecial.tryParseBigDecimal(segs[5]);
        ln_percent[0] = TradeSpecial.tryParseBigDecimal(segs[6]);
        ln_des[1] = "Carboidratos totais(g)";
        ln_valor[1] = TradeSpecial.tryParseBigDecimal(segs[7]);
        ln_percent[1] = TradeSpecial.tryParseBigDecimal(segs[8]);
        ln_des[2] = " A\u00e7\u00facares totais(g)";
        ln_valor[2] = TradeSpecial.tryParseBigDecimal(segs[9]);
        ln_percent[2] = TradeSpecial.tryParseBigDecimal(segs[10]);
        ln_des[3] = "  A\u00e7\u00facares adicionados(g)";
        ln_valor[3] = TradeSpecial.tryParseBigDecimal(segs[11]);
        ln_percent[3] = TradeSpecial.tryParseBigDecimal(segs[12]);
        ln_des[4] = "Proteinas(g)";
        ln_valor[4] = TradeSpecial.tryParseBigDecimal(segs[13]);
        ln_percent[4] = TradeSpecial.tryParseBigDecimal(segs[14]);
        ln_des[5] = "Gorduras totais(g)";
        ln_valor[5] = TradeSpecial.tryParseBigDecimal(segs[15]);
        ln_percent[5] = TradeSpecial.tryParseBigDecimal(segs[16]);
        ln_des[6] = " Gorduras saturadas(g)";
        ln_valor[6] = TradeSpecial.tryParseBigDecimal(segs[17]);
        ln_percent[6] = TradeSpecial.tryParseBigDecimal(segs[18]);
        ln_des[7] = " Gordura trans(g)";
        ln_valor[7] = TradeSpecial.tryParseBigDecimal(segs[19]);
        ln_percent[7] = TradeSpecial.tryParseBigDecimal(segs[20]);
        ln_des[8] = "Fibra alimentar(g)";
        ln_valor[8] = TradeSpecial.tryParseBigDecimal(segs[21]);
        ln_percent[8] = TradeSpecial.tryParseBigDecimal(segs[22]);
        ln_des[9] = "S\u00f3dio(mg)";
        ln_valor[9] = TradeSpecial.tryParseBigDecimal(segs[23]);
        ln_percent[9] = TradeSpecial.tryParseBigDecimal(segs[24]);
        ln_des[10] = segs[25];
        ln_valor[10] = TradeSpecial.tryParseBigDecimal(segs[26]);
        ln_percent[10] = TradeSpecial.tryParseBigDecimal(segs[27]);
        ln_des[11] = segs[28];
        ln_valor[11] = TradeSpecial.tryParseBigDecimal(segs[29]);
        ln_percent[11] = TradeSpecial.tryParseBigDecimal(segs[30]);
        ln_des[12] = segs[31];
        ln_valor[12] = TradeSpecial.tryParseBigDecimal(segs[32]);
        ln_percent[12] = TradeSpecial.tryParseBigDecimal(segs[33]);
        ln_des[13] = segs[34];
        ln_valor[13] = TradeSpecial.tryParseBigDecimal(segs[35]);
        ln_percent[13] = TradeSpecial.tryParseBigDecimal(segs[36]);
        ln_des[14] = segs[37];
        ln_valor[14] = TradeSpecial.tryParseBigDecimal(segs[38]);
        ln_percent[14] = TradeSpecial.tryParseBigDecimal(segs[39]);
        ln_des[15] = segs[40];
        ln_valor[15] = TradeSpecial.tryParseBigDecimal(segs[41]);
        ln_percent[15] = TradeSpecial.tryParseBigDecimal(segs[42]);
        ln_des[16] = segs[43];
        ln_valor[16] = TradeSpecial.tryParseBigDecimal(segs[44]);
        ln_percent[16] = TradeSpecial.tryParseBigDecimal(segs[45]);
        ln_des[17] = segs[46];
        ln_valor[17] = TradeSpecial.tryParseBigDecimal(segs[47]);
        ln_percent[17] = TradeSpecial.tryParseBigDecimal(segs[48]);
        ln_des[18] = segs[49];
        ln_valor[18] = TradeSpecial.tryParseBigDecimal(segs[50]);
        ln_percent[18] = TradeSpecial.tryParseBigDecimal(segs[51]);
        ln_des[19] = segs[52];
        ln_valor[19] = TradeSpecial.tryParseBigDecimal(segs[53]);
        ln_percent[19] = TradeSpecial.tryParseBigDecimal(segs[54]);
        for (loop = 0; loop < 20; ++loop) {
            ln_valor100[loop] = valor > 0 ? ln_valor[loop].divide(new BigDecimal(valor).movePointLeft(2)) : BigDecimal.ZERO;
        }
        int angle = itemValue[5];
        int dir = PtMapArea.GetDir(angle);
        PtMapArea area = new PtMapArea(new PtMapAddr(itemValue[8], itemValue[9] - subY), new PtMapAddr(itemValue[10], itemValue[11]), dir);
        if (area.ts.y > 0) {
            out = out + "10" + TradeContent.printCalculate_getX4(area.ts.y - 1);
        }
        out = out + "04";
        subY += area.te.y + 1;
        area.ts.x = 0;
        int widthDot = 336;
        if (widthDot < labelwidth) {
            widthDot = labelwidth;
        }
        area.te.x = widthDot - 1;
        area.te.y = 0;
        area.ts.y = 0;
        int printAlarm = 0;
        int alarmType = !bitmapAlways ? (unit1.equals("g") ? 0 : (unit1.equals("ml") ? 1 : type)) : type;
        if (ln_valor100[9].compareTo(new BigDecimal(alarmType == 1 ? 3000 : 6000).movePointLeft(1)) >= 0) {
            printAlarm += 4;
        }
        if (ln_valor100[6].compareTo(new BigDecimal(alarmType == 1 ? 30 : 60).movePointLeft(1)) >= 0) {
            printAlarm += 2;
        }
        if (ln_valor100[3].compareTo(new BigDecimal(alarmType == 1 ? 75 : 150).movePointLeft(1)) >= 0) {
            ++printAlarm;
        }
        String udline = "0A000000" + TradeContent.printCalculate_getX4(area.ts.x) + TradeContent.printCalculate_getX4(0) + TradeContent.printCalculate_getX4(area.te.x) + TradeContent.printCalculate_getX4(2) + "04";
        Info4 = GlobalPara.getInstance().EcsCal_Unit_isWeight(unit) ? (valor <= 0 ? Info4 + " 0" : Info4 + " " + itemC.getAmount().divide(new BigDecimal(valor), 0, 4).toString()) : Info4 + " " + itemC.getAmount().toString();
        Info4 = Info4 + " por\u00e7\u00f5es";
        Info5 = Info5 + Integer.toString(valor);
        Info5 = !bitmapAlways ? Info5 + (alarmType != 0 ? " ml" : " g") : Info5 + unit1;
        Info5 = Info5 + unit2;
        if (angle == 2) {
            String mapInfo;
            if (bitmapAlways && printAlarm > 0) {
                mapInfo = TradeSpecial.printCalculte_Special_Nutrition_GetMapInfo_Simple(area, angle, 8, 0);
                out = out + TradeContent.printCalculate_Bitmap_Inner(mapInfo, printAlarm) + "04";
            }
            out = out + udline;
            out = out + TradeSpecial.printCalculte_Speical_Nutrition_Buttom(area, Info3, angle, 7, font_6P, 3, true);
            loop = 20;
            while (loop > 0) {
                out = out + TradeSpecial.printCalculte_Speical_Nutrition_4_Loop(area, ln_des, ln_valor, ln_valor100, ln_percent, --loop, type, angle, percentPrint, tryRemoveDot, font_8P, bitmapAlways);
            }
            out = out + TradeSpecial.printCalculte_Speical_Nutrition_Header_UD(area, unit1, valor, type, angle, font_8PB);
            out = out + TradeSpecial.printCalculte_Speical_Nutrition_Header(area, Info5, angle, 7, font_8P);
            out = out + TradeSpecial.printCalculte_Speical_Nutrition_Header(area, Info4, angle, 7, font_8P);
            out = out + TradeSpecial.printCalculte_Speical_Nutrition_Header(area, title, angle, 8, font_10PB);
            out = out + udline;
            if (!bitmapAlways && printAlarm > 0) {
                mapInfo = TradeSpecial.printCalculte_Special_Nutrition_GetMapInfo_Simple(area, angle, 8, 0);
                out = out + TradeContent.printCalculate_Bitmap_Inner(mapInfo, printAlarm) + "04";
            }
        } else {
            String mapInfo;
            if (!bitmapAlways && printAlarm > 0) {
                mapInfo = TradeSpecial.printCalculte_Special_Nutrition_GetMapInfo_Simple(area, angle, 8, 0);
                out = out + TradeContent.printCalculate_Bitmap_Inner(mapInfo, printAlarm) + "04";
            }
            out = out + TradeSpecial.printCalculte_Speical_Nutrition_Header(area, title, angle, 8, font_10PB);
            out = out + TradeSpecial.printCalculte_Speical_Nutrition_Header(area, Info4, angle, 7, font_8P);
            out = out + TradeSpecial.printCalculte_Speical_Nutrition_Header(area, Info5, angle, 7, font_8P);
            out = out + TradeSpecial.printCalculte_Speical_Nutrition_Header_UD(area, unit1, valor, type, angle, font_8P);
            for (loop = 0; loop < 20; ++loop) {
                out = out + TradeSpecial.printCalculte_Speical_Nutrition_4_Loop(area, ln_des, ln_valor, ln_valor100, ln_percent, loop, type, angle, percentPrint, tryRemoveDot, font_8P, bitmapAlways);
            }
            out = out + udline;
            out = out + TradeSpecial.printCalculte_Speical_Nutrition_Buttom(area, Info3, angle, 7, font_6P, 3, true);
            out = out + udline;
            if (bitmapAlways && printAlarm > 0) {
                mapInfo = TradeSpecial.printCalculte_Special_Nutrition_GetMapInfo_Simple(area, angle, 8, 0);
                out = out + TradeContent.printCalculate_Bitmap_Inner(mapInfo, printAlarm) + "04";
            }
        }
        return new TradeSpOut(out, subY);
    }

    public static Object printCalculte_Special_TA128(TradeContent tc, int[] itemValue, String mapInfo, int x_Init, int subY, int labelwidth) {
        String out = "";
        ItemContent itemC = tc.getItem().get(x_Init > 0 ? x_Init - 1 : 0);
        if (itemValue[2] == 0) {
            return TradeSpecial.printCalculte_Special_Nutrition_4(itemC, itemValue, subY, labelwidth, itemC.getPlu().getSspVale_0(), true, "INFORMA\u00c7\u00c3O NUTRICIONAL", itemC.getPlu().getSspVale_3(), false, true, 14, 16, 17, 19);
        }
        if (itemValue[2] == 1) {
            out = TradeSpecial.printCalculte_Special_ID2Text(itemValue, "SU2", itemC.getPlu().getSspVale_1());
            return TradeContent.printCalculate_CommandText(mapInfo, out);
        }
        if (itemValue[2] == 2) {
            out = TradeSpecial.printCalculte_Special_ID2Text(itemValue, "IR2", itemC.getPlu().getSspVale_2());
            return TradeContent.printCalculate_CommandText(mapInfo, out);
        }
        if (itemValue[2] == 3) {
            if (itemValue[3] == 0) {
                Object loto = tc.getSpInfo("TA128_Lot");
                out = loto != null && loto instanceof String ? (String)loto : itemC.getPlu().getText().text(Integer.valueOf(5));
                return TradeContent.printCalculate_CommandText(mapInfo, out);
            }
            if (itemValue[3] == 1) {
                if (GlobalPara.getInstance().EcsCal_Unit_isWeight(itemC.getUnit_weight())) {
                    out = itemC.getTare().compareTo(BigDecimal.ZERO) > 0 ? "L" : "B";
                    return TradeContent.printCalculate_CommandText(mapInfo, out);
                }
                return "";
            }
            if (itemValue[3] == 2) {
                Object dro = tc.getSpInfo("TA128_DateRetro_Start");
                Calendar calendar = Calendar.getInstance();
                if (dro != null && dro instanceof Date) {
                    calendar.setTime((Date)dro);
                } else {
                    calendar.setTime(tc.getTradeTime());
                }
                return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().EcsCal_PrintDate(calendar));
            }
            if (itemValue[3] == 3) {
                Object dro = tc.getSpInfo("TA128_DateRetro_Start");
                Object drd = tc.getSpInfo("TA128_DateRetro_Days");
                CalPLU_ShelfDate shelfdate = dro != null && drd != null && dro instanceof Date && drd instanceof Integer ? new CalPLU_ShelfDate((Integer)drd, (Date)dro) : new CalPLU_ShelfDate(itemC, tc.getTradeTime());
                if (!shelfdate.isPrintable()) {
                    return "";
                }
                if (shelfdate.isByHour()) {
                    if (shelfdate.getInType() >= 4) {
                        return TradeContent.printCalculate_CommandText(mapInfo, shelfdate.getDirectValue().toString() + GlobalPara.getInstance().getLang("Hours"));
                    }
                    Calendar calendar = shelfdate.getCalendar();
                    return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().EcsCal_PrintDate(calendar) + "\n " + GlobalPara.getInstance().EcsCal_PrintTime(calendar) + " ");
                }
                if (shelfdate.getInType() >= 4) {
                    return TradeContent.printCalculate_CommandText(mapInfo, shelfdate.getDirectValue().toString() + GlobalPara.getInstance().getLang("Days"));
                }
                return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().EcsCal_PrintDate(shelfdate.getCalendar()));
            }
            if (itemValue[3] == 4) {
                return TradeContent.printCalculate_CommandText(mapInfo, itemC.getPlu().getText().text(Integer.valueOf(0)) + itemC.getPlu().getText().text(Integer.valueOf(1)) + itemC.getPlu().getText().text(Integer.valueOf(2)));
            }
            return "";
        }
        return "";
    }

    public static Object printCalculte_Special(TradeContent tc, int[] itemValue, String mapInfo, int x_Init, int subY, int labelwidth) {
        String out = "";
        try {
            String tmsVersion = GlobalPara.getInstance().Pos_TMSVersion();
            if ("TA128".equals(tmsVersion)) {
                return TradeSpecial.printCalculte_Special_TA128(tc, itemValue, mapInfo, x_Init, subY, labelwidth);
            }
            int itemNo = x_Init > 0 ? x_Init : 1;
            String caled = tc.getCustomInfo().get('P' + Integer.toString(itemValue[2]) + '-' + Integer.toString(itemValue[3]) + '-' + Integer.toString(itemNo));
            if (caled == null) {
                caled = tc.getCustomInfo().get('P' + Integer.toString(itemValue[2]) + '-' + Integer.toString(itemValue[3]));
            }
            if (caled != null) {
                int barPos = caled.indexOf(58);
                out = barPos == 18 && caled.startsWith("#B") ? TradeContent.printCalculate_DrawBarcode(mapInfo, caled.substring(2, 18), caled.substring(19).getBytes()) : TradeContent.printCalculate_CommandText(mapInfo, caled);
            }
        }
        catch (Exception e) {
            out = "";
        }
        return out;
    }
}

