/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.other.cmpt;

import com.jhscale.common.model.device._inner.PublicExecute;
import com.jhscale.common.model.device._inner.PublicExecuteModify;
import com.jhscale.common.model.inter.DataJSONModel;
import com.jhscale.common.utils.ByteUtils;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.io.TCPServer;
import com.jhscale.meter.io.UDPLink;
import com.jhscale.meter.io.control.SocketControl;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.io.listener.SocketClientEventListener;
import com.jhscale.meter.model.device.TCPServerDevice;
import com.jhscale.meter.model.device.UDPDevice;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.protocol.model.SocketNotify;
import com.jhscale.meter.protocol.other.CMPT;
import com.jhscale.meter.protocol.other.cmpt.CMPTAction;
import java.net.InetAddress;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;

public abstract class ACMPTAction<T extends ACMPTAction>
implements CMPTAction<ACMPTAction> {
    private TCPServer TCPServer;
    private UDPLink UDPLink;
    private CMPT cmpt;
    private SocketControl tcp_server_control;
    private SocketControl udp_control;
    private SocketNotify notify;
    protected byte[] buffer_TCP = new byte[40960];
    protected int buffer_TCP_Pose = 0;
    protected long buffer_TCP_Tick = 0L;
    private PublicExecuteModify execute;
    private final long delay = 3000L;
    private Timer timer;

    @Override
    public T Init_CMPT_Action(CMPT cmpt, SocketControl tcp_server_control, SocketControl udp_control, SocketNotify notify) {
        this.cmpt = cmpt;
        this.tcp_server_control = tcp_server_control;
        this.udp_control = udp_control;
        this.notify = notify;
        return (T)this;
    }

    @Override
    public boolean Init_Action() throws MeterException {
        this.Init_TCP_Server();
        this.Init_UDP();
        return true;
    }

    @Override
    public boolean Stop_Action() throws MeterException {
        if (this.TCPServer != null) {
            this.TCPServer.closePort();
            this.TCPServer = null;
        }
        if (this.UDPLink != null) {
            this.UDPLink.closePort();
            this.UDPLink = null;
        }
        return true;
    }

    @Override
    public boolean Init_TCP_Server() throws MeterException {
        TCPServerDevice tcp_server_device = this.cmpt.getTcp_server_device();
        if (Objects.nonNull(tcp_server_device)) {
            this.TCPServer = new TCPServer(this.tcp_server_control, this.cmpt.getTcp_server_device(), (DeviceClientEventListener)new SocketClientEventListener(){

                @Override
                public void onClientLink(InetAddress address, int port) {
                    if (GlobalPara.getInstance().isRunLog()) {
                        System.out.println("TCP Server onClientLink......");
                    }
                }

                @Override
                public void onClientBreak(InetAddress address, int port) {
                    if (GlobalPara.getInstance().isRunLog()) {
                        System.out.println("TCP Server onClientBreak......");
                    }
                }

                @Override
                public void onClientEventExp(MeterException e) {
                    if (ACMPTAction.this.notify != null) {
                        ACMPTAction.this.notify.onClientEventExp(e);
                    }
                }

                @Override
                public byte[] onClientEventResponse(PortManager portManager, byte[] bytes) throws MeterException {
                    if (bytes != null && bytes.length > 0) {
                        byte[] tcp_server;
                        if (GlobalPara.getInstance().isRunLog()) {
                            System.out.printf("onClientEventResponse Content: %s%n", ByteUtils.bytes2HexString((byte[])bytes));
                        }
                        if ((tcp_server = ACMPTAction.this.tcp_server(portManager, bytes)) != null && tcp_server.length > 0) {
                            portManager.writeDataImmediately(tcp_server);
                        }
                    }
                    return new byte[0];
                }
            });
            return this.TCPServer.openPort();
        }
        return false;
    }

    @Override
    public boolean Init_UDP() throws MeterException {
        UDPDevice udp_device = this.cmpt.getUdp_device();
        if (Objects.nonNull(udp_device)) {
            this.UDPLink = new UDPLink(this.udp_control, this.cmpt.getUdp_device(), (DeviceClientEventListener)new SocketClientEventListener(){

                @Override
                public byte[] onClientEvent(PortManager portManager, InetAddress address, int port, byte[] bytes) throws MeterException {
                    byte[] udp;
                    if (GlobalPara.getInstance().isRunLog()) {
                        System.out.println(String.format("\u6536\u5230\u6765\u81ea:%s,\u5bf9\u65b9\u7aef\u53e3\u53f7\u4e3a:%s,\u6d88\u606f\u5185\u5bb9\uff1a%s", address, port, ByteUtils.bytes2HexString((byte[])bytes)));
                    }
                    if ((udp = ACMPTAction.this.udp(portManager, address, port, bytes)) != null && udp.length > 0) {
                        ACMPTAction.this.UDPLink.writeDataImmediately(udp);
                    }
                    return new byte[0];
                }

                @Override
                public void onClientEventExp(MeterException e) {
                    if (ACMPTAction.this.notify != null) {
                        ACMPTAction.this.notify.onClientEventExp(e);
                    }
                }
            });
            return this.UDPLink.openPort();
        }
        return false;
    }

    @Override
    public CMPT CMPT() {
        return this.cmpt;
    }

    protected void addCache(DataJSONModel model) {
        if (this.execute == null) {
            this.execute = new PublicExecuteModify("PLU");
        }
        this.execute.add(new DataJSONModel[]{model});
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public synchronized void run() {
                if (ACMPTAction.this.execute != null) {
                    ACMPTAction.this.execute.setSerial(ACMPTAction.this.cmpt.getSerial());
                    ACMPTAction.this.notify.acceptEvent((PublicExecute)ACMPTAction.this.execute);
                    ACMPTAction.this.execute = null;
                }
            }
        }, 3000L);
    }
}

