/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.other.cmpt;

import com.jhscale.common.model.device.plu.DPLUV5;
import com.jhscale.common.model.device.plu.module.DPriceV2;
import com.jhscale.common.model.device.plu.module.DPrintWithBitMapV1;
import com.jhscale.common.model.device.plu.module.DTextV1;
import com.jhscale.common.model.device.plu.module.DTimeV2;
import com.jhscale.common.model.inter.DataJSONModel;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.protocol.other.cmpt.ACMPTAction;
import java.math.BigDecimal;
import java.net.InetAddress;
import org.apache.commons.lang3.StringUtils;

public class DAHU_ACMPT
extends ACMPTAction<DAHU_ACMPT> {
    @Override
    public byte[] tcp_server(PortManager portManager, byte[] bytes) throws MeterException {
        byte[] response = new byte[]{};
        for (int loop = 0; loop < bytes.length; ++loop) {
            byte Data2 = bytes[loop];
            if (Data2 == 33) {
                this.buffer_TCP_Pose = 1;
                continue;
            }
            if (this.buffer_TCP_Pose < 1) continue;
            if (Data2 == 13 || Data2 == 10) {
                this.buffer_TCP[this.buffer_TCP_Pose - 1] = 0;
                if (this.buffer_TCP_Pose <= 2) {
                    this.buffer_TCP_Pose = 0;
                    continue;
                }
                if (this.buffer_TCP[0] == 48) {
                    if (this.buffer_TCP[1] == 77) {
                        response = new byte[]{48, 109, 13, 10, 3};
                    } else if (this.buffer_TCP[1] == 87) {
                        int Class2 = 9;
                        int PS_UserDate = 1;
                        int sPLUno = this.CustomProtocol_DAHUA_GetNumber(this.buffer_TCP, 2);
                        int Note = this.CustomProtocol_DAHUA_GetNumber_FromCharNext(this.buffer_TCP, (byte)65);
                        BigDecimal Price = new BigDecimal(this.CustomProtocol_DAHUA_GetNumber_FromCharNext(this.buffer_TCP, (byte)66)).movePointLeft(2);
                        int Unit = this.CustomProtocol_DAHUA_GetNumber_FromCharNext(this.buffer_TCP, (byte)67) != 0 ? 2 : 3;
                        int PC_UserDate = this.CustomProtocol_DAHUA_GetNumber_FromCharNext(this.buffer_TCP, (byte)68);
                        int BarF1 = this.CustomProtocol_DAHUA_GetNumber_FromCharNext(this.buffer_TCP, (byte)69);
                        String Name = this.CustomProtocol_DAHUA_GetString_FromCharNext(this.buffer_TCP, (byte)72);
                        if (sPLUno > 0 && sPLUno <= 99979 && StringUtils.isNotBlank((CharSequence)Name)) {
                            this.addCache((DataJSONModel)((DPLUV5)new DPLUV5().setNo(Integer.valueOf(sPLUno))).setItemCode(Integer.valueOf(Note)).setUnit(Integer.valueOf(Unit)).setCategory(Integer.valueOf(Class2)).setName(Name).setPrint(new DPrintWithBitMapV1().setBitmap(Integer.valueOf(BarF1))).setTime(new DTimeV2().setUseDatePS(Integer.valueOf(PS_UserDate)).setUseDatePC(Integer.valueOf(PC_UserDate))).setPrice(new DPriceV2().setPrice(Price)).addPinyinSimple());
                        }
                        portManager.writeDataImmediately(this.CustomProtocol_DAHUA_ASK(new byte[]{48, 119, 48, 48, 48, 48, 97, 48, 13, 10, 3}, sPLUno, 4));
                    } else if (this.buffer_TCP[1] == 86) {
                        int Pos = this.CustomProtocol_DAHUA_FoundCharNext(this.buffer_TCP, (byte)65);
                        int Class3 = 9;
                        int PS_UserDate = 1;
                        int sPLUno = this.CustomProtocol_DAHUA_GetNumber(this.buffer_TCP, 2);
                        int Note = this.CustomProtocol_DAHUA_GetNumber_Lng(this.buffer_TCP, Pos, 7);
                        BigDecimal Price = new BigDecimal(this.CustomProtocol_DAHUA_GetNumber_Lng(this.buffer_TCP, Pos + 7, 6)).movePointLeft(2);
                        int Unit = this.buffer_TCP[Pos + 13] == 49 ? 2 : 3;
                        int PC_UserDate = this.CustomProtocol_DAHUA_GetNumber_Lng(this.buffer_TCP, Pos + 20, 3);
                        int BarF1 = this.CustomProtocol_DAHUA_GetNumber_Lng(this.buffer_TCP, Pos + 23, 2);
                        String Index = new String(this.buffer_TCP, Pos + 27, 13);
                        if (Index.equals("0000000000000")) {
                            Index = "";
                        }
                        if (StringUtils.isNotBlank((CharSequence)Index)) {
                            Index = Index.trim();
                        }
                        BigDecimal Tare = new BigDecimal(this.CustomProtocol_DAHUA_GetNumber_Lng(this.buffer_TCP, Pos + 40, 5)).movePointLeft(3);
                        String Name = this.CustomProtocol_DAHUA_GetString_FromCharNext(this.buffer_TCP, (byte)66);
                        String Text1 = this.CustomProtocol_DAHUA_GetString_FromCharNext(this.buffer_TCP, (byte)67);
                        String Text2 = this.CustomProtocol_DAHUA_GetString_FromCharNext(this.buffer_TCP, (byte)68);
                        if (sPLUno > 0 && sPLUno <= 99979 && StringUtils.isNotBlank((CharSequence)Name)) {
                            this.addCache((DataJSONModel)((DPLUV5)new DPLUV5().setNo(Integer.valueOf(sPLUno))).setItemCode(Integer.valueOf(Note)).setIndexBar(Index).setUnit(Integer.valueOf(Unit)).setCategory(Integer.valueOf(Class3)).setName(Name).setPrint(new DPrintWithBitMapV1().setBitmap(Integer.valueOf(BarF1))).setText(new DTextV1().addTexts(new String[]{Text1, Text2})).setTime(new DTimeV2().setUseDatePS(Integer.valueOf(PS_UserDate)).setUseDatePC(Integer.valueOf(PC_UserDate))).setPrice(new DPriceV2().setPrice(Price)).setTare(Tare).addPinyinSimple());
                        }
                        portManager.writeDataImmediately(this.CustomProtocol_DAHUA_ASK(new byte[]{48, 118, 48, 48, 48, 48, 97, 48, 13, 10, 3}, sPLUno, 4));
                    } else if (this.buffer_TCP[1] == 80) {
                        int Year = this.CustomProtocol_DAHUA_GetNumber_Lng(this.buffer_TCP, 2, 2);
                        int Month = this.CustomProtocol_DAHUA_GetNumber_Lng(this.buffer_TCP, 4, 2);
                        int DayMonth = this.CustomProtocol_DAHUA_GetNumber_Lng(this.buffer_TCP, 6, 2);
                        int Hour = this.CustomProtocol_DAHUA_GetNumber_Lng(this.buffer_TCP, 8, 2);
                        int Minute = this.CustomProtocol_DAHUA_GetNumber_Lng(this.buffer_TCP, 10, 2);
                        boolean Second = false;
                        portManager.writeDataImmediately(new byte[]{48, 112, 13, 10, 3});
                    } else {
                        byte[] answer = new String(new byte[]{this.buffer_TCP[1]}).toLowerCase().getBytes();
                        portManager.writeDataImmediately(new byte[]{48, answer[0], 13, 10, 3});
                    }
                }
                this.buffer_TCP_Pose = 0;
                continue;
            }
            if (this.buffer_TCP_Pose >= this.buffer_TCP.length) continue;
            this.buffer_TCP[this.buffer_TCP_Pose - 1] = Data2;
            ++this.buffer_TCP_Pose;
        }
        return response;
    }

    @Override
    public byte[] udp(PortManager portManager, InetAddress address, int port, byte[] bytes) {
        byte[] response = new byte[]{};
        int send = 0;
        if (bytes != null && bytes.length > 0) {
            for (int loop = 0; loop < bytes.length; ++loop) {
                if (bytes[loop] == 85) {
                    send = 1;
                    continue;
                }
                if (bytes[loop] == 87) {
                    send = 2;
                    continue;
                }
                if (bytes[loop] != 89) continue;
                send = 3;
            }
        }
        if (send == 1) {
            byte[] output = new byte[]{69, 84, 79, 82, 83, 50, 51, 50, 95, 48, 48, 48, 32, 32, 32, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            output[16] = -64;
            output[17] = -88;
            output[18] = 100;
            output[19] = -63;
            output[20] = 1;
            output[21] = 2;
            output[22] = 3;
            output[23] = 4;
            output[24] = 5;
            output[25] = 6;
            response = output;
        }
        return response;
    }

    private int CustomProtocol_DAHUA_GetNumber(byte[] input, int offset) {
        int rv = 0;
        int ctv;
        while ((ctv = input[offset] - 48) <= 9 && ctv >= 0) {
            rv = rv * 10 + ctv;
            ++offset;
        }
        return rv;
    }

    private int CustomProtocol_DAHUA_GetNumber_FromCharNext(byte[] input, byte Char) {
        int Pos = this.CustomProtocol_DAHUA_FoundCharNext(input, Char);
        if (Pos == 0) {
            return 0;
        }
        return this.CustomProtocol_DAHUA_GetNumber(input, Pos);
    }

    private int CustomProtocol_DAHUA_FoundCharNext(byte[] input, byte Char) {
        for (int Loop = 2; Loop < input.length; ++Loop) {
            byte ct = input[Loop];
            if (ct == 0) {
                return 0;
            }
            if (ct != Char) continue;
            return Loop + 1;
        }
        return 0;
    }

    private String CustomProtocol_DAHUA_GetString_FromCharNext(byte[] input, byte Char) {
        int sPos = this.CustomProtocol_DAHUA_FoundCharNext(input, Char);
        if (sPos == 0) {
            return "";
        }
        String txt = this.CustomProtocol_DAHUA_GetString(input, sPos);
        if (StringUtils.isNotBlank((CharSequence)txt)) {
            txt = txt.trim();
        }
        return txt;
    }

    private String CustomProtocol_DAHUA_GetString(byte[] input, int offset) {
        String result;
        byte[] target = new byte[1024];
        int tPos = 0;
        if (input[offset] == 0) {
            return "";
        }
        while (true) {
            if (tPos >= target.length - 3) {
                target[tPos] = 0;
                break;
            }
            int a1 = input[offset] - 48;
            int a2 = input[offset + 1] - 48;
            int b1 = input[offset + 2] - 48;
            int b2 = input[offset + 3] - 48;
            int rv0 = a1 * 10 + a2;
            int rv1 = b1 * 10 + b2;
            if (rv0 < 0 || rv0 > 99 || rv1 < 0 || rv1 > 99) {
                rv1 = 0;
                rv0 = 0;
            }
            if (rv0 == 0) {
                target[tPos] = 0;
                break;
            }
            if (rv0 == 1 && rv1 == 1) {
                target[tPos] = 32;
                ++tPos;
            } else if (rv0 == 3 && rv1 <= 95) {
                target[tPos] = (byte)(rv1 + 32);
                ++tPos;
            } else {
                target[tPos] = (byte)(rv0 + 160);
                target[tPos + 1] = (byte)(rv1 + 160);
                tPos += 2;
            }
            offset += 4;
        }
        try {
            result = new String(target, "GB2312");
        }
        catch (Exception exp) {
            result = "";
        }
        if (result.equals("\u4e0a\u6d77\u5927\u534e\u7535\u5b50\u79e4\u5382")) {
            result = "\u4e0a\u6d77\u7cbe\u51fd\u4fe1\u606f\u79d1\u6280\u6709\u9650\u516c\u53f8";
        }
        return result;
    }

    private byte[] CustomProtocol_DAHUA_ASK(byte[] input, int value, int lng) {
        while (lng > 0) {
            input[2 + --lng] = (byte)(value % 10 + 48);
            value /= 10;
        }
        return input;
    }

    private int CustomProtocol_DAHUA_GetNumber_Lng(byte[] input, int offset, int lng) {
        int result = 0;
        for (int loop = 0; loop < lng; ++loop) {
            result = input[offset + loop] - 48 + result * 10;
        }
        return result;
    }
}

