/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.other.cmpt;

import com.jhscale.common.model.device.plu.DPLUV5;
import com.jhscale.common.model.device.plu.module.DPriceV2;
import com.jhscale.common.model.device.plu.module.DTimeV2;
import com.jhscale.common.model.inter.DataJSONModel;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.protocol.other.cmpt.ACMPTAction;
import java.math.BigDecimal;
import java.net.InetAddress;
import org.apache.commons.lang3.StringUtils;

public class Toledo_ACMPT
extends ACMPTAction<Toledo_ACMPT> {
    @Override
    public boolean Init_UDP() throws MeterException {
        return true;
    }

    @Override
    public byte[] tcp_server(PortManager portManager, byte[] bytes) throws MeterException {
        byte[] response = new byte[]{};
        for (int loop = 0; loop < bytes.length; ++loop) {
            byte Data2 = bytes[loop];
            if (this.buffer_TCP_Pose == 0) {
                if (Data2 != 2) continue;
                this.buffer_TCP_Pose = 1;
                continue;
            }
            if (this.buffer_TCP_Pose <= 14) {
                this.buffer_TCP[this.buffer_TCP_Pose - 1] = Data2;
                ++this.buffer_TCP_Pose;
                continue;
            }
            int Local_Lng = this.GetU16(this.buffer_TCP, 4);
            int Local_Records = this.GetU16(this.buffer_TCP, 2);
            int Local_Type = this.buffer_TCP[7] & 0xFF;
            int Local_NeedVersion = this.buffer_TCP[9] & 0xFF;
            if (Local_Lng == 0) {
                this.buffer_TCP_Pose = 0;
                continue;
            }
            if (this.buffer_TCP_Pose < this.buffer_TCP.length - 3) {
                this.buffer_TCP[this.buffer_TCP_Pose - 3] = Data2;
            }
            ++this.buffer_TCP_Pose;
            if (Local_Records == 0) {
                if (this.buffer_TCP_Pose < 17) continue;
                this.buffer_TCP_Pose = 0;
                portManager.writeDataImmediately(new byte[]{102, 2, 14, 0, 1, 0, 6, 0, 1, -18, 0, -64, -77, 1, 0, 0, 20, 7, 15, 14, 14, 37, 48, 59});
                continue;
            }
            if (this.buffer_TCP_Pose < 15 + Local_Lng) continue;
            if (Local_Type == 238 && Local_Lng == 6) {
                byte DayMonth = this.buffer_TCP[12];
                byte Month = this.buffer_TCP[13];
                byte Year = this.buffer_TCP[14];
                byte Hour = this.buffer_TCP[15];
                byte Minute = this.buffer_TCP[16];
                byte by = this.buffer_TCP[17];
            } else if (Local_Type == 207 && Local_Lng == 68) {
                String Name;
                int Loop = 28;
                while (this.buffer_TCP[29 + --Loop] == 32) {
                    this.buffer_TCP[29 + Loop] = 0;
                    if (Loop != 0) continue;
                }
                try {
                    Name = new String(this.buffer_TCP, 29, 28, "GB2312");
                }
                catch (Exception exp) {
                    Name = "";
                }
                if (StringUtils.isNotBlank((CharSequence)Name)) {
                    Name = Name.trim();
                }
                int Class2 = 9;
                int PS_UserDate = 1;
                int sPLUno = this.GetS32(this.buffer_TCP, 12);
                int Note = this.CustomProtocol_DAHUA_GetNumber_Lng(this.buffer_TCP, 16, 13);
                BigDecimal Price = new BigDecimal(this.GetS32(this.buffer_TCP, 58)).movePointLeft(2);
                int Unit = (this.buffer_TCP[72] & 1) != 0 ? 2 : 1;
                int PC_UserDate = this.GetU16(this.buffer_TCP, 76);
                if (sPLUno > 0 && sPLUno <= 99979 && StringUtils.isNotBlank((CharSequence)Name)) {
                    this.addCache((DataJSONModel)((DPLUV5)new DPLUV5().setNo(Integer.valueOf(sPLUno))).setItemCode(Integer.valueOf(Note)).setUnit(Integer.valueOf(Unit)).setCategory(Integer.valueOf(Class2)).setName(Name).setTime(new DTimeV2().setUseDatePS(Integer.valueOf(PS_UserDate)).setUseDatePC(Integer.valueOf(PC_UserDate))).setPrice(new DPriceV2().setPrice(Price)).addPinyinSimple());
                }
            }
            this.buffer_TCP[2] = (byte)(--Local_Records & 0xFF);
            this.buffer_TCP[3] = (byte)(Local_Records >> 8);
            this.buffer_TCP_Pose = 15;
        }
        return response;
    }

    @Override
    public byte[] udp(PortManager portManager, InetAddress address, int port, byte[] bytes) {
        return new byte[0];
    }

    private int GetU16(byte[] input, int offset) {
        return (input[offset] & 0xFF) + (input[offset + 1] & 0xFF) * 256;
    }

    private int GetS32(byte[] input, int offset) {
        return (input[offset] & 0xFF) + (input[offset + 1] & 0xFF) * 256 + (input[offset + 2] & 0xFF) * 65536 + (input[offset + 3] & 0xFF) * 0x1000000;
    }

    private int CustomProtocol_DAHUA_GetNumber_Lng(byte[] input, int offset, int lng) {
        int result = 0;
        for (int loop = 0; loop < lng; ++loop) {
            result = input[offset + loop] - 48 + result * 10;
        }
        return result;
    }
}

