/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print;

import com.jhscale.common.utils.SystemtUtils;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.print.PrintUpgradeThread;
import com.jhscale.meter.protocol.print.entity.PrintLOGParam;
import com.jhscale.meter.protocol.print.entity.PrintRequest;
import com.jhscale.meter.protocol.print.entity.PrintResponse;
import com.jhscale.meter.protocol.print.entity.ScheduleState;
import com.jhscale.meter.protocol.print.entity.cmd.Print0000Request;
import com.jhscale.meter.protocol.print.entity.cmd.Print0000Response;
import com.jhscale.meter.protocol.print.entity.cmd.Print0200Request;
import com.jhscale.meter.protocol.print.entity.cmd.Print0200Response;
import com.jhscale.meter.protocol.print.entity.file.PrintFileRequest;
import com.jhscale.meter.protocol.print.entity.file.bitmap.PrintBitMapRequest;
import com.jhscale.meter.protocol.print.entity.file.font.PrintFontRequest;
import com.jhscale.meter.protocol.print.entity.file.upgrade.PrintUpgradeRequest;
import com.jhscale.meter.protocol.print.entity.para.Para;
import com.jhscale.meter.protocol.print.link.IPrintBack;
import com.jhscale.meter.protocol.print.link.Messenger;
import com.jhscale.meter.protocol.print.produce.entity.PrintBackResponse;
import com.jhscale.meter.utils.PrintUtils;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public interface PrintCommunication {
    public void setSerial(Integer var1);

    public Integer getSerial();

    default public PrintCommunication communication() {
        return this;
    }

    public boolean checkCommunication() throws MeterException;

    public Messenger messenger();

    public void addSendCmd(String var1, PrintRequest var2) throws MeterException;

    public void sendCmd(String var1, PrintRequest var2) throws MeterException;

    default public void sendCmd(PrintRequest request) throws MeterException {
        this.checkCommunication();
        request.setCommunication(this);
        PrintUtils.debug(this.param(), String.format("PrintType [ %s ] Content[ %s ]", "Direct Send", request.getContent()));
        this.addSendCmd(request.cmd(), request);
    }

    default public void sendData(PrintRequest request) throws MeterException {
        this.checkCommunication();
        request.setCommunication(this);
        String content = request.assembler().toString();
        if (StringUtils.isNotBlank((CharSequence)content)) {
            request.setContent(content);
        }
        PrintUtils.debug(this.param(), String.format("PrintType [ %s ] Content[ %s ]", request.printType().getBitVal(), request.getContent()));
        this.addSendCmd(request.printType().init(), request);
    }

    default public void sendDataWithoutAssemble(PrintRequest request) throws MeterException {
        this.checkCommunication();
        request.setCommunication(this);
        PrintUtils.debug(this.param(), String.format("PrintType [ %s ] Content[ %s ]", request.printType().getBitVal(), request.getContent()));
        this.addSendCmd(request.printType().init(), request);
    }

    default public void sendDataWithAllPackage(PrintRequest request) throws MeterException {
        this.checkCommunication();
        request.setCommunication(this);
        String content = request.assembler().toString();
        if (StringUtils.isNotBlank((CharSequence)content)) {
            request.setContent(content);
        }
        PrintUtils.debug(this.param(), String.format("PrintType [ %s ] Content[ %s ]", "Direct Send", request.getContent()));
        request.setAll(true);
        request.setFirst(false);
        this.addSendCmd(null, request);
    }

    public void addParas(List<Para> var1) throws MeterException;

    public void clearPara();

    public List<Para> paras();

    public boolean originalResponse();

    public PrintLOGParam param();

    public void logSwitch(boolean var1, Integer var2);

    public boolean isSendStatus();

    public void sendSuccess();

    public void closeMessenger();

    default public List<Integer> getUpgradeFileParam(PrintFileRequest request) throws MeterException {
        request.checkUpgradeFile(request.getUpgradeFileName());
        return request.getNameParams();
    }

    default public void upgrade(final PrintFileRequest request) throws MeterException {
        Print0200Request print0200Request = new Print0200Request();
        print0200Request.setSdk(true);
        print0200Request.setUpgrade(true);
        print0200Request.setPrintBack(new IPrintBack(){

            @Override
            public void responseBack(PrintResponse response) {
                block3: {
                    try {
                        if (!((Print0200Response)response).isResult()) {
                            throw new MeterException(MeterStateEnum.\u6253\u5370\u5347\u7ea7\u4fdd\u62a4\u5931\u8d25);
                        }
                        request.setUpgrade(true);
                        PrintCommunication.this.sendData(request);
                    }
                    catch (MeterException e) {
                        e.printStackTrace();
                        if (!Objects.nonNull(request.getPrintBack())) break block3;
                        request.getPrintBack().responseBack(PrintBackResponse.fail(PrintCommunication.this.getSerial(), e.getMeterState()));
                    }
                }
            }
        });
        this.sendData(print0200Request);
    }

    default public void upgrade_all(final PrintFileRequest request) throws MeterException {
        SystemtUtils.sleep((int)2);
        Print0200Request print0200Request = new Print0200Request();
        print0200Request.setSdk(true);
        print0200Request.setUpgrade(true);
        print0200Request.setPrintBack(new IPrintBack(){

            @Override
            public void responseBack(PrintResponse response) {
                block3: {
                    try {
                        if (!((Print0200Response)response).isResult()) {
                            throw new MeterException(MeterStateEnum.\u6253\u5370\u5347\u7ea7\u4fdd\u62a4\u5931\u8d25);
                        }
                        PrintFileRequest printFileRequest = null;
                        printFileRequest = request instanceof PrintFontRequest ? new PrintFontRequest() : (request instanceof PrintBitMapRequest ? new PrintBitMapRequest() : new PrintUpgradeRequest());
                        printFileRequest.setFile(request.getFile());
                        printFileRequest.setName(request.getName());
                        printFileRequest.setInputStream(request.getInputStream());
                        printFileRequest.setNameParams(request.getNameParams());
                        printFileRequest.setHexData(request.getHexData());
                        printFileRequest.setCommunication(request.getCommunication());
                        printFileRequest.setName(request.getName());
                        printFileRequest.setUpgrade(true);
                        final PrintUpgradeThread printUpgradeThread = new PrintUpgradeThread("upgrade_all after", PrintCommunication.this.communication(), request.getPrintBack());
                        printUpgradeThread.start();
                        printFileRequest.setPrintBack(new IPrintBack(){

                            @Override
                            public void schedule(ScheduleState scheduleState) {
                                if (request.getPrintBack() != null) {
                                    request.getPrintBack().schedule(scheduleState);
                                }
                            }

                            @Override
                            public void responseBack(PrintBackResponse response) {
                                System.out.println(String.format("\u5347\u7ea7\u54cd\u5e94\uff1a\u3010%s\u3011", response.toString()));
                                printUpgradeThread.response(response);
                            }
                        });
                        PrintCommunication.this.sendDataWithAllPackage(printFileRequest);
                    }
                    catch (MeterException e) {
                        e.printStackTrace();
                        if (!Objects.nonNull(request.getPrintBack())) break block3;
                        request.getPrintBack().responseBack(PrintBackResponse.fail(PrintCommunication.this.getSerial(), e.getMeterState()));
                    }
                }
            }
        });
        this.sendData(print0200Request);
    }

    default public void checkUpgrade(final List<Integer> nameParas, final IPrintBack printBack) throws MeterException {
        if (nameParas == null || nameParas.size() > 2) {
            throw new MeterException(MeterStateEnum.\u65e0\u6548\u5347\u7ea7\u6587\u4ef6\u68c0\u67e5);
        }
        Print0000Request request = new Print0000Request();
        request.setSdk(true);
        request.setPrintBack(new IPrintBack(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void responseBack(PrintResponse printResponse) {
                if (!Objects.nonNull(printBack)) return;
                Print0000Response response = (Print0000Response)printResponse;
                try {
                    if (nameParas.size() == 1) {
                        if (!response.getFontVersion().equals(((Integer)nameParas.get(0)).toString())) throw new MeterException(MeterStateEnum.\u5b57\u5e93\u672a\u5347\u7ea7\u6210\u529f);
                        printBack.responseBack(PrintBackResponse.success(PrintCommunication.this.getSerial()));
                        return;
                    } else if (nameParas.size() == 2) {
                        if (!response.getFirmwareVersion().equals(((Integer)nameParas.get(0)).toString()) || !response.getUpgradeVersion().equals(((Integer)nameParas.get(1)).toString())) throw new MeterException(MeterStateEnum.\u7248\u672c\u672a\u5347\u7ea7\u6210\u529f);
                        printBack.responseBack(PrintBackResponse.success(PrintCommunication.this.getSerial()));
                        return;
                    } else {
                        printBack.responseBack(PrintBackResponse.success(PrintCommunication.this.getSerial()));
                    }
                    return;
                }
                catch (MeterException e) {
                    e.printStackTrace();
                    printBack.responseBack(PrintBackResponse.fail(PrintCommunication.this.getSerial(), e.getMeterState()));
                }
            }
        });
        this.sendData(request);
    }
}

