/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print;

import com.jhscale.common.model.license.RSAEncryptDecrypt;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.print.PrintCommunication;
import com.jhscale.meter.protocol.print.PrintConstant;
import com.jhscale.meter.protocol.print.data.PrintDataAssemble;
import com.jhscale.meter.protocol.print.data.PrintDataParse;
import com.jhscale.meter.protocol.print.data.PrintVal;
import com.jhscale.meter.protocol.print.entity.PrintCmdInfo;
import com.jhscale.meter.protocol.print.entity.PrintLOGParam;
import com.jhscale.meter.protocol.print.entity.PrintRequest;
import com.jhscale.meter.protocol.print.entity.PrintResponse;
import com.jhscale.meter.protocol.print.entity.data.PrintDataRequest;
import com.jhscale.meter.protocol.print.entity.para.Para;
import com.jhscale.meter.protocol.print.entity.para.RealBitmapPara;
import com.jhscale.meter.protocol.print.image.ImageProcess;
import com.jhscale.meter.protocol.print.link.IPrintBack;
import com.jhscale.meter.protocol.print.link.Messenger;
import com.jhscale.meter.protocol.print.link.ReadReuslt;
import com.jhscale.meter.protocol.print.link.SendResult;
import com.jhscale.meter.protocol.print.produce.entity.PrintBackResponse;
import com.jhscale.meter.protocol.print.temp.Temp;
import com.jhscale.meter.protocol.print.temp.Temp1;
import com.jhscale.meter.utils.PrintUtils;
import java.lang.reflect.ParameterizedType;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class PrintFactory
implements PrintCommunication {
    private String charset = "UTF-8";
    private ImageProcess imageProcess;
    private RSAEncryptDecrypt encryptDecrypt;
    private List<PrintDataParse.PrintPart> printParts;
    private Integer serial;
    private Messenger messenger;
    private Long communicationMaxTime = PrintConstant.SINGLE_COMMUNICATION_MAX_TIME;
    private List<Para> paraCache;
    private boolean originalResponse = false;
    private PrintLOGParam param;
    private List<PrintCmdInfo> printCmdInfoList;
    private SendPrintThread thread;
    private boolean threadStatus = false;
    private boolean sendStatus = false;
    private PrintCmdInfo now;
    private int count = 0;
    private Integer sleep = 10;
    private Integer max = 50;
    private boolean timeout = true;

    public PrintFactory addRSAEncryptDecrypt(RSAEncryptDecrypt encryptDecrypt) {
        this.encryptDecrypt = encryptDecrypt;
        return this;
    }

    public RSAEncryptDecrypt obtainRSAEncryptDecrypt() throws MeterException {
        if (this.encryptDecrypt == null) {
            throw new MeterException(MeterStateEnum.\u52a0\u89e3\u5bc6\u6a21\u5757\u672a\u521d\u59cb\u5316);
        }
        return this.encryptDecrypt;
    }

    public Charset charset() {
        return Charset.forName(this.charset);
    }

    public PrintFactory setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    public String getCharset() {
        return this.charset;
    }

    public PrintFactory originalResponse(boolean originalResponse) {
        this.originalResponse = originalResponse;
        return this;
    }

    @Override
    public boolean originalResponse() {
        return this.originalResponse;
    }

    @Override
    public PrintLOGParam param() {
        if (this.param == null) {
            this.param = new PrintLOGParam();
        }
        return this.param;
    }

    @Override
    public void logSwitch(boolean logSwitch, Integer logLength) {
        if (this.param == null) {
            this.param = new PrintLOGParam();
        }
        this.param.set_switch(logSwitch);
        this.param.set_length(Objects.isNull(logLength) || logLength == 0 ? 2048 : logLength);
    }

    private PrintFactory() {
    }

    public static PrintFactory getInstance() {
        return SinglePrintFactory.INSTANCE;
    }

    @Deprecated
    public PrintFactory build(String charset, List<PrintDataParse.PrintPart> printParts, Messenger messenger, Long communicationMaxTime) throws MeterException {
        return this.setCharset(charset).setPrintParts(printParts).setMessenger(messenger).setCommunicationMaxTime(communicationMaxTime);
    }

    public PrintFactory build(String charset, List<PrintDataParse.PrintPart> printParts, Messenger messenger) throws MeterException {
        return this.setCharset(charset).setPrintParts(printParts).setMessenger(messenger);
    }

    public PrintFactory build(List<PrintDataParse.PrintPart> printParts, Messenger messenger) throws MeterException {
        return this.setPrintParts(printParts).setMessenger(messenger);
    }

    public PrintFactory build(Messenger messenger) {
        return this.setMessenger(messenger);
    }

    public PrintFactory build(Integer serial, Messenger messenger) {
        this.serial = serial;
        return this.setMessenger(messenger);
    }

    public PrintFactory build(ImageProcess imageProcess) {
        return this.setImageProcess(imageProcess);
    }

    public PrintDataParse templateAnalysisPrintData(String template) throws MeterException {
        if (StringUtils.isBlank((CharSequence)template)) {
            throw new MeterException(MeterStateEnum.\u89e3\u6790\u6a21\u677f\u65e0\u6548);
        }
        return new PrintDataParse(template);
    }

    public List<PrintDataParse.PrintPart> templateAnalysis(String template) throws MeterException {
        return this.templateAnalysisPrintData(template).getPrintParts();
    }

    public PrintFactory templateAnalysisAndSet(String template) throws MeterException {
        return this.setPrintParts(this.templateAnalysis(template));
    }

    public PrintFactory setPrintParts(List<PrintDataParse.PrintPart> printParts) throws MeterException {
        if (printParts == null || printParts.isEmpty()) {
            throw new MeterException(MeterStateEnum.\u6a21\u677f\u7247\u6bb5\u65e0\u6548);
        }
        this.printParts = printParts;
        return this;
    }

    public List<PrintDataParse.PrintPart> getUsingPrintParts() {
        return this.printParts;
    }

    public PrintFactory putMapping(Integer index, String field, String mapping) throws MeterException {
        if (this.printParts == null) {
            throw new MeterException(MeterStateEnum.\u6253\u5370\u6a21\u677f\u6570\u636e\u672a\u8bbe\u7f6e);
        }
        if (index >= this.printParts.size()) {
            throw new MeterException(MeterStateEnum.\u6a21\u677f\u7247\u6bb5\u4e0d\u5b58\u5728);
        }
        this.getUsingPrintParts().get(index).putMapping(field, mapping);
        return this;
    }

    public PrintFactory putMappings(Integer index, Map<String, String> mappings) throws MeterException {
        if (this.printParts == null) {
            throw new MeterException(MeterStateEnum.\u6253\u5370\u6a21\u677f\u6570\u636e\u672a\u8bbe\u7f6e);
        }
        if (index >= this.printParts.size()) {
            throw new MeterException(MeterStateEnum.\u6a21\u677f\u7247\u6bb5\u4e0d\u5b58\u5728);
        }
        this.getUsingPrintParts().get(index).setMappings(mappings);
        return this;
    }

    public String assemblePrintData(PrintVal printVal) throws MeterException {
        if (this.printParts == null) {
            throw new MeterException(MeterStateEnum.\u6253\u5370\u6a21\u677f\u6570\u636e\u672a\u8bbe\u7f6e);
        }
        return new PrintDataAssemble(this.charset(), this.printParts, printVal).assemble();
    }

    public PrintFactory setImageProcess(ImageProcess imageProcess) {
        if (this.imageProcess == null) {
            this.imageProcess = imageProcess;
        }
        return this;
    }

    public ImageProcess getImageProcess() {
        return this.imageProcess;
    }

    @Deprecated
    public PrintFactory setCommunicationMaxTime(Long communicationMaxTime) {
        this.communicationMaxTime = communicationMaxTime;
        return this;
    }

    public PrintFactory setMessenger(Messenger messenger) {
        if (this.messenger == null) {
            this.messenger = messenger;
        }
        if (this.printCmdInfoList == null) {
            this.printCmdInfoList = Collections.synchronizedList(new ArrayList());
        }
        this.printCmdInfoList.clear();
        this.threadStatus = true;
        this.sendStatus = false;
        if (this.thread == null) {
            this.thread = new SendPrintThread();
            this.thread.start();
        }
        return this;
    }

    @Override
    public void sendSuccess() {
        this.sendStatus = false;
        this.count = 0;
        this.now = null;
    }

    @Override
    public boolean isSendStatus() {
        return this.sendStatus;
    }

    @Override
    public void closeMessenger() {
        if (this.messenger != null) {
            this.messenger.close();
            this.messenger = null;
        }
        this.threadStatus = false;
        this.sendStatus = false;
        if (this.printCmdInfoList != null) {
            this.printCmdInfoList.clear();
            this.printCmdInfoList = null;
        }
        if (this.thread != null) {
            this.thread = null;
        }
    }

    public void setSleep(Integer sleep) {
        this.sleep = sleep;
    }

    public void setMax(Integer max, boolean timeout) {
        this.max = Objects.nonNull(max) ? max : 50;
        this.timeout = timeout;
    }

    @Deprecated
    public String communication(String content) throws MeterException {
        if (this.messenger == null || !this.threadStatus) {
            throw new MeterException(MeterStateEnum.\u901a\u8baf\u7ec4\u4ef6\u672a\u521d\u59cb\u5316);
        }
        long start = System.currentTimeMillis();
        SendResult sendResult = this.messenger.send(content);
        while (this.messenger.effectiveCommunicationTime(sendResult.getCommunicationLogo())) {
            if (System.currentTimeMillis() - start > this.communicationMaxTime) {
                throw new MeterException(MeterStateEnum.\u901a\u8baf\u8d85\u65f6);
            }
            ReadReuslt readReuslt = this.messenger.read(sendResult.getCommunicationLogo());
            if (readReuslt.hasResponse()) {
                return readReuslt.getResponse();
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        throw new MeterException(MeterStateEnum.\u901a\u8baf\u8d85\u65f6);
    }

    @Override
    public void setSerial(Integer serial) {
        this.serial = serial;
    }

    @Override
    public Integer getSerial() {
        return this.serial;
    }

    @Override
    public boolean checkCommunication() throws MeterException {
        if (this.messenger == null || !this.threadStatus) {
            throw new MeterException(MeterStateEnum.\u901a\u8baf\u7ec4\u4ef6\u672a\u521d\u59cb\u5316);
        }
        return true;
    }

    @Override
    public Messenger messenger() {
        return this.messenger;
    }

    @Override
    public void addSendCmd(String cmd, PrintRequest request) throws MeterException {
        this.checkCommunication();
        this.sendSuccess();
        this.printCmdInfoList.add(new PrintCmdInfo(cmd, request));
    }

    @Override
    public void sendCmd(String cmd, PrintRequest request) throws MeterException {
        try {
            request.setCommunication(this);
            Class clazz = (Class)((ParameterizedType)request.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            this.messenger.sendCmd(cmd, request, (PrintResponse)clazz.newInstance());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MeterException(MeterStateEnum.\u7cfb\u7edf\u5f02\u5e38_V1);
        }
    }

    @Override
    public void addParas(List<Para> paras) throws MeterException {
        if (this.paraCache == null) {
            this.paraCache = new ArrayList<Para>();
        }
        PrintUtils.debug(this.param(), paras);
        if (paras != null && !paras.isEmpty()) {
            for (Para para : paras) {
                if (!(para instanceof RealBitmapPara)) continue;
                throw new MeterException(MeterStateEnum.\u5b9e\u65f6\u4f4d\u56fe\u4f7f\u7528\u4e13\u7528\u63a5\u53e3);
            }
            this.paraCache.addAll(paras);
        }
        PrintUtils.debug(this.param(), this.paraCache);
    }

    @Override
    public void clearPara() {
        if (this.paraCache != null) {
            this.paraCache.clear();
            this.paraCache = null;
        }
    }

    @Override
    public List<Para> paras() {
        return this.paraCache;
    }

    @Deprecated
    public void printTemp(IPrintBack printBack, PrintVal printVal) throws MeterException {
        if (this.messenger == null || !this.threadStatus) {
            throw new MeterException(MeterStateEnum.\u901a\u8baf\u7ec4\u4ef6\u672a\u521d\u59cb\u5316);
        }
        if (this.printParts == null) {
            new Temp1().tempInit();
        }
        String data = this.assemblePrintData(printVal);
        PrintDataRequest request = new PrintDataRequest();
        request.setPrintBack(printBack);
        request.setData(data);
        this.sendData(request);
    }

    public void printTemp(IPrintBack printBack, PrintVal printVal, Temp temp) throws MeterException {
        if (this.messenger == null || !this.threadStatus) {
            throw new MeterException(MeterStateEnum.\u901a\u8baf\u7ec4\u4ef6\u672a\u521d\u59cb\u5316);
        }
        if (temp != null) {
            temp.tempInit();
        } else if (this.printParts == null) {
            new Temp1().tempInit();
        }
        String data = this.assemblePrintData(printVal);
        PrintDataRequest request = new PrintDataRequest();
        request.setPrintBack(printBack);
        request.setData(data);
        this.sendData(request);
    }

    private class SendPrintThread
    extends Thread {
        private int max_length;

        public SendPrintThread() {
            super("SendPrintThread");
            this.max_length = 510;
        }

        @Override
        public void run() {
            while (PrintFactory.this.threadStatus && !this.isInterrupted()) {
                if (!PrintFactory.this.sendStatus) {
                    this.printExecute();
                    continue;
                }
                try {
                    Thread.sleep(PrintFactory.this.sleep.intValue());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                PrintFactory.this.count++;
                if (PrintFactory.this.count <= PrintFactory.this.max || PrintFactory.this.now == null) continue;
                if (PrintFactory.this.timeout) {
                    PrintFactory.this.now.getRequest().timeOut();
                }
                PrintFactory.this.now.getRequest().getCommunication().sendSuccess();
            }
        }

        private synchronized void printExecute() {
            try {
                block11: {
                    if (PrintFactory.this.printCmdInfoList != null && !PrintFactory.this.printCmdInfoList.isEmpty()) {
                        try {
                            PrintFactory.this.now = (PrintCmdInfo)PrintFactory.this.printCmdInfoList.remove(0);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (PrintFactory.this.now != null) {
                            try {
                                PrintFactory.this.sendStatus = true;
                                if (PrintFactory.this.now.getRequest().isAll()) {
                                    while (PrintFactory.this.now != null && !PrintFactory.this.now.getRequest().isEnd()) {
                                        PrintFactory.this.now.getRequest().setSubContentLength(this.max_length);
                                        PrintFactory.this.now.getRequest().getCommunication().sendCmd(PrintFactory.this.now.getRequest().cmd(), PrintFactory.this.now.getRequest());
                                    }
                                } else {
                                    PrintFactory.this.sendCmd(PrintFactory.this.now.getCmd(), PrintFactory.this.now.getRequest());
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                PrintFactory.this.sendSuccess();
                                IPrintBack printBack = PrintFactory.this.now.getRequest().getPrintBack();
                                if (printBack == null) break block11;
                                printBack.responseBack(PrintBackResponse.fail(PrintFactory.this.getSerial(), "101", "\u7cfb\u7edf\u5f02\u5e38:" + e.getMessage()));
                            }
                        }
                    }
                }
                Thread.sleep(3L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class SinglePrintFactory {
        private static PrintFactory INSTANCE = new PrintFactory();

        private SinglePrintFactory() {
        }
    }
}

