/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print;

import com.jhscale.common.model.device._inner.DLOGContent;
import com.jhscale.common.model.device.bitmap.DBitMap;
import com.jhscale.common.model.device.font.DFont;
import com.jhscale.common.model.device.info.DServerInfo;
import com.jhscale.common.model.device.saleman.DSaleMan;
import com.jhscale.common.utils.ArrayUtils;
import com.jhscale.common.utils.GJSONUtils;
import com.jhscale.common.utils.SystemtUtils;
import com.jhscale.meter.entity.CPReport;
import com.jhscale.meter.entity.LOGReport;
import com.jhscale.meter.entity.PLUReport;
import com.jhscale.meter.entity.server.CPServerReport;
import com.jhscale.meter.entity.server.LOGServerReport;
import com.jhscale.meter.entity.server.PLUServerReport;
import com.jhscale.meter.entity.server.ZXDOrder;
import com.jhscale.meter.entity.server.order.Address;
import com.jhscale.meter.entity.server.order.DistributorNote;
import com.jhscale.meter.entity.server.order.MerchantNote;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.protocol.model.PrintContent;
import com.jhscale.meter.protocol.model.PrintState;
import com.jhscale.meter.protocol.model.TradeContent;
import com.jhscale.meter.protocol.print.em.Dir;
import com.jhscale.meter.protocol.print.em.Grid;
import com.jhscale.meter.protocol.print.em.PrintParamSave;
import com.jhscale.meter.protocol.print.entity.PrintRequest;
import com.jhscale.meter.protocol.print.entity.PrintResponse;
import com.jhscale.meter.protocol.print.entity.ServerNotify;
import com.jhscale.meter.protocol.print.entity.cmd.Print0100Request;
import com.jhscale.meter.protocol.print.entity.data.PrintDataRequest;
import com.jhscale.meter.protocol.print.entity.data.PrintTradeRequest;
import com.jhscale.meter.protocol.print.entity.file.bitmap.PrintBitMapRequest;
import com.jhscale.meter.protocol.print.entity.file.font.PrintFontRequest;
import com.jhscale.meter.protocol.print.entity.para.TempBitmapPara;
import com.jhscale.meter.protocol.print.line.PrintLine;
import com.jhscale.meter.protocol.print.line.PrintLineE;
import com.jhscale.meter.protocol.print.line.PrintLineLMR;
import com.jhscale.meter.protocol.print.line.PrintLineN;
import com.jhscale.meter.protocol.print.link.IPrintBack;
import com.jhscale.meter.protocol.print.link.Messenger;
import com.jhscale.meter.protocol.print.produce.IPrintBasic;
import com.jhscale.meter.protocol.print.produce.entity.PrintBackResponse;
import com.jhscale.meter.protocol.print.produce.entity.PrintInfoResponse;
import com.jhscale.meter.protocol.print.produce.impl.PrintProcessor;
import com.jhscale.meter.protocol.print.produce.impl.PrintProcessor_A;
import com.jhscale.meter.protocol.print.produce.impl.PrintProcessor_B;
import com.jhscale.meter.protocol.print.produce.impl.PrintProduce;
import com.jhscale.meter.utils.FileUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class PrintGeneralFactory
implements GlobalPara.GlobalParaRefresh {
    private Map<Integer, PrintProcessor> printProcessorMap;
    private Map<Integer, PrintState> printState = new HashMap<Integer, PrintState>();
    private Map<Integer, PrintInfoResponse> printInfo = new HashMap<Integer, PrintInfoResponse>();
    public static final int CLOUD_REPORT = 1;
    public static final int CLOUD_DETAIL = 2;
    public static final int LOG_REPORT = 3;
    public static final int LOG_DETAIL = 4;
    public static final int PLU_REPORT = 5;
    public static final int MERCHANT_ORDER = 6;
    public static final int DISTRIBUTOR_ORDER = 7;
    private Map<Integer, String> dict;
    public static final Integer Date = 1;
    public static final Integer Money_Amount = 2;
    public static final Integer Finish = 3;
    public static final Integer CP_Report = 4;
    public static final Integer LG_Report = 5;
    public static final Integer PLU_Report = 6;
    public static final Integer Ali_Pay = 7;
    public static final Integer WX_Pay = 8;
    public static final Integer Union_Pay = 9;
    public static final Integer JH_Pay = 10;
    public static final Integer YZ_Pay = 11;
    public static final Integer Scale = 12;
    public static final Integer Refund = 13;
    public static final Integer UnConfirm = 14;
    public static final Integer Clear = 15;
    public static final Integer Hedge = 16;
    public static final Integer Auto = 17;
    public static final Integer Input = 18;
    public static final Integer Output = 19;
    public static final Integer Inventory = 20;
    public static final Integer Order = 21;
    public static final Integer Loss = 22;
    public static final Integer Abandonment = 23;
    public static final Integer Cash = 24;
    public static final Integer CardPay = 25;
    public static final Integer OtherPay1 = 26;
    public static final Integer OtherPay2 = 27;
    public static final Integer OtherPay3 = 28;
    public static final Integer JKYPay = 29;
    public static final Integer JKYGivePay = 30;
    public static final Integer JKYRecharge = 31;
    public static final Integer JKYGiveRecharge = 32;
    public static final Integer Special2 = 33;
    public static final Integer Special3 = 34;
    public static final Integer Special4 = 35;
    public static final Integer Special5 = 36;
    public static final Integer Special6 = 37;
    public static final Integer Special7 = 38;
    public static final Integer Summary = 39;
    public static final Integer Error = 40;

    public PrintGeneralFactory putPrintState(Integer serial, String state1, String state2) {
        state1 = StringUtils.isBlank((CharSequence)state1) ? "00000000" : state1;
        state2 = StringUtils.isBlank((CharSequence)state2) ? "00000000" : state2;
        this.printState.put(serial, new PrintState(state1, state2));
        return this;
    }

    public PrintGeneralFactory putPrintInfo(Integer serial, PrintInfoResponse response) {
        this.printInfo.put(serial, response);
        return this;
    }

    public Map<Integer, PrintState> getPrintState() {
        return this.printState;
    }

    public Map<Integer, PrintInfoResponse> getPrintInfo() {
        return this.printInfo;
    }

    private PrintGeneralFactory() {
        this.printProcessorMap = new HashMap<Integer, PrintProcessor>();
        this.dict = new HashMap<Integer, String>();
        GlobalPara.getInstance().addRefresh(this);
    }

    public static PrintGeneralFactory getInstance() {
        return SinglePrintGeneralFactory.INSTANCE;
    }

    public PrintGeneralFactory putDict(Integer no, String val) {
        this.dict.put(no, val);
        return this;
    }

    public PrintGeneralFactory putDict(Map<Integer, String> dict) {
        if (dict != null && !dict.isEmpty()) {
            this.dict.putAll(dict);
        }
        return this;
    }

    public PrintGeneralFactory clearDict() {
        this.dict.clear();
        return this;
    }

    public Map<Integer, String> dict() {
        return this.dict;
    }

    public String dict(Integer no, String def) {
        return this.dict.getOrDefault(no, def);
    }

    public String dict(Integer no) {
        return this.dict.get(no);
    }

    public String dict(String def) {
        if (StringUtils.isNotBlank((CharSequence)def)) {
            switch (def) {
                case "\u65e5\u671f": {
                    def = this.dict.getOrDefault(Date, def);
                    break;
                }
                case "\u7d2f\u8ba1\u989d/\u7b14\u6570": {
                    def = this.dict.getOrDefault(Money_Amount, def);
                    break;
                }
                case "\u5b8c": {
                    def = this.dict.getOrDefault(Finish, def);
                    break;
                }
                case "\u4e91\u652f\u4ed8\u62a5\u8868": {
                    def = this.dict.getOrDefault(CP_Report, def);
                    break;
                }
                case "\u9500\u552e\u62a5\u8868": {
                    def = this.dict.getOrDefault(LG_Report, def);
                    break;
                }
                case "PLU\u62a5\u8868": {
                    def = this.dict.getOrDefault(PLU_Report, def);
                    break;
                }
                case "\u652f\u4ed8\u5b9d": {
                    def = this.dict.getOrDefault(Ali_Pay, def);
                    break;
                }
                case "\u5fae\u4fe1": {
                    def = this.dict.getOrDefault(WX_Pay, def);
                    break;
                }
                case "\u4e91\u95ea\u4ed8": {
                    def = this.dict.getOrDefault(Union_Pay, def);
                    break;
                }
                case "\u5efa\u884c": {
                    def = this.dict.getOrDefault(JH_Pay, def);
                    break;
                }
                case "\u90ae\u653f": {
                    def = this.dict.getOrDefault(YZ_Pay, def);
                    break;
                }
                case "\u9500\u552e": {
                    def = this.dict.getOrDefault(Scale, def);
                    break;
                }
                case "\u9000\u6b3e": {
                    def = this.dict.getOrDefault(Refund, def);
                    break;
                }
                case "\u672a\u786e\u8ba4": {
                    def = this.dict.getOrDefault(UnConfirm, def);
                    break;
                }
                case "\u6e05\u9664": {
                    def = this.dict.getOrDefault(Clear, def);
                    break;
                }
                case "\u6302\u5355\u7b14\u6570": {
                    def = this.dict.getOrDefault(Hedge, def);
                    break;
                }
                case "\u81ea\u52a8\u6a21\u5f0f": {
                    def = this.dict.getOrDefault(Auto, def);
                    break;
                }
                case "\u5165\u5e93": {
                    def = this.dict.getOrDefault(Input, def);
                    break;
                }
                case "\u51fa\u5e93": {
                    def = this.dict.getOrDefault(Output, def);
                    break;
                }
                case "\u76d8\u5e93": {
                    def = this.dict.getOrDefault(Inventory, def);
                    break;
                }
                case "\u8ba2\u5355": {
                    def = this.dict.getOrDefault(Order, def);
                    break;
                }
                case "\u635f\u8017": {
                    def = this.dict.getOrDefault(Loss, def);
                    break;
                }
                case "\u6298\u820d": {
                    def = this.dict.getOrDefault(Abandonment, def);
                    break;
                }
                case "\u73b0\u91d1": {
                    def = this.dict.getOrDefault(Cash, def);
                    break;
                }
                case "\u5361\u4ed8": {
                    def = this.dict.getOrDefault(CardPay, def);
                    break;
                }
                case "\u5176\u4ed6\u652f\u4ed81": {
                    def = this.dict.getOrDefault(OtherPay1, def);
                    break;
                }
                case "\u5176\u4ed6\u652f\u4ed82": {
                    def = this.dict.getOrDefault(OtherPay2, def);
                    break;
                }
                case "\u5176\u4ed6\u652f\u4ed83": {
                    def = this.dict.getOrDefault(OtherPay3, def);
                    break;
                }
                case "\u5409\u5361\u4e91\u652f\u4ed8": {
                    def = this.dict.getOrDefault(JKYPay, def);
                    break;
                }
                case "\u5409\u5361\u4e91\u8d60\u9001\u652f\u4ed8": {
                    def = this.dict.getOrDefault(JKYGivePay, def);
                    break;
                }
                case "\u5409\u5361\u4e91\u5145\u503c": {
                    def = this.dict.getOrDefault(JKYRecharge, def);
                    break;
                }
                case "\u5409\u5361\u4e91\u8d60\u9001\u5145\u503c": {
                    def = this.dict.getOrDefault(JKYGiveRecharge, def);
                    break;
                }
                case "\u7279\u6b8a\u652f\u4ed82": {
                    def = this.dict.getOrDefault(Special2, def);
                    break;
                }
                case "\u7279\u6b8a\u652f\u4ed83": {
                    def = this.dict.getOrDefault(Special3, def);
                    break;
                }
                case "\u7279\u6b8a\u652f\u4ed84": {
                    def = this.dict.getOrDefault(Special4, def);
                    break;
                }
                case "\u7279\u6b8a\u652f\u4ed85": {
                    def = this.dict.getOrDefault(Special5, def);
                    break;
                }
                case "\u7279\u6b8a\u652f\u4ed86": {
                    def = this.dict.getOrDefault(Special6, def);
                    break;
                }
                case "\u7279\u6b8a\u652f\u4ed87": {
                    def = this.dict.getOrDefault(Special7, def);
                    break;
                }
                case "\u6c47\u603b": {
                    def = this.dict.getOrDefault(Summary, def);
                    break;
                }
                case "\u9519\u8bef\u7b14\u6570": {
                    def = this.dict.getOrDefault(Error, def);
                    break;
                }
            }
        }
        return def;
    }

    public PrintGeneralFactory Init_Print_Factory(Messenger a, Messenger b) throws MeterException {
        if (a == null && b == null) {
            throw new MeterException(MeterStateEnum.\u6253\u5370\u6a21\u5757\u672a\u521d\u59cb\u5316);
        }
        if (a != null) {
            PrintProcessor_A processor_a = new PrintProcessor_A().setMessenger(a);
            this.obtainPrintInfo(processor_a);
        }
        if (b != null) {
            PrintProcessor_B printProcessor_b = new PrintProcessor_B().setMessenger(b);
            this.obtainPrintInfo(printProcessor_b);
        }
        return this;
    }

    public PrintGeneralFactory build_Default(Messenger messenger) {
        PrintProduce printProduce = new PrintProduce().setMessenger(messenger);
        this.obtainPrintInfo(printProduce);
        return this;
    }

    public PrintGeneralFactory build_A(Messenger messenger) {
        return this.build(0, messenger);
    }

    public PrintGeneralFactory build_B(Messenger messenger) {
        return this.build(1, messenger);
    }

    public PrintGeneralFactory build(Integer serial, Messenger messenger) {
        IPrintBasic print = this.checkMessage(messenger);
        if (print == null) {
            PrintProcessor printProcessor = new PrintProcessor().setMessenger(serial, messenger);
            this.Put_Print(printProcessor);
            this.obtainPrintInfo(printProcessor);
        }
        return this;
    }

    public PrintGeneralFactory close() throws MeterException {
        if (this.printProcessorMap != null && !this.printProcessorMap.isEmpty()) {
            for (PrintProcessor value : this.printProcessorMap.values()) {
                if (value == null) continue;
                value.close();
            }
        }
        return this;
    }

    public PrintGeneralFactory obtainPrintInfo(final PrintProcessor processor) {
        try {
            processor.getPrintInfo(new IPrintBack(){

                @Override
                public void responseBack(PrintBackResponse response) {
                    if (response instanceof PrintInfoResponse) {
                        PrintInfoResponse printInfoResponse = (PrintInfoResponse)response;
                        PrintGeneralFactory.getInstance().putPrintState(processor.communication().getSerial(), printInfoResponse.getState1(), printInfoResponse.getState2());
                        PrintGeneralFactory.getInstance().putPrintInfo(processor.communication().getSerial(), printInfoResponse);
                    } else {
                        try {
                            System.err.printf("\u83b7\u53d6\u6253\u5370\u673a\u7c7b\u578b\u5f02\u5e38,\u91cd\u65b0\u83b7\u53d6\u6253\u5370\u673a\u4fe1\u606f \u6570\u636e\u5185\u5bb9%s%n", GJSONUtils.objectToJSON((Object)response));
                        }
                        catch (Exception e) {
                            System.err.printf("\u83b7\u53d6\u6253\u5370\u673a\u7c7b\u578b\u5f02\u5e38: %s%n", e.getMessage());
                        }
                        PrintGeneralFactory.this.obtainPrintInfo(processor);
                    }
                }
            });
        }
        catch (Exception e) {
            System.err.printf("\u83b7\u53d6\u6253\u5370\u673a\u4fe1\u606f\u5931\u8d25\uff1a%s%n", e.getMessage());
        }
        return this;
    }

    private IPrintBasic checkMessage(Messenger messenger) {
        if (this.printProcessorMap != null && !this.printProcessorMap.isEmpty()) {
            for (IPrintBasic iPrintBasic : this.printProcessorMap.values()) {
                if (iPrintBasic == null || iPrintBasic.communication().messenger() == null || !StringUtils.isBlank((CharSequence)iPrintBasic.communication().messenger().identify()) || !iPrintBasic.communication().messenger().identify().equals(messenger.identify())) continue;
                return iPrintBasic;
            }
        }
        return null;
    }

    public PrintGeneralFactory Put_Print(PrintProcessor print) {
        if (this.printProcessorMap == null) {
            this.printProcessorMap = new HashMap<Integer, PrintProcessor>();
        }
        this.printProcessorMap.put(print.communication().getSerial(), print);
        return this;
    }

    public List<PrintBackResponse> execute(PrintRequest request, int ... ports) {
        return this.execute(40, request, ports);
    }

    public List<PrintBackResponse> execute(int timeout, PrintRequest request, int ... ports) {
        int[] nArray;
        timeout = timeout == 0 ? 40 : timeout;
        final HashMap responses = new HashMap();
        if (ports != null && ports.length > 0) {
            nArray = ports;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        }
        ports = nArray;
        Integer[] i_ports = ArrayUtils.ifRepeat((int[])ports);
        for (int count = 0; count < timeout; ++count) {
            int execute_size = 0;
            for (Integer port : i_ports) {
                PrintBackResponse printBackResponse = (PrintBackResponse)responses.get(port);
                if (printBackResponse != null) continue;
                try {
                    PrintRequest rq = (PrintRequest)GJSONUtils.objectToObject((Object)request, request.getClass());
                    rq.setPrintBack(new IPrintBack(){

                        @Override
                        public void responseBack(PrintBackResponse response) {
                            responses.put(response.getSerial(), response);
                        }
                    });
                    this.getCommunication(port, false).send(rq);
                    ++execute_size;
                }
                catch (MeterException e) {
                    System.err.printf("Serial[%s]_Err: %s%n", port, e.getMessage());
                }
            }
            try {
                Thread.sleep(150L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (responses.size() == execute_size) break;
        }
        return new ArrayList<PrintBackResponse>(responses.values());
    }

    @Override
    public int[] refreshIds() {
        return new int[]{22, 23, 30, 244, 245, 246};
    }

    @Override
    public void refreshAction(int no, int value) {
        this.print_set(no);
    }

    public void print_set(int no) {
        ArrayList<Print0100Request> a = new ArrayList<Print0100Request>();
        ArrayList<Print0100Request> b = new ArrayList<Print0100Request>();
        switch (no) {
            case 22: {
                a.add(new Print0100Request(0, PrintParamSave.FOREVER, GlobalPara.getInstance().getTMS(22)));
                break;
            }
            case 23: {
                b.add(new Print0100Request(0, PrintParamSave.FOREVER, GlobalPara.getInstance().getTMS(23)));
                break;
            }
            case 30: {
                b.add(new Print0100Request(30, PrintParamSave.FOREVER, GlobalPara.getInstance().getTMS(30, 270)));
                break;
            }
            case 244: 
            case 245: 
            case 246: {
                int ignore = 0;
                if ((GlobalPara.getInstance().getTMS(244) & 1) != 0) {
                    ignore |= 1;
                }
                if ((GlobalPara.getInstance().getTMS(245) & 1) != 0) {
                    ignore |= 2;
                }
                if (GlobalPara.getInstance().getTMS(246) > 0) {
                    ignore |= 4;
                }
                a.add(new Print0100Request(1, PrintParamSave.FOREVER, ignore));
                b.add(new Print0100Request(1, PrintParamSave.FOREVER, ignore));
            }
        }
        this.print_set(a, b);
    }

    private void print_set(List<Print0100Request> a, List<Print0100Request> b) {
        long start1;
        if (!a.isEmpty()) {
            start1 = System.currentTimeMillis();
            for (Print0100Request request : a) {
                this.execute(request, 0);
            }
            long end1 = System.currentTimeMillis();
            System.out.printf("A %s Time: %s%n", a.size(), end1 - start1);
        }
        if (!b.isEmpty()) {
            start1 = System.currentTimeMillis();
            for (Print0100Request request : b) {
                this.execute(request, 1);
            }
            long end1 = System.currentTimeMillis();
            System.out.printf("B %s Time: %s%n", b.size(), end1 - start1);
        }
    }

    @Deprecated
    public void print_before() {
        int[][] ids = new int[][]{{244, 245, 246}, {22}, {23}};
        ArrayList<Print0100Request> a = new ArrayList<Print0100Request>();
        ArrayList<Print0100Request> b = new ArrayList<Print0100Request>();
        block5: for (int i = 0; i < ids.length; ++i) {
            switch (i) {
                case 0: {
                    if (!GlobalPara.getInstance().checkTMS_Update(ids[0])) continue block5;
                    int ignore = 0;
                    if ((GlobalPara.getInstance().getTMS(244) & 1) != 0) {
                        ignore |= 1;
                    }
                    if ((GlobalPara.getInstance().getTMS(245) & 1) != 0) {
                        ignore |= 2;
                    }
                    if (GlobalPara.getInstance().getTMS(246) > 0) {
                        ignore |= 4;
                    }
                    a.add(new Print0100Request(1, PrintParamSave.FOREVER, ignore));
                    b.add(new Print0100Request(1, PrintParamSave.FOREVER, ignore));
                    continue block5;
                }
                case 1: {
                    if (!GlobalPara.getInstance().checkTMS_Update(ids[1])) continue block5;
                    a.add(new Print0100Request(0, PrintParamSave.FOREVER, GlobalPara.getInstance().getTMS(22)));
                    continue block5;
                }
                case 2: {
                    if (!GlobalPara.getInstance().checkTMS_Update(ids[2])) continue block5;
                    b.add(new Print0100Request(0, PrintParamSave.FOREVER, GlobalPara.getInstance().getTMS(23)));
                }
            }
        }
        this.print_set(a, b);
    }

    public void bitMapUpgrade(boolean print, DBitMap bitMap, IPrintBack printBack) throws MeterException {
        this.bitMapUpgrade(print, bitMap, printBack, new Integer[0]);
    }

    public void bitMapUpgrade(boolean print, DBitMap bitMap, IPrintBack printBack, Integer ... ports) throws MeterException {
        this.bitMapUpgrade(print, Arrays.asList(bitMap), printBack, ports);
    }

    public void bitMapUpgrade(boolean print, List<DBitMap> bitMaps, IPrintBack printBack) throws MeterException {
        this.bitMapUpgrade(print, bitMaps, printBack, new Integer[0]);
    }

    public void bitMapUpgrade(boolean print, List<DBitMap> bitMaps, IPrintBack printBack, Integer ... ports) throws MeterException {
        Integer[] integerArray;
        if (ports != null && ports.length > 0) {
            integerArray = ports;
        } else {
            Integer[] integerArray2 = new Integer[1];
            integerArray = integerArray2;
            integerArray2[0] = 0;
        }
        ports = integerArray;
        this.bitMapUpgrade(print, 0, bitMaps, printBack, Arrays.asList(ports));
    }

    private void bitMapUpgrade(boolean print, int i_bitmap, List<DBitMap> bitMaps, IPrintBack printBack, List<Integer> ports) {
        DBitMap bitMap = bitMaps.get(i_bitmap);
        String hexData = FileUtils.fileContentsToHex(bitMap.getBmp());
        this.bitMapUpgrade(print, bitMap, hexData, ++i_bitmap, bitMaps, printBack, 0, ports);
    }

    private void bitMapUpgrade(final boolean print, final DBitMap bitMap, final String hexData, final int i_bitmap, final List<DBitMap> bitMaps, final IPrintBack printBack, int i_port, final List<Integer> ports) {
        try {
            Integer port = ports.get(i_port);
            final PrintProcessor communication = this.getCommunication(port, false);
            final int finalI_port = ++i_port;
            PrintBitMapRequest request = new PrintBitMapRequest(null, hexData);
            request.setPrintBack(new IPrintBack(){

                @Override
                public void responseBack(PrintBackResponse response) {
                    System.out.printf("\u6253\u5370\u673a[%s] \u4f4d\u56fe[%s] \u5347\u7ea7\u54cd\u5e94\uff1a %s\n", communication.communication().getSerial(), bitMap.no(), response.toString());
                    if (print) {
                        PrintGeneralFactory.this.bitMapPrint(print, response, bitMap, communication, hexData, i_bitmap, bitMaps, printBack, finalI_port, ports);
                    } else if (finalI_port == ports.size() && i_bitmap == bitMaps.size()) {
                        printBack.responseBack(response);
                    } else if (finalI_port != ports.size()) {
                        PrintGeneralFactory.this.bitMapUpgrade(print, bitMap, hexData, i_bitmap, bitMaps, printBack, finalI_port, ports);
                    } else {
                        PrintGeneralFactory.this.bitMapUpgrade(print, i_bitmap, bitMaps, printBack, ports);
                    }
                }
            });
            communication.bitMapUpgrade(request);
        }
        catch (MeterException e) {
            e.printStackTrace();
        }
    }

    private void bitMapPrint(final boolean print, final PrintBackResponse bitMapUpgradeResponse, final DBitMap bitMap, final PrintProcessor communication, final String hexData, final int i_bitmap, final List<DBitMap> bitMaps, final IPrintBack printBack, final int finalI_port, final List<Integer> ports) {
        if (print) {
            try {
                PrintDataRequest request = new PrintDataRequest().addPara(new TempBitmapPara().set_Dir(Dir.ZERO).set_Grid(Grid.Defaul_Grid).setStartX(0).setStartY(0).setOffsetX(384).setOffsetY(200).set_InnerBitmapNumber(bitMap.no())).addPrintPointAndCutPoint();
                request.setPrintBack(new IPrintBack(){

                    @Override
                    public void responseBack(PrintBackResponse response) {
                        System.out.printf("\u6253\u5370\u673a[%s] \u4f4d\u56fe[%s] \u6253\u5370\u54cd\u5e94\uff1a %s\n", communication.communication().getSerial(), bitMap.no(), response.toString());
                        if (finalI_port == ports.size() && i_bitmap == bitMaps.size()) {
                            printBack.responseBack(bitMapUpgradeResponse);
                        } else if (finalI_port != ports.size()) {
                            SystemtUtils.sleep((int)6);
                            PrintGeneralFactory.this.bitMapUpgrade(print, bitMap, hexData, i_bitmap, bitMaps, printBack, finalI_port, ports);
                        } else {
                            SystemtUtils.sleep((int)6);
                            PrintGeneralFactory.this.bitMapUpgrade(print, i_bitmap, bitMaps, printBack, ports);
                        }
                    }
                });
                communication.printSend(request);
            }
            catch (MeterException e) {
                e.printStackTrace();
            }
        }
    }

    public void fontUpgrade(DFont font, IPrintBack printBack) throws MeterException {
        this.fontUpgrade(font, printBack, new int[0]);
    }

    public void fontUpgrade(DFont font, IPrintBack printBack, int ... ports) throws MeterException {
        int[] nArray;
        if (ports != null && ports.length > 0) {
            nArray = ports;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        }
        ports = nArray;
        String hexData = FileUtils.fileContentsToHex(font.getFnt());
        for (int port : ports) {
            PrintFontRequest request = new PrintFontRequest(null, hexData);
            request.setPrintBack(printBack);
            this.getCommunication(port, false).fontUpgrade(request);
        }
    }

    public void print_answer(List<PrintContent> printContents, IPrintBack printBack) throws MeterException {
        this.print_answer(printContents, printBack, true);
    }

    public void print_direct(List<PrintContent> printContents, IPrintBack printBack) throws MeterException {
        this.print_answer(printContents, printBack, true);
    }

    public void print_answer(List<PrintContent> printContents, IPrintBack printBack, boolean first) throws MeterException {
        if (printContents != null && !printContents.isEmpty()) {
            for (PrintContent printContent : printContents) {
                if (printContent.getPcs() <= 0) continue;
                for (int i = 0; i < printContent.getPcs(); ++i) {
                    PrintTradeRequest request = new PrintTradeRequest();
                    request.setPrintBack(printBack);
                    request.setNow(i + 1);
                    request.setTotal(printContent.getPcs());
                    request.setHex(printContent.getHex());
                    if (printContent.getWidth() == 48) {
                        this.getNode_A(first).send(request);
                        continue;
                    }
                    this.getNode_B(first).send(request);
                }
            }
        }
    }

    public void print_direct(List<PrintContent> printContents, IPrintBack printBack, boolean first) throws MeterException {
        if (printContents != null && !printContents.isEmpty()) {
            for (PrintContent printContent : printContents) {
                if (printContent.getPcs() <= 0) continue;
                for (int i = 0; i < printContent.getPcs(); ++i) {
                    PrintTradeRequest request = new PrintTradeRequest();
                    request.setPrintBack(printBack);
                    request.setNow(i + 1);
                    request.setTotal(printContent.getPcs());
                    request.setHex(printContent.getHex());
                    if (printContent.getWidth() == 48) {
                        this.getNode_A(first).sendAll(request);
                        continue;
                    }
                    this.getNode_B(first).sendAll(request);
                }
            }
        }
    }

    public boolean Print_Line(IPrintBack printBack, PrintLine ... lines) {
        try {
            if (lines != null && lines.length > 0) {
                this.getCommunication().Print_Line(printBack, Arrays.asList(lines));
                return true;
            }
        }
        catch (MeterException e) {
            e.printStackTrace();
        }
        return false;
    }

    public void Open_Print(PrintLine ... others) {
        DServerInfo serverInfo = GlobalPara.getInstance().getServerInfo();
        DSaleMan saleMan = GlobalPara.getInstance().getSaleMan();
        ArrayList<PrintLine> lines = new ArrayList<PrintLine>();
        if (Objects.nonNull(serverInfo)) {
            String device_info;
            List payment;
            String erp_info;
            String market_info;
            lines.add(new PrintLineLMR().setRight(serverInfo.isCloud() ? "\u4e91\u670d\u52a1\u5df2\u8fde\u63a5" : "\u4e91\u670d\u52a1\u672a\u8fde\u63a5"));
            String string = serverInfo.store_all_info();
            if (StringUtils.isNotBlank((CharSequence)string)) {
                lines.add(new PrintLineN(string));
            }
            if (saleMan != null) {
                lines.add(new PrintLineN(String.format("P* %s[%s]", saleMan.getName(), saleMan.no())));
            }
            if (StringUtils.isNotBlank((CharSequence)(market_info = serverInfo.market_info()))) {
                lines.add(new PrintLineN(market_info));
            }
            if (StringUtils.isNotBlank((CharSequence)(erp_info = serverInfo.erp_info()))) {
                lines.add(new PrintLineN(erp_info));
            }
            if ((payment = serverInfo.payment()) != null && !payment.isEmpty()) {
                for (String s : payment) {
                    if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                    lines.add(new PrintLineN(s));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(device_info = serverInfo.device_info()))) {
                lines.add(new PrintLineN(device_info));
            }
        } else {
            lines.add(new PrintLineLMR().setRight("\u4e91\u670d\u52a1\u672a\u8fde\u63a5"));
        }
        if (others != null) {
            for (PrintLine other : others) {
                if (other == null) continue;
                lines.add(other);
            }
        }
        try {
            this.getCommunication().Print_Line(new IPrintBack(){

                @Override
                public void responseBack(PrintResponse response) {
                    if (GlobalPara.getInstance().isRunLog()) {
                        System.out.println(response.toString());
                    }
                }
            }, lines);
        }
        catch (MeterException meterException) {
            System.err.printf("\u5f00\u673a\u6253\u5370\u5f02\u5e38\uff1a%s%n", meterException.getMessage());
        }
    }

    private PrintProcessor first() {
        if (this.printProcessorMap != null && !this.printProcessorMap.isEmpty()) {
            for (PrintProcessor processor : this.printProcessorMap.values()) {
                if (processor == null) continue;
                return processor;
            }
        }
        return null;
    }

    public PrintProcessor getDefault(boolean first) throws MeterException {
        PrintProcessor Default = this.printProcessorMap.get(0);
        if (Default == null && first) {
            Default = this.first();
        }
        if (Default == null) {
            throw new MeterException(MeterStateEnum.\u901a\u8baf\u7ec4\u4ef6\u672a\u521d\u59cb\u5316);
        }
        return Default;
    }

    public PrintProcessor getNode_A(boolean first) throws MeterException {
        PrintProcessor processor = this.printProcessorMap.get(0);
        if (processor == null && first) {
            processor = this.first();
        }
        if (processor == null) {
            throw new MeterException(MeterStateEnum.\u901a\u8baf\u7ec4\u4ef6A\u672a\u521d\u59cb\u5316);
        }
        return processor;
    }

    public PrintProcessor getNode_B(boolean first) throws MeterException {
        PrintProcessor processor = this.printProcessorMap.get(1);
        if (processor == null && first) {
            processor = this.first();
        }
        if (processor == null) {
            throw new MeterException(MeterStateEnum.\u901a\u8baf\u7ec4\u4ef6B\u672a\u521d\u59cb\u5316);
        }
        return processor;
    }

    public PrintProcessor getCommunication(int serial, boolean first) throws MeterException {
        PrintProcessor processor = this.printProcessorMap.get(serial);
        if (processor == null && first) {
            processor = this.first();
        }
        if (processor == null) {
            throw new MeterException(MeterStateEnum.\u901a\u8baf\u7ec4\u4ef6\u672a\u521d\u59cb\u5316);
        }
        return processor;
    }

    public PrintProcessor getCommunication() throws MeterException {
        int tms = GlobalPara.getInstance().getTMS(27);
        int serial = tms == 48 || tms == 0 ? 0 : 1;
        return this.getCommunication(serial, true);
    }

    public PrintProcessor getFunctionPrintProcess(int tms) throws MeterException {
        int node = GlobalPara.getInstance().getTMS(tms, 0);
        return this.getCommunication(node, true);
    }

    public void notify(ServerNotify notify, IPrintBack printBack) throws MeterException {
        if (notify != null) {
            if (StringUtils.isBlank((CharSequence)notify.getContent())) {
                this.undefined(notify, printBack);
            } else {
                switch (notify.getCommand()) {
                    case 1: {
                        this.cloudReport(notify, printBack);
                        break;
                    }
                    case 2: {
                        this.cloudDetail(notify, printBack);
                        break;
                    }
                    case 3: {
                        this.logReport(notify, printBack);
                        break;
                    }
                    case 4: {
                        this.logDetail(notify, printBack);
                        break;
                    }
                    case 5: {
                        this.pluReport(notify, printBack);
                        break;
                    }
                    case 6: {
                        this.merchantOrder(notify, printBack);
                        break;
                    }
                    case 7: {
                        this.distributorOrder(notify, printBack);
                        break;
                    }
                    default: {
                        this.undefined(notify, printBack);
                    }
                }
            }
        }
    }

    private void distributorOrder(ServerNotify notify, IPrintBack printBack) throws MeterException {
        ZXDOrder order = notify.contentToObj(ZXDOrder.class);
        System.out.println(order.toJSON());
        Address address = order.address();
        System.out.println(address.toJSON());
        DistributorNote distributorNote = order.distributorNote();
        System.out.println(distributorNote.toJSON());
        this.distributorOrder(order, printBack);
    }

    public void distributorOrder(ZXDOrder order, IPrintBack printBack) throws MeterException {
        List<PrintLine> lines = order.toDistributorPrintLine();
        this.getCommunication().Print_Line(printBack, lines);
    }

    private void merchantOrder(ServerNotify notify, IPrintBack printBack) throws MeterException {
        ZXDOrder order = notify.contentToObj(ZXDOrder.class);
        System.out.println(order.toJSON());
        Address address = order.address();
        System.out.println(address.toJSON());
        MerchantNote merchantNote = order.merchantNote();
        System.out.println(merchantNote.toJSON());
        this.merchantOrder(order, printBack);
    }

    public void merchantOrder(ZXDOrder order, IPrintBack printBack) throws MeterException {
        List<PrintLine> lines = order.toMerchantPrintLine();
        this.getCommunication().Print_Line(printBack, lines);
    }

    private void pluReport(ServerNotify notify, IPrintBack printBack) throws MeterException {
        PLUServerReport serverReport = notify.contentToObj(PLUServerReport.class);
        this.pluReport(serverReport, printBack);
    }

    public void pluReport(PLUServerReport serverReport, IPrintBack printBack) throws MeterException {
        PLUReport report = serverReport.toReport();
        report.setStoreName(serverReport.getStoreName());
        report.setDeviceName(serverReport.getDeviceName());
        report.setDate(serverReport.getDate());
        report.setMoney(serverReport.moneyPoint());
        report.setWeight(serverReport.weightPoint());
        this.getCommunication().printReport(printBack, report);
    }

    private void logDetail(ServerNotify notify, IPrintBack printBack) throws MeterException {
        DLOGContent content = notify.contentToObj(DLOGContent.class);
        this.logDetail(content, printBack);
    }

    public void logDetail(DLOGContent content, IPrintBack printBack) throws MeterException {
        TradeContent tradeContent = new TradeContent().Total_Log(content).printCalculate();
        this.print_answer(tradeContent.getPrintContents(), printBack);
    }

    private void logReport(ServerNotify notify, IPrintBack printBack) throws MeterException {
        LOGServerReport serverReport = notify.contentToObj(LOGServerReport.class);
        this.logReport(serverReport, printBack);
    }

    public void logReport(LOGServerReport serverReport, IPrintBack printBack) throws MeterException {
        LOGReport report = serverReport.toReport();
        report.setStoreName(serverReport.getStoreName());
        report.setDeviceName(serverReport.getDeviceName());
        report.setDate(serverReport.getDate());
        report.setMoney(serverReport.moneyPoint());
        report.setWeight(serverReport.weightPoint());
        this.getCommunication().printReport(printBack, report);
    }

    private void cloudDetail(ServerNotify notify, IPrintBack printBack) throws MeterException {
        this.undefined(notify, printBack);
    }

    private void cloudReport(ServerNotify notify, IPrintBack printBack) throws MeterException {
        CPServerReport serverReport = notify.contentToObj(CPServerReport.class);
        this.cloudReport(serverReport, printBack);
    }

    public void cloudReport(CPServerReport serverReport, IPrintBack printBack) throws MeterException {
        CPReport report = serverReport.toReport();
        report.setStoreName(serverReport.getStoreName());
        report.setDeviceName(serverReport.getDeviceName());
        report.setDate(serverReport.getDate());
        report.setMoney(serverReport.moneyPoint());
        report.setWeight(serverReport.weightPoint());
        this.getCommunication().printReport(printBack, report);
    }

    public void undefined(ServerNotify notify, IPrintBack printBack) throws MeterException {
        PrintLineN line = new PrintLineN().setContent(String.format("Undefined Command:[%s] Content:[%s]", notify.getCommand(), notify.getContent()));
        this.getCommunication().printSend(printBack, line, new PrintLineE());
    }

    private static class SinglePrintGeneralFactory {
        private static PrintGeneralFactory INSTANCE = new PrintGeneralFactory();

        private SinglePrintGeneralFactory() {
        }
    }
}

