/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.print.PrintCommunication;
import com.jhscale.meter.protocol.print.PrintConstant;
import com.jhscale.meter.protocol.print.PrintThread;
import com.jhscale.meter.protocol.print.entity.PrintCmdInfo;
import com.jhscale.meter.protocol.print.entity.PrintLOGParam;
import com.jhscale.meter.protocol.print.entity.PrintRequest;
import com.jhscale.meter.protocol.print.entity.PrintResponse;
import com.jhscale.meter.protocol.print.entity.para.Para;
import com.jhscale.meter.protocol.print.entity.para.RealBitmapPara;
import com.jhscale.meter.protocol.print.link.Messenger;
import com.jhscale.meter.utils.PrintUtils;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PrintNode
implements PrintCommunication {
    private Integer serial;
    private Messenger messenger;
    private PrintThread thread;
    private Long communicationMaxTime = PrintConstant.SINGLE_COMMUNICATION_MAX_TIME;
    private List<Para> paraCache;
    private boolean originalResponse = false;
    private PrintLOGParam param;

    public PrintNode() {
    }

    public PrintNode(Integer serial, Messenger messenger) {
        this.setMessenger(serial, messenger);
    }

    public PrintNode(Integer serial, Messenger messenger, Long communicationMaxTime) {
        this(serial, messenger);
        this.communicationMaxTime = communicationMaxTime;
    }

    public PrintNode originalResponse(boolean originalResponse) {
        this.originalResponse = originalResponse;
        return this;
    }

    @Override
    public boolean originalResponse() {
        return this.originalResponse;
    }

    @Override
    public PrintLOGParam param() {
        if (this.param == null) {
            this.param = new PrintLOGParam();
        }
        return this.param;
    }

    @Override
    public void logSwitch(boolean logSwitch, Integer logLength) {
        if (this.param == null) {
            this.param = new PrintLOGParam();
        }
        this.param.set_switch(logSwitch);
        this.param.set_length(Objects.isNull(logLength) || logLength == 0 ? 2048 : logLength);
    }

    public PrintNode setCommunicationMaxTime(Long communicationMaxTime) {
        this.communicationMaxTime = communicationMaxTime;
        return this;
    }

    public PrintNode setMessenger(Integer serial, Messenger messenger) {
        this.serial = serial;
        this.messenger = messenger;
        if (this.thread == null) {
            this.thread = new PrintThread().reset();
            this.thread.start();
        } else {
            this.thread.reset();
        }
        return this;
    }

    @Override
    public boolean isSendStatus() {
        return this.thread == null ? false : this.thread.isSend();
    }

    @Override
    public void sendSuccess() {
        if (this.thread != null) {
            this.thread.once();
        }
    }

    @Override
    public void closeMessenger() {
        if (this.messenger != null) {
            this.messenger.close();
            this.messenger = null;
        }
        if (this.thread != null) {
            this.thread.cease();
            this.thread = null;
        }
    }

    @Override
    public void setSerial(Integer serial) {
        this.serial = serial;
    }

    @Override
    public Integer getSerial() {
        return this.serial;
    }

    @Override
    public boolean checkCommunication() throws MeterException {
        if (this.messenger == null || this.thread == null) {
            throw new MeterException(MeterStateEnum.\u901a\u8baf\u7ec4\u4ef6\u672a\u521d\u59cb\u5316);
        }
        return true;
    }

    @Override
    public Messenger messenger() {
        return this.messenger;
    }

    @Override
    public void addSendCmd(String cmd, PrintRequest request) throws MeterException {
        this.checkCommunication();
        this.thread.add(new PrintCmdInfo(cmd, request));
    }

    @Override
    public void sendCmd(String cmd, PrintRequest request) throws MeterException {
        try {
            request.setCommunication(this);
            Class clazz = (Class)((ParameterizedType)request.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            this.messenger.sendCmd(cmd, request, (PrintResponse)clazz.newInstance());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MeterException(MeterStateEnum.\u7cfb\u7edf\u5f02\u5e38_V2);
        }
    }

    @Override
    public void addParas(List<Para> paras) throws MeterException {
        if (this.paraCache == null) {
            this.paraCache = new ArrayList<Para>();
        }
        PrintUtils.debug(this.param(), paras);
        if (paras != null && !paras.isEmpty()) {
            for (Para para : paras) {
                if (!(para instanceof RealBitmapPara)) continue;
                throw new MeterException(MeterStateEnum.\u5b9e\u65f6\u4f4d\u56fe\u4f7f\u7528\u4e13\u7528\u63a5\u53e3);
            }
            this.paraCache.addAll(paras);
        }
        PrintUtils.debug(this.param(), this.paraCache);
    }

    @Override
    public void clearPara() {
        if (this.paraCache != null) {
            this.paraCache.clear();
            this.paraCache = null;
        }
    }

    @Override
    public List<Para> paras() {
        return this.paraCache;
    }
}

