/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.print.entity.PrintCmdInfo;
import com.jhscale.meter.protocol.print.produce.entity.PrintBackResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PrintThread
extends Thread {
    private List<PrintCmdInfo> printCmdInfo = Collections.synchronizedList(new ArrayList());
    private PrintCmdInfo upgradeInfo;
    private PrintCmdInfo now;
    private boolean execute = false;
    private boolean send = false;
    private int count = 0;
    private int sleep = 10;
    private int max = 50;
    private int max_length = 510;

    public PrintThread() {
        super("PrintThread");
    }

    public synchronized PrintThread reset() {
        this.printCmdInfo.clear();
        this.now = null;
        this.upgradeInfo = null;
        this.execute = true;
        this.send = false;
        this.count = 0;
        return this;
    }

    public synchronized PrintThread cease() {
        this.execute = false;
        this.send = false;
        this.now = null;
        this.upgradeInfo = null;
        if (this.printCmdInfo != null) {
            this.printCmdInfo.clear();
            this.printCmdInfo = null;
        }
        return this;
    }

    public synchronized PrintThread once() {
        this.send = false;
        this.count = 0;
        this.now = null;
        this.upgradeInfo = null;
        return this;
    }

    public synchronized PrintThread cycle(int sleep, int max) {
        this.sleep = sleep;
        this.max = max;
        return this;
    }

    public boolean isSend() {
        return this.send;
    }

    public synchronized void add(PrintCmdInfo printCmdInfo) {
        if (printCmdInfo.getRequest().isUpgrade()) {
            this.upgradeInfo = printCmdInfo;
        } else {
            this.printCmdInfo.add(printCmdInfo);
        }
    }

    @Override
    public void run() {
        while (this.execute && !this.isInterrupted()) {
            if (!this.send) {
                this.printExecute();
                continue;
            }
            try {
                Thread.sleep(this.sleep);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++this.count;
            if (this.count <= this.max || this.now == null) continue;
            this.now.getRequest().timeOut();
        }
    }

    private synchronized void printExecute() {
        if (this.upgradeInfo != null) {
            this.now = this.upgradeInfo;
        } else if (this.printCmdInfo != null && !this.printCmdInfo.isEmpty()) {
            try {
                this.now = this.printCmdInfo.remove(0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            if (this.now != null && this.now.getRequest() != null) {
                this.send = true;
                if (this.now.getRequest().isAll()) {
                    while (!this.now.getRequest().isEnd()) {
                        this.now.getRequest().setSubContentLength(this.max_length);
                        this.now.getRequest().getCommunication().sendCmd(this.now.getRequest().cmd(), this.now.getRequest());
                    }
                } else {
                    this.now.getRequest().getCommunication().sendCmd(this.now.getCmd(), this.now.getRequest());
                }
            }
        }
        catch (MeterException e) {
            e.printStackTrace();
            if (this.now != null && this.now.getRequest() != null && this.now.getRequest().getPrintBack() != null) {
                this.now.getRequest().getPrintBack().responseBack(PrintBackResponse.fail(this.now.getRequest().getCommunication().getSerial(), "101", "\u7cfb\u7edf\u5f02\u5e38:" + e.getMessage()));
            }
            this.once();
        }
        try {
            Thread.sleep(3L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

