/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print.data;

import com.jhscale.meter.protocol.print.data.PrintDataParse;
import com.jhscale.meter.protocol.print.data.PrintVal;
import com.jhscale.meter.utils.ByteUtils;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class PrintDataAssemble {
    private Charset charset;
    private List<PrintDataParse.PrintPart> printParts;
    private PrintVal printVal;

    public PrintDataAssemble() {
    }

    public PrintDataAssemble(Charset charset, List<PrintDataParse.PrintPart> printParts, PrintVal printVal) {
        this.charset = charset;
        this.printParts = printParts;
        this.printVal = printVal;
    }

    public String assemble() {
        StringBuffer sb = new StringBuffer();
        if (this.printParts != null && !this.printParts.isEmpty()) {
            Collections.sort(this.printParts);
            for (PrintDataParse.PrintPart printPart : this.printParts) {
                if (printPart.isCycle()) {
                    List<Map<String, String>> cycleList = this.printVal.getCycle().get(printPart.getOrder());
                    if (cycleList == null || cycleList.isEmpty()) continue;
                    for (Map<String, String> cycleVal : cycleList) {
                        ArrayList fieldVals = new ArrayList();
                        printPart.getFields().forEach(field -> fieldVals.add(this.getPrintVal((String)field, printPart, cycleVal)));
                        sb.append(String.format(printPart.getFilledPart(), fieldVals.toArray()));
                    }
                    continue;
                }
                ArrayList fieldVals = new ArrayList();
                printPart.getFields().forEach(field -> fieldVals.add(this.getPrintVal((String)field, printPart, this.printVal.getSimple())));
                sb.append(String.format(printPart.getFilledPart(), fieldVals.toArray()));
            }
        }
        return sb.toString();
    }

    private String getPrintVal(String field, PrintDataParse.PrintPart printPart, Map<String, String> printVal) {
        if (StringUtils.isBlank((CharSequence)field)) {
            return "";
        }
        String val = null;
        if (field.startsWith("T")) {
            String T_VAL = printPart.mapping(field);
            val = StringUtils.isBlank((CharSequence)T_VAL) ? field : T_VAL;
            val = val.replace("T", "");
        } else {
            String S_VAL;
            String I_VAL;
            String _VAL;
            String R_VAL;
            val = field.startsWith("R") ? (StringUtils.isBlank((CharSequence)(R_VAL = printVal.get(printPart.mapping(field)))) ? " " : R_VAL) : (field.startsWith("#") ? (StringUtils.isBlank((CharSequence)(_VAL = printVal.get(printPart.mapping(field)))) ? "" : _VAL) : (field.startsWith("I") || field.startsWith("i") ? (StringUtils.isBlank((CharSequence)(I_VAL = printVal.get(printPart.mapping(field)))) ? " " : I_VAL) : (field.startsWith("S") || field.startsWith("s") ? (StringUtils.isBlank((CharSequence)(S_VAL = printVal.get(printPart.mapping(field)))) ? " " : S_VAL) : (field.startsWith("Z") || field.startsWith("z") ? field : field + "_UK"))));
        }
        val = StringUtils.isNotBlank((CharSequence)val) ? val : "";
        return ByteUtils.toHexAscii(val.getBytes(this.charset)) + "00";
    }
}

